package com.google.template.soy.jbcsrc;

import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import java.io.Serializable;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoAnnotationProcessor")
final class AutoAnnotation_TemplateCompiler_createDelTemplateMetadata implements TemplateMetadata.DelTemplateMetadata, Serializable {
  private static final long serialVersionUID = -171301176558682561L;

  private final String delPackage;

  private final String name;

  private final String variant;

  AutoAnnotation_TemplateCompiler_createDelTemplateMetadata(
      String delPackage,
      String name,
      String variant) {
    if (delPackage == null) {
      throw new NullPointerException("Null delPackage");
    }
    this.delPackage = delPackage;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (variant == null) {
      throw new NullPointerException("Null variant");
    }
    this.variant = variant;
  }

  @Override
  public Class<? extends TemplateMetadata.DelTemplateMetadata> annotationType() {
    return TemplateMetadata.DelTemplateMetadata.class;
  }

  @Override
  public String delPackage() {
    return delPackage;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String variant() {
    return variant;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("@com.google.template.soy.jbcsrc.shared.TemplateMetadata.DelTemplateMetadata(");
    sb.append("delPackage=");
    appendQuoted(sb, delPackage);
    sb.append(", ");
    sb.append("name=");
    appendQuoted(sb, name);
    sb.append(", ");
    sb.append("variant=");
    appendQuoted(sb, variant);
    return sb.append(')').toString();
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata.DelTemplateMetadata) {
      TemplateMetadata.DelTemplateMetadata that = (TemplateMetadata.DelTemplateMetadata) o;
      return delPackage.equals(that.delPackage())
          && name.equals(that.name())
          && variant.equals(that.variant());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return
        + (-192010299 ^ delPackage.hashCode())
    // -192010299 is 127 * "delPackage".hashCode()
        + (428460789 ^ name.hashCode())
    // 428460789 is 127 * "name".hashCode()
        + (7025147 ^ variant.hashCode())
    // 7025147 is 127 * "variant".hashCode()
    ;
  }

  private static void appendQuoted(StringBuilder sb, String s) {
    sb.append('"');
    for (int i = 0; i < s.length(); i++) {
      appendEscaped(sb, s.charAt(i));
    }
    sb.append('"');
  }

  private static void appendEscaped(StringBuilder sb, char c) {
    switch (c) {
      case '\\':
      case '"':
      case '\'':
      sb.append('\\').append(c);
      break;
      case '\n':
      sb.append("\\n");
      break;
      case '\r':
      sb.append("\\r");
      break;
      case '\t':
      sb.append("\\t");
      break;
      default:
      if (c < 0x20) {
        sb.append('\\');
        appendWithZeroPadding(sb, Integer.toOctalString(c), 3);
      } else if (c < 0x7f || Character.isLetter(c)) {
        sb.append(c);
      } else {
        sb.append("\\u");
        appendWithZeroPadding(sb, Integer.toHexString(c), 4);
      }
      break;
    }
  }

  private static void appendWithZeroPadding(StringBuilder sb, String s, int width) {
    for (int i = width - s.length(); i > 0; i--) {
      sb.append('0');
    }
    sb.append(s);
  }
}
