package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoAnnotationProcessor")
final class AutoAnnotation_TemplateCompiler_createTemplateMetadata implements TemplateMetadata, Serializable {
  private static final long serialVersionUID = 3669170800150389298L;

  private final SanitizedContent.ContentKind contentKind;

  private final String[] injectedParams;

  private final String[] requiredCssNames;

  private final String[] requiredCssPaths;

  private final String[] callees;

  private final String[] delCallees;

  private final TemplateMetadata.DelTemplateMetadata deltemplateMetadata;

  AutoAnnotation_TemplateCompiler_createTemplateMetadata(
      SanitizedContent.ContentKind contentKind,
      Set<String> requiredCssNames,
      Set<String> requiredCssPaths,
      Set<String> injectedParams,
      Set<String> callees,
      Set<String> delCallees,
      TemplateMetadata.DelTemplateMetadata deltemplateMetadata) {
    if (contentKind == null) {
      throw new NullPointerException("Null contentKind");
    }
    this.contentKind = contentKind;
    if (requiredCssNames == null) {
      throw new NullPointerException("Null requiredCssNames");
    }
    this.requiredCssNames = requiredCssNames.toArray(new String[0]);
    if (requiredCssPaths == null) {
      throw new NullPointerException("Null requiredCssPaths");
    }
    this.requiredCssPaths = requiredCssPaths.toArray(new String[0]);
    if (injectedParams == null) {
      throw new NullPointerException("Null injectedParams");
    }
    this.injectedParams = injectedParams.toArray(new String[0]);
    if (callees == null) {
      throw new NullPointerException("Null callees");
    }
    this.callees = callees.toArray(new String[0]);
    if (delCallees == null) {
      throw new NullPointerException("Null delCallees");
    }
    this.delCallees = delCallees.toArray(new String[0]);
    if (deltemplateMetadata == null) {
      throw new NullPointerException("Null deltemplateMetadata");
    }
    this.deltemplateMetadata = deltemplateMetadata;
  }

  @Override
  public Class<? extends TemplateMetadata> annotationType() {
    return TemplateMetadata.class;
  }

  @Override
  public SanitizedContent.ContentKind contentKind() {
    return contentKind;
  }

  @Override
  public String[] injectedParams() {
    return injectedParams.clone()
    ;
  }

  @Override
  public String[] requiredCssNames() {
    return requiredCssNames.clone()
    ;
  }

  @Override
  public String[] requiredCssPaths() {
    return requiredCssPaths.clone()
    ;
  }

  @Override
  public String[] callees() {
    return callees.clone()
    ;
  }

  @Override
  public String[] delCallees() {
    return delCallees.clone()
    ;
  }

  @Override
  public TemplateMetadata.DelTemplateMetadata deltemplateMetadata() {
    return deltemplateMetadata;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("@com.google.template.soy.jbcsrc.shared.TemplateMetadata(");
    sb.append("contentKind=");
    sb.append(contentKind);
    sb.append(", ");
    sb.append("requiredCssNames=");
    appendQuoted(sb, requiredCssNames);
    sb.append(", ");
    sb.append("requiredCssPaths=");
    appendQuoted(sb, requiredCssPaths);
    sb.append(", ");
    sb.append("injectedParams=");
    appendQuoted(sb, injectedParams);
    sb.append(", ");
    sb.append("callees=");
    appendQuoted(sb, callees);
    sb.append(", ");
    sb.append("delCallees=");
    appendQuoted(sb, delCallees);
    sb.append(", ");
    sb.append("deltemplateMetadata=");
    sb.append(deltemplateMetadata);
    return sb.append(')').toString();
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata) {
      TemplateMetadata that = (TemplateMetadata) o;
      return contentKind.equals(that.contentKind())
          && Arrays.equals(injectedParams,
          (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
          ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).injectedParams
          : that.injectedParams())
          && Arrays.equals(requiredCssNames,
          (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
          ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).requiredCssNames
          : that.requiredCssNames())
          && Arrays.equals(requiredCssPaths,
          (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
          ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).requiredCssPaths
          : that.requiredCssPaths())
          && Arrays.equals(callees,
          (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
          ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).callees
          : that.callees())
          && Arrays.equals(delCallees,
          (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
          ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).delCallees
          : that.delCallees())
          && deltemplateMetadata.equals(that.deltemplateMetadata());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return
        + (2083903187 ^ contentKind.hashCode())
    // 2083903187 is 127 * "contentKind".hashCode()
        + (-1126726806 ^ Arrays.hashCode(injectedParams))
    // -1126726806 is 127 * "injectedParams".hashCode()
        + (1267675708 ^ Arrays.hashCode(requiredCssNames))
    // 1267675708 is 127 * "requiredCssNames".hashCode()
        + (1503116182 ^ Arrays.hashCode(requiredCssPaths))
    // 1503116182 is 127 * "requiredCssPaths".hashCode()
        + (957403595 ^ Arrays.hashCode(callees))
    // 957403595 is 127 * "callees".hashCode()
        + (183110358 ^ Arrays.hashCode(delCallees))
    // 183110358 is 127 * "delCallees".hashCode()
        + (-1347007956 ^ deltemplateMetadata.hashCode())
    // -1347007956 is 127 * "deltemplateMetadata".hashCode()
    ;
  }

  private static void appendQuoted(StringBuilder sb, String[] strings) {
    sb.append('[');
    String sep = "";
    for (String s : strings) {
      sb.append(sep);
      sep = ", ";
      appendQuoted(sb, s);
    }
    sb.append(']');
  }

  private static void appendQuoted(StringBuilder sb, String s) {
    sb.append('"');
    for (int i = 0; i < s.length(); i++) {
      appendEscaped(sb, s.charAt(i));
    }
    sb.append('"');
  }

  private static void appendEscaped(StringBuilder sb, char c) {
    switch (c) {
      case '\\':
      case '"':
      case '\'':
      sb.append('\\').append(c);
      break;
      case '\n':
      sb.append("\\n");
      break;
      case '\r':
      sb.append("\\r");
      break;
      case '\t':
      sb.append("\\t");
      break;
      default:
      if (c < 0x20) {
        sb.append('\\');
        appendWithZeroPadding(sb, Integer.toOctalString(c), 3);
      } else if (c < 0x7f || Character.isLetter(c)) {
        sb.append(c);
      } else {
        sb.append("\\u");
        appendWithZeroPadding(sb, Integer.toHexString(c), 4);
      }
      break;
    }
  }

  private static void appendWithZeroPadding(StringBuilder sb, String s, int width) {
    for (int i = width - s.length(); i > 0; i--) {
      sb.append('0');
    }
    sb.append(s);
  }
}
