package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprtree.Operator;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BinaryOperation extends BinaryOperation {

  private final ImmutableList<Statement> initialStatements;

  private final int precedence;

  private final Operator.Associativity associativity;

  private final String operator;

  private final Expression arg1;

  private final Expression arg2;

  AutoValue_BinaryOperation(
      ImmutableList<Statement> initialStatements,
      int precedence,
      Operator.Associativity associativity,
      String operator,
      Expression arg1,
      Expression arg2) {
    if (initialStatements == null) {
      throw new NullPointerException("Null initialStatements");
    }
    this.initialStatements = initialStatements;
    this.precedence = precedence;
    if (associativity == null) {
      throw new NullPointerException("Null associativity");
    }
    this.associativity = associativity;
    if (operator == null) {
      throw new NullPointerException("Null operator");
    }
    this.operator = operator;
    if (arg1 == null) {
      throw new NullPointerException("Null arg1");
    }
    this.arg1 = arg1;
    if (arg2 == null) {
      throw new NullPointerException("Null arg2");
    }
    this.arg2 = arg2;
  }

  @Override
  public ImmutableList<Statement> initialStatements() {
    return initialStatements;
  }

  @Override
  int precedence() {
    return precedence;
  }

  @Override
  Operator.Associativity associativity() {
    return associativity;
  }

  @Override
  String operator() {
    return operator;
  }

  @Override
  Expression arg1() {
    return arg1;
  }

  @Override
  Expression arg2() {
    return arg2;
  }

  @Override
  public String toString() {
    return "BinaryOperation{"
        + "initialStatements=" + initialStatements + ", "
        + "precedence=" + precedence + ", "
        + "associativity=" + associativity + ", "
        + "operator=" + operator + ", "
        + "arg1=" + arg1 + ", "
        + "arg2=" + arg2
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BinaryOperation) {
      BinaryOperation that = (BinaryOperation) o;
      return this.initialStatements.equals(that.initialStatements())
          && this.precedence == that.precedence()
          && this.associativity.equals(that.associativity())
          && this.operator.equals(that.operator())
          && this.arg1.equals(that.arg1())
          && this.arg2.equals(that.arg2());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= initialStatements.hashCode();
    h$ *= 1000003;
    h$ ^= precedence;
    h$ *= 1000003;
    h$ ^= associativity.hashCode();
    h$ *= 1000003;
    h$ ^= operator.hashCode();
    h$ *= 1000003;
    h$ ^= arg1.hashCode();
    h$ *= 1000003;
    h$ ^= arg2.hashCode();
    return h$;
  }

}
