package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.types.TemplateType;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TemplateMetadata extends TemplateMetadata {

  private final SoyFileKind soyFileKind;

  private final SourceLocation sourceLocation;

  private final HtmlElementMetadataP htmlElement;

  private final SoyElementMetadataP soyElement;

  private final String templateName;

  private final String delTemplateName;

  private final String delTemplateVariant;

  private final TemplateType templateType;

  private final Visibility visibility;

  private final String delPackageName;

  private final boolean component;

  private AutoValue_TemplateMetadata(
      SoyFileKind soyFileKind,
      SourceLocation sourceLocation,
      @Nullable HtmlElementMetadataP htmlElement,
      @Nullable SoyElementMetadataP soyElement,
      String templateName,
      @Nullable String delTemplateName,
      @Nullable String delTemplateVariant,
      TemplateType templateType,
      Visibility visibility,
      @Nullable String delPackageName,
      boolean component) {
    this.soyFileKind = soyFileKind;
    this.sourceLocation = sourceLocation;
    this.htmlElement = htmlElement;
    this.soyElement = soyElement;
    this.templateName = templateName;
    this.delTemplateName = delTemplateName;
    this.delTemplateVariant = delTemplateVariant;
    this.templateType = templateType;
    this.visibility = visibility;
    this.delPackageName = delPackageName;
    this.component = component;
  }

  @Override
  public SoyFileKind getSoyFileKind() {
    return soyFileKind;
  }

  @Override
  public SourceLocation getSourceLocation() {
    return sourceLocation;
  }

  @Nullable
  @Override
  public HtmlElementMetadataP getHtmlElement() {
    return htmlElement;
  }

  @Nullable
  @Override
  public SoyElementMetadataP getSoyElement() {
    return soyElement;
  }

  @Override
  public String getTemplateName() {
    return templateName;
  }

  @Nullable
  @Override
  public String getDelTemplateName() {
    return delTemplateName;
  }

  @Nullable
  @Override
  public String getDelTemplateVariant() {
    return delTemplateVariant;
  }

  @Override
  public TemplateType getTemplateType() {
    return templateType;
  }

  @Override
  public Visibility getVisibility() {
    return visibility;
  }

  @Nullable
  @Override
  public String getDelPackageName() {
    return delPackageName;
  }

  @Override
  public boolean getComponent() {
    return component;
  }

  @Override
  public String toString() {
    return "TemplateMetadata{"
        + "soyFileKind=" + soyFileKind + ", "
        + "sourceLocation=" + sourceLocation + ", "
        + "htmlElement=" + htmlElement + ", "
        + "soyElement=" + soyElement + ", "
        + "templateName=" + templateName + ", "
        + "delTemplateName=" + delTemplateName + ", "
        + "delTemplateVariant=" + delTemplateVariant + ", "
        + "templateType=" + templateType + ", "
        + "visibility=" + visibility + ", "
        + "delPackageName=" + delPackageName + ", "
        + "component=" + component
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata) {
      TemplateMetadata that = (TemplateMetadata) o;
      return this.soyFileKind.equals(that.getSoyFileKind())
          && this.sourceLocation.equals(that.getSourceLocation())
          && (this.htmlElement == null ? that.getHtmlElement() == null : this.htmlElement.equals(that.getHtmlElement()))
          && (this.soyElement == null ? that.getSoyElement() == null : this.soyElement.equals(that.getSoyElement()))
          && this.templateName.equals(that.getTemplateName())
          && (this.delTemplateName == null ? that.getDelTemplateName() == null : this.delTemplateName.equals(that.getDelTemplateName()))
          && (this.delTemplateVariant == null ? that.getDelTemplateVariant() == null : this.delTemplateVariant.equals(that.getDelTemplateVariant()))
          && this.templateType.equals(that.getTemplateType())
          && this.visibility.equals(that.getVisibility())
          && (this.delPackageName == null ? that.getDelPackageName() == null : this.delPackageName.equals(that.getDelPackageName()))
          && this.component == that.getComponent();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= soyFileKind.hashCode();
    h$ *= 1000003;
    h$ ^= sourceLocation.hashCode();
    h$ *= 1000003;
    h$ ^= (htmlElement == null) ? 0 : htmlElement.hashCode();
    h$ *= 1000003;
    h$ ^= (soyElement == null) ? 0 : soyElement.hashCode();
    h$ *= 1000003;
    h$ ^= templateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateName == null) ? 0 : delTemplateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateVariant == null) ? 0 : delTemplateVariant.hashCode();
    h$ *= 1000003;
    h$ ^= templateType.hashCode();
    h$ *= 1000003;
    h$ ^= visibility.hashCode();
    h$ *= 1000003;
    h$ ^= (delPackageName == null) ? 0 : delPackageName.hashCode();
    h$ *= 1000003;
    h$ ^= component ? 1231 : 1237;
    return h$;
  }

  @Override
  public TemplateMetadata.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TemplateMetadata.Builder {
    private SoyFileKind soyFileKind;
    private SourceLocation sourceLocation;
    private HtmlElementMetadataP htmlElement;
    private SoyElementMetadataP soyElement;
    private String templateName;
    private String delTemplateName;
    private String delTemplateVariant;
    private TemplateType templateType;
    private Visibility visibility;
    private String delPackageName;
    private Boolean component;
    Builder() {
    }
    private Builder(TemplateMetadata source) {
      this.soyFileKind = source.getSoyFileKind();
      this.sourceLocation = source.getSourceLocation();
      this.htmlElement = source.getHtmlElement();
      this.soyElement = source.getSoyElement();
      this.templateName = source.getTemplateName();
      this.delTemplateName = source.getDelTemplateName();
      this.delTemplateVariant = source.getDelTemplateVariant();
      this.templateType = source.getTemplateType();
      this.visibility = source.getVisibility();
      this.delPackageName = source.getDelPackageName();
      this.component = source.getComponent();
    }
    @Override
    public TemplateMetadata.Builder setSoyFileKind(SoyFileKind soyFileKind) {
      if (soyFileKind == null) {
        throw new NullPointerException("Null soyFileKind");
      }
      this.soyFileKind = soyFileKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setSourceLocation(SourceLocation sourceLocation) {
      if (sourceLocation == null) {
        throw new NullPointerException("Null sourceLocation");
      }
      this.sourceLocation = sourceLocation;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setHtmlElement(HtmlElementMetadataP htmlElement) {
      this.htmlElement = htmlElement;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setSoyElement(SoyElementMetadataP soyElement) {
      this.soyElement = soyElement;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateName(String templateName) {
      if (templateName == null) {
        throw new NullPointerException("Null templateName");
      }
      this.templateName = templateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateName(String delTemplateName) {
      this.delTemplateName = delTemplateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateVariant(String delTemplateVariant) {
      this.delTemplateVariant = delTemplateVariant;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateType(TemplateType templateType) {
      if (templateType == null) {
        throw new NullPointerException("Null templateType");
      }
      this.templateType = templateType;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setVisibility(Visibility visibility) {
      if (visibility == null) {
        throw new NullPointerException("Null visibility");
      }
      this.visibility = visibility;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelPackageName(@Nullable String delPackageName) {
      this.delPackageName = delPackageName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setComponent(boolean component) {
      this.component = component;
      return this;
    }
    @Override
    TemplateMetadata autobuild() {
      if (this.soyFileKind == null
          || this.sourceLocation == null
          || this.templateName == null
          || this.templateType == null
          || this.visibility == null
          || this.component == null) {
        StringBuilder missing = new StringBuilder();
        if (this.soyFileKind == null) {
          missing.append(" soyFileKind");
        }
        if (this.sourceLocation == null) {
          missing.append(" sourceLocation");
        }
        if (this.templateName == null) {
          missing.append(" templateName");
        }
        if (this.templateType == null) {
          missing.append(" templateType");
        }
        if (this.visibility == null) {
          missing.append(" visibility");
        }
        if (this.component == null) {
          missing.append(" component");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TemplateMetadata(
          this.soyFileKind,
          this.sourceLocation,
          this.htmlElement,
          this.soyElement,
          this.templateName,
          this.delTemplateName,
          this.delTemplateVariant,
          this.templateType,
          this.visibility,
          this.delPackageName,
          this.component);
    }
  }

}
