package com.google.template.soy.types;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TemplateType_Parameter extends TemplateType.Parameter {

  private final String name;

  private final TemplateType.ParameterKind kind;

  private final TemplateType.Parameter.LazyTypeWrapper typeWrapper;

  private final boolean required;

  private final boolean implicit;

  private final String description;

  private AutoValue_TemplateType_Parameter(
      String name,
      TemplateType.ParameterKind kind,
      TemplateType.Parameter.LazyTypeWrapper typeWrapper,
      boolean required,
      boolean implicit,
      @Nullable String description) {
    this.name = name;
    this.kind = kind;
    this.typeWrapper = typeWrapper;
    this.required = required;
    this.implicit = implicit;
    this.description = description;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public TemplateType.ParameterKind getKind() {
    return kind;
  }

  @Override
  TemplateType.Parameter.LazyTypeWrapper getTypeWrapper() {
    return typeWrapper;
  }

  @Override
  public boolean isRequired() {
    return required;
  }

  @Override
  public boolean isImplicit() {
    return implicit;
  }

  @Nullable
  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public String toString() {
    return "Parameter{"
        + "name=" + name + ", "
        + "kind=" + kind + ", "
        + "typeWrapper=" + typeWrapper + ", "
        + "required=" + required + ", "
        + "implicit=" + implicit + ", "
        + "description=" + description
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateType.Parameter) {
      TemplateType.Parameter that = (TemplateType.Parameter) o;
      return this.name.equals(that.getName())
          && this.kind.equals(that.getKind())
          && this.typeWrapper.equals(that.getTypeWrapper())
          && this.required == that.isRequired()
          && this.implicit == that.isImplicit()
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= typeWrapper.hashCode();
    h$ *= 1000003;
    h$ ^= required ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= implicit ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    return h$;
  }

  @Override
  public TemplateType.Parameter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TemplateType.Parameter.Builder {
    private String name;
    private TemplateType.ParameterKind kind;
    private TemplateType.Parameter.LazyTypeWrapper typeWrapper;
    private Boolean required;
    private Boolean implicit;
    private String description;
    Builder() {
    }
    private Builder(TemplateType.Parameter source) {
      this.name = source.getName();
      this.kind = source.getKind();
      this.typeWrapper = source.getTypeWrapper();
      this.required = source.isRequired();
      this.implicit = source.isImplicit();
      this.description = source.getDescription();
    }
    @Override
    public TemplateType.Parameter.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public TemplateType.Parameter.Builder setKind(TemplateType.ParameterKind kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    TemplateType.Parameter.Builder setTypeWrapper(TemplateType.Parameter.LazyTypeWrapper typeWrapper) {
      if (typeWrapper == null) {
        throw new NullPointerException("Null typeWrapper");
      }
      this.typeWrapper = typeWrapper;
      return this;
    }
    @Override
    public TemplateType.Parameter.Builder setRequired(boolean required) {
      this.required = required;
      return this;
    }
    @Override
    public TemplateType.Parameter.Builder setImplicit(boolean implicit) {
      this.implicit = implicit;
      return this;
    }
    @Override
    public TemplateType.Parameter.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    public TemplateType.Parameter build() {
      if (this.name == null
          || this.kind == null
          || this.typeWrapper == null
          || this.required == null
          || this.implicit == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.kind == null) {
          missing.append(" kind");
        }
        if (this.typeWrapper == null) {
          missing.append(" typeWrapper");
        }
        if (this.required == null) {
          missing.append(" required");
        }
        if (this.implicit == null) {
          missing.append(" implicit");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TemplateType_Parameter(
          this.name,
          this.kind,
          this.typeWrapper,
          this.required,
          this.implicit,
          this.description);
    }
  }

}
