package com.google.template.soy.types.ast;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GenericTypeNode extends GenericTypeNode {

  private final SourceLocation sourceLocation;

  private final Identifier identifier;

  private final ImmutableList<TypeNode> arguments;

  AutoValue_GenericTypeNode(
      SourceLocation sourceLocation,
      Identifier identifier,
      ImmutableList<TypeNode> arguments) {
    if (sourceLocation == null) {
      throw new NullPointerException("Null sourceLocation");
    }
    this.sourceLocation = sourceLocation;
    if (identifier == null) {
      throw new NullPointerException("Null identifier");
    }
    this.identifier = identifier;
    if (arguments == null) {
      throw new NullPointerException("Null arguments");
    }
    this.arguments = arguments;
  }

  @Override
  public SourceLocation sourceLocation() {
    return sourceLocation;
  }

  @Override
  public Identifier identifier() {
    return identifier;
  }

  @Override
  public ImmutableList<TypeNode> arguments() {
    return arguments;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GenericTypeNode) {
      GenericTypeNode that = (GenericTypeNode) o;
      return this.sourceLocation.equals(that.sourceLocation())
          && this.identifier.equals(that.identifier())
          && this.arguments.equals(that.arguments());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= sourceLocation.hashCode();
    h$ *= 1000003;
    h$ ^= identifier.hashCode();
    h$ *= 1000003;
    h$ ^= arguments.hashCode();
    return h$;
  }

}
