package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SoyFileSetParser extends SoyFileSetParser {

  private final SoyAstCache cache;

  private final ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers;

  private final ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits;

  private final PassManager passManager;

  private final ErrorReporter errorReporter;

  private final SoyTypeRegistry typeRegistry;

  private final Optional<CssRegistry> cssRegistry;

  private AutoValue_SoyFileSetParser(
      @Nullable SoyAstCache cache,
      ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers,
      ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits,
      PassManager passManager,
      ErrorReporter errorReporter,
      SoyTypeRegistry typeRegistry,
      Optional<CssRegistry> cssRegistry) {
    this.cache = cache;
    this.soyFileSuppliers = soyFileSuppliers;
    this.compilationUnits = compilationUnits;
    this.passManager = passManager;
    this.errorReporter = errorReporter;
    this.typeRegistry = typeRegistry;
    this.cssRegistry = cssRegistry;
  }

  @Nullable
  @Override
  SoyAstCache cache() {
    return cache;
  }

  @Override
  public ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers() {
    return soyFileSuppliers;
  }

  @Override
  ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits() {
    return compilationUnits;
  }

  @Override
  PassManager passManager() {
    return passManager;
  }

  @Override
  ErrorReporter errorReporter() {
    return errorReporter;
  }

  @Override
  public SoyTypeRegistry typeRegistry() {
    return typeRegistry;
  }

  @Override
  public Optional<CssRegistry> cssRegistry() {
    return cssRegistry;
  }

  @Override
  public String toString() {
    return "SoyFileSetParser{"
        + "cache=" + cache + ", "
        + "soyFileSuppliers=" + soyFileSuppliers + ", "
        + "compilationUnits=" + compilationUnits + ", "
        + "passManager=" + passManager + ", "
        + "errorReporter=" + errorReporter + ", "
        + "typeRegistry=" + typeRegistry + ", "
        + "cssRegistry=" + cssRegistry
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SoyFileSetParser) {
      SoyFileSetParser that = (SoyFileSetParser) o;
      return (this.cache == null ? that.cache() == null : this.cache.equals(that.cache()))
          && this.soyFileSuppliers.equals(that.soyFileSuppliers())
          && this.compilationUnits.equals(that.compilationUnits())
          && this.passManager.equals(that.passManager())
          && this.errorReporter.equals(that.errorReporter())
          && this.typeRegistry.equals(that.typeRegistry())
          && this.cssRegistry.equals(that.cssRegistry());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (cache == null) ? 0 : cache.hashCode();
    h$ *= 1000003;
    h$ ^= soyFileSuppliers.hashCode();
    h$ *= 1000003;
    h$ ^= compilationUnits.hashCode();
    h$ *= 1000003;
    h$ ^= passManager.hashCode();
    h$ *= 1000003;
    h$ ^= errorReporter.hashCode();
    h$ *= 1000003;
    h$ ^= typeRegistry.hashCode();
    h$ *= 1000003;
    h$ ^= cssRegistry.hashCode();
    return h$;
  }

  static final class Builder extends SoyFileSetParser.Builder {
    private SoyAstCache cache;
    private ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers;
    private ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits;
    private PassManager passManager;
    private ErrorReporter errorReporter;
    private SoyTypeRegistry typeRegistry;
    private Optional<CssRegistry> cssRegistry = Optional.empty();
    Builder() {
    }
    @Override
    public SoyFileSetParser.Builder setCache(SoyAstCache cache) {
      this.cache = cache;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setSoyFileSuppliers(ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers) {
      if (soyFileSuppliers == null) {
        throw new NullPointerException("Null soyFileSuppliers");
      }
      this.soyFileSuppliers = soyFileSuppliers;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setCompilationUnits(ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits) {
      if (compilationUnits == null) {
        throw new NullPointerException("Null compilationUnits");
      }
      this.compilationUnits = compilationUnits;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setPassManager(PassManager passManager) {
      if (passManager == null) {
        throw new NullPointerException("Null passManager");
      }
      this.passManager = passManager;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setErrorReporter(ErrorReporter errorReporter) {
      if (errorReporter == null) {
        throw new NullPointerException("Null errorReporter");
      }
      this.errorReporter = errorReporter;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setTypeRegistry(SoyTypeRegistry typeRegistry) {
      if (typeRegistry == null) {
        throw new NullPointerException("Null typeRegistry");
      }
      this.typeRegistry = typeRegistry;
      return this;
    }
    @Override
    public SoyFileSetParser.Builder setCssRegistry(Optional<CssRegistry> cssRegistry) {
      if (cssRegistry == null) {
        throw new NullPointerException("Null cssRegistry");
      }
      this.cssRegistry = cssRegistry;
      return this;
    }
    @Override
    public SoyFileSetParser build() {
      if (this.soyFileSuppliers == null
          || this.compilationUnits == null
          || this.passManager == null
          || this.errorReporter == null
          || this.typeRegistry == null) {
        StringBuilder missing = new StringBuilder();
        if (this.soyFileSuppliers == null) {
          missing.append(" soyFileSuppliers");
        }
        if (this.compilationUnits == null) {
          missing.append(" compilationUnits");
        }
        if (this.passManager == null) {
          missing.append(" passManager");
        }
        if (this.errorReporter == null) {
          missing.append(" errorReporter");
        }
        if (this.typeRegistry == null) {
          missing.append(" typeRegistry");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SoyFileSetParser(
          this.cache,
          this.soyFileSuppliers,
          this.compilationUnits,
          this.passManager,
          this.errorReporter,
          this.typeRegistry,
          this.cssRegistry);
    }
  }

}
