package com.google.template.soy.jbcsrc.restricted;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConstructorRef extends ConstructorRef {

  private final TypeInfo instanceClass;

  private final Method method;

  private final ImmutableList<Type> argTypes;

  AutoValue_ConstructorRef(
      TypeInfo instanceClass,
      Method method,
      ImmutableList<Type> argTypes) {
    if (instanceClass == null) {
      throw new NullPointerException("Null instanceClass");
    }
    this.instanceClass = instanceClass;
    if (method == null) {
      throw new NullPointerException("Null method");
    }
    this.method = method;
    if (argTypes == null) {
      throw new NullPointerException("Null argTypes");
    }
    this.argTypes = argTypes;
  }

  @Override
  public TypeInfo instanceClass() {
    return instanceClass;
  }

  @Override
  public Method method() {
    return method;
  }

  @Override
  public ImmutableList<Type> argTypes() {
    return argTypes;
  }

  @Override
  public String toString() {
    return "ConstructorRef{"
        + "instanceClass=" + instanceClass + ", "
        + "method=" + method + ", "
        + "argTypes=" + argTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConstructorRef) {
      ConstructorRef that = (ConstructorRef) o;
      return this.instanceClass.equals(that.instanceClass())
          && this.method.equals(that.method())
          && this.argTypes.equals(that.argTypes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= instanceClass.hashCode();
    h$ *= 1000003;
    h$ ^= method.hashCode();
    h$ *= 1000003;
    h$ ^= argTypes.hashCode();
    return h$;
  }

}
