/*
 * Copyright 2015 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.template.soy.jbcsrc.restricted;

/** Holds flags controlling compiler behavior. */
public final class Flags {
  /**
   * Controls extra debug checks in the compiler that are generally redundant with bytecode
   * verification. Currently only enabled in tests.
   */
  public static final boolean DEBUG = Boolean.getBoolean("soy_jbcsrc_debug_mode");

  private Flags() {}
}
