/* SoyFileParser.java */
/* Generated By:JavaCC: Do not edit this line. SoyFileParser.java */
package com.google.template.soy.soyparse;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;
import static com.google.template.soy.exprtree.Operator.createOperatorNode;

import com.google.template.soy.types.FunctionType;
import java.io.IOException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLocation.Point;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter.Checkpoint;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrorKind.StyleAllowance;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNode.PrimitiveNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.DelPackageDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.Comment;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ExternImplNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.JavaImplNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode.BlockNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNode.SoyFileHeaderInfo;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.TemplateType.ParameterKind;
import com.google.template.soy.types.ast.FunctionTypeNode;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.Set;
import javax.annotation.Nullable;

/**
 * This parser's specification is in SoyFileParser.jj, which is read by JavaCC and transformed
 * into SoyFileParser.java. To modify this parser, please edit SoyFileParser.jj. Do not edit
 * SoyFileParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses the following Soy file structure:
 *
 * 1. Delegate package (delpackage/mod):
 *    + Optional.
 *    + The file must contain 0 or 1 delpackage declaration.
 *    + It must appear before the namespace declaration.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:  {delpackage MySecretFeature} or {mod MySecretFeature}
 *
 * 2. Namespace:
 *    + The file must contain exactly one namespace declaration.
 *    + It must appear before any templates.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:
 *    {namespace boo.foo}
 *
 * 3. Alias:
 *    + Alias declarations must appear after the namespace declaration.
 *    + They must appear before any templates.
 *    + Each must appear on its own line and start at the start of a line.
 *    Examples:
 *    {alias boo.foo.goo.moo}
 *    {alias boo.foo.goo.moo as zoo}
 *
 * 4. SoyDoc:
 *    + Starts with slash-star-star (/**) and ends with star-slash (*&#47;) like JavaDoc.
 *    + SoyDoc must appear on its own line(s) and start at the start of a line.
 *
 * 5. Template:
 *    + The {template} tag and the {/template} tag must each appear on its own line(s) and start
 *      at the start of a line.
 *    Examples:
 *    /**
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *    {template foo autoescape="..."}
 *      {msg desc=""}
 *        {$boo} has a friend named {$goo.firstName}.
 *      {/msg}
 *    {/template}
 *
 * 6. Misc:
 *    + Other than the items specified above, everything else is ignored.
 *    + SoyDoc blocks not immediately followed by a template are ignored.
 *    + The file must end with a newline.
 *
 * Template contents are parsed as follows:
 *
 * Header:
 *
 * 1. Comments:
 *    + Standard "//" for a rest-of-line comment. Must appear at start of line or after a space.
 *    + Standard slash-star (/*) ... star-slash (*&#47;) for a block comment.
 *    + Doc comments are not allowed, except when attached to a valid declaration.
 *
 * 2. Param declaration:
 *    + Soy tag with command name "@param" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@param' tag.
 *    Examples:
 *    {@param foo: bool}
 *    {@param foo: list<int>}  /** A list of numbers. *&#47;
 *    {@param? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 3. Injected param declaration:
 *    + Works exactly like @param except that parameter values are taken from the
 *      implicit $ij scope.
 *    + Soy tag with command name "@inject" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@inject' tag.
 *    Examples:
 *    {@inject foo: bool}
 *    {@inject foo: list<int>}  /** A list of numbers. *&#47;
 *    {@inject? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 4. State variable declaration:
 *    + Soy tag with command name "@state" and command text "key: type".
 *    + State variables must be explicitly initialized.
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the state tag, or must start on the same line as the end of the '@state' tag.
 *    Examples:
 *    {@state foo: bool = true}
 *    {@state foo: list<int> = [1, 2, 3]}  /** A list of numbers. *&#47;
 *
 * Body:
 *
 * 1. Soy tag format:
 *    + Can be delimited by single braces "{...}".
 *    + } characters are only allowed in tags if they're inside string literals.
 *    + Some Soy tags are allowed to end in "/}" to denote immediate ending of a block.
 *    + It is an error to use "/}" when it's not applicable to the command.
 *    + If there is a command name, it must come immediately after the opening delimiter.
 *    + The command name must be followed by either the closing delimiter (if the command does not
 *      take any command text) or a whitespace (if the command takes command text).
 *    Examples:
 *    {print $boo}   // explicit 'print' command
 *    {$boo.foo}   // implicit 'print' command
 *    {printer}   // implicit 'print' command (the prefix 'print' here is not a command name)
 *    {\n}   // a command that doesn't take any command text
 *    {call gooMoo data="all" /}   // self-ending block
 *    {call gooMoo data="all"}...{/call}   // block with separate start and end tags
 *
 * 2. Raw text:
 *    + Raw text is fixed text that will be part of the template output. There are 3 types.
 *    + Any text outside of Soy tags is raw text.
 *    + There are 8 special character commands that produce raw text strings:
 *      {sp} = space   {nil} = empty string   {\n} = newline (line feed)   {\r} = carriage return
 *      {\t} = tab   {lb} = left brace   {rb} = right brace   {nbsp} = non-breaking space
 *    + A section of raw text (may contain braces) can be enclosed within a 'literal' block:
 *      {literal}...{/literal}
 *
 * 3. Msg blocks:
 *    + A block between {msg} and {/msg} tags represents a message for translation.
 *    + It is an error to nest {msg} blocks.
 *    + Within a {msg} block, the parsing of Soy tags is the same. The only difference is that we
 *      also recognize "&lt;" and "&gt;" as opening and closing an HTML tag. This is because each
 *      HTML tag as a whole needs to be turned into a single placeholder in the message.
 *    + A {msg} block may have a {plural} or {select} block as its only content.
 *    + A {msg} block may be followed by one optional additional {fallbackmsg} block.
 *    Example:
 *    {msg desc="Event title."}
 *      Join event &lt;a href="{$event.url}"&gt;{$event.title}&lt;/a&gt;.
 *    {fallbackmsg desc="Event title."}
 *      Join event {$event.title}.
 *    {/msg}
 *
 * 4. Other Soy commands:
 *    {print ...}
 *    {...}    // implied 'print' command
 *    {xid ...}
 *    {css ...}
 *    {let ... /}
 *    {let ...}...{/let}
 *    {if ...}...{elseif ...}...{else ...}...{/if}
 *    {switch ...}{case ...}...{default}...{/switch}
 *    {foreach ...}...{ifempty}...{/foreach}
 *    {for ...}...{/for}
 *    {call ... /}
 *    {delcall ... /}
 *    {call ...}{param ... /}{param ...}...{/param}{/call}
 *    {delcall ...}{param ... /}{param ...}...{/param}{/delcall}
 *    {log}...{/log}
 *    {debugger}
 *    {velog ...}....{/velog}
 *    {key ...}
 *
 * 5. Misc:
 *    + The following commands are not allowed to appear in a template:
 *      {alias ...}   {namespace ...}   {delpackage ...}   {mod ...}  {template ...}   {deltemplate ...}
 *
 * Expressions:
 *
 * A. Variable:
 *    + A dollar sign "$" followed by an identifier (no space between).
 *
 * B. Data reference:
 *    + The first part must be "$" followed by the first key name (no space between).
 *    + The first key name cannot be a number.
 *    + A variable will only have the first part. A data reference may have subsequent parts.
 *    + Subsequent parts may be:
 *       - A dot "." or question-dot "?." followed by a key name or array index (spaces between are
 *         allowed).
 *       - Brackets "[ ]" or question-brackets "?[ ]" with any expression inside the brackets (see
 *         below for definition of expression).
 *    + A special case is when the first key name is "ij". In this case, it's a reference to
 *      injected data, and the reference is considered to start from the second key (i.e. the second
 *      key actually becomes the first key in the parsed node).
 *    Examples:   $aaa   $ij.aaa   $aaa.bbb.0.ccc.12   $aaa[0]['bbb'].ccc   $aaa[$bbb + $ccc]
 *
 * C. Global:
 *    + One or more identifiers. If more than one, a dot "." is used to separate them.
 *    + Must not be preceded by a dollar sign "$".
 *    Examples:   AAA   aaa.bbb.CCC   a22.b88_
 *
 * D. Expression list:
 *    + A comma-separated list of one or more expressions (see below for definition of expression).
 *    Examples:   $aaa, $bbb.ccc + 1, round(3.14)
 *
 * E. Named parameter list:
 *    + A named parameter list, used only for proto initialization calls.
 *    + A comma-separate list of named expressions, in which names and expressions are separated by
 *      a colon ":".
 *    + Named and unnamed expressions cannot be mixed within the same function call.
 *    Examples:   foo: $aaa, bar: $bbb.ccc + 1, baz: round(3.14)
 *
 * F. Expression:
 *
 *    1. Data reference:
 *       + See above for definition.
 *
 *    2. Global:
 *       + See above for definition.
 *
 *    3. Null:   null
 *
 *    4. Boolean:   false   true
 *
 *    5. Integer:
 *       + No octal numbers.
 *       + Hex numbers have strict lower case "x" in "0x" and "A-F" or "a-f".
 *       Examples:   0   26   -729   0x1a2B
 *
 *    6. Float:
 *       + Decimal numbers only.
 *       + Must have digits on both sides of decimal point.
 *       + Exponents have strict lower case "e".
 *       Examples:   0.0   3.14159   -20.0   6.03e23   -3e-3
 *
 *    7. String:
 *       + Single quotes only.
 *       + Escape sequences:   \\   \'   \"   \n   \r   \t   \b   \f
 *       + Unicode escape:   \ u ####   (backslash, "u", four hex digits -- no spaces in between)
 *       Examples:   ''   'abc'   'blah bleh bluh'   'aa\\bb\'cc\ndd'   '☺'
 *
 *    8. List literal:
 *       + Delimited by brackets.
 *       Examples:   []   ['blah', 123, $foo]
 *
 *    9. Record literal:
 *       + Delimited by record().
 *       + Keys must be identifiers.
 *       Examples:   record()   record(aaa: 'blah', bbb: 123, boo: $foo)
 *
 *    10. Operator:
 *       + Parentheses can be used to override precedence rules:   ( )
 *       + Precedence 8:   - (unary)   not
 *       + Precedence 7:   *   /   %
 *       + Precedence 6:   +   - (binary)
 *       + Precedence 5:   <   >   <=   >=
 *       + Precedence 4:   ==   !=
 *       + Precedence 3:   and
 *       + Precedence 2:   or
 *       + Precedence 1:   ?: (binary)   ? : (ternary)
 *
 *    11. Function:
 *       + Function name, open parenthesis, optional expression list, close parenthesis.
 *       + The function name is one or more identifiers, separated by dots.
 *       + See above for the definition of an expression list.
 *       Examples:   foo()   parseInt($item)   my.new.Proto(a: 'str', b: $foo)
 *
 *    12. Proto initialization:
 *       + Fully qualified proto name, open parenthesis, optional named parameter list,
 *         close parenthesis.
 *       + See above for the definition of a named parameter list.
 *       Examples:   proto()   my.new.Proto(a: 'str', b: $foo)*
 * </pre>
 */
public class SoyFileParser implements SoyFileParserConstants {

  // Template errors:
  private static final SoyErrorKind INVALID_ALIAS_NAME =
      SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.");
  private static final SoyErrorKind INVALID_CALLEE_NAME =
      SoyErrorKind.of("Invalid callee name ''{0}''.");
  private static final SoyErrorKind INVALID_TEMPLATE_NAME =
      SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot "
          + "followed by an identifier.");
  private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK =
      SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");
  private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS =
      SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.");
  private static final SoyErrorKind PLURAL_CASE_MALFORMED =
      SoyErrorKind.of("Invalid number in ''plural case'' command text.");
  private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER =
      SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.");
  private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE =
      SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.");
  // There's nothing technical preventing us from allowing default values on injected parameters,
  // but we're not sure if that's something we want in the language, so we're preventing it for now.
  private static final SoyErrorKind INJECT_DEFAULT_PARAM =
      SoyErrorKind.of("Default parameters are not supported on injected parameters.");
  private static final SoyErrorKind OPTIONAL_DEFAULT_PARAM =
      SoyErrorKind.of(
          "Default parameters are not supported on optional parameters. Did you mean "
          + "'''{@param ...}'''?");
  private static final SoyErrorKind STATE_IN_TEMPLATE =
      SoyErrorKind.of("@state declarations are only allowed in elements.");
  private static final SoyErrorKind STATE_REQUIRES_VALUE =
      SoyErrorKind.of("@state declarations require an initial value.");

  // Expression errors:
  static final SoyErrorKind DUPLICATE_KEY_NAME =
      SoyErrorKind.of("Duplicate argument ''{0}''.");
  private static final SoyErrorKind INVALID_RECORD_KEY = SoyErrorKind.of(
      "Invalid record key ''{0}''. A record key must be a valid Soy identifier. Did you mean to use a map?");
  private static final SoyErrorKind INTEGER_OUT_OF_RANGE =
      SoyErrorKind.of(
          "Soy integers are constrained to the range of JavaScript integers: "
              + "https://www.ecma-international.org/ecma-262/5.1/#sec-8.5",
          StyleAllowance.NO_PUNCTUATION);
  private static final SoyErrorKind INVALID_PARAM_NAME =
      SoyErrorKind.of("Invalid param name ''{0}''.");
  private static final SoyErrorKind UNEXPECTED_PIPE =
      SoyErrorKind.of("Unexpected ''|''. Print directives should not have whitespace after ''|''.");
  private static final SoyErrorKind EMPTY_RECORD_LITERAL =
      SoyErrorKind.of("Empty record literal.");
  private static final SoyErrorKind RECORD_NAMED_PARAMS =
      SoyErrorKind.of("Record literals require named parameters.");
  private static final SoyErrorKind EMPTY_RECORD_TYPE =
      SoyErrorKind.of("Empty record type.");
  private static final SoyErrorKind LEGACY_NOT_ERROR =
      SoyErrorKind.of("Found use of ''!'' instead of the ''not'' operator.");

  // Extern errors:
  private static final SoyErrorKind MULTIPLE_IMPLS =
      SoyErrorKind.of("An extern can only have one implementation per language.");

  // Error message that mimics a ParseException
  private static final SoyErrorKind PARSER_ERROR =
      SoyErrorKind.of(
          "parse error at ''{0}'': expected {1}",
          StyleAllowance.NO_CAPS,
          StyleAllowance.NO_PUNCTUATION);

  /** Names of attributes whose values should be parsed as expressions. */
  private static final ImmutableSet<String> EXPR_ATTR_NAMES =
      ImmutableSet.of("data", "genders", "key", "logonly", "variant", "modifies");

  private static List<CommandTagAttribute> validateAttributes(
      SourceLocation currentLocation, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
    for (CommandTagAttribute attribute : attributes) {
      if (currentLocation != null && currentLocation.isJustBefore(attribute.getName().location())) {
        errorReporter.report(
            attribute.getName().location(),
            PARSER_ERROR,
            attribute.getName().identifier(),
            "whitespace");
      }
      currentLocation = attribute.getSourceLocation();
    }
    return attributes;
  }

  /** Attempts to parse the given input as a Soy expression. */
  public static ExprNode parseExprOrDie(String exprText) {
    return parseExpression(exprText, ErrorReporter.exploding());
  }

  /** Attempts to parse the given input as a Soy expression. Returns null if parsing fails. */
  @Nullable
  public static ExprNode parseExpression(
      String exprText, ErrorReporter errorReporter) {
    SourceFilePath filePath = SourceFilePath.create("expression parser");
    SoyFileParser parser = new SoyFileParser(exprText, filePath, errorReporter);
    try {
      return parser.ExprInput();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(
          errorReporter, filePath, e, parser.token_source.curLexState);
      return null;
    }
  }

  /** Attempts to parse the given input as a type node. Returns null if parsing fails. */
  @Nullable
  public static TypeNode parseType(
      String typeText,
      SourceFilePath filePath,
      ErrorReporter errorReporter) {
    SoyFileParser parser = new SoyFileParser(typeText, filePath, errorReporter);
    try {
      return parser.TypeExprInput();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(
          errorReporter, filePath, e, parser.token_source.curLexState);
      return null;
    }
  }

  /** Node id generator for the tree being built. */
  private IdGenerator nodeIdGen;

  /** Path of source being parsed. This is descriptive, not a means to refetch source. */
  public SourceFilePath filePath;

  /** Controls how to handle whitespaces (e.g. whether to join lines or preserve whitespace). */
  private WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;

  /** For reporting errors during parsing. */
  private ErrorReporter errorReporter;

  /** The header info for the file we are parsing. */
  private SoyFileHeaderInfo headerInfo;

  // The names of all import symbols that can be referenced, (e.g. "foo" and "myBar" in:
  // "import {foo, bar as myBar} from ...").
  public List<String> importSymbols = new ArrayList<String>();

  /**
   * Constructor that takes a reader object providing the input.
   *
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param filePath The path of the source being parsed. Used for reporting.
   * @param errorReporter For reporting parse errors.
   */
  public SoyFileParser(
      IdGenerator nodeIdGen,
      Reader input,
      SourceFilePath filePath,
      ErrorReporter errorReporter) {
    this(new SoyFileParserTokenManager(new SoySimpleCharStream(input)));
    this.nodeIdGen = checkNotNull(nodeIdGen);
    this.filePath = checkNotNull(filePath);
    this.errorReporter = checkNotNull(errorReporter);
    initTokenSource();
  }

  /** Constructor for use by parseExpression() and parseType() only. */
  private SoyFileParser(
      String input,
      SourceFilePath filePath,
      ErrorReporter errorReporter) {
    // this starts the lexer in a particular state instead of DEFAULT
    this(new SoyFileParserTokenManager(
        new SoySimpleCharStream(new StringReader(input), 1, 1), EXPR));
    this.filePath = filePath;
    this.errorReporter = checkNotNull(errorReporter);
    // Some part of the parser assume that header info is not null.
    this.headerInfo = SoyFileHeaderInfo.EMPTY;
    initTokenSource();
  }

  private void initTokenSource() {
    this.token_source.setParser(this);
  }

  /** Attempts to parse the given input as a Soy file. Returns null if parsing fails. */
  @Nullable
  public SoyFileNode parseSoyFile() {
    checkNotNull(nodeIdGen);
    Checkpoint checkpoint = errorReporter.checkpoint();
    SoyFileNode soyFileNode = null;
    try {
      soyFileNode = SoyFile();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, token_source.curLexState);
    } catch (TokenMgrError e) {
      ParseErrors.reportTokenMgrError(errorReporter, filePath, e);
    }

    // our callers expect us to return null when encountering parsing errors.
    if (errorReporter.errorsSince(checkpoint)) {
      return null;
    }
    // Parse the html tags
    // See comments on HtmlRewriter for why this isn't deeply integrated into this parser.
    HtmlRewriter.rewrite(soyFileNode, nodeIdGen, errorReporter);
    return soyFileNode;
  }

  /**
   * Reports the error and skips to the given token.
   *
   * See https://javacc.org/tutorials/errorrecovery
   */
  private void reportFileErrorAndSkipTo(ParseException error, int skipTo) {
    ParseErrors.reportSoyFileParseException(
        errorReporter, filePath, error, token_source.curLexState);
    Token t;
    do {
      t = getNextToken();
    // We need to halt when observing EOF.  The behavior of the token manager is to keep returning
    // EOF from getNextToken(), so if we don't check for it this will become an infinite loop.
    } while (t.kind != skipTo && t.kind != EOF);
  }

  /**
   * Reports the error and skips to the given token if it observes the end of a template; throws an
   * exception to halt parsing.
   *
   * See https://javacc.org/tutorials/errorrecovery
   */
  @CheckReturnValue
  private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int... kinds) {
    ParseErrors.reportSoyFileParseException(
        errorReporter, filePath, error, token_source.curLexState);
    return skipToTemplateToken(kinds);
  }

  /**
   * Reports the error and skips to the given token if it observes the end of a template; throws an
   * exception to halt parsing.
   *
   * Accepts an "adviceToUser" string to provide debugging tips for common syntax mistakes.
   *
   * See https://javacc.org/tutorials/errorrecovery
   */
  @CheckReturnValue
  private Token reportTemplateBodyErrorAndSkipTo(ParseException error, String adviceToUser,
        int... kinds) {
    ParseErrors.reportSoyFileParseException(
        errorReporter, filePath, error, token_source.curLexState, adviceToUser);
    return skipToTemplateToken(kinds);
  }

  @CheckReturnValue
  private Token skipToTemplateToken(int... kinds) {
    ImmutableSet<Integer> skipTo = ImmutableSet.copyOf(Ints.asList(kinds));
    Token t;
    while (true) {
      t = getNextToken();
      if (skipTo.contains(t.kind)) {
        return t;
      }
      // We need to halt when observing EOF.  The behavior of the token manager is to keep returning
      // EOF from getNextToken(), so if we don't check for it this will become an infinite loop.
      if (t.kind == CMD_CLOSE_TEMPLATE || t.kind == CMD_CLOSE_DELTEMPLATE || t.kind == EOF) {
        throw new AbortParsingError();
      }
    }
  }

  /**
   * Gets the point just before the upcoming token. Note that the {@link SimpleCharStream}'s
   * "tokenBegin" refers to the upcoming token that hasn't actually been parsed yet. So for
   * "foo bar baz", once the parser has executed a line like "token foo = foo()", the current token
   * would be bar and not foo.
   *
   * See the generated char stream class here:
   */
  @CheckReturnValue
  Point getPointJustBeforeNextToken() {
    return ((SoySimpleCharStream) (token_source.input_stream)).getPointJustBeforeNextToken();
  }

  /** Creates a source location that starts at the token and ends at the given point. */
  private SourceLocation createSrcLoc(Token t, Point p) {
   return createSrcLoc(t).extend(p);
  }

  /** Create a SourceLocation spanning all given tokens. */
  SourceLocation createSrcLoc(Token tok1, Token... rest) {
    return Tokens.createSrcLoc(filePath, tok1, rest);
  }

  /** Create a SourceLocation spanning between the given token and node. */
  private SourceLocation createSrcLoc(Token tok1, Node lastNode) {
    return createSrcLoc(tok1).extend(lastNode.getSourceLocation());
  }

  /** Create a SourceLocation spanning between the given nodes. */
  private SourceLocation createSrcLoc(Node firstNode, Node lastNode) {
    return firstNode.getSourceLocation().extend(lastNode.getSourceLocation());
  }

  /** Create a SourceLocation spanning between a token and the last of a list of nodes. */
  private SourceLocation createSrcLoc(Token tok1, List<? extends Node> nodes) {
    if (nodes.isEmpty()) {
      return createSrcLoc(tok1);
    }
    return createSrcLoc(tok1, nodes.get(nodes.size() - 1));
  }

  /** Create a SourceLocation spanning a list of nodes. */
  private SourceLocation createSrcLoc(List<? extends Node> nodes) {
    if (nodes.isEmpty()) {
      return new SourceLocation(filePath);
    }
    return createSrcLoc(nodes.get(0), nodes.get(nodes.size() - 1));
  }

  /** Create an error ExprNode at the location of the given tokens. */
  private VarRefNode errorExpr(Token tok1, Token... rest) {
    return VarRefNode.error(createSrcLoc(tok1, rest));
  }

  private ImmutableList<Comment> buildComments(SoyFileParserTokenManager manager) {
    ImmutableList.Builder<Comment> comments = ImmutableList.builder();
    for (Comment comment : manager.comments) {
      comments.add(comment);
    }
    return comments.build();
  }

  private CommandTagAttribute newTag(
      Identifier id, QuoteStyle quoteStyle, ImmutableList<ExprNode> exprList, SourceLocation loc) {
    if (id.identifier().equals("data")
        && exprList.size() == 1
        && exprList.get(0).toSourceString().equals("all")) {
      SourceLocation valueLoc = exprList.get(0).getSourceLocation();
      SourceLocation withQuotes = new SourceLocation(
          valueLoc.getFilePath(), valueLoc.getBeginPoint().offset(0, -1), valueLoc.getEndPoint().offset(0, 1));
      return new CommandTagAttribute(id, quoteStyle, "all", withQuotes, loc);
    }
    return new CommandTagAttribute(id, quoteStyle, exprList, loc);
  }

  // An error that can be thrown to abort parsing.  This is useful if an error has been reported
  // and it is known that parsing cannot continue.
  private static final class AbortParsingError extends Error {}

  /** Propagates advice to ParseErrors in a more natural way. Always avoids double logging. */
  static final class ParseExceptionWithAdvice extends ParseException {
    final ParseException original;
    final String advice;

    ParseExceptionWithAdvice(ParseException original, String advice) {
      this.original = original;
      this.advice = advice;
    }
  }

  /** State available while parsing a single expression. */
  static final class ExprState {
    // If this is the expression of a print command.
    final boolean isPrint;
    // How many () nestings deep we are.
    int groupNesting = 0;

    ExprState(boolean isPrint) {
      this.isPrint = isPrint;
    }
  }

  final private SoyFileNode SoyFile() throws ParseException {SoyFileNode file;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 0:{
      file = EmptySoyFile();
      break;
      }
    case NAMESPACE_OPEN:
    case DELPACKAGE_OPEN:
    case MODNAME_OPEN:{
      file = NonEmptySoyFile();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return file;}
    throw new Error("Missing return statement in function");
  }

  final private SoyFileNode EmptySoyFile() throws ParseException {Token eof;
    eof = jj_consume_token(0);
{if ("" != null) return new SoyFileNode(
        nodeIdGen.genId(),
        new SourceLocation(filePath,
            SourceLocation.Point.create(1, 1),
            SourceLocation.Point.create(Math.max(1, eof.beginLine), Math.max(1, eof.beginColumn))),
            NamespaceDeclaration.EMPTY,
            SoyFileHeaderInfo.EMPTY,
            buildComments(token_source));}
    throw new Error("Missing return statement in function");
  }

  final private SoyFileNode NonEmptySoyFile() throws ParseException {DelPackageDeclaration delpackageDecl = null;
  NamespaceDeclaration namespace;
  AliasDeclaration alias;
  ImportNode importNode;
  ConstNode constant;
  ExternNode extern;
  ImmutableList.Builder<AliasDeclaration> aliases = new ImmutableList.Builder<AliasDeclaration>();
  ImmutableList.Builder<ImportNode> imports = new ImmutableList.Builder<ImportNode>();
  ImmutableList.Builder<ConstNode> constants = new ImmutableList.Builder<ConstNode>();
  ImmutableList.Builder<ExternNode> externs = new ImmutableList.Builder<ExternNode>();
  TemplateNode template;
  Token eof;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DELPACKAGE_OPEN:
    case MODNAME_OPEN:{
      delpackageDecl = DelPackage();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    namespace = Namespace();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALIAS_OPEN:
      case IMPORT_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALIAS_OPEN:{
        alias = Alias();
if (alias != null) {
        aliases.add(alias);
      }
        break;
        }
      case IMPORT_OPEN:{
        importNode = Import();
if (importNode != null) {
        imports.add(importNode);
      }
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONST_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      constant = ConstStmt();
if (constant != null) {
        constants.add(constant);
      }
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTERN_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      extern = ExternStmt();
if (extern != null) {
        externs.add(extern);
      }
    }
headerInfo = new SoyFileHeaderInfo(errorReporter, delpackageDecl, namespace,
        aliases.build(), importSymbols);
    List<TemplateNode> templates = new ArrayList<TemplateNode>();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DELTEMPLATE_OPEN:
      case TEMPLATE_OPEN:
      case ELEMENT_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      template = Template(headerInfo);
if (template != null) {
        // it will be null if a parsing error occurred
        templates.add(template);
      }
    }
    eof = jj_consume_token(0);
SoyFileNode sfn = new SoyFileNode(
        nodeIdGen.genId(),
        new SourceLocation(filePath, SourceLocation.Point.create(1, 1),
            SourceLocation.Point.create(eof.beginLine, eof.beginColumn)),
            namespace, headerInfo, buildComments(token_source));
    sfn.addChildren(imports.build());
    sfn.addChildren(constants.build());
     sfn.addChildren(externs.build());
    sfn.addChildren(templates);
    {if ("" != null) return sfn;}
    throw new Error("Missing return statement in function");
  }

  final private ExternNode ExternStmt() throws ParseException {Token open, name, openClose, close;
  List<CommandTagAttribute> attributes;
  FunctionTypeNode type;
  ExternImplNode impl;
List<ExternImplNode> impls = new ArrayList<ExternImplNode>();
    open = jj_consume_token(EXTERN_OPEN);
    name = jj_consume_token(NAME);
    jj_consume_token(CMD_COLON);
    type = FunctionType();
    openClose = jj_consume_token(CMD_END);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_OPEN_JS_IMPL:{
        impl = JsImplStmt();
impls.add(impl);
        break;
        }
      case CMD_OPEN_JAVA_IMPL:{
        impl = JavaImplStmt();
impls.add(impl);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_OPEN_JS_IMPL:
      case CMD_OPEN_JAVA_IMPL:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_5;
      }
    }
    close = jj_consume_token(CMD_CLOSE_EXTERN);
boolean hasJsImpl = false;
    boolean hasJavaImpl = false;
    for (ExternImplNode parsedImpl : impls) {
      if (parsedImpl instanceof JsImplNode) {
        if (hasJsImpl) {
          errorReporter.report(parsedImpl.getSourceLocation(), MULTIPLE_IMPLS);
        }
        hasJsImpl = true;
      }
      if (parsedImpl instanceof JavaImplNode) {
        if (hasJavaImpl) {
          errorReporter.report(parsedImpl.getSourceLocation(), MULTIPLE_IMPLS);
        }
        hasJavaImpl = true;
      }
    }
    boolean exported = open.image.startsWith("{export ");
    ExternNode node = new ExternNode(nodeIdGen.genId(), createSrcLoc(open, close),
        Identifier.create(name.image, createSrcLoc(name)), type,
        createSrcLoc(open, openClose), exported);
    node.addChildren(impls);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private JsImplNode JsImplStmt() throws ParseException {Token open, close;
  List<CommandTagAttribute> attributes;
    open = jj_consume_token(CMD_OPEN_JS_IMPL);
    attributes = Attributes();
    close = jj_consume_token(CMD_SELF_CLOSE);
SourceLocation srcLoc = createSrcLoc(open, close);
    validateAttributes(null, attributes, errorReporter);
    {if ("" != null) return new JsImplNode(nodeIdGen.genId(), srcLoc, attributes, errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private JavaImplNode JavaImplStmt() throws ParseException {Token open, close;
  List<CommandTagAttribute> attributes;
    open = jj_consume_token(CMD_OPEN_JAVA_IMPL);
    attributes = Attributes();
    close = jj_consume_token(CMD_SELF_CLOSE);
SourceLocation srcLoc = createSrcLoc(open, close);
    validateAttributes(null, attributes, errorReporter);
    {if ("" != null) return new JavaImplNode(nodeIdGen.genId(), srcLoc, attributes, errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private AliasDeclaration Alias() throws ParseException {Token open, close;
  Identifier namespace, alias = null;
    open = jj_consume_token(ALIAS_OPEN);
    namespace = Identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      Keyword("as");
      alias = Identifier();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    close = jj_consume_token(CMD_END);
SourceLocation srcLoc = createSrcLoc(open, close);

    if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
      errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
      {if ("" != null) return null;}
    }

    if (alias == null) {
      // The alias command contains only the namespace, and the alias portion (i.e. as Foo) is
      // missing. The namespace is implicitly aliased to the last portion of the dotted identifier.
      {if ("" != null) return AliasDeclaration.create(srcLoc, namespace);}
    }
    {if ("" != null) return AliasDeclaration.create(srcLoc, namespace, alias);}
    throw new Error("Missing return statement in function");
  }

  final private ImportedVar ModuleImportVar() throws ParseException {Token star = null;
  Token identifier = null;
  Token alias = null;
    star = jj_consume_token(STAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      Keyword("as");
      alias = jj_consume_token(IDENT);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
if (alias == null) {
      errorReporter.report(createSrcLoc(star), PARSER_ERROR, star.image, "'import * as Foo'");
      {if ("" != null) return new ImportedVar("*", "ERROR", createSrcLoc(star));}
    } else {
      importSymbols.add(alias.image);
      {if ("" != null) return new ImportedVar("*", alias.image, createSrcLoc(star, alias));}
    }
    throw new Error("Missing return statement in function");
  }

  final private ImmutableList<ImportedVar> SymbolImportVarList() throws ParseException {Token star = null;
  Token identifier = null;
  Token alias = null;
  SourceLocation loc;
  ImmutableList.Builder<ImportedVar> importedVars = new ImmutableList.Builder<ImportedVar>();
    identifier = jj_consume_token(IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      Keyword("as");
      alias = jj_consume_token(IDENT);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
String a1 = null;
    loc = createSrcLoc(identifier);
    if (alias != null) {
      a1 = alias.image;
      loc = loc.extend(createSrcLoc(alias));
      importSymbols.add(alias.image);
    } else {
      importSymbols.add(identifier.image);
    }
    importedVars.add(new ImportedVar(identifier.image, a1, loc));
    alias = null;
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DEFAULT_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      jj_consume_token(DEFAULT_COMMA);
      identifier = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        Keyword("as");
        alias = jj_consume_token(IDENT);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        ;
      }
String a2 = null;
      loc = createSrcLoc(identifier);
      if (alias != null) {
        a2 = alias.image;
        loc = loc.extend(createSrcLoc(alias));
        importSymbols.add(alias.image);
      } else {
        importSymbols.add(identifier.image);
      }
      importedVars.add(new ImportedVar(identifier.image, a2, loc));
      alias = null;
    }
{if ("" != null) return importedVars.build();}
    throw new Error("Missing return statement in function");
  }

  final private ImportNode Import() throws ParseException {Token open, close;
  StringNode path = null;
  ImportedVar moduleImportVar;
  ImmutableList<ImportedVar> identifiers = ImmutableList.of();
    open = jj_consume_token(IMPORT_OPEN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LCURLY:
    case STAR:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        moduleImportVar = ModuleImportVar();
identifiers = ImmutableList.of(moduleImportVar);
        break;
        }
      case LCURLY:{
        jj_consume_token(LCURLY);
        // Individual symbol imports ("import {foo, bar as myBar} from 'path.file.soy'").
                identifiers = SymbolImportVarList();
        jj_consume_token(RCURLY);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(FROM);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    path = StringLiteral();
    close = jj_consume_token(SEMICOLON);
{if ("" != null) return new ImportNode(nodeIdGen.genId(), createSrcLoc(open, close), path,
          identifiers);}
    throw new Error("Missing return statement in function");
  }

  final private NamespaceDeclaration Namespace() throws ParseException {Token open, close;
  Identifier name;
  List<CommandTagAttribute> attributes;
    open = jj_consume_token(NAMESPACE_OPEN);
    name = DottedIdent();
    attributes = Attributes();
    close = jj_consume_token(CMD_END);
validateAttributes(createSrcLoc(open), attributes, errorReporter);
    {if ("" != null) return new NamespaceDeclaration(name, attributes, errorReporter, createSrcLoc(open, close));}
    throw new Error("Missing return statement in function");
  }

  final private List<CommandTagAttribute> Attributes() throws ParseException {CommandTagAttribute attr;
  List<CommandTagAttribute> attributes = ImmutableList.of();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      attr = Attribute();
if (attributes.isEmpty()) {
        attributes = new ArrayList<CommandTagAttribute>();
      }
      attributes.add(attr);
    }
CommandTagAttribute.removeDuplicatesAndReportErrors(attributes, errorReporter);
    {if ("" != null) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final private CommandTagAttribute Attribute() throws ParseException {Identifier name;
  Token nameToken, value;
  ImmutableList<ExprNode> exprList = ImmutableList.of();
  Token qToken;
  Token startValue;
  QuoteStyle quoteStyle;
checkState(token_source.curLexState == IN_CMD_TAG || token_source.curLexState == EXPR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      nameToken = jj_consume_token(NAME);
      break;
      }
    case IDENT:{
      nameToken = jj_consume_token(IDENT);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
name = Identifier.create(nameToken.image, createSrcLoc(nameToken));
    // At this point we have an attribute, so make sure we're in the IN_CMD_TAG lexical state, which
    // is required to parse the attribute (this will switch EXPR to IN_CMD_TAG, if already in
    // IN_CMD_TAG this is a no-op). We only want to do this when we're sure we have an attribute
    // because if there is no attribute, the next token will be a "}", which will switch the lexical
    // state to TEMPLATE_DEFAULT so we can parse the template contents. At this point, if the next
    // token is a "}" it will already have been tokenized and the lexical state will have already
    // switched to TEMPLATE_DEFAULT, so we don't override that here.
    token_source.SwitchTo(IN_CMD_TAG);
    jj_consume_token(CMD_EQ);
    if (EXPR_ATTR_NAMES.contains(name.identifier())) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOUBLE_QUOTE:{
        jj_consume_token(CMD_DOUBLE_QUOTE);
quoteStyle = QuoteStyle.DOUBLE;
        token_source.SwitchTo(EXPR_NO_DOUBLE_QUOTE);
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NULL:
          case TRUE:
          case FALSE:
          case DEC_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case SINGLE_QUOTE:
          case DOUBLE_QUOTE:
          case MINUS:
          case NOT:
          case LBRACKET:
          case LPAREN:
          case ASSERT_NON_NULL:
          case IDENT:{
            exprList = ExprList(false);
            break;
            }
          default:
            jj_la1[18] = jj_gen;
            ;
          }
          qToken = jj_consume_token(END_DQ_EXPR_ATTR);
        } catch (ParseException e) {
token_source.SwitchTo(IN_CMD_TAG);
        exprList = ImmutableList.of(errorExpr(e.currentToken));
        qToken = reportTemplateBodyErrorAndSkipTo(e, CMD_DOUBLE_QUOTE, END_DQ_EXPR_ATTR);
        }
        break;
        }
      case CMD_SINGLE_QUOTE:{
        jj_consume_token(CMD_SINGLE_QUOTE);
quoteStyle = QuoteStyle.SINGLE;
        token_source.SwitchTo(EXPR_NO_SINGLE_QUOTE);
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NULL:
          case TRUE:
          case FALSE:
          case DEC_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case SINGLE_QUOTE:
          case DOUBLE_QUOTE:
          case MINUS:
          case NOT:
          case LBRACKET:
          case LPAREN:
          case ASSERT_NON_NULL:
          case IDENT:{
            exprList = ExprList(false);
            break;
            }
          default:
            jj_la1[19] = jj_gen;
            ;
          }
          qToken = jj_consume_token(END_SQ_EXPR_ATTR);
        } catch (ParseException e) {
token_source.SwitchTo(IN_CMD_TAG);
        exprList = ImmutableList.of(errorExpr(e.currentToken));
        qToken = reportTemplateBodyErrorAndSkipTo(e, CMD_SINGLE_QUOTE, END_SQ_EXPR_ATTR);
        }
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (exprList.isEmpty()) {
        errorReporter.report(createSrcLoc(qToken), PARSER_ERROR, qToken.image, "an expression");
        exprList = ImmutableList.of(errorExpr(qToken));
      }
      {if ("" != null) return newTag(name, quoteStyle, exprList, createSrcLoc(nameToken, qToken));}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOUBLE_QUOTE:
      case CMD_SINGLE_QUOTE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_DOUBLE_QUOTE:{
          startValue = jj_consume_token(CMD_DOUBLE_QUOTE);
token_source.pushState(IN_DQ_ATTRIBUTE_VALUE);
          value = jj_consume_token(DQ_ATTRIBUTE_VALUE);
quoteStyle = QuoteStyle.DOUBLE;
          break;
          }
        case CMD_SINGLE_QUOTE:{
          startValue = jj_consume_token(CMD_SINGLE_QUOTE);
token_source.pushState(IN_SQ_ATTRIBUTE_VALUE);
          value = jj_consume_token(SQ_ATTRIBUTE_VALUE);
quoteStyle = QuoteStyle.SINGLE;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
{if ("" != null) return new CommandTagAttribute(name, quoteStyle, value.image,
          createSrcLoc(startValue, value), createSrcLoc(nameToken, value));}
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final private DelPackageDeclaration DelPackage() throws ParseException {Identifier name;
  Token open, close;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DELPACKAGE_OPEN:{
      open = jj_consume_token(DELPACKAGE_OPEN);
      break;
      }
    case MODNAME_OPEN:{
      open = jj_consume_token(MODNAME_OPEN);
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = DottedIdent();
    close = jj_consume_token(CMD_END);
{if ("" != null) return DelPackageDeclaration.create(createSrcLoc(open,close), name);}
    throw new Error("Missing return statement in function");
  }

  final private TemplateNode Template(SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {Token open, close = null;
  TemplateNode templateNode = null;
  RawTextNode initialWhitespace = null;
  List<StandaloneNode> templateBodyNodes = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TEMPLATE_OPEN:{
      open = jj_consume_token(TEMPLATE_OPEN);
TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, false);
whitespaceMode = builder.getWhitespaceMode();
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ false);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_TEMPLATE);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_TEMPLATE);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    case DELTEMPLATE_OPEN:{
      open = jj_consume_token(DELTEMPLATE_OPEN);
TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, true);
whitespaceMode = builder.getWhitespaceMode();
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ false);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_DELTEMPLATE);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_DELTEMPLATE);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    case ELEMENT_OPEN:{
      open = jj_consume_token(ELEMENT_OPEN);
TemplateElementNodeBuilder builder = new TemplateElementNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, false);
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ true);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_ELEMENT);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_ELEMENT);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (initialWhitespace != null) {
      templateNode.addChild(initialWhitespace);
    }
    if (templateBodyNodes != null) {
      templateNode.addChildren(templateBodyNodes);
    }
    {if ("" != null) return templateNode;}
    throw new Error("Missing return statement in function");
  }

  final private void TemplateOpenTagHelper(TemplateNodeBuilder<?> builder, Token open, boolean isDeltemplate) throws ParseException {Identifier templateName;
  List<CommandTagAttribute> attributes;
  Token close;
// eagerly fetch the id to be backwards compatible.  if we delay allocating, all the ids in the
    // file will change.  TODO(b/32224284): remove ids
    builder.setId(nodeIdGen.genId());
    templateName = TemplateNameInDef(isDeltemplate);
    attributes = Attributes();
validateAttributes(templateName.location(), attributes, errorReporter);
    builder.setCommandValues(templateName, attributes);
    // We can't set soy doc until after setCommandValues due to conditions in the builder.
    // --- Set the SoyDoc. ---
    // special tokens are accessible from the non-special tokens that come after them.
    Token soyDoc = open.specialToken;
    if (soyDoc != null && soyDoc.kind == SOYDOC) {
      builder.setSoyDoc(soyDoc.image, createSrcLoc(soyDoc));
    }
    close = jj_consume_token(CMD_END);
builder.setOpenTagLocation(createSrcLoc(open, close));
  }

  final private Identifier TemplateNameInDef(boolean isDeltemplate) throws ParseException {Identifier templateName;
    templateName = TemplateName();
if (!isDeltemplate &&
        templateName.type() != Identifier.Type.SINGLE_IDENT) {
      errorReporter.report(
          templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
    }
{if ("" != null) return templateName;}
    throw new Error("Missing return statement in function");
  }

  final private Identifier TemplateName() throws ParseException {Identifier ident;
    ident = DottedIdent();
{if ("" != null) return ident;}
    throw new Error("Missing return statement in function");
  }

  final private Identifier DottedIdent() throws ParseException {StringBuilder sb = null;
  Token dot, name, next = null;
    name = jj_consume_token(NAME);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOT:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_8;
      }
      dot = jj_consume_token(CMD_DOT);
      next = jj_consume_token(NAME);
if (sb == null) {
        sb = new StringBuilder();
        sb.append(name.image);
      }
      sb.append('.').append(next.image);
    }
{if ("" != null) return sb == null
      ? Identifier.create(name.image, createSrcLoc(name))
      : Identifier.create(sb.toString(), createSrcLoc(name, next));}
    throw new Error("Missing return statement in function");
  }

  final private void SkipWhitespace() throws ParseException {
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TOKEN_WS:{
        ;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        break label_9;
      }
      jj_consume_token(TOKEN_WS);
    }
  }

  final private RawTextNode RawText() throws ParseException {Token tagBegin, token;
  RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_SP:
    case CMD_FULL_NIL:
    case CMD_FULL_LF:
    case CMD_FULL_CR:
    case CMD_FULL_TAB:
    case CMD_FULL_LB:
    case CMD_FULL_RB:
    case CMD_FULL_NBSP:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:{
        token = jj_consume_token(CMD_FULL_SP);
        break;
        }
      case CMD_FULL_NIL:{
        token = jj_consume_token(CMD_FULL_NIL);
        break;
        }
      case CMD_FULL_CR:{
        token = jj_consume_token(CMD_FULL_CR);
        break;
        }
      case CMD_FULL_LF:{
        token = jj_consume_token(CMD_FULL_LF);
        break;
        }
      case CMD_FULL_TAB:{
        token = jj_consume_token(CMD_FULL_TAB);
        break;
        }
      case CMD_FULL_LB:{
        token = jj_consume_token(CMD_FULL_LB);
        break;
        }
      case CMD_FULL_RB:{
        token = jj_consume_token(CMD_FULL_RB);
        break;
        }
      case CMD_FULL_NBSP:{
        token = jj_consume_token(CMD_FULL_NBSP);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return RawTextBuilder.buildCommandCharNode(token, filePath, nodeIdGen);}
      break;
      }
    case CMD_OPEN_LITERAL:
    case TOKEN_WS:
    case TOKEN_NOT_WS:{
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TOKEN_WS:
        case TOKEN_NOT_WS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case TOKEN_NOT_WS:{
            token = jj_consume_token(TOKEN_NOT_WS);
            break;
            }
          case TOKEN_WS:{
            token = jj_consume_token(TOKEN_WS);
            break;
            }
          default:
            jj_la1[28] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
builder.addBasic(token);
          break;
          }
        case CMD_OPEN_LITERAL:{
          tagBegin = jj_consume_token(CMD_OPEN_LITERAL);
          token = jj_consume_token(LITERAL_RAW_TEXT_CONTENT);
// Preserve the original SourceLocation.
        SourceLocation loc = createSrcLoc(tagBegin, token);
        // Remove the closing tag from the token.
        token.image = token.image.substring(0, token.image.length() - "{/literal}".length());
        token.endColumn -= "{/literal}".length();
        {if ("" != null) return builder.buildLiteral(token, loc);}
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
if (getToken(1).kind == CMD_OPEN_LITERAL) {
        {if ("" != null) return builder.build();}
      }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_OPEN_LITERAL:
        case TOKEN_WS:
        case TOKEN_NOT_WS:{
          ;
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          break label_10;
        }
      }
{if ("" != null) return builder.build();}
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private RawTextNode TemplateHeader(TemplateNodeBuilder<?> templateBuilder, boolean allowState) throws ParseException {Token tok;
  TemplateHeaderVarDefn param;
  TemplateHeaderVarDefn docSinkParam = null;
  List<TemplateHeaderVarDefn> params = ImmutableList.of();
  RawTextNode whitespace = null;
  String soyDoc = null;
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DECL_BEGIN_PARAM:
      case DECL_ATTRIBUTE_STAR:
      case DECL_BEGIN_ATTR:
      case DECL_BEGIN_OPT_ATTR:
      case DECL_BEGIN_OPT_PARAM:
      case DECL_BEGIN_INJECT_PARAM:
      case DECL_BEGIN_OPT_INJECT_PARAM:
      case DECL_BEGIN_STATE_VAR:
      case DECL_BEGIN_OPT_STATE_VAR:
      case TOKEN_WS:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TOKEN_WS:{
RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
        label_12:
        while (true) {
          // prefer staying in the loop
                  tok = jj_consume_token(TOKEN_WS);
if (tok.specialToken != null && tok.specialToken.kind == SOYDOC) {
            if (docSinkParam != null) {
              String desc = tok.specialToken.image;
              desc = desc.substring(3, desc.length() - 2).trim();
              docSinkParam.setDesc(desc);
              docSinkParam = null;
            } else {
              soyDoc = tok.specialToken.image;
            }
          } else if (tok.image.contains("\n") || tok.image.contains("\r")) {
            docSinkParam = null;
          }
          builder.addBasic(tok);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case TOKEN_WS:{
            ;
            break;
            }
          default:
            jj_la1[33] = jj_gen;
            break label_12;
          }
        }
whitespace = builder.build();
        break;
        }
      case DECL_BEGIN_PARAM:
      case DECL_ATTRIBUTE_STAR:
      case DECL_BEGIN_ATTR:
      case DECL_BEGIN_OPT_ATTR:
      case DECL_BEGIN_OPT_PARAM:
      case DECL_BEGIN_INJECT_PARAM:
      case DECL_BEGIN_OPT_INJECT_PARAM:
      case DECL_BEGIN_STATE_VAR:
      case DECL_BEGIN_OPT_STATE_VAR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DECL_ATTRIBUTE_STAR:{
          tok = jj_consume_token(DECL_ATTRIBUTE_STAR);
templateBuilder.setAllowExtraAttributes(createSrcLoc(tok));
          break;
          }
        case DECL_BEGIN_PARAM:
        case DECL_BEGIN_ATTR:
        case DECL_BEGIN_OPT_ATTR:
        case DECL_BEGIN_OPT_PARAM:
        case DECL_BEGIN_INJECT_PARAM:
        case DECL_BEGIN_OPT_INJECT_PARAM:
        case DECL_BEGIN_STATE_VAR:
        case DECL_BEGIN_OPT_STATE_VAR:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DECL_BEGIN_PARAM:
          case DECL_BEGIN_OPT_PARAM:
          case DECL_BEGIN_INJECT_PARAM:
          case DECL_BEGIN_OPT_INJECT_PARAM:
          case DECL_BEGIN_STATE_VAR:
          case DECL_BEGIN_OPT_STATE_VAR:{
            param = ParamDecl(soyDoc);
            break;
            }
          case DECL_BEGIN_ATTR:
          case DECL_BEGIN_OPT_ATTR:{
            param = AttrDecl(soyDoc);
            break;
            }
          default:
            jj_la1[34] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
docSinkParam = param;
          switch (param.kind()) {
            case PARAM:
              // we just parsed a param, preceding whitespace/doc comments are not important
              whitespace = null;
              soyDoc = null;
              if (params.isEmpty()) {
                params = new ArrayList<TemplateHeaderVarDefn>();
              }
              params.add(param);
              break;
            case STATE:
              if (params.isEmpty()) {
                params = new ArrayList<TemplateHeaderVarDefn>();
              }
              if (allowState) {
                params.add(param);
              } else {
                errorReporter.report(param.nameLocation(), STATE_IN_TEMPLATE);
              }
              break;
            default:
              {if (true) throw new AssertionError("unexpected var kind: " + param.kind());}
          }
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
templateBuilder.addVarDefns(params);
    {if ("" != null) return whitespace;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateHeaderVarDefn ParamDecl(@Nullable String desc) throws ParseException {Token tagBegin, name;
  Token tagEnd = null;
  TypeNode paramTypeNode = null;
  ExprNode value = null;
  boolean optional = false;
  boolean inject = false;
  boolean stateVar = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DECL_BEGIN_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_PARAM);
      break;
      }
    case DECL_BEGIN_OPT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_PARAM);
optional = true;
      break;
      }
    case DECL_BEGIN_INJECT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_INJECT_PARAM);
inject = true;
      break;
      }
    case DECL_BEGIN_OPT_INJECT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_INJECT_PARAM);
inject = true; optional = true;
      break;
      }
    case DECL_BEGIN_STATE_VAR:{
      tagBegin = jj_consume_token(DECL_BEGIN_STATE_VAR);
stateVar = true;
      break;
      }
    case DECL_BEGIN_OPT_STATE_VAR:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_STATE_VAR);
stateVar = true; optional = true;
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tagBegin.specialToken != null && tagBegin.specialToken.kind == SOYDOC) {
      desc = tagBegin.specialToken.image;
    }
    name = jj_consume_token(NAME);
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_COLON:{
        jj_consume_token(CMD_COLON);
        paramTypeNode = TypeExpr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          value = Expr();
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          ;
        }
        break;
        }
      case CMD_COLON_EQ:{
        jj_consume_token(CMD_COLON_EQ);
        value = Expr();
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException parseException) {
tagEnd = reportTemplateBodyErrorAndSkipTo(parseException, CMD_END);
    }
if (desc != null) {
      // trim the leading /** and trailing */ as well as the whitespace from the doc comment.
      desc = desc.substring(3, desc.length() - 2).trim();
    }
    if (stateVar) {
      if (value == null && !optional) {
        errorReporter.report(createSrcLoc(tagBegin), STATE_REQUIRES_VALUE);
        value = errorExpr(name);
      }
      {if ("" != null) return new TemplateStateVar(
          name.image,
          paramTypeNode,
          optional,
          value,
          desc,
          createSrcLoc(name),
          tagEnd == null? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagEnd));}
    } else {
      if (value != null) {
        if (inject) {
          errorReporter.report(createSrcLoc(tagBegin), INJECT_DEFAULT_PARAM);
        } else if (optional) {
          errorReporter.report(createSrcLoc(tagBegin), OPTIONAL_DEFAULT_PARAM);
        }
      }
      {if ("" != null) return new TemplateParam(
          name.image,
          createSrcLoc(name),
          tagEnd == null? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagEnd),
          paramTypeNode,
          inject,
          /* isImplicit= */ false,
          optional,
          desc,
          value);}
    }
    throw new Error("Missing return statement in function");
  }

  final private TemplateHeaderVarDefn AttrDecl(@Nullable String desc) throws ParseException {Token tagBegin, name, lastName = null;
  Token tagEnd = null;
  TypeNode paramTypeNode = null;
  boolean optional = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DECL_BEGIN_ATTR:{
      tagBegin = jj_consume_token(DECL_BEGIN_ATTR);
      break;
      }
    case DECL_BEGIN_OPT_ATTR:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_ATTR);
optional = true;
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tagBegin.specialToken != null && tagBegin.specialToken.kind == SOYDOC) {
      desc = tagBegin.specialToken.image;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATTRIBUTE:{
      name = jj_consume_token(ATTRIBUTE);
      break;
      }
    case NAME:{
      name = jj_consume_token(NAME);
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    try {
      jj_consume_token(CMD_COLON);
      paramTypeNode = TypeExpr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException parseException) {
tagEnd = reportTemplateBodyErrorAndSkipTo(parseException, CMD_END);
    }
if (desc != null) {
      // trim the leading /** and trailing */ as well as the whitespace from the doc comment.
      desc = desc.substring(3, desc.length() - 2).trim();
    }
    {if ("" != null) return new AttrParam(
        name.image,
        optional,
        paramTypeNode,
        desc,
        lastName == null ? createSrcLoc(name) : createSrcLoc(name, lastName),
        tagEnd == null? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagEnd));}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlock() throws ParseException {StandaloneNode node;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case CMD_SKIP:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        ;
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        break label_13;
      }
      node = TemplateBlockItem();
if (templateBlock.isEmpty()) {
        templateBlock = new ArrayList<StandaloneNode>();
      }
      templateBlock.add(node);
    }
{if ("" != null) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private StandaloneNode TemplateBlockItem() throws ParseException {StandaloneNode node;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_SP:
    case CMD_FULL_NIL:
    case CMD_FULL_LF:
    case CMD_FULL_CR:
    case CMD_FULL_TAB:
    case CMD_FULL_LB:
    case CMD_FULL_RB:
    case CMD_FULL_NBSP:
    case CMD_OPEN_LITERAL:
    case TOKEN_WS:
    case TOKEN_NOT_WS:{
      node = RawText();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:
    case CMD_BEGIN_MSG:
    case CMD_BEGIN_IF:
    case CMD_BEGIN_LET:
    case CMD_BEGIN_FOR:
    case CMD_BEGIN_SWITCH:
    case CMD_OPEN_LOG:
    case CMD_FULL_DEBUGGER:
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:
    case CMD_BEGIN_KEY:
    case CMD_BEGIN_VELOG:
    case CMD_SKIP:{
      node = Stmt();
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode Stmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_LET:
    case CMD_OPEN_LOG:
    case CMD_FULL_DEBUGGER:
    case CMD_BEGIN_KEY:
    case CMD_BEGIN_VELOG:
    case CMD_SKIP:{
      stmt = NonPrintableStmt();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:
    case CMD_BEGIN_MSG:
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:{
      stmt = PrintableStmt();
      break;
      }
    case CMD_BEGIN_IF:
    case CMD_BEGIN_FOR:
    case CMD_BEGIN_SWITCH:{
      stmt = ControlFlowStmt();
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode NonPrintableStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_LET:{
      stmt = LetStmt();
      break;
      }
    case CMD_OPEN_LOG:{
      stmt = LogStmt();
      break;
      }
    case CMD_FULL_DEBUGGER:{
      stmt = DebuggerStmt();
      break;
      }
    case CMD_BEGIN_VELOG:{
      stmt = VeLogStmt();
      break;
      }
    case CMD_BEGIN_KEY:{
      stmt = KeyStmt();
      break;
      }
    case CMD_SKIP:{
      stmt = SkipStmt();
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode PrintableStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_MSG:{
      stmt = MsgStmt();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:{
      stmt = CallStmt();
      break;
      }
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:{
      stmt = PrintStmt();
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode ControlFlowStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_IF:{
      stmt = IfStmt();
      break;
      }
    case CMD_BEGIN_SWITCH:{
      stmt = SwitchStmt();
      break;
      }
    case CMD_BEGIN_FOR:{
      stmt = ForStmt();
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private MsgFallbackGroupNode MsgStmt() throws ParseException {Token tagBegin, tagEnd, tagClose, fallbackTagBegin;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<StandaloneNode> templateBlock, fallbackTemplateBlock;
  MsgNode fallback = null;
    tagBegin = jj_consume_token(CMD_BEGIN_MSG);
    try {
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
    templateBlock = TemplateBlockForMsg();
validateAttributes(createSrcLoc(tagEnd), attributes, errorReporter);
    SourceLocation msgLocation = createSrcLoc(tagBegin, tagEnd);
    SourceLocation srcLocation = msgLocation;
    SourceLocation blockLocation = createSrcLoc(templateBlock);
    // Makes sure that the error message for empty message does have a known location.
    if (blockLocation.isKnown()) {
      srcLocation = msgLocation.extend(blockLocation);
    }
    MsgNode msg = new MsgNode(nodeIdGen.genId(), srcLocation, msgLocation, "msg", attributes, errorReporter);
    msg.addChildren(templateBlock);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_FALLBACK_MSG:{
      fallbackTagBegin = jj_consume_token(CMD_BEGIN_FALLBACK_MSG);
      try {
        attributes = Attributes();
        tagEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
      }
      fallbackTemplateBlock = TemplateBlockForMsg();
validateAttributes(createSrcLoc(tagEnd), attributes, errorReporter);
      msgLocation = createSrcLoc(fallbackTagBegin, tagEnd);
      SourceLocation openTag = msgLocation;
      blockLocation = createSrcLoc(fallbackTemplateBlock);
      // Makes sure that the error message for empty message does have a known location.
      if (blockLocation.isKnown()) {
        msgLocation = msgLocation.extend(blockLocation);
      }
      fallback =
          new MsgNode(nodeIdGen.genId(), msgLocation, openTag, "fallbackmsg", attributes, errorReporter);
      fallback.addChildren(fallbackTemplateBlock);
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    tagClose = jj_consume_token(CMD_CLOSE_MSG);
MsgFallbackGroupNode msgGroup =
        new MsgFallbackGroupNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagClose));
    msgGroup.addChild(msg);
    if (fallback != null) {
      msgGroup.addChild(fallback);
    }
    {if ("" != null) return msgGroup;}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlockForMsg() throws ParseException {RawTextNode rawText;
  StandaloneNode stmt;
  StandaloneNode msgPluralOrSelectNode;
  // The index of the plural or select node, if any
  int pluralOrSelectIndex = -1;
  // Whether or not the first node is just whitespace.
  boolean firstNodeIsWhitespace = false;
  List<StandaloneNode> templateBlock = new ArrayList<StandaloneNode>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TOKEN_WS:{
Token tok;
      RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
      label_14:
      while (true) {
        // prefer staying in the loop
              tok = jj_consume_token(TOKEN_WS);
builder.addBasic(tok);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TOKEN_WS:{
          ;
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          break label_14;
        }
      }
rawText = builder.build();
      if (rawText != null) {
        firstNodeIsWhitespace = true;
        templateBlock.add(rawText);
      }
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_PLURAL:
      case CMD_BEGIN_SELECT:
      case CMD_BEGIN_SWITCH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case CMD_SKIP:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        ;
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_PLURAL:
      case CMD_BEGIN_SELECT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_PLURAL:{
          msgPluralOrSelectNode = MsgPlural();
          break;
          }
        case CMD_BEGIN_SELECT:{
          msgPluralOrSelectNode = MsgSelect();
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        SkipWhitespace();
if (firstNodeIsWhitespace) {
        // The first node was just basic whitespace.  Which is allowed but ignored prior to a plural
        // or select.  So just drop it.
        templateBlock.remove(0);
        firstNodeIsWhitespace = false;
      }
      if (pluralOrSelectIndex == -1) {
        pluralOrSelectIndex = templateBlock.size();
      }
      templateBlock.add(msgPluralOrSelectNode);
        break;
        }
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case CMD_SKIP:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        stmt = TemplateBlockItem();
if (stmt != null) { templateBlock.add(stmt); }
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
// Plural/select are only allowed if they are the only child
    // However we do allow them to be prefixed or suffixed with arbitrary amounts of whitespace.
    if (pluralOrSelectIndex != -1) {
      StandaloneNode pluralOrSelect = templateBlock.get(pluralOrSelectIndex);
      for (int i = 0; i < templateBlock.size(); i++) {
        if (i == pluralOrSelectIndex) {
          continue;
        }
        errorReporter.report(
          // blame the current node
          templateBlock.get(i).getSourceLocation(),
          i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER,
          pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
      }
      // return the single plural or select and drop the other items.  We have either reported
      // errors or have ignored them because they are purely whitespace.
      {if ("" != null) return ImmutableList.of(pluralOrSelect);}
    }
    {if ("" != null) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private MsgPluralNode MsgPlural() throws ParseException {Token tagBegin, tagEnd, caseBeginTag, caseBeginEnd, tagClose;
  ExprNode pluralExpr;
  ExprNode caseExpr;
  List<CommandTagAttribute> attributes;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_PLURAL);
    try {
      pluralExpr = Expr();
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
pluralExpr = errorExpr(tagBegin);
    attributes = ImmutableList.of();
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
validateAttributes(pluralExpr.getSourceLocation(), attributes, errorReporter);

    List<CaseOrDefaultNode> caseNodes = new ArrayList<CaseOrDefaultNode>();
    SkipWhitespace();
    try {
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          break label_16;
        }
        caseBeginTag = jj_consume_token(CMD_BEGIN_CASE);
        caseExpr = Expr();
        caseBeginEnd = jj_consume_token(CMD_END);
int value;
        if (!(caseExpr instanceof IntegerNode)) {
          errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED);
          value = 0;
        } else {
          value = (int) ((IntegerNode) caseExpr).getValue();
          if (value < 0) {
            errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
            value = 0;
          }
        }
        templateBlock = TemplateBlockForMsg();
if (templateBlock.size() == 1 &&
            (templateBlock.get(0) instanceof MsgPluralNode ||
             templateBlock.get(0) instanceof MsgSelectNode )) {
          errorReporter.report(
              templateBlock.get(0).getSourceLocation(),
              PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
        }
        MsgPluralCaseNode caseNode =
            new MsgPluralCaseNode(
                nodeIdGen.genId(),
                createSrcLoc(caseBeginTag, templateBlock),
                createSrcLoc(caseBeginTag, caseBeginEnd),
                value);
        caseNode.addChildren(templateBlock);
        caseNodes.add(caseNode);
      }
      caseBeginTag = jj_consume_token(CMD_FULL_DEFAULT);
      templateBlock = TemplateBlockForMsg();
if (templateBlock.size() == 1 &&
          (templateBlock.get(0) instanceof MsgPluralNode ||
           templateBlock.get(0) instanceof MsgSelectNode )) {
        errorReporter.report(
            templateBlock.get(0).getSourceLocation(),
            PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
      }
      MsgPluralDefaultNode defaultNode =
          new MsgPluralDefaultNode(nodeIdGen.genId(), createSrcLoc(caseBeginTag, templateBlock),
              createSrcLoc(caseBeginTag));
      defaultNode.addChildren(templateBlock);
      caseNodes.add(defaultNode);
      tagClose = jj_consume_token(CMD_CLOSE_PLURAL);
    } catch (ParseException e) {
// report and keep going to maintain previous behavior around reporting errors for unexpected
    // textual content before the first {case} tag
    tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_PLURAL);
    }
MsgPluralNode pluralNode =
        MsgPluralNode.fromPluralExpr(
            nodeIdGen.genId(),
            createSrcLoc(tagBegin, tagClose),
            createSrcLoc(tagBegin, tagEnd),
            pluralExpr,
            attributes,
            errorReporter);
    pluralNode.addChildren(caseNodes);
    {if ("" != null) return pluralNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgSelectNode MsgSelect() throws ParseException {Token tagBegin, caseTagBegin, caseTagEnd, tagClose, tagEnd;
  Token tagBeginEnd = null;
  ExprNode selectExpr;
  ExprNode caseExpr;
  List<CommandTagAttribute> attributes;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_SELECT);
    try {
      selectExpr = Expr();
      attributes = Attributes();
      tagBeginEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
selectExpr = errorExpr(tagBegin);
    attributes = ImmutableList.of();
    tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
validateAttributes(selectExpr.getSourceLocation(), attributes, errorReporter);

    List<CaseOrDefaultNode> caseNodes = new ArrayList<CaseOrDefaultNode>();
    SkipWhitespace();
    try {
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_17;
        }
        caseTagBegin = jj_consume_token(CMD_BEGIN_CASE);
        caseExpr = Expr();
        caseTagEnd = jj_consume_token(CMD_END);
        templateBlock = TemplateBlockForMsg();
String value = ParseErrors.validateSelectCaseLabel(caseExpr, errorReporter);
        MsgSelectCaseNode caseNode =
            new MsgSelectCaseNode(nodeIdGen.genId(), createSrcLoc(caseTagBegin, templateBlock),
                createSrcLoc(caseTagBegin, caseTagEnd), value);
        caseNodes.add(caseNode);
        caseNode.addChildren(templateBlock);
      }
      caseTagBegin = jj_consume_token(CMD_FULL_DEFAULT);
      templateBlock = TemplateBlockForMsg();
MsgSelectDefaultNode defaultNode =
          new MsgSelectDefaultNode(nodeIdGen.genId(), createSrcLoc(caseTagBegin, templateBlock),
              createSrcLoc(caseTagBegin));
      caseNodes.add(defaultNode);
      defaultNode.addChildren(templateBlock);
      tagClose = jj_consume_token(CMD_CLOSE_SELECT);
    } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_SELECT);
    }
MsgSelectNode selectNode = MsgSelectNode.fromSelectExpr(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagClose),
        tagBeginEnd == null ? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagBeginEnd),
        new ExprRootNode(selectExpr),
        attributes,
        errorReporter);
    selectNode.addChildren(caseNodes);
    {if ("" != null) return selectNode;}
    throw new Error("Missing return statement in function");
  }

  final private PrintNode PrintStmt() throws ParseException {Token tagBegin;
  Token tagEnd;
  boolean isImplicit;
  ExprNode expr = null;
  List<PrintDirectiveNode> directives = ImmutableList.of();
  List<CommandTagAttribute> attributes = ImmutableList.of();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_PRINT:{
      tagBegin = jj_consume_token(CMD_BEGIN_PRINT);
isImplicit = false;
      break;
      }
    case CMD_BEGIN_IMPLICIT_PRINT:{
      tagBegin = jj_consume_token(CMD_BEGIN_IMPLICIT_PRINT);
isImplicit = true;
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    try {
      expr = PrintExpr();
      directives = PrintDirectives();
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
validateAttributes(expr.getSourceLocation(), attributes, errorReporter);
    PrintNode node = new PrintNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagEnd),
        isImplicit,
        expr,
        attributes,
        errorReporter);
    node.addChildren(directives);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private List<PrintDirectiveNode> PrintDirectives() throws ParseException {PrintDirectiveNode node;
  List<PrintDirectiveNode> directives = ImmutableList.of();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        break label_18;
      }
      node = PrintDirective();
if (directives.isEmpty()) {
        directives = new ArrayList<PrintDirectiveNode>();
      }
      directives.add(node);
    }
{if ("" != null) return directives;}
    throw new Error("Missing return statement in function");
  }

  final private PrintDirectiveNode PrintDirective() throws ParseException {Token vbar, directive = null;
  ImmutableList<ExprNode> args = ImmutableList.of();
    vbar = jj_consume_token(VBAR);
    try {
      directive = jj_consume_token(IDENT);
    } catch (ParseException e) {
{if (true) throw new ParseExceptionWithAdvice(e,
        " (Disambiguate bitwise OR (|) from print directive by placing the expression inside parentheses.)");}
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      args = ExprList(true);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
if (!Tokens.areAdjacent(vbar, directive)) {
      errorReporter.report(createSrcLoc(vbar), UNEXPECTED_PIPE);
    }
    SourceLocation loc = createSrcLoc(vbar, directive);
    Identifier ident = Identifier.create("|" + directive.image, loc);
    if (!args.isEmpty()) {
      loc = loc.extend(args.get(args.size() - 1).getSourceLocation());
    }
    {if ("" != null) return new PrintDirectiveNode(nodeIdGen.genId(), /* name= */ ident, /* location= */ loc, args);}
    throw new Error("Missing return statement in function");
  }

  final private KeyNode KeyStmt() throws ParseException {Token tagBegin;
  Token tagEnd;
  ExprNode expr = null;
    tagBegin = jj_consume_token(CMD_BEGIN_KEY);
    try {
      expr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
KeyNode node = new KeyNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagEnd),
        expr);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private SkipNode SkipStmt() throws ParseException {Token tagBegin;
    tagBegin = jj_consume_token(CMD_SKIP);
SkipNode node = new SkipNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin));
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private LetNode LetStmt() throws ParseException {Token tagBegin, tagClose, nameTok = null, tagBeginEnd = null;
  ExprNode valueExpr = null;
  CommandTagAttribute attr = null;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    tagBegin = jj_consume_token(CMD_BEGIN_LET);
    try {
      nameTok = jj_consume_token(IDENT);
    } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    SourceLocation loc = createSrcLoc(tagBegin, tagClose);
    {if ("" != null) return new LetValueNode(-1, loc, "$error", loc, errorExpr(tagBegin));}
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      try {
        jj_consume_token(COLON);
        valueExpr = Expr();
        tagClose = jj_consume_token(CMD_SELF_CLOSE);
      } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
      if (valueExpr == null) {
        valueExpr = errorExpr(tagClose);
      }
      }
{if ("" != null) return new LetValueNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagClose),
          nameTok.image,
          createSrcLoc(nameTok),
          valueExpr);}
      break;
      }
    case NAME:
    case IDENT:{
      try {
        attr = Attribute();
        tagBeginEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END, CMD_SELF_CLOSE);
      }
      templateBlock = TemplateBlock();
      tagClose = jj_consume_token(CMD_CLOSE_LET);
if (attr == null) {
        SourceLocation loc = createSrcLoc(tagBegin, tagClose);
        {if ("" != null) return new LetValueNode(-1, loc, "$error", loc, errorExpr(tagBegin));}
      }
      LetContentNode node =
          new LetContentNode(
              nodeIdGen.genId(),
              createSrcLoc(tagBegin, tagClose),
              tagBeginEnd == null ? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagBeginEnd),
              nameTok.image,
              createSrcLoc(nameTok),
              attr,
              errorReporter);
      node.addChildren(templateBlock);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private ConstNode ConstStmt() throws ParseException {Token tagBegin, tagClose, nameTok = null, tagBeginEnd = null;
  ExprNode valueExpr = null;
  CommandTagAttribute attr = null;
  List<StandaloneNode> templateBlock = ImmutableList.of();
  boolean exported;
    tagBegin = jj_consume_token(CONST_OPEN);
exported = tagBegin.image.startsWith("{export ");
    try {
      nameTok = jj_consume_token(IDENT);
    } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    SourceLocation loc = createSrcLoc(tagBegin, tagClose);
    {if ("" != null) return new ConstNode(-1, loc, "$error", loc, errorExpr(tagBegin), exported);}
    }
    try {
      jj_consume_token(EQ);
      valueExpr = Expr();
      tagClose = jj_consume_token(CMD_SELF_CLOSE);
    } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    if (valueExpr == null) {
      valueExpr = errorExpr(tagClose);
    }
    }
{if ("" != null) return new ConstNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagClose),
        nameTok.image,
        createSrcLoc(nameTok),
        valueExpr,
        exported);}
    throw new Error("Missing return statement in function");
  }

  final private IfNode IfStmt() throws ParseException {Token tagBegin, tagClose, condTagBegin, elseTag;
  Token tagBeginEnd = null;
  ExprNode ifExpr;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_IF);
    try {
      ifExpr = Expr();
      tagBeginEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
ifExpr = errorExpr(tagBegin);
    tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
    templateBlock = TemplateBlock();
List<BlockNode> condNodes = new ArrayList<BlockNode>();
    IfCondNode ifCondNode = new IfCondNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, getPointJustBeforeNextToken()),
        tagBeginEnd == null ? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagBeginEnd),
        "if",
        ifExpr);
    condNodes.add(ifCondNode);
    ifCondNode.addChildren(templateBlock);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_ELSEIF:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_19;
      }
      condTagBegin = jj_consume_token(CMD_BEGIN_ELSEIF);
      try {
        ifExpr = Expr();
        tagBeginEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
ifExpr = errorExpr(condTagBegin);
      tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
      }
      templateBlock = TemplateBlock();
ifCondNode = new IfCondNode(
          nodeIdGen.genId(),
          createSrcLoc(condTagBegin, getPointJustBeforeNextToken()),
          tagBeginEnd == null ? createSrcLoc(condTagBegin) : createSrcLoc(condTagBegin, tagBeginEnd),
          "elseif",
          ifExpr);
      condNodes.add(ifCondNode);
      ifCondNode.addChildren(templateBlock);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_ELSE:{
      elseTag = jj_consume_token(CMD_FULL_ELSE);
      templateBlock = TemplateBlock();
IfElseNode ifElseNode =
          new IfElseNode(nodeIdGen.genId(), createSrcLoc(elseTag, getPointJustBeforeNextToken()),
              createSrcLoc(elseTag));
      condNodes.add(ifElseNode);
      ifElseNode.addChildren(templateBlock);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    tagClose = jj_consume_token(CMD_CLOSE_IF);
IfNode ifNode = new IfNode(nodeIdGen.genId(), createSrcLoc(tagClose), createSrcLoc(tagBegin, tagClose));
    ifNode.addChildren(condNodes);
    {if ("" != null) return ifNode;}
    throw new Error("Missing return statement in function");
  }

  final private VeLogNode VeLogStmt() throws ParseException {ExprNode veDataExpr = null;
  Token tagBegin, tagBeginEnd, tagClose;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_VELOG);
    try {
      veDataExpr = Expr();
      attributes = Attributes();
      tagBeginEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (veDataExpr == null) {
      veDataExpr = errorExpr(tagBegin);
    }
    tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
    templateBlock = TemplateBlock();
    tagClose = jj_consume_token(CMD_CLOSE_VELOG);
validateAttributes(veDataExpr.getSourceLocation(), attributes, errorReporter);
    VeLogNode node = new VeLogNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagClose),
        createSrcLoc(tagBegin, tagBeginEnd),
        veDataExpr,
        attributes,
        errorReporter);
    node.addChildren(templateBlock);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private SwitchNode SwitchStmt() throws ParseException {Token tagBegin, caseTag, caseTagEnd, defaultTag, tagClose;
  Token tagBeginEnd = null;
  ExprNode switchExpr;
  ImmutableList<ExprNode> caseExprs;
  List<StandaloneNode> templateBlock;
  SwitchDefaultNode defaultNode = null;
    tagBegin = jj_consume_token(CMD_BEGIN_SWITCH);
    try {
      switchExpr = Expr();
      tagBeginEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
switchExpr = errorExpr(tagBegin);
    tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
List<CaseOrDefaultNode> cases = new ArrayList<CaseOrDefaultNode>();
    SkipWhitespace();
    try {
      label_20:
      while (true) {
        caseTag = jj_consume_token(CMD_BEGIN_CASE);
        caseExprs = ExprList(false);
        caseTagEnd = jj_consume_token(CMD_END);
        templateBlock = TemplateBlock();
SwitchCaseNode caseNode = new SwitchCaseNode(
            nodeIdGen.genId(),
            createSrcLoc(caseTag, getPointJustBeforeNextToken()),
            createSrcLoc(caseTag, caseTagEnd),
            caseExprs);
        caseNode.addChildren(templateBlock);
        cases.add(caseNode);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          break label_20;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_DEFAULT:{
        defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
        templateBlock = TemplateBlock();
defaultNode =
            new SwitchDefaultNode(nodeIdGen.genId(),
                createSrcLoc(defaultTag, getPointJustBeforeNextToken()),
                createSrcLoc(defaultTag));
        defaultNode.addChildren(templateBlock);
        cases.add(defaultNode);
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        ;
      }
      tagClose = jj_consume_token(CMD_CLOSE_SWITCH);
    } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_SWITCH);
    }
SwitchNode switchNode =
        new SwitchNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagClose),
            tagBeginEnd == null ? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagBeginEnd),
            switchExpr);
    switchNode.addChildren(cases);
    {if ("" != null) return switchNode;}
    throw new Error("Missing return statement in function");
  }

  final private ForNode ForStmt() throws ParseException {Token tagBegin, tagClose, ifemptyTag, nameTok;
  Token tagBeginEnd = null;
  Token indexTok = null;
  Identifier nameId = null;
  Identifier indexId = null;
  ExprNode expr = null;
  String name = null;
  List<StandaloneNode> templateBlock;
  ForIfemptyNode ifempty = null;
    tagBegin = jj_consume_token(CMD_BEGIN_FOR);
    try {
      nameTok = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        indexTok = jj_consume_token(IDENT);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        ;
      }
nameId = Identifier.create(nameTok.image, createSrcLoc(nameTok));
        indexId =
            indexTok == null ? null : Identifier.create(indexTok.image, createSrcLoc(indexTok));
      jj_consume_token(IN);
      expr = Expr();
      tagBeginEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
tagBeginEnd = reportTemplateBodyErrorAndSkipTo(
        e,
        "\nFor-loops should be formatted as: \"{for $foo in <listExpression>}\" or " +
            "\"{for $foo, $i in <listExpression>}\".",
        CMD_END);

    if (nameId == null) {
      nameId = Identifier.create("$error", createSrcLoc(tagBegin));
    }
    if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    }
    templateBlock = TemplateBlock();
ForNonemptyNode nonEmpty =
        new ForNonemptyNode(
            nodeIdGen.genId(),
            nameId,
            indexId,
            createSrcLoc(tagBegin, templateBlock));
    nonEmpty.addChildren(templateBlock);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_IFEMPTY:{
      ifemptyTag = jj_consume_token(CMD_FULL_IFEMPTY);
      templateBlock = TemplateBlock();
ifempty = new ForIfemptyNode(nodeIdGen.genId(), createSrcLoc(ifemptyTag, templateBlock),
          createSrcLoc(ifemptyTag));
      ifempty.addChildren(templateBlock);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    tagClose = jj_consume_token(CMD_CLOSE_FOR);
ForNode forNode =
        new ForNode(
            nodeIdGen.genId(),
            createSrcLoc(tagBegin, tagClose),
            tagBeginEnd == null ? createSrcLoc(tagBegin) : createSrcLoc(tagBegin, tagBeginEnd),
            expr);
    forNode.addChild(nonEmpty);
    if (ifempty != null) {
      forNode.addChild(ifempty);
    }
    {if ("" != null) return forNode;}
    throw new Error("Missing return statement in function");
  }

  final private CallNode CallStmt() throws ParseException {Token tagBegin, tagClose;
  Token tagBeginEnd = null;
  Identifier calleeName = null;
  ExprNode calleeExpr = null;
  boolean selfClosing = false;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<CallParamNode> params = ImmutableList.of();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_CALL:{
      // {call}
          tagBegin = jj_consume_token(CMD_BEGIN_CALL);
      try {
        calleeExpr = Expr();
        attributes = Attributes();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_SELF_CLOSE:{
          tagClose = jj_consume_token(CMD_SELF_CLOSE);
selfClosing = true;
          break;
          }
        case CMD_END:{
          tagBeginEnd = jj_consume_token(CMD_END);
          params = CallParams();
          tagClose = jj_consume_token(CMD_CLOSE_CALL);
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_CLOSE_CALL);
      if (calleeExpr == null && calleeName == null) {
        SourceLocation loc = createSrcLoc(tagBegin);
        calleeExpr = TemplateLiteralNode.forVarRef(
           new VarRefNode("$error", loc, null));
      }
      }
SourceLocation loc = createSrcLoc(tagBegin, tagClose);
      if (calleeExpr == null) {
        // This branch only executes for template names beginning with ".",
        // which should always be references to local templates.
        calleeExpr = TemplateLiteralNode.forVarRef(
           new VarRefNode(calleeName.identifier(), calleeName.location(), null));
        validateAttributes(calleeName.location(), attributes, errorReporter);
      } else {
        validateAttributes(calleeExpr.getSourceLocation(), attributes, errorReporter);
      }
      CallBasicNode node = new CallBasicNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagClose),
          (tagBeginEnd != null) ? createSrcLoc(tagBegin, tagBeginEnd) : loc,
          calleeExpr,
          attributes,
          selfClosing,
          errorReporter);
      node.addChildren(params);
      {if ("" != null) return node;}
      break;
      }
    case CMD_BEGIN_DELCALL:{
      // {delcall}
          tagBegin = jj_consume_token(CMD_BEGIN_DELCALL);
      try {
        calleeName = TemplateName();
        attributes = Attributes();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_SELF_CLOSE:{
          tagClose = jj_consume_token(CMD_SELF_CLOSE);
selfClosing = true;
          break;
          }
        case CMD_END:{
          tagBeginEnd = jj_consume_token(CMD_END);
          params = CallParams();
          tagClose = jj_consume_token(CMD_CLOSE_DELCALL);
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_CLOSE_DELCALL);
      if (calleeName == null) {
        calleeName = Identifier.create("error", createSrcLoc(tagBegin));
      }
      }
validateAttributes(calleeName.location(), attributes, errorReporter);
      SourceLocation tag = createSrcLoc(tagBegin, tagClose);
      CallDelegateNode node = new CallDelegateNode(
          nodeIdGen.genId(),
          tag,
          (tagBeginEnd != null) ? createSrcLoc(tagBegin, tagBeginEnd) : tag,
          calleeName,
          attributes,
          selfClosing,
          errorReporter);
      node.addChildren(params);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private List<CallParamNode> CallParams() throws ParseException {List<CallParamNode> params = ImmutableList.of();
  CallParamNode paramNode;
    SkipWhitespace();
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_PARAM:{
        ;
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_21;
      }
      paramNode = CallParam();
if (params.isEmpty()) {
        params = new ArrayList<CallParamNode>();
      }
      params.add(paramNode);
      SkipWhitespace();
    }
{if ("" != null) return params;}
    throw new Error("Missing return statement in function");
  }

  final private CallParamNode CallParam() throws ParseException {Token tagBegin, tagClose, tagBeginEnd = null;
  Identifier key;
  ExprNode valueExpr = null;
  CommandTagAttribute attr = null;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    tagBegin = jj_consume_token(CMD_BEGIN_PARAM);
    try {
      key = Identifier();
    } catch (ParseException e) {
key = Identifier.create("error", createSrcLoc(tagBegin));
    tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    {if ("" != null) return new CallParamValueNode(-1, createSrcLoc(tagBegin, tagClose), key, errorExpr(tagBegin));}
    }
if (key.type() != Identifier.Type.SINGLE_IDENT) {
      errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      try {
        jj_consume_token(COLON);
        valueExpr = Expr();
        tagClose = jj_consume_token(CMD_SELF_CLOSE);
      } catch (ParseException e) {
tagClose = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
      if (valueExpr == null) {
        valueExpr = errorExpr(tagClose);
      }
      }
{if ("" != null) return new CallParamValueNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagClose),
          key,
          valueExpr);}
      break;
      }
    case NAME:
    case IDENT:{
      try {
        attr = Attribute();
        tagBeginEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagBeginEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END, CMD_SELF_CLOSE);
      }
      templateBlock = TemplateBlock();
      tagClose = jj_consume_token(CMD_CLOSE_PARAM);
if (attr == null) {
        {if ("" != null) return
            new CallParamValueNode(-1, createSrcLoc(tagBegin, tagClose), key, errorExpr(tagBegin));}
      }
      CallParamContentNode node =
          new CallParamContentNode(
              nodeIdGen.genId(),
              createSrcLoc(tagBegin, tagClose),
              createSrcLoc(tagBegin, tagBeginEnd),
              key,
              attr,
              errorReporter);
      node.addChildren(templateBlock);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private LogNode LogStmt() throws ParseException {Token open, close;
  List<StandaloneNode> templateBlock;
    open = jj_consume_token(CMD_OPEN_LOG);
    templateBlock = TemplateBlock();
    close = jj_consume_token(CMD_CLOSE_LOG);
LogNode logNode = new LogNode(nodeIdGen.genId(), createSrcLoc(open, close));
    logNode.addChildren(templateBlock);
    {if ("" != null) return logNode;}
    throw new Error("Missing return statement in function");
  }

  final private DebuggerNode DebuggerStmt() throws ParseException {Token token;
    token = jj_consume_token(CMD_FULL_DEBUGGER);
{if ("" != null) return new DebuggerNode(nodeIdGen.genId(), createSrcLoc(token));}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ExprInput() throws ParseException {ExprNode expr;
    expr = Expr();
    jj_consume_token(0);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ImmutableList<ExprNode> ExprList(boolean printNode) throws ParseException {ExprNode expr;
  ImmutableList.Builder<ExprNode> exprList = ImmutableList.builder();
  ExprState state = new ExprState(printNode);
    expr = NestedExpr(state);
exprList.add(expr);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      expr = NestedExpr(state);
exprList.add(expr);
    }
{if ("" != null) return exprList.build();}
    throw new Error("Missing return statement in function");
  }

  final private CallArgs CallArgs() throws ParseException {Token comma, close;
  List<SourceLocation.Point> commaLocations;
  ExprNode key, val;
  List<ExprNode> params = new ArrayList<ExprNode>();
  Identifier paramName;
  List<Identifier> paramIds;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case MINUS:
    case NOT:
    case LBRACKET:
    case LPAREN:
    case ASSERT_NON_NULL:
    case IDENT:{
      // Parse the first thing, whether ID or expression.
        val = Expr();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
paramIds = new ArrayList<Identifier>();

      // Parsed this as an ExprNode but it must actually be an identifier.
      String firstId = val.toSourceString();
      if (BaseUtils.isDottedIdentifier(firstId)) {
        paramName = Identifier.create(firstId, val.getSourceLocation());
      } else {
        errorReporter.report(val.getSourceLocation(), INVALID_PARAM_NAME, firstId);
        paramName = Identifier.create("error" + paramIds.size(), val.getSourceLocation());
      }
      paramIds.add(paramName);
        val = Expr();
params.add(val);
        label_23:
        while (true) {
          if (getToken(1).kind == COMMA && getToken(2).kind != RPAREN) {
            ;
          } else {
            break label_23;
          }
          jj_consume_token(COMMA);
          paramName = Identifier();
          jj_consume_token(COLON);
          val = Expr();
paramIds.add(paramName);
        params.add(val);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          ;
        }
        // trailing comma
            close = jj_consume_token(RPAREN);
{if ("" != null) return CallArgs.named(errorReporter,
          ImmutableList.copyOf(paramIds), ImmutableList.copyOf(params), close);}
        break;
        }
      case COMMA:{
        // B. Positional parameters, 2 or more.
            comma = jj_consume_token(COMMA);
commaLocations = new ArrayList<SourceLocation.Point>();

      params.add(val);
      commaLocations.add(createSrcLoc(comma).getBeginPoint());
        val = Expr();
params.add(val);
        label_24:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            break label_24;
          }
          comma = jj_consume_token(COMMA);
          val = Expr();
params.add(val);
        commaLocations.add(createSrcLoc(comma).getBeginPoint());
        }
        close = jj_consume_token(RPAREN);
{if ("" != null) return CallArgs.positional(ImmutableList.copyOf(params), ImmutableList.copyOf(commaLocations), close);}
        break;
        }
      case RPAREN:{
        // C. Positional parameters, exactly 1.
            close = jj_consume_token(RPAREN);
{if ("" != null) return CallArgs.positional(ImmutableList.of(val), ImmutableList.of(), close);}
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case RPAREN:{
      // D. No parameters.
        close = jj_consume_token(RPAREN);
{if ("" != null) return CallArgs.empty(close);}
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Expr() throws ParseException {ExprNode expr;
  ExprState state = new ExprState(false);
    expr = PrecExpr1(state);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrintExpr() throws ParseException {ExprNode expr;
  ExprState state = new ExprState(true);
    expr = PrecExpr1(state);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode NestedExpr(ExprState state) throws ParseException {ExprNode expr;
    expr = PrecExpr1(state);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr1(ExprState state) throws ParseException {ExprNode expr1, expr2;
  Token op, op2;
ExprNode expr;
    expr = PrecExpr2(state);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QMARK:
    case QCOLON:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QCOLON:{
        op = jj_consume_token(QCOLON);
        expr1 = PrecExpr1(state);
expr = Operator.NULL_COALESCING.createNode(createSrcLoc(expr, expr1), createSrcLoc(op), expr, expr1);
        break;
        }
      case QMARK:{
        op = jj_consume_token(QMARK);
        expr1 = PrecExpr1(state);
        op2 = jj_consume_token(COLON);
        expr2 = PrecExpr1(state);
expr = Operator.CONDITIONAL.createNode(
        expr.getSourceLocation().extend(expr2.getSourceLocation()), createSrcLoc(op, op2), expr, expr1, expr2);
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr2(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr3(state);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_25;
      }
      op = jj_consume_token(OR);
      rightHand = PrecExpr3(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        2,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr3(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr4(state);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        break label_26;
      }
      op = jj_consume_token(AND);
      rightHand = PrecExpr4(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        3,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr4(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr5(state);
if (state.isPrint && state.groupNesting == 0) {
      // If this is a print node expression and we aren't in a grouping then
      // don't interpret | as an operator. It should be a print directive.
      {if ("" != null) return expr;}
    }
    label_27:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_27;
      }
      op = jj_consume_token(VBAR);
      rightHand = PrecExpr5(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        4,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr5(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr6(state);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BITWISE_XOR:{
        ;
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        break label_28;
      }
      op = jj_consume_token(BITWISE_XOR);
      rightHand = PrecExpr6(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        5,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr6(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr7(state);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BITWISE_AND:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_29;
      }
      op = jj_consume_token(BITWISE_AND);
      rightHand = PrecExpr7(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        6,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr7(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr8(state);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_EQ:
      case NOT_EQ:{
        ;
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_EQ:{
        op = jj_consume_token(DOUBLE_EQ);
        break;
        }
      case NOT_EQ:{
        op = jj_consume_token(NOT_EQ);
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr8(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        7,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr8(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr9(state);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LANGLE:
      case RANGLE:
      case LT_EQ:
      case GT_EQ:{
        ;
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_31;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LANGLE:{
        op = jj_consume_token(LANGLE);
        break;
        }
      case RANGLE:{
        op = jj_consume_token(RANGLE);
        break;
        }
      case LT_EQ:{
        op = jj_consume_token(LT_EQ);
        break;
        }
      case GT_EQ:{
        op = jj_consume_token(GT_EQ);
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr9(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        8,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr9(ExprState state) throws ParseException {ExprNode rightHand;
  Token op1, op2 = null;
ExprNode expr;
    expr = PrecExpr10(state);
    label_32:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_32;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SHIFT_LEFT:{
        op1 = jj_consume_token(SHIFT_LEFT);
        break;
        }
      case RANGLE:{
        op1 = jj_consume_token(RANGLE);
        op2 = jj_consume_token(RANGLE);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr10(state);
SourceLocation opLoc = createSrcLoc(op1);
      String opImage = op1.image;
      if (op2 != null) {
        opLoc = createSrcLoc(op1, op2);
        opImage += op2.image;
        if (!opLoc.isSingleLine() || opLoc.getLength() != 2) {
          // Guard against whitespace between > and >.
          {if (true) throw generateParseException();}
        }
      }
      expr = createOperatorNode(
        createSrcLoc(expr, rightHand), opImage, opLoc, 9, expr, rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr10(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr11(state);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        op = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        op = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr11(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        10,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr11(ExprState state) throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr12(state);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:
      case DIV:
      case MOD:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:{
        op = jj_consume_token(TIMES);
        break;
        }
      case DIV:{
        op = jj_consume_token(DIV);
        break;
        }
      case MOD:{
        op = jj_consume_token(MOD);
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr12(state);
expr = createOperatorNode(
        createSrcLoc(expr, rightHand),
        op.image,
        createSrcLoc(op),
        11,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr12(ExprState state) throws ParseException {Token op;
ExprNode expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case LBRACKET:
    case LPAREN:
    case IDENT:{
      expr = PrecExpr13(state);
      break;
      }
    case MINUS:
    case NOT:
    case ASSERT_NON_NULL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        op = jj_consume_token(NOT);
        break;
        }
      case MINUS:{
        op = jj_consume_token(MINUS);
        break;
        }
      case ASSERT_NON_NULL:{
        op = jj_consume_token(ASSERT_NON_NULL);
errorReporter.report(createSrcLoc(op), LEGACY_NOT_ERROR);
        // Compilation will fail because we reported an error, but keep going the best we can,
        // treating "!$expr" as "not $expr"
        op.image = "not";
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = PrecExpr12(state);
SourceLocation opLocation = createSrcLoc(op);
      SourceLocation location = opLocation.extend(expr.getSourceLocation());

      if (op.kind == MINUS && expr instanceof IntegerNode) {
        long value = -1 * ((IntegerNode) expr).getValue();
        expr = new IntegerNode(value, location);
      } else if (op.kind == MINUS && expr instanceof FloatNode) {
        double value = -1 * ((FloatNode) expr).getValue();
        expr = new FloatNode(value, location);
      } else {
        expr = createOperatorNode(
            location,
            op.image,
            opLocation,
            12,
            expr);
      }
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr13(ExprState state) throws ParseException {ExprNode expr, keyExpr;
  Token ident, open, close, op;
  CallArgs callArgs;
    expr = Primary(state);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QDOT:
      case DOT:
      case LBRACKET:
      case QLBRACKET:
      case ASSERT_NON_NULL:{
        ;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QDOT:
      case DOT:
      case LBRACKET:
      case QLBRACKET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QDOT:
        case DOT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:{
            op = jj_consume_token(DOT);
            break;
            }
          case QDOT:{
            op = jj_consume_token(QDOT);
            break;
            }
          default:
            jj_la1[94] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          ident = jj_consume_token(IDENT);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            jj_consume_token(LPAREN);
            callArgs = CallArgs();
expr = callArgs
              .toBuilder()
              .setTarget(expr)
              .setIdentifier(Identifier.create(ident.image, createSrcLoc(ident)))
              .setSourceLocation(createSrcLoc(op, callArgs.close))
              .setNullSafe(op.kind == QDOT)
              .buildMethod();
            break;
            }
          default:
            jj_la1[95] = jj_gen;
expr =
              new FieldAccessNode(
                  expr,
                  ident.image,
                  createSrcLoc(op, ident),
                  op.kind == QDOT);
          }
          break;
          }
        case LBRACKET:
        case QLBRACKET:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            open = jj_consume_token(LBRACKET);
            break;
            }
          case QLBRACKET:{
            open = jj_consume_token(QLBRACKET);
            break;
            }
          default:
            jj_la1[96] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          keyExpr = NestedExpr(state);
          close = jj_consume_token(RBRACKET);
expr =
            new ItemAccessNode(
                expr,
                keyExpr,
                createSrcLoc(open, close),
                open.kind == QLBRACKET);
          break;
          }
        default:
          jj_la1[97] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case ASSERT_NON_NULL:{
        op = jj_consume_token(ASSERT_NON_NULL);
SourceLocation opLocation = createSrcLoc(op);
      expr = createOperatorNode(
          expr.getSourceLocation().extend(opLocation),
          op.image,
          opLocation,
          13,
          expr);
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Primary(ExprState state) throws ParseException {ExprNode primary;
  Token lParen,rParen;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      primary = GroupNode(state);
      break;
      }
    case IDENT:{
      primary = VarRefOrFunctionCallLike(state);
      break;
      }
    case LBRACKET:{
      primary = List(state);
      break;
      }
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:{
      primary = Primitive();
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return primary;}
    throw new Error("Missing return statement in function");
  }

  final private GroupNode GroupNode(ExprState state) throws ParseException {ExprNode primary;
  Token lParen, rParen;
  state.groupNesting++;
    lParen = jj_consume_token(LPAREN);
    primary = NestedExpr(state);
    rParen = jj_consume_token(RPAREN);
state.groupNesting--;
    {if ("" != null) return new GroupNode(primary, createSrcLoc(lParen, rParen));}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode VarRefOrFunctionCallLike(ExprState state) throws ParseException {Token identToken;
  Identifier ident;
  Token openParen = null, closeParen = null;
  CallArgs callArgs;
    identToken = jj_consume_token(IDENT);
ident = Identifier.create(identToken.image, createSrcLoc(identToken));
    boolean isRecord = "record".equals(identToken.image);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      openParen = jj_consume_token(LPAREN);
      if (identToken.image.equals("map")) {
{if ("" != null) return MapLiteral(state, ident);}
      } else if (identToken.image.equals("ve")) {
{if ("" != null) return VeLiteral(ident);}
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NULL:
        case TRUE:
        case FALSE:
        case DEC_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case SINGLE_QUOTE:
        case DOUBLE_QUOTE:
        case MINUS:
        case NOT:
        case LBRACKET:
        case LPAREN:
        case RPAREN:
        case ASSERT_NON_NULL:
        case IDENT:{
          callArgs = CallArgs();
SourceLocation loc = ident.location().extend(createSrcLoc(callArgs.close));
        CallableExprBuilder callBuilder = CallableExprBuilder.builder();
        if (isRecord) {
          RecordLiteralNode node;
          if (callArgs.values.isEmpty()) {
            errorReporter.report(ident.location(), EMPTY_RECORD_LITERAL);
            node = new RecordLiteralNode(ident, ImmutableList.of(), loc);
          } else if (callArgs.isNamed()) {
            for (Identifier name : callArgs.names) {
              // CallArgs already reported error for non-dotted ident.
              if (name.type() != Identifier.Type.SINGLE_IDENT) {
                errorReporter.report(
                    name.location(),
                    INVALID_RECORD_KEY,
                    name.identifier());
              }
            }
            node = new RecordLiteralNode(ident, callArgs.names, loc);
          } else {
            errorReporter.report(ident.location(), RECORD_NAMED_PARAMS);
            node = new RecordLiteralNode(ident, ImmutableList.of(), loc);
          }
          node.addChildren(callArgs.values);
          {if ("" != null) return node;}
        }

        {if ("" != null) return callArgs
            .toBuilder()
            .setIdentifier(ident)
            .setSourceLocation(loc)
            .buildFunction();}
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
// We did not find parens, this is a var ref node
    {if ("" != null) return new VarRefNode(identToken.image, createSrcLoc(identToken), null);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode MapLiteral(ExprState state, Identifier ident) throws ParseException {ExprNode key = null, val;
  Token closeParen;
  ImmutableMap.Builder<ExprNode, ExprNode> kvPairs = ImmutableMap.builder();
  boolean fromList = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case MINUS:
    case NOT:
    case LBRACKET:
    case LPAREN:
    case ASSERT_NON_NULL:
    case IDENT:{
      key = NestedExpr(state);
fromList = true;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        val = NestedExpr(state);
kvPairs.put(key, val);
        fromList = false;
        label_36:
        while (true) {
          if (getToken(1).kind == COMMA && getToken(2).kind != RPAREN) {
            ;
          } else {
            break label_36;
          }
          jj_consume_token(COMMA);
          key = NestedExpr(state);
          jj_consume_token(COLON);
          val = NestedExpr(state);
kvPairs.put(key, val);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    closeParen = jj_consume_token(RPAREN);
// Note: the case where there are no keys or values is ambiguous.
    // It could be a 0-arg function call to a function called "map".
    // (Function calls and map literals are usually distinguished by their parameter syntax
    // (positional vs. named), but that's not helpful when there are no params.)
    SourceLocation srcLoc = ident.location().extend(createSrcLoc(closeParen));
    {if ("" != null) return fromList ? new MapLiteralFromListNode(ident, key, srcLoc, nodeIdGen.genId()) : new MapLiteralNode(ident, kvPairs.build(), srcLoc);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode VeLiteral(Identifier ident) throws ParseException {Identifier name;
  Token closeParen;
    name = Identifier();
    closeParen = jj_consume_token(RPAREN);
SourceLocation srcLoc = ident.location().extend(createSrcLoc(closeParen));
    {if ("" != null) return new VeLiteralNode(ident, name, srcLoc);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode List(ExprState state) throws ParseException {Token begin, end;
  ExprNode firstExpr;
  ExprNode listNode;
    begin = jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RBRACKET:{
      // Empty [] case.
            end = jj_consume_token(RBRACKET);
{if ("" != null) return new ListLiteralNode(new ArrayList<ExprNode>(), createSrcLoc(begin, end), ImmutableList.of());}
      break;
      }
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case MINUS:
    case NOT:
    case LBRACKET:
    case LPAREN:
    case ASSERT_NON_NULL:
    case IDENT:{
      firstExpr = NestedExpr(state);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FOR:{
        // After the first expr, we have enough info to branch: list comprehensions will have "FOR"
                // as the next token; list literals will either have a comma or a closing "]".
                listNode = ListComprehension(state, begin, firstExpr);
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        if (jj_2_3(1)) {
          listNode = ListLiteral(state, begin, firstExpr);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return listNode;}
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ListComprehension(ExprState state, Token begin, ExprNode itemExpr) throws ParseException {Token end, listIterVar = null;
  Token indexVar = null;
  ExprNode listExpr = null;
  ExprNode filterExpr = null;
  SourceLocation listIterVarIdentLocation = null;
    jj_consume_token(FOR);
    try {
      listIterVar = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        indexVar = jj_consume_token(IDENT);
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        ;
      }
      jj_consume_token(IN);
      listExpr = NestedExpr(state);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IF:{
        jj_consume_token(IF);
        filterExpr = NestedExpr(state);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        ;
      }
      end = jj_consume_token(RBRACKET);
    } catch (ParseException e) {
end =
        reportTemplateBodyErrorAndSkipTo(
            e,
            "\nList comprehensions should be formatted as:"
               + " \"[$foo.bar for $foo in <listExpression>]\" or \"[$foo.bar for $foo, $i in <listExpression>]\".",
            RBRACKET);
    {if ("" != null) return new ListComprehensionNode(errorExpr(begin), "$error", createSrcLoc(begin), "$error",
        createSrcLoc(begin), errorExpr(begin), errorExpr(begin), createSrcLoc(begin, end),
        nodeIdGen.genId());}
    }
String indexVarName = indexVar == null ? null : indexVar.image;
    SourceLocation indexVarNameLocation = indexVar == null ? null : createSrcLoc(indexVar);
    {if ("" != null) return new ListComprehensionNode(listExpr, listIterVar.image, createSrcLoc(listIterVar),
      indexVarName, indexVarNameLocation, itemExpr, filterExpr, createSrcLoc(begin, end),
      nodeIdGen.genId());}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ListLiteral(ExprState state, Token begin, ExprNode firstItem) throws ParseException {Token end;
  ExprNode itemExpr;
  Token comma;
  List<ExprNode> items = ImmutableList.of();
  List<SourceLocation.Point> commaLocations = new ArrayList<SourceLocation.Point>();
items = new ArrayList<ExprNode>();
      items.add(firstItem);
    label_37:
    while (true) {
      if (getToken(1).kind == COMMA && getToken(2).kind != RBRACKET) {
        ;
      } else {
        break label_37;
      }
      comma = jj_consume_token(COMMA);
      itemExpr = NestedExpr(state);
items.add(itemExpr);
        commaLocations.add(createSrcLoc(comma).getBeginPoint());
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      comma = jj_consume_token(COMMA);
commaLocations.add(createSrcLoc(comma).getBeginPoint());
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    end = jj_consume_token(RBRACKET);
{if ("" != null) return new ListLiteralNode(items, createSrcLoc(begin, end), commaLocations);}
    throw new Error("Missing return statement in function");
  }

  final private PrimitiveNode Primitive() throws ParseException {Token tok;
  PrimitiveNode primitive;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:{
      tok = jj_consume_token(NULL);
primitive = new NullNode(createSrcLoc(tok));
      break;
      }
    case TRUE:{
      tok = jj_consume_token(TRUE);
primitive = new BooleanNode(true, createSrcLoc(tok));
      break;
      }
    case FALSE:{
      tok = jj_consume_token(FALSE);
primitive = new BooleanNode(false, createSrcLoc(tok));
      break;
      }
    case DEC_INTEGER:{
      tok = jj_consume_token(DEC_INTEGER);
SourceLocation loc = createSrcLoc(tok);
      Long parsed = Longs.tryParse(tok.image, 10);
      if (parsed == null || !IntegerNode.isInRange(parsed)) {
        errorReporter.report(loc, INTEGER_OUT_OF_RANGE);
        parsed = 0L;
      }
      primitive = new IntegerNode(parsed, loc);
      break;
      }
    case HEX_INTEGER:{
      tok = jj_consume_token(HEX_INTEGER);
SourceLocation loc = createSrcLoc(tok);
      Long parsed = Longs.tryParse(tok.image.substring(2), 16);
      if (parsed == null || !IntegerNode.isInRange(parsed)) {
        errorReporter.report(loc, INTEGER_OUT_OF_RANGE);
        parsed = 0L;
      }
      primitive = new IntegerNode(parsed, loc);
      break;
      }
    case FLOAT:{
      tok = jj_consume_token(FLOAT);
primitive = new FloatNode(Double.parseDouble(tok.image), createSrcLoc(tok));
      break;
      }
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:{
      primitive = StringLiteral();
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return primitive;}
    throw new Error("Missing return statement in function");
  }

  final private StringNode StringLiteral() throws ParseException {Token quote, value;
  QuoteStyle quoteStyle;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTE:{
      quote = jj_consume_token(SINGLE_QUOTE);
token_source.pushState(IN_SQ_STRING);
      value = jj_consume_token(SQ_STRING);
quoteStyle = QuoteStyle.SINGLE;
      break;
      }
    case DOUBLE_QUOTE:{
      quote = jj_consume_token(DOUBLE_QUOTE);
token_source.pushState(IN_DQ_STRING);
      value = jj_consume_token(DQ_STRING);
quoteStyle = QuoteStyle.DOUBLE;
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
SourceLocation loc = createSrcLoc(quote, value);
    // strip the final character which is the closing quotation mark.
    String rawString = value.image.substring(0, value.image.length() - 1);
    String unescaped = SoyParseUtils.unescapeString(rawString, errorReporter, loc);
    {if ("" != null) return new StringNode(unescaped, quoteStyle, loc);}
    throw new Error("Missing return statement in function");
  }

  final private Identifier Identifier() throws ParseException {Token first, next = null;
  StringBuilder sb = null;  // lazily allocated

    first = jj_consume_token(IDENT);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        break label_38;
      }
      jj_consume_token(DOT);
      next = jj_consume_token(IDENT);
if (sb == null) {
        sb = new StringBuilder();
        sb.append(first.image);
      }
      sb.append('.').append(next.image);
    }
{if ("" != null) return sb == null
      ? Identifier.create(first.image, createSrcLoc(first))
      : Identifier.create(sb.toString(), createSrcLoc(first, next));}
    throw new Error("Missing return statement in function");
  }

  final private Identifier DottedOrDashedIdent() throws ParseException {Token first, next = null;
  Token delim = null, prevDelim = null;
  StringBuilder sb = null;  // lazily allocated

    first = jj_consume_token(IDENT);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        break label_39;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:{
        delim = jj_consume_token(MINUS);
        break;
        }
      case DOT:{
        delim = jj_consume_token(DOT);
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      next = jj_consume_token(IDENT);
if (prevDelim != null && !prevDelim.image.equals(delim.image)) {
        errorReporter.report(
            createSrcLoc(delim), PARSER_ERROR, delim.image, "'" + prevDelim.image + "'");
      }
      if (sb == null) {
        sb = new StringBuilder();
        sb.append(first.image);
      }
      sb.append(delim.image).append(next.image);
      prevDelim = delim;
    }
{if ("" != null) return sb == null
      ? Identifier.create(first.image, createSrcLoc(first))
      : Identifier.create(sb.toString(), createSrcLoc(first, next));}
    throw new Error("Missing return statement in function");
  }

  final private Token Keyword(String keyword) throws ParseException {Token ident;
    ident = jj_consume_token(IDENT);
if (!ident.image.equals(keyword)) {
      {if (true) throw generateParseException();}
    }
    {if ("" != null) return ident;}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode TypeExprInput() throws ParseException {TypeNode type;
    type = TypeExpr();
    jj_consume_token(0);
{if ("" != null) return type;}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode TypeExpr() throws ParseException {TypeNode first;
  TypeNode next;
  // lazily allocate the list since most of the time this isn't actually a Union
  List<TypeNode> members = null;
    first = PrimaryType();
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        break label_40;
      }
      jj_consume_token(VBAR);
      next = PrimaryType();
if (members == null) {
        members = new ArrayList<TypeNode>();
        members.add(first);
      }
      members.add(next);
    }
{if ("" != null) return members == null ? first : UnionTypeNode.create(members);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode PrimaryType() throws ParseException {TypeNode type;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      type = NamedType();
      break;
      }
    case NULL:{
      type = NullType();
      break;
      }
    case QMARK:{
      type = UnknownType();
      break;
      }
    case LBRACKET:{
      type = RecordType();
      break;
      }
    case LPAREN:{
      type = TemplateType();
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return type;}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode TemplateType() throws ParseException {List<TemplateTypeNode.Parameter> parameters = ImmutableList.of();
  Token open, close, arrow;
  TypeNode returnType;
  TemplateTypeNode.Parameter parameter;
    open = jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case ATTR_IDENT:{
      parameter = TemplateParameter();
parameters = new ArrayList<TemplateTypeNode.Parameter>();
      parameters.add(parameter);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          break label_41;
        }
        jj_consume_token(COMMA);
        parameter = TemplateParameter();
parameters.add(parameter);
      }
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    close = jj_consume_token(RPAREN);
    arrow = jj_consume_token(FORWARD_ARROW);
    returnType = NamedType();
SourceLocation srcLoc = createSrcLoc(open, returnType.sourceLocation().getEndPoint());
    {if ("" != null) return TemplateTypeNode.create(srcLoc, parameters, returnType);}
    throw new Error("Missing return statement in function");
  }

  final private TemplateTypeNode.Parameter TemplateParameter() throws ParseException {Token parameterName;
  TypeNode parameterType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      parameterName = jj_consume_token(IDENT);
      break;
      }
    case ATTR_IDENT:{
      parameterName = jj_consume_token(ATTR_IDENT);
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COLON);
    parameterType = TypeExpr();
ParameterKind kind = ParameterKind.PARAM;
    String paramName = parameterName.image;
    if (paramName.startsWith("@")) {
      kind = ParameterKind.ATTRIBUTE;
      paramName = TemplateType.Parameter.attrToParamName(paramName.substring(1));
    }
    {if ("" != null) return TemplateTypeNode.Parameter.create(createSrcLoc(parameterName), paramName, parameterName.image, kind, parameterType);}
    throw new Error("Missing return statement in function");
  }

  final private FunctionTypeNode FunctionType() throws ParseException {List<FunctionTypeNode.Parameter> parameters = ImmutableList.of();
  Token open, close, arrow;
  TypeNode returnType;
  FunctionTypeNode.Parameter parameter;
    open = jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      parameter = FunctionParameter();
parameters = new ArrayList<FunctionTypeNode.Parameter>();
      parameters.add(parameter);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          break label_42;
        }
        jj_consume_token(COMMA);
        parameter = FunctionParameter();
parameters.add(parameter);
      }
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      ;
    }
    close = jj_consume_token(RPAREN);
    arrow = jj_consume_token(FORWARD_ARROW);
    returnType = TypeExpr();
SourceLocation srcLoc = createSrcLoc(open, returnType.sourceLocation().getEndPoint());
    {if ("" != null) return FunctionTypeNode.create(srcLoc, parameters, returnType);}
    throw new Error("Missing return statement in function");
  }

  final private FunctionTypeNode.Parameter FunctionParameter() throws ParseException {Token parameterName;
  TypeNode parameterType;
    parameterName = jj_consume_token(IDENT);
    jj_consume_token(COLON);
    parameterType = TypeExpr();
String paramName = parameterName.image;
    {if ("" != null) return FunctionTypeNode.Parameter.create(
        createSrcLoc(parameterName), paramName, parameterName.image, parameterType);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode RecordType() throws ParseException {List<RecordTypeNode.Property> properties = ImmutableList.of();
  Token open, close;
  RecordTypeNode.Property prop;
    open = jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      prop = RecordField();
properties = new ArrayList<RecordTypeNode.Property>();
      properties.add(prop);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          break label_43;
        }
        jj_consume_token(COMMA);
        prop = RecordField();
properties.add(prop);
      }
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    close = jj_consume_token(RBRACKET);
SourceLocation srcLoc = createSrcLoc(open, close);
    if (properties.isEmpty()) {
      errorReporter.report(srcLoc, EMPTY_RECORD_TYPE);
    }

    {if ("" != null) return RecordTypeNode.create(srcLoc, properties);}
    throw new Error("Missing return statement in function");
  }

  final private RecordTypeNode.Property RecordField() throws ParseException {Token fieldName;
  Token colon;
  TypeNode fieldType;
    fieldName = jj_consume_token(IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QCOLON:{
      colon = jj_consume_token(QCOLON);
      break;
      }
    case COLON:{
      colon = jj_consume_token(COLON);
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    fieldType = TypeExpr();
{if ("" != null) return RecordTypeNode.Property.create(createSrcLoc(fieldName), fieldName.image, "?:".equals(colon.image), fieldType);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode NullType() throws ParseException {Token tok;
    tok = jj_consume_token(NULL);
{if ("" != null) return NamedTypeNode.create(createSrcLoc(tok), tok.image);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode NamedType() throws ParseException {Token open, close;
  Identifier identifier;
  SourceLocation fullLocation;

  TypeNode arg;
  List<TypeNode> genericArgs = ImmutableList.of();
    identifier = DottedOrDashedIdent();
fullLocation = identifier.location();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGLE:{
      open = jj_consume_token(LANGLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NULL:
      case QMARK:
      case LBRACKET:
      case LPAREN:
      case IDENT:{
        arg = TypeExpr();
genericArgs = new ArrayList<TypeNode>();
        genericArgs.add(arg);
        label_44:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[125] = jj_gen;
            break label_44;
          }
          jj_consume_token(COMMA);
          arg = TypeExpr();
genericArgs.add(arg);
        }
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        ;
      }
      close = jj_consume_token(RANGLE);
{if ("" != null) return GenericTypeNode.create(
          fullLocation.extend(createSrcLoc(close)),
          identifier,
          genericArgs);}
      break;
      }
    default:
      jj_la1[127] = jj_gen;
      ;
    }
{if ("" != null) return NamedTypeNode.create(identifier);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode UnknownType() throws ParseException {Token tok;
    tok = jj_consume_token(QMARK);
{if ("" != null) return NamedTypeNode.create(createSrcLoc(tok), "?");}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_3_3()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_51()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_52()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(VBAR)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(ASSERT_NON_NULL)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  private boolean jj_3R_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(RANGLE)) return true;
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(HEX_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(DEC_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public SoyFileParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[128];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x3801,0x3000,0x4400,0x4400,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x240000,0x240000,0x0,0x0,0x0,0x0,0xc00000,0xc00000,0xc00000,0x3000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x8,0x7,0x60,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0xff00000,0x0,0x10000000,0x10000000,0x1ff00000,0x7fc00,0x0,0x7f400,0x7fc00,0x7fc00,0x7c400,0x0,0x0,0x3000,0x0,0x7ff00000,0x7ff00000,0x60000000,0x0,0x60000000,0x0,0x0,0x0,0x0,0x7ff00000,0x0,0x7ff00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbe841448,0xbe841448,0xbe841448,0xb2800400,0xc000008,0x41040,0x10,0x0,0x0,0xbe855448,0x14000,0xbe855448,0x100000,0x100000,0xc000000,0x0,0x0,0x0,0x80,0x100,0x100000,0x200000,0x0,0x400000,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x1fe000,0x1fe000,0x0,0x0,0x0,0x0,0x0,0x100,0x800,0x0,0x1800,0x1800,0x1800,0x1800,0x800,0x800,0x0,0x0,0x800,0x0,0x0,0x30,0x0,0xc,0x1800,0x1800,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x1800,0x0,0x1800,0x0,0x0,0x0,0x0,0x20000000,0x20000004,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x0,0x0,0x20000004,0x0,0x0,0x0,0x20000000,0x1fe000,0x50000000,0x50000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe000,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe000,0x1fe000,0x0,0x0,0x20000000,0x1fe000,0x0,0x1fe000,0x0,0x0,0x0,0x1fe000,0x180000,0x0,0x0,0x0,0x0,0x10002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x10002000,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x80000000,0x0,0x80000000,0x0,0x0,0x80000000,0x80000000,0xc2048800,0xc2048800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x200000,0x200000,0x200000,0x4200000,0xc6048800,0x0,0x0,0x0,0x1,0x2,0x4,0x18,0x18,0x1e0,0x1e0,0x240,0xc00,0xc00,0x7000,0x7000,0x40008800,0xc2048800,0x40170000,0x30000,0x2000000,0x140000,0x170000,0x40170000,0x82040000,0xc6048800,0x2000000,0x200000,0x0,0xc2048800,0x400000,0xc20c8800,0x200000,0x1000000,0x200000,0x0,0x0,0x20000,0x20800,0x20800,0x8000000,0x82040000,0x200000,0x80000000,0x80000000,0x200000,0x80000000,0x200000,0x80000000,0x0,0x200000,0x82040000,0x20,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[3];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public SoyFileParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SoyFileParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public SoyFileParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new SoyFileParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SoyFileParser(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[172];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 128; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 172; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 3; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
