/*
 * Copyright 2020 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.soytree.SoyTypeP;

/** Base type for all imported symbol types. */
public abstract class ImportType extends SoyType {

  @Override
  public <T> T accept(SoyTypeVisitor<T> visitor) {
    return visitor.visit(this);
  }

  @Override
  void doToProto(SoyTypeP.Builder builder) {
    throw new UnsupportedOperationException();
  }

  @Override
  boolean doIsAssignableFromNonUnionType(SoyType srcType) {
    // Nothing is assignable to this placeholder type.
    return false;
  }

  /** Returns the full list of any valid nested symbols, of any type, within this type. */
  public ImmutableCollection<String> getNestedSymbolNames() {
    return ImmutableSet.of();
  }
}
