/* JsLexerTokenManager.java */
/* Generated By:JavaCC: Do not edit this line. JsLexerTokenManager.java */
package com.google.template.soy.parsepasses.contextautoesc;
import static com.google.common.base.Preconditions.checkState;
import com.google.template.soy.parsepasses.contextautoesc.Context.UriPart;
import com.google.template.soy.soytree.HtmlContext;
import java.io.IOException;
import java.io.StringReader;

/** Token Manager. */
@SuppressWarnings("unused")class JsLexerTokenManager implements JsLexerConstants {
  static Context calculateTransitions(Context starting, String text, int offset) {
    StringReader reader = new StringReader(text);
    if (offset > 0) {
      try {
        reader.skip(offset);
      } catch (IOException ioe) {
        // StringReader only throws IOE if it is closed, and we definitely haven't closed it yet.
        throw new AssertionError(ioe);
      }
    } else if (offset < 0) {
      throw new IllegalArgumentException("negative offset?: " + offset);
    }
    JsLexerTokenManager mgr =
        new JsLexerTokenManager(new SimpleCharStream(reader), lexicalStateFromContext(starting));
    mgr.currentContext = starting;
    Token tok = mgr.getNextToken();
    if (tok.kind != EOF) {
      throw new IllegalStateException("Failed to process all of the text");
    }
    // We currently don't support dynamic printing within a js regex character class.  Supporting
    // this wouldn't be difficult (just need to add a new Context bit), but it isn't clear that it
    // is important
    if (mgr.curLexState == REGEX_CHARACTER_CLASS) {
      mgr.error("Invalid JS regular expression character class.  Expected ']'.");
    }
    return mgr.currentContext;
  }

  private static int lexicalStateFromContext(Context context) {
    // TODO(lukes): consider handling all the non-trivial states in a lexer like this.
    switch(context.state()) {
      case HTML_PCDATA:
      case HTML_RCDATA:
      case HTML_BEFORE_OPEN_TAG_NAME:
      case HTML_BEFORE_CLOSE_TAG_NAME:
      case HTML_TAG_NAME:
      case HTML_TAG:
      case HTML_ATTRIBUTE_NAME:
      case HTML_COMMENT:
      case HTML_NORMAL_ATTR_VALUE:
      case HTML_HTML_ATTR_VALUE:
      case HTML_META_REFRESH_CONTENT:
      case CSS:
      case CSS_COMMENT:
      case CSS_DQ_STRING:
      case CSS_SQ_STRING:
      case CSS_URI:
      case CSS_DQ_URI:
      case CSS_SQ_URI:
      case URI:
      case TEXT:
      case HTML_SCRIPT_PHRASING_DATA:
        throw new IllegalArgumentException("the js lexer doesn't support this context: " + context);
      case JS:
        return context.jsTemplateLiteralNestDepth() > 0 ? TEMPLATE_LITERAL_EXPRESSION : DEFAULT;
      case JS_LINE_COMMENT:
        return LINE_COMMENT;
      case JS_BLOCK_COMMENT:
        return BLOCK_COMMENT;
      case JS_DQ_STRING:
        return DQ_STRING;
      case JS_SQ_STRING:
        return SQ_STRING;
      case JS_REGEX:
        return REGEX;
      case JS_TEMPLATE_LITERAL:
        return TEMPLATE_LITERAL;
    }
    throw new AssertionError("unhandled state: " + context);
  }
  private Context currentContext;

  private void transitionToState(HtmlContext state) {
    currentContext = currentContext.transitionToState(state);
  }

  private void transitionToJsStringLiteral(HtmlContext state) {
    currentContext =
        currentContext.toBuilder()
            .withState(state)
            .withSlashType(Context.JsFollowingSlash.NONE)
            .withUriPart(UriPart.NONE)
            .build();
  }

  private void switchToDefaultOrTemplateLiteral() {
    if (currentContext.jsTemplateLiteralNestDepth() > 0) {
      SwitchTo(TEMPLATE_LITERAL_EXPRESSION);
    } else {
      SwitchTo(DEFAULT);
    }
  }

  private void transitionToJsDivPreceder() {
    checkState(
        currentContext.state() == HtmlContext.JS
            || currentContext.state() == HtmlContext.JS_TEMPLATE_LITERAL,
        "Expected state to be JS was: %s", currentContext);
    currentContext = currentContext.derive(Context.JsFollowingSlash.DIV_OP);
  }

  private void transitionToJsRegexPreceder() {
    checkState(
        currentContext.state() == HtmlContext.JS
            || currentContext.state() == HtmlContext.JS_TEMPLATE_LITERAL,
        "Expected state to be JS was: %s", currentContext);
    currentContext = currentContext.derive(Context.JsFollowingSlash.REGEX);
  }

  private void error(String explanation) {
   throw new LexerError(explanation, input_stream.bufpos);
  }

  @Override
  public String toString() {
    return "TokenManager{" + lexStateNames[curLexState] + ", context=" + currentContext + "}";
  }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private final int jjStopStringLiteralDfa_7(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x10000000L) != 0L)
            return 10;
         if ((active0 & 0x700000000L) != 0L)
            return 6;
         if ((active1 & 0x1ffeL) != 0L)
         {
            jjmatchedKind = 82;
            return 10;
         }
         return -1;
      case 1:
         if ((active1 & 0x20L) != 0L)
            return 10;
         if ((active1 & 0x1fdeL) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 82;
               jjmatchedPos = 1;
            }
            return 10;
         }
         return -1;
      case 2:
         if ((active1 & 0x800L) != 0L)
            return 10;
         if ((active1 & 0x17deL) != 0L)
         {
            if (jjmatchedPos != 2)
            {
               jjmatchedKind = 82;
               jjmatchedPos = 2;
            }
            return 10;
         }
         return -1;
      case 3:
         if ((active1 & 0x44L) != 0L)
            return 10;
         if ((active1 & 0x179aL) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 3;
            return 10;
         }
         return -1;
      case 4:
         if ((active1 & 0x1002L) != 0L)
            return 10;
         if ((active1 & 0x798L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 4;
            return 10;
         }
         return -1;
      case 5:
         if ((active1 & 0x610L) != 0L)
            return 10;
         if ((active1 & 0x188L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 5;
            return 10;
         }
         return -1;
      case 6:
         if ((active1 & 0x80L) != 0L)
            return 10;
         if ((active1 & 0x108L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 6;
            return 10;
         }
         return -1;
      case 7:
         if ((active1 & 0x8L) != 0L)
            return 10;
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 7;
            return 10;
         }
         return -1;
      case 8:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 8;
            return 10;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_7(int pos, long active0, long active1){
   return jjMoveNfa_7(jjStopStringLiteralDfa_7(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_7(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 14;
         return jjMoveStringLiteralDfa1_7(0x18000L, 0x0L);
      case 34:
         return jjStopAtPos(0, 8);
      case 35:
         return jjStopAtPos(0, 17);
      case 37:
         jjmatchedKind = 18;
         return jjMoveStringLiteralDfa1_7(0x80000L, 0x0L);
      case 38:
         jjmatchedKind = 20;
         return jjMoveStringLiteralDfa1_7(0x600000L, 0x0L);
      case 39:
         return jjStopAtPos(0, 9);
      case 40:
         return jjStopAtPos(0, 23);
      case 42:
         jjmatchedKind = 24;
         return jjMoveStringLiteralDfa1_7(0x2000000L, 0x0L);
      case 43:
         jjmatchedKind = 26;
         return jjMoveStringLiteralDfa1_7(0x8001000L, 0x0L);
      case 44:
         return jjStartNfaWithStates_7(0, 28, 10);
      case 45:
         jjmatchedKind = 29;
         return jjMoveStringLiteralDfa1_7(0xc0002000L, 0x0L);
      case 46:
         jjmatchedKind = 32;
         return jjMoveStringLiteralDfa1_7(0x600000000L, 0x0L);
      case 47:
         jjmatchedKind = 11;
         return jjMoveStringLiteralDfa1_7(0x8000000c0L, 0x0L);
      case 58:
         jjmatchedKind = 36;
         return jjMoveStringLiteralDfa1_7(0x2000000000L, 0x0L);
      case 59:
         return jjStopAtPos(0, 38);
      case 60:
         jjmatchedKind = 39;
         return jjMoveStringLiteralDfa1_7(0x70000000000L, 0x0L);
      case 61:
         jjmatchedKind = 43;
         return jjMoveStringLiteralDfa1_7(0x300000000000L, 0x0L);
      case 62:
         jjmatchedKind = 46;
         return jjMoveStringLiteralDfa1_7(0xf800000000000L, 0x0L);
      case 63:
         return jjStopAtPos(0, 52);
      case 64:
         return jjStopAtPos(0, 53);
      case 91:
         return jjStopAtPos(0, 54);
      case 94:
         jjmatchedKind = 55;
         return jjMoveStringLiteralDfa1_7(0x700000000000000L, 0x0L);
      case 96:
         return jjStopAtPos(0, 10);
      case 98:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x2L);
      case 99:
         return jjMoveStringLiteralDfa1_7(0x0L, 0xcL);
      case 100:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x30L);
      case 101:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x40L);
      case 102:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x80L);
      case 105:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x100L);
      case 114:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_7(0x0L, 0x1c00L);
      case 123:
         return jjStopAtPos(0, 59);
      case 124:
         jjmatchedKind = 60;
         return jjMoveStringLiteralDfa1_7(0xe000000000000000L, 0x0L);
      case 125:
         return jjStopAtPos(0, 3);
      case 126:
         return jjStopAtPos(0, 64);
      default :
         return jjMoveNfa_7(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_7(long active0, long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active0 & 0x200000L) != 0L)
         {
            jjmatchedKind = 21;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0x400000L, active1, 0L);
      case 42:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         break;
      case 43:
         if ((active0 & 0x1000L) != 0L)
            return jjStopAtPos(1, 12);
         break;
      case 45:
         if ((active0 & 0x2000L) != 0L)
            return jjStopAtPos(1, 13);
         break;
      case 46:
         if ((active0 & 0x200000000L) != 0L)
         {
            jjmatchedKind = 33;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0x400000000L, active1, 0L);
      case 47:
         if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(1, 7);
         break;
      case 58:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStopAtPos(1, 37);
         break;
      case 60:
         if ((active0 & 0x20000000000L) != 0L)
         {
            jjmatchedKind = 41;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0x40000000000L, active1, 0L);
      case 61:
         if ((active0 & 0x8000L) != 0L)
         {
            jjmatchedKind = 15;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x80000L) != 0L)
            return jjStopAtPos(1, 19);
         else if ((active0 & 0x2000000L) != 0L)
            return jjStopAtPos(1, 25);
         else if ((active0 & 0x8000000L) != 0L)
            return jjStopAtPos(1, 27);
         else if ((active0 & 0x40000000L) != 0L)
            return jjStopAtPos(1, 30);
         else if ((active0 & 0x800000000L) != 0L)
            return jjStopAtPos(1, 35);
         else if ((active0 & 0x10000000000L) != 0L)
            return jjStopAtPos(1, 40);
         else if ((active0 & 0x100000000000L) != 0L)
         {
            jjmatchedKind = 44;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 47);
         else if ((active0 & 0x100000000000000L) != 0L)
            return jjStopAtPos(1, 56);
         else if ((active0 & 0x2000000000000000L) != 0L)
            return jjStopAtPos(1, 61);
         return jjMoveStringLiteralDfa2_7(active0, 0x200000010000L, active1, 0L);
      case 62:
         if ((active0 & 0x80000000L) != 0L)
            return jjStopAtPos(1, 31);
         else if ((active0 & 0x1000000000000L) != 0L)
         {
            jjmatchedKind = 48;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0xe000000000000L, active1, 0L);
      case 94:
         if ((active0 & 0x200000000000000L) != 0L)
         {
            jjmatchedKind = 57;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0x400000000000000L, active1, 0L);
      case 97:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x4L);
      case 101:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x210L);
      case 104:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x1000L);
      case 105:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x80L);
      case 108:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x40L);
      case 110:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x100L);
      case 111:
         if ((active1 & 0x20L) != 0L)
            return jjStartNfaWithStates_7(1, 69, 10);
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x8L);
      case 114:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x802L);
      case 121:
         return jjMoveStringLiteralDfa2_7(active0, 0L, active1, 0x400L);
      case 124:
         if ((active0 & 0x4000000000000000L) != 0L)
         {
            jjmatchedKind = 62;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_7(active0, 0x8000000000000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_7(0, active0, active1);
}
private int jjMoveStringLiteralDfa2_7(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_7(0, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(1, active0, active1);
      return 2;
   }
   switch(curChar)
   {
      case 46:
         if ((active0 & 0x400000000L) != 0L)
            return jjStopAtPos(2, 34);
         break;
      case 61:
         if ((active0 & 0x10000L) != 0L)
            return jjStopAtPos(2, 16);
         else if ((active0 & 0x400000L) != 0L)
            return jjStopAtPos(2, 22);
         else if ((active0 & 0x40000000000L) != 0L)
            return jjStopAtPos(2, 42);
         else if ((active0 & 0x200000000000L) != 0L)
            return jjStopAtPos(2, 45);
         else if ((active0 & 0x2000000000000L) != 0L)
            return jjStopAtPos(2, 49);
         else if ((active0 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 58);
         else if ((active0 & 0x8000000000000000L) != 0L)
            return jjStopAtPos(2, 63);
         break;
      case 62:
         if ((active0 & 0x4000000000000L) != 0L)
         {
            jjmatchedKind = 50;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_7(active0, 0x8000000000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x2L);
      case 108:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x10L);
      case 110:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x88L);
      case 112:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x400L);
      case 114:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x1000L);
      case 115:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x144L);
      case 116:
         return jjMoveStringLiteralDfa3_7(active0, 0L, active1, 0x200L);
      case 121:
         if ((active1 & 0x800L) != 0L)
            return jjStartNfaWithStates_7(2, 75, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_7(1, active0, active1);
}
private int jjMoveStringLiteralDfa3_7(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_7(1, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(2, active0, active1);
      return 3;
   }
   switch(curChar)
   {
      case 61:
         if ((active0 & 0x8000000000000L) != 0L)
            return jjStopAtPos(3, 51);
         break;
      case 97:
         return jjMoveStringLiteralDfa4_7(active0, 0L, active1, 0x82L);
      case 101:
         if ((active1 & 0x4L) != 0L)
            return jjStartNfaWithStates_7(3, 66, 10);
         else if ((active1 & 0x40L) != 0L)
            return jjStartNfaWithStates_7(3, 70, 10);
         return jjMoveStringLiteralDfa4_7(active0, 0L, active1, 0x410L);
      case 111:
         return jjMoveStringLiteralDfa4_7(active0, 0L, active1, 0x1000L);
      case 116:
         return jjMoveStringLiteralDfa4_7(active0, 0L, active1, 0x108L);
      case 117:
         return jjMoveStringLiteralDfa4_7(active0, 0L, active1, 0x200L);
      default :
         break;
   }
   return jjStartNfa_7(2, active0, active1);
}
private int jjMoveStringLiteralDfa4_7(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_7(2, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(3, 0L, active1);
      return 4;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa5_7(active1, 0x100L);
      case 105:
         return jjMoveStringLiteralDfa5_7(active1, 0x8L);
      case 107:
         if ((active1 & 0x2L) != 0L)
            return jjStartNfaWithStates_7(4, 65, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa5_7(active1, 0x80L);
      case 111:
         return jjMoveStringLiteralDfa5_7(active1, 0x400L);
      case 114:
         return jjMoveStringLiteralDfa5_7(active1, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa5_7(active1, 0x10L);
      case 119:
         if ((active1 & 0x1000L) != 0L)
            return jjStartNfaWithStates_7(4, 76, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_7(3, 0L, active1);
}
private int jjMoveStringLiteralDfa5_7(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_7(3, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(4, 0L, active1);
      return 5;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x10L) != 0L)
            return jjStartNfaWithStates_7(5, 68, 10);
         break;
      case 102:
         if ((active1 & 0x400L) != 0L)
            return jjStartNfaWithStates_7(5, 74, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa6_7(active1, 0x80L);
      case 110:
         if ((active1 & 0x200L) != 0L)
            return jjStartNfaWithStates_7(5, 73, 10);
         return jjMoveStringLiteralDfa6_7(active1, 0x108L);
      default :
         break;
   }
   return jjStartNfa_7(4, 0L, active1);
}
private int jjMoveStringLiteralDfa6_7(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_7(4, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(5, 0L, active1);
      return 6;
   }
   switch(curChar)
   {
      case 99:
         return jjMoveStringLiteralDfa7_7(active1, 0x100L);
      case 117:
         return jjMoveStringLiteralDfa7_7(active1, 0x8L);
      case 121:
         if ((active1 & 0x80L) != 0L)
            return jjStartNfaWithStates_7(6, 71, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_7(5, 0L, active1);
}
private int jjMoveStringLiteralDfa7_7(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_7(5, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(6, 0L, active1);
      return 7;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x8L) != 0L)
            return jjStartNfaWithStates_7(7, 67, 10);
         return jjMoveStringLiteralDfa8_7(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_7(6, 0L, active1);
}
private int jjMoveStringLiteralDfa8_7(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_7(6, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(7, 0L, active1);
      return 8;
   }
   switch(curChar)
   {
      case 111:
         return jjMoveStringLiteralDfa9_7(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_7(7, 0L, active1);
}
private int jjMoveStringLiteralDfa9_7(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_7(7, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(8, 0L, active1);
      return 9;
   }
   switch(curChar)
   {
      case 102:
         if ((active1 & 0x100L) != 0L)
            return jjStartNfaWithStates_7(9, 72, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_7(8, 0L, active1);
}
private int jjStartNfaWithStates_7(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_7(state, pos + 1);
}
static final long[] jjbitVec0 = {
   0x30000000000L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec1 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec3 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_7(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x3ff1010ffffd9ffL & l) != 0L)
                  {
                     if (kind > 82)
                        kind = 82;
                     { jjCheckNAdd(10); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  else if (curChar == 46)
                     { jjCheckNAdd(6); }
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAddStates(0, 3); }
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 77)
                        kind = 77;
                     { jjCheckNAdd(4); }
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 79)
                        kind = 79;
                     { jjCheckNAddTwoStates(23, 25); }
                  }
                  break;
               case 1:
                  if (curChar == 10 && kind > 5)
                     kind = 5;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 77)
                     kind = 77;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 77)
                     kind = 77;
                  { jjCheckNAdd(4); }
                  break;
               case 5:
                  if (curChar == 46)
                     { jjCheckNAdd(6); }
                  break;
               case 6:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(6, 7); }
                  break;
               case 8:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(9); }
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(9); }
                  break;
               case 10:
                  if ((0x3ff1010ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddStates(0, 3); }
                  break;
               case 12:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(12, 13); }
                  break;
               case 13:
                  if (curChar != 46)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(14, 15); }
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(14, 15); }
                  break;
               case 16:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(17); }
                  break;
               case 17:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(17); }
                  break;
               case 18:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(18, 19); }
                  break;
               case 20:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(21); }
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(21); }
                  break;
               case 22:
                  if (curChar != 48)
                     break;
                  if (kind > 79)
                     kind = 79;
                  { jjCheckNAddTwoStates(23, 25); }
                  break;
               case 24:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 25:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 79)
                     kind = 79;
                  { jjCheckNAdd(25); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 10:
                  if ((0x87fffffe97fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               case 7:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(4, 5); }
                  break;
               case 15:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(6, 7); }
                  break;
               case 19:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(8, 9); }
                  break;
               case 23:
                  if ((0x100000001000000L & l) != 0L)
                     { jjCheckNAdd(24); }
                  break;
               case 24:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  { jjCheckNAdd(24); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 82)
                        kind = 82;
                     { jjCheckNAdd(10); }
                  }
                  break;
               case 10:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_5()
{
   return jjMoveNfa_5(0, 0);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 3;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 85)
                        kind = 85;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 85)
                     kind = 85;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 85)
                     kind = 85;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_0(){
   switch(curChar)
   {
      case 36:
         return jjMoveStringLiteralDfa1_0(0x8000000000L);
      case 92:
         return jjMoveStringLiteralDfa1_0(0x7000000000L);
      case 96:
         return jjStopAtPos(0, 104);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_0(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 36:
         if ((active1 & 0x1000000000L) != 0L)
            return jjStopAtPos(1, 100);
         break;
      case 96:
         if ((active1 & 0x4000000000L) != 0L)
            return jjStopAtPos(1, 102);
         break;
      case 123:
         if ((active1 & 0x2000000000L) != 0L)
            return jjStopAtPos(1, 101);
         else if ((active1 & 0x8000000000L) != 0L)
            return jjStopAtPos(1, 103);
         break;
      default :
         return 2;
   }
   return 2;
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1){
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_3(){
   switch(curChar)
   {
      case 92:
         return jjMoveStringLiteralDfa1_3(0x10000000L);
      case 93:
         return jjStopAtPos(0, 91);
      default :
         return jjMoveNfa_3(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 93:
         if ((active1 & 0x10000000L) != 0L)
            return jjStopAtPos(1, 92);
         break;
      default :
         break;
   }
   return jjStartNfa_3(0, 0L, active1);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 3;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 93)
                        kind = 93;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 93)
                     kind = 93;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 93)
                     kind = 93;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x200000000L) != 0L)
            return 4;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1){
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_1(){
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 96);
      case 92:
         return jjMoveStringLiteralDfa1_1(0x200000000L);
      default :
         return jjMoveNfa_1(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_1(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_1(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 39:
         if ((active1 & 0x200000000L) != 0L)
            return jjStopAtPos(1, 97);
         break;
      default :
         break;
   }
   return jjStartNfa_1(0, 0L, active1);
}
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 7;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 99)
                        kind = 99;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 1:
                  if (curChar == 10 && kind > 98)
                     kind = 98;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 5:
                  if (curChar == 10 && kind > 99)
                     kind = 99;
                  break;
               case 6:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (curChar == 92)
                     { jjAddStates(10, 11); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 98)
                     kind = 98;
                  break;
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 99)
                     kind = 99;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 7 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_8(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x10000000L) != 0L)
            return 10;
         if ((active0 & 0x700000000L) != 0L)
            return 6;
         if ((active1 & 0x1ffeL) != 0L)
         {
            jjmatchedKind = 82;
            return 10;
         }
         return -1;
      case 1:
         if ((active1 & 0x20L) != 0L)
            return 10;
         if ((active1 & 0x1fdeL) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 82;
               jjmatchedPos = 1;
            }
            return 10;
         }
         return -1;
      case 2:
         if ((active1 & 0x800L) != 0L)
            return 10;
         if ((active1 & 0x17deL) != 0L)
         {
            if (jjmatchedPos != 2)
            {
               jjmatchedKind = 82;
               jjmatchedPos = 2;
            }
            return 10;
         }
         return -1;
      case 3:
         if ((active1 & 0x44L) != 0L)
            return 10;
         if ((active1 & 0x179aL) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 3;
            return 10;
         }
         return -1;
      case 4:
         if ((active1 & 0x1002L) != 0L)
            return 10;
         if ((active1 & 0x798L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 4;
            return 10;
         }
         return -1;
      case 5:
         if ((active1 & 0x610L) != 0L)
            return 10;
         if ((active1 & 0x188L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 5;
            return 10;
         }
         return -1;
      case 6:
         if ((active1 & 0x80L) != 0L)
            return 10;
         if ((active1 & 0x108L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 6;
            return 10;
         }
         return -1;
      case 7:
         if ((active1 & 0x8L) != 0L)
            return 10;
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 7;
            return 10;
         }
         return -1;
      case 8:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 82;
            jjmatchedPos = 8;
            return 10;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_8(int pos, long active0, long active1){
   return jjMoveNfa_8(jjStopStringLiteralDfa_8(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_8(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 14;
         return jjMoveStringLiteralDfa1_8(0x18000L, 0x0L);
      case 34:
         return jjStopAtPos(0, 8);
      case 35:
         return jjStopAtPos(0, 17);
      case 37:
         jjmatchedKind = 18;
         return jjMoveStringLiteralDfa1_8(0x80000L, 0x0L);
      case 38:
         jjmatchedKind = 20;
         return jjMoveStringLiteralDfa1_8(0x600000L, 0x0L);
      case 39:
         return jjStopAtPos(0, 9);
      case 40:
         return jjStopAtPos(0, 23);
      case 42:
         jjmatchedKind = 24;
         return jjMoveStringLiteralDfa1_8(0x2000000L, 0x0L);
      case 43:
         jjmatchedKind = 26;
         return jjMoveStringLiteralDfa1_8(0x8001000L, 0x0L);
      case 44:
         return jjStartNfaWithStates_8(0, 28, 10);
      case 45:
         jjmatchedKind = 29;
         return jjMoveStringLiteralDfa1_8(0xc0002000L, 0x0L);
      case 46:
         jjmatchedKind = 32;
         return jjMoveStringLiteralDfa1_8(0x600000000L, 0x0L);
      case 47:
         jjmatchedKind = 11;
         return jjMoveStringLiteralDfa1_8(0x8000000c0L, 0x0L);
      case 58:
         jjmatchedKind = 36;
         return jjMoveStringLiteralDfa1_8(0x2000000000L, 0x0L);
      case 59:
         return jjStopAtPos(0, 38);
      case 60:
         jjmatchedKind = 39;
         return jjMoveStringLiteralDfa1_8(0x70000000000L, 0x0L);
      case 61:
         jjmatchedKind = 43;
         return jjMoveStringLiteralDfa1_8(0x300000000000L, 0x0L);
      case 62:
         jjmatchedKind = 46;
         return jjMoveStringLiteralDfa1_8(0xf800000000000L, 0x0L);
      case 63:
         return jjStopAtPos(0, 52);
      case 64:
         return jjStopAtPos(0, 53);
      case 91:
         return jjStopAtPos(0, 54);
      case 94:
         jjmatchedKind = 55;
         return jjMoveStringLiteralDfa1_8(0x700000000000000L, 0x0L);
      case 96:
         return jjStopAtPos(0, 10);
      case 98:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x2L);
      case 99:
         return jjMoveStringLiteralDfa1_8(0x0L, 0xcL);
      case 100:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x30L);
      case 101:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x40L);
      case 102:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x80L);
      case 105:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x100L);
      case 114:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x1c00L);
      case 123:
         return jjStopAtPos(0, 59);
      case 124:
         jjmatchedKind = 60;
         return jjMoveStringLiteralDfa1_8(0xe000000000000000L, 0x0L);
      case 125:
         return jjStopAtPos(0, 4);
      case 126:
         return jjStopAtPos(0, 64);
      default :
         return jjMoveNfa_8(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_8(long active0, long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active0 & 0x200000L) != 0L)
         {
            jjmatchedKind = 21;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0x400000L, active1, 0L);
      case 42:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         break;
      case 43:
         if ((active0 & 0x1000L) != 0L)
            return jjStopAtPos(1, 12);
         break;
      case 45:
         if ((active0 & 0x2000L) != 0L)
            return jjStopAtPos(1, 13);
         break;
      case 46:
         if ((active0 & 0x200000000L) != 0L)
         {
            jjmatchedKind = 33;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0x400000000L, active1, 0L);
      case 47:
         if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(1, 7);
         break;
      case 58:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStopAtPos(1, 37);
         break;
      case 60:
         if ((active0 & 0x20000000000L) != 0L)
         {
            jjmatchedKind = 41;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0x40000000000L, active1, 0L);
      case 61:
         if ((active0 & 0x8000L) != 0L)
         {
            jjmatchedKind = 15;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x80000L) != 0L)
            return jjStopAtPos(1, 19);
         else if ((active0 & 0x2000000L) != 0L)
            return jjStopAtPos(1, 25);
         else if ((active0 & 0x8000000L) != 0L)
            return jjStopAtPos(1, 27);
         else if ((active0 & 0x40000000L) != 0L)
            return jjStopAtPos(1, 30);
         else if ((active0 & 0x800000000L) != 0L)
            return jjStopAtPos(1, 35);
         else if ((active0 & 0x10000000000L) != 0L)
            return jjStopAtPos(1, 40);
         else if ((active0 & 0x100000000000L) != 0L)
         {
            jjmatchedKind = 44;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 47);
         else if ((active0 & 0x100000000000000L) != 0L)
            return jjStopAtPos(1, 56);
         else if ((active0 & 0x2000000000000000L) != 0L)
            return jjStopAtPos(1, 61);
         return jjMoveStringLiteralDfa2_8(active0, 0x200000010000L, active1, 0L);
      case 62:
         if ((active0 & 0x80000000L) != 0L)
            return jjStopAtPos(1, 31);
         else if ((active0 & 0x1000000000000L) != 0L)
         {
            jjmatchedKind = 48;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0xe000000000000L, active1, 0L);
      case 94:
         if ((active0 & 0x200000000000000L) != 0L)
         {
            jjmatchedKind = 57;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0x400000000000000L, active1, 0L);
      case 97:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x4L);
      case 101:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x210L);
      case 104:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x1000L);
      case 105:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x80L);
      case 108:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x40L);
      case 110:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x100L);
      case 111:
         if ((active1 & 0x20L) != 0L)
            return jjStartNfaWithStates_8(1, 69, 10);
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x8L);
      case 114:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x802L);
      case 121:
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x400L);
      case 124:
         if ((active0 & 0x4000000000000000L) != 0L)
         {
            jjmatchedKind = 62;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_8(active0, 0x8000000000000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_8(0, active0, active1);
}
private int jjMoveStringLiteralDfa2_8(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_8(0, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(1, active0, active1);
      return 2;
   }
   switch(curChar)
   {
      case 46:
         if ((active0 & 0x400000000L) != 0L)
            return jjStopAtPos(2, 34);
         break;
      case 61:
         if ((active0 & 0x10000L) != 0L)
            return jjStopAtPos(2, 16);
         else if ((active0 & 0x400000L) != 0L)
            return jjStopAtPos(2, 22);
         else if ((active0 & 0x40000000000L) != 0L)
            return jjStopAtPos(2, 42);
         else if ((active0 & 0x200000000000L) != 0L)
            return jjStopAtPos(2, 45);
         else if ((active0 & 0x2000000000000L) != 0L)
            return jjStopAtPos(2, 49);
         else if ((active0 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 58);
         else if ((active0 & 0x8000000000000000L) != 0L)
            return jjStopAtPos(2, 63);
         break;
      case 62:
         if ((active0 & 0x4000000000000L) != 0L)
         {
            jjmatchedKind = 50;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_8(active0, 0x8000000000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x2L);
      case 108:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x10L);
      case 110:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x88L);
      case 112:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x400L);
      case 114:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x1000L);
      case 115:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x144L);
      case 116:
         return jjMoveStringLiteralDfa3_8(active0, 0L, active1, 0x200L);
      case 121:
         if ((active1 & 0x800L) != 0L)
            return jjStartNfaWithStates_8(2, 75, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_8(1, active0, active1);
}
private int jjMoveStringLiteralDfa3_8(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_8(1, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(2, active0, active1);
      return 3;
   }
   switch(curChar)
   {
      case 61:
         if ((active0 & 0x8000000000000L) != 0L)
            return jjStopAtPos(3, 51);
         break;
      case 97:
         return jjMoveStringLiteralDfa4_8(active0, 0L, active1, 0x82L);
      case 101:
         if ((active1 & 0x4L) != 0L)
            return jjStartNfaWithStates_8(3, 66, 10);
         else if ((active1 & 0x40L) != 0L)
            return jjStartNfaWithStates_8(3, 70, 10);
         return jjMoveStringLiteralDfa4_8(active0, 0L, active1, 0x410L);
      case 111:
         return jjMoveStringLiteralDfa4_8(active0, 0L, active1, 0x1000L);
      case 116:
         return jjMoveStringLiteralDfa4_8(active0, 0L, active1, 0x108L);
      case 117:
         return jjMoveStringLiteralDfa4_8(active0, 0L, active1, 0x200L);
      default :
         break;
   }
   return jjStartNfa_8(2, active0, active1);
}
private int jjMoveStringLiteralDfa4_8(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_8(2, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(3, 0L, active1);
      return 4;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa5_8(active1, 0x100L);
      case 105:
         return jjMoveStringLiteralDfa5_8(active1, 0x8L);
      case 107:
         if ((active1 & 0x2L) != 0L)
            return jjStartNfaWithStates_8(4, 65, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa5_8(active1, 0x80L);
      case 111:
         return jjMoveStringLiteralDfa5_8(active1, 0x400L);
      case 114:
         return jjMoveStringLiteralDfa5_8(active1, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa5_8(active1, 0x10L);
      case 119:
         if ((active1 & 0x1000L) != 0L)
            return jjStartNfaWithStates_8(4, 76, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_8(3, 0L, active1);
}
private int jjMoveStringLiteralDfa5_8(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_8(3, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(4, 0L, active1);
      return 5;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x10L) != 0L)
            return jjStartNfaWithStates_8(5, 68, 10);
         break;
      case 102:
         if ((active1 & 0x400L) != 0L)
            return jjStartNfaWithStates_8(5, 74, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa6_8(active1, 0x80L);
      case 110:
         if ((active1 & 0x200L) != 0L)
            return jjStartNfaWithStates_8(5, 73, 10);
         return jjMoveStringLiteralDfa6_8(active1, 0x108L);
      default :
         break;
   }
   return jjStartNfa_8(4, 0L, active1);
}
private int jjMoveStringLiteralDfa6_8(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_8(4, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(5, 0L, active1);
      return 6;
   }
   switch(curChar)
   {
      case 99:
         return jjMoveStringLiteralDfa7_8(active1, 0x100L);
      case 117:
         return jjMoveStringLiteralDfa7_8(active1, 0x8L);
      case 121:
         if ((active1 & 0x80L) != 0L)
            return jjStartNfaWithStates_8(6, 71, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_8(5, 0L, active1);
}
private int jjMoveStringLiteralDfa7_8(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_8(5, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(6, 0L, active1);
      return 7;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x8L) != 0L)
            return jjStartNfaWithStates_8(7, 67, 10);
         return jjMoveStringLiteralDfa8_8(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_8(6, 0L, active1);
}
private int jjMoveStringLiteralDfa8_8(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_8(6, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(7, 0L, active1);
      return 8;
   }
   switch(curChar)
   {
      case 111:
         return jjMoveStringLiteralDfa9_8(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_8(7, 0L, active1);
}
private int jjMoveStringLiteralDfa9_8(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_8(7, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(8, 0L, active1);
      return 9;
   }
   switch(curChar)
   {
      case 102:
         if ((active1 & 0x100L) != 0L)
            return jjStartNfaWithStates_8(9, 72, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_8(8, 0L, active1);
}
private int jjStartNfaWithStates_8(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_8(state, pos + 1);
}
private int jjMoveNfa_8(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x3ff1010ffffd9ffL & l) != 0L)
                  {
                     if (kind > 82)
                        kind = 82;
                     { jjCheckNAdd(10); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  else if (curChar == 46)
                     { jjCheckNAdd(6); }
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAddStates(0, 3); }
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 77)
                        kind = 77;
                     { jjCheckNAdd(4); }
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 79)
                        kind = 79;
                     { jjCheckNAddTwoStates(23, 25); }
                  }
                  break;
               case 1:
                  if (curChar == 10 && kind > 5)
                     kind = 5;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 77)
                     kind = 77;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 77)
                     kind = 77;
                  { jjCheckNAdd(4); }
                  break;
               case 5:
                  if (curChar == 46)
                     { jjCheckNAdd(6); }
                  break;
               case 6:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(6, 7); }
                  break;
               case 8:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(9); }
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(9); }
                  break;
               case 10:
                  if ((0x3ff1010ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddStates(0, 3); }
                  break;
               case 12:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(12, 13); }
                  break;
               case 13:
                  if (curChar != 46)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(14, 15); }
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(14, 15); }
                  break;
               case 16:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(17); }
                  break;
               case 17:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(17); }
                  break;
               case 18:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAddTwoStates(18, 19); }
                  break;
               case 20:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(21); }
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(21); }
                  break;
               case 22:
                  if (curChar != 48)
                     break;
                  if (kind > 79)
                     kind = 79;
                  { jjCheckNAddTwoStates(23, 25); }
                  break;
               case 24:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 25:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 79)
                     kind = 79;
                  { jjCheckNAdd(25); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 10:
                  if ((0x87fffffe97fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               case 7:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(4, 5); }
                  break;
               case 15:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(6, 7); }
                  break;
               case 19:
                  if ((0x2000000020L & l) != 0L)
                     { jjAddStates(8, 9); }
                  break;
               case 23:
                  if ((0x100000001000000L & l) != 0L)
                     { jjCheckNAdd(24); }
                  break;
               case 24:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  { jjCheckNAdd(24); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 82)
                        kind = 82;
                     { jjCheckNAdd(10); }
                  }
                  break;
               case 10:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  { jjCheckNAdd(10); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_4(int pos, long active0, long active1){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_4(int pos, long active0, long active1){
   return jjMoveNfa_4(jjStopStringLiteralDfa_4(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_4(){
   switch(curChar)
   {
      case 47:
         return jjStopAtPos(0, 90);
      case 91:
         return jjStopAtPos(0, 89);
      case 92:
         return jjMoveStringLiteralDfa1_4(0x1800000L);
      default :
         return jjMoveNfa_4(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_4(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active1 & 0x800000L) != 0L)
            return jjStopAtPos(1, 87);
         break;
      case 91:
         if ((active1 & 0x1000000L) != 0L)
            return jjStopAtPos(1, 88);
         break;
      default :
         break;
   }
   return jjStartNfa_4(0, 0L, active1);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 3;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 86)
                     kind = 86;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 86)
                     kind = 86;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x80000000L) != 0L)
            return 4;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1){
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_2(){
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 94);
      case 92:
         return jjMoveStringLiteralDfa1_2(0x80000000L);
      default :
         return jjMoveNfa_2(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active1 & 0x80000000L) != 0L)
            return jjStopAtPos(1, 95);
         break;
      default :
         break;
   }
   return jjStartNfa_2(0, 0L, active1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 7;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 99)
                        kind = 99;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 1:
                  if (curChar == 10 && kind > 98)
                     kind = 98;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 5:
                  if (curChar == 10 && kind > 99)
                     kind = 99;
                  break;
               case 6:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (curChar == 92)
                     { jjAddStates(10, 11); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 98)
                     kind = 98;
                  break;
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 99)
                     kind = 99;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 7 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_6(){
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_6(0x100000L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_6(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      default :
         return 2;
   }
   return 2;
}
static final int[] jjnextStates = {
   12, 13, 18, 19, 8, 9, 16, 17, 20, 21, 4, 6, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 32:
         return ((jjbitVec0[i2] & l2) != 0L);
      default :
         return false;
   }
}
private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec3[i2] & l2) != 0L);
      default :
         if ((jjbitVec1[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, };
protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 8;
int defaultLexState = 8;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(Exception e)
   {
      jjmatchedKind = 0;
      jjmatchedPos = -1;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 1:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 2:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_2();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 3:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_3();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 4:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_4();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 5:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_5();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 6:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_6();
       if (jjmatchedPos == 0 && jjmatchedKind > 105)
       {
          jjmatchedKind = 105;
       }
       break;
     case 7:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_7();
       if (jjmatchedPos == 0 && jjmatchedKind > 83)
       {
          jjmatchedKind = 83;
       }
       break;
     case 8:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_8();
       if (jjmatchedPos == 0 && jjmatchedKind > 83)
       {
          jjmatchedKind = 83;
       }
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
}

void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 3 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToState(HtmlContext.JS_TEMPLATE_LITERAL);
         break;
      case 4 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 6 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToState(HtmlContext.JS_BLOCK_COMMENT);
         break;
      case 7 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToState(HtmlContext.JS_LINE_COMMENT);
         break;
      case 8 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsStringLiteral(HtmlContext.JS_DQ_STRING);
         break;
      case 9 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsStringLiteral(HtmlContext.JS_SQ_STRING);
         break;
      case 10 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              currentContext = currentContext.toBuilder()
                          .withState(HtmlContext.JS_TEMPLATE_LITERAL)
                          .withJsTemplateLiteralNestDepth(
                              currentContext.jsTemplateLiteralNestDepth() + 1)
                          .build();
         break;
      case 11 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
  switch (currentContext.slashType()) {
    case DIV_OP:
      currentContext = currentContext.toBuilder()
          .withState(HtmlContext.JS)
          .withSlashType(Context.JsFollowingSlash.REGEX)
          .build();
      break;
    case REGEX:
      currentContext = currentContext.toBuilder()
          .withState(HtmlContext.JS_REGEX)
          .withSlashType(Context.JsFollowingSlash.NONE)
          .build();
       SwitchTo(REGEX);
       break;
    case NONE:
    case UNKNOWN:
      error(
          "Slash (/) cannot follow the preceding branches since it is unclear "
              + "whether the slash is a RegExp literal or division operator.  "
              + "Consider adding parentheses to disambiguate");
  }
         break;
      case 12 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsDivPreceder();
         break;
      case 13 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsDivPreceder();
         break;
      case 14 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 15 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 16 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 17 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 18 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 19 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 20 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 21 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 22 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 23 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 24 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 25 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 26 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 27 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 28 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 29 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 30 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 31 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 32 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 33 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 34 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 35 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 36 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 37 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 38 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 39 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 40 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 41 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 42 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 43 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 44 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 45 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 46 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 47 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 48 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 49 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 50 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 51 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
               transitionToJsRegexPreceder();
         break;
      case 52 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 53 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 54 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 55 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 56 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 57 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 58 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 59 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 60 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 61 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 62 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 63 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 64 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsRegexPreceder();
         break;
      case 65 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                transitionToJsRegexPreceder();
         break;
      case 66 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
               transitionToJsRegexPreceder();
         break;
      case 67 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                   transitionToJsRegexPreceder();
         break;
      case 68 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                 transitionToJsRegexPreceder();
         break;
      case 69 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToJsRegexPreceder();
         break;
      case 70 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
               transitionToJsRegexPreceder();
         break;
      case 71 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                  transitionToJsRegexPreceder();
         break;
      case 72 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                     transitionToJsRegexPreceder();
         break;
      case 73 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                 transitionToJsRegexPreceder();
         break;
      case 74 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                 transitionToJsRegexPreceder();
         break;
      case 75 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToJsRegexPreceder();
         break;
      case 76 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                transitionToJsRegexPreceder();
         break;
      case 77 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                               transitionToJsDivPreceder();
         break;
      case 78 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                   transitionToJsDivPreceder();
         break;
      case 79 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                          transitionToJsDivPreceder();
         break;
      case 80 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
      transitionToJsDivPreceder();
         break;
      case 82 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToJsDivPreceder();
         break;
      case 83 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                  transitionToJsDivPreceder();
         break;
      case 84 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToState(HtmlContext.JS);  switchToDefaultOrTemplateLiteral();
         break;
      case 85 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToState(HtmlContext.JS);  switchToDefaultOrTemplateLiteral();
         break;
      case 86 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             error("unexpected end of line in JavaScript regex literal");
         break;
      case 90 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            transitionToState(HtmlContext.JS);
            transitionToJsDivPreceder();
            switchToDefaultOrTemplateLiteral();
         break;
      case 93 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
            error("unexpected end of line in JavaScript regex literal");
         break;
      case 94 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToState(HtmlContext.JS);
             transitionToJsDivPreceder();
             switchToDefaultOrTemplateLiteral();
         break;
      case 96 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             transitionToState(HtmlContext.JS);
             transitionToJsDivPreceder();
             switchToDefaultOrTemplateLiteral();
         break;
      case 98 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
             error("unexpected end of line in JavaScript String literal");
         break;
      case 103 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              transitionToState(HtmlContext.JS);
         break;
      case 104 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
              currentContext = currentContext.toBuilder()
                          .withState(HtmlContext.JS)
                          .withJsTemplateLiteralNestDepth(
                              currentContext.jsTemplateLiteralNestDepth() - 1)
                          .withSlashType(Context.JsFollowingSlash.REGEX)
                          .build();
              switchToDefaultOrTemplateLiteral();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

    /** Constructor. */
    public JsLexerTokenManager(SimpleCharStream stream){

      if (SimpleCharStream.staticFlag)
            throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");

    input_stream = stream;
  }

  /** Constructor. */
  public JsLexerTokenManager (SimpleCharStream stream, int lexState){
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Reinitialise parser. */
  public void ReInit(SimpleCharStream stream)
  {
	
    jjmatchedPos = jjnewStateCnt = 0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private void ReInitRounds()
  {
    int i;
    jjround = 0x80000001;
    for (i = 26; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  /** Reinitialise parser. */
  public void ReInit( SimpleCharStream stream, int lexState)
  {
  
    ReInit( stream);
    SwitchTo(lexState);
  }

  /** Switch to specified lex state. */
  public void SwitchTo(int lexState)
  {
    if (lexState >= 9 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }

/** Lexer state names. */
public static final String[] lexStateNames = {
   "TEMPLATE_LITERAL",
   "SQ_STRING",
   "DQ_STRING",
   "REGEX_CHARACTER_CLASS",
   "REGEX",
   "LINE_COMMENT",
   "BLOCK_COMMENT",
   "TEMPLATE_LITERAL_EXPRESSION",
   "DEFAULT",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, 0, -1, -1, 6, 5, 2, 1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, 7, -1, -1, 
};
static final long[] jjtoToken = {
   0x1L, 0x0L, 
};
static final long[] jjtoSkip = {
   0xfffffffffffffff8L, 0x3fffffdffffL, 
};
    protected SimpleCharStream  input_stream;

    private final int[] jjrounds = new int[26];
    private final int[] jjstateSet = new int[2 * 26];

    private final StringBuilder jjimage = new StringBuilder();
    private StringBuilder image = jjimage;
    private int jjimageLen;
    private int lengthOfMatch;
    
    protected int curChar;
}
