/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.SoyCompilerFileReader;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.VeMetadata;
import com.google.template.soy.plugin.java.internal.CompiledJarsPluginSignatureReader;
import com.google.template.soy.soytree.CompilationUnit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

final class CacheLoaders {
    static final SoyInputCache.CacheLoader<AnnotatedLoggingConfig> LOGGING_CONFIG_LOADER = new SoyInputCache.CacheLoader<AnnotatedLoggingConfig>(){

        @Override
        public AnnotatedLoggingConfig read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (InputStream stream = reader.read(file).openStream();){
                AnnotatedLoggingConfig annotatedLoggingConfig = AnnotatedLoggingConfig.parseFrom(stream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                return annotatedLoggingConfig;
            }
        }
    };
    private static final ImmutableMap<String, Descriptors.FileDescriptor> WELL_KNOWN_PROTOS = ImmutableMap.of((Object)VeMetadata.getDescriptor().getName(), (Object)VeMetadata.getDescriptor());
    static final SoyInputCache.CacheLoader<CachedDescriptorSet> CACHED_DESCRIPTOR_SET_LOADER = new SoyInputCache.CacheLoader<CachedDescriptorSet>(){

        @Override
        public CachedDescriptorSet read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (InputStream stream = reader.read(file).openStream();){
                CachedDescriptorSet cachedDescriptorSet = new CachedDescriptorSet(file, DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)stream, (ExtensionRegistryLite)ProtoUtils.REGISTRY));
                return cachedDescriptorSet;
            }
        }
    };
    static final SoyInputCache.CacheLoader<CompiledJarsPluginSignatureReader> JAVA_DEPS = new SoyInputCache.CacheLoader<CompiledJarsPluginSignatureReader>(){

        @Override
        public CompiledJarsPluginSignatureReader read(File file, SoyCompilerFileReader reader, SoyInputCache cache) {
            return new CompiledJarsPluginSignatureReader((List<File>)ImmutableList.of((Object)file), false);
        }
    };
    static final SoyInputCache.CacheLoader<CompilationUnit> COMPILATION_UNIT_LOADER = new SoyInputCache.CacheLoader<CompilationUnit>(){

        @Override
        public CompilationUnit read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (GZIPInputStream is = new GZIPInputStream(reader.read(file).openStream(), 32768);){
                CompilationUnit compilationUnit = CompilationUnit.parseFrom(is, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                return compilationUnit;
            }
        }
    };

    private CacheLoaders() {
    }

    static final class CachedDescriptorSet {
        private final File file;
        private final Map<String, DescriptorProtos.FileDescriptorProto> protosByFileName;
        private final Map<String, Descriptors.FileDescriptor> fileNameToDescriptors = new LinkedHashMap<String, Descriptors.FileDescriptor>();

        CachedDescriptorSet(File file, DescriptorProtos.FileDescriptorSet proto) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
            ImmutableMap.Builder protosByFileNameBuilder = ImmutableMap.builder();
            for (DescriptorProtos.FileDescriptorProto fileProto : proto.getFileList()) {
                protosByFileNameBuilder.put((Object)fileProto.getName(), (Object)fileProto);
                if (!WELL_KNOWN_PROTOS.containsKey((Object)fileProto.getName())) continue;
                this.fileNameToDescriptors.put(fileProto.getName(), (Descriptors.FileDescriptor)WELL_KNOWN_PROTOS.get((Object)fileProto.getName()));
            }
            this.protosByFileName = protosByFileNameBuilder.buildOrThrow();
        }

        File getFile() {
            return this.file;
        }

        Set<String> getProtoFileNames() {
            return this.protosByFileName.keySet();
        }

        Collection<Descriptors.FileDescriptor> getFileDescriptors(SetMultimap<String, CachedDescriptorSet> protoFileToDescriptor, SoyInputCache cache) throws Descriptors.DescriptorValidationException {
            if (this.fileNameToDescriptors.size() == this.protosByFileName.size()) {
                return this.fileNameToDescriptors.values();
            }
            for (DescriptorProtos.FileDescriptorProto fileProto : this.protosByFileName.values()) {
                this.buildDescriptor(fileProto, protoFileToDescriptor, cache);
            }
            return this.fileNameToDescriptors.values();
        }

        private Descriptors.FileDescriptor buildDescriptor(DescriptorProtos.FileDescriptorProto fileProto, SetMultimap<String, CachedDescriptorSet> protoFileToDescriptor, SoyInputCache cache) throws Descriptors.DescriptorValidationException {
            Descriptors.FileDescriptor descriptor = this.fileNameToDescriptors.get(fileProto.getName());
            if (descriptor != null) {
                return descriptor;
            }
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[fileProto.getDependencyCount()];
            for (int i = 0; i < fileProto.getDependencyCount(); ++i) {
                String depName = fileProto.getDependency(i);
                Set depDescriptorSets = protoFileToDescriptor.get((Object)depName);
                if (depDescriptorSets.isEmpty()) {
                    throw new IllegalStateException("Cannot find proto descriptor for " + depName + " which is a dependency of " + fileProto.getName());
                }
                for (CachedDescriptorSet dep : depDescriptorSets) {
                    if (dep == this) continue;
                    cache.declareDependency(this.getFile(), dep.getFile());
                }
                CachedDescriptorSet dep = (CachedDescriptorSet)depDescriptorSets.iterator().next();
                DescriptorProtos.FileDescriptorProto depProto = dep.protosByFileName.get(depName);
                if (depProto == null) {
                    throw new IllegalStateException("Cannot find proto for: " + depName + " which is a dependency of " + fileProto.getName());
                }
                deps[i] = dep.buildDescriptor(depProto, protoFileToDescriptor, cache);
            }
            descriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileProto, (Descriptors.FileDescriptor[])deps);
            this.fileNameToDescriptors.put(fileProto.getName(), descriptor);
            return descriptor;
        }
    }
}

