/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyErrors;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.kohsuke.args4j.Option;

public final class SoyPluginValidator
extends AbstractSoyCompiler {
    @Option(name="--output", required=true, usage="[Required] The file name of the output file to be written. This will only contain the word 'true'.")
    private File output;
    @Option(name="--pluginRuntimeJars", required=false, usage="[Optional] The list of jars that contain the plugin runtime logic, for use validating plugin dependencies at compile time. If not set, runtime jars are assumed to be on the classpath.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> pluginRuntimeJars;

    SoyPluginValidator(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyPluginValidator() {
    }

    public static void main(String[] args) {
        new SoyPluginValidator().runMain(args);
    }

    @Override
    boolean requireSources() {
        return false;
    }

    @Override
    String formatCompilationException(SoyCompilationException sce) {
        return SoyErrors.formatErrorsMessageOnly(sce.getErrors());
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        if (this.pluginRuntimeJars != null) {
            sfsBuilder.setPluginRuntimeJars(this.pluginRuntimeJars);
        }
        sfsBuilder.build().validateUserPlugins();
        Files.write(this.output.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)"true"), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

