/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.protobuf.Message;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyMaps;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class BasicFunctionsRuntime {
    private BasicFunctionsRuntime() {
    }

    public static long ceil(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return ((IntegerData)arg).longValue();
        }
        return (long)Math.ceil(arg.floatValue());
    }

    public static ImmutableList<SoyValueProvider> concatLists(List<SoyList> args) {
        ImmutableList.Builder flattened = ImmutableList.builder();
        for (SoyList soyList : args) {
            flattened.addAll(soyList.asJavaList());
        }
        return flattened.build();
    }

    public static SoyMap concatMaps(SoyMap map, SoyMap mapTwo) {
        LinkedHashMap<SoyValue, SoyValueProvider> mapBuilder = new LinkedHashMap<SoyValue, SoyValueProvider>();
        mapBuilder.putAll(map.asJavaMap());
        mapBuilder.putAll(mapTwo.asJavaMap());
        return SoyMapImpl.forProviderMap(mapBuilder);
    }

    public static boolean listContains(SoyList list, SoyValue value) {
        return list.asResolvedJavaList().contains(value);
    }

    public static int listIndexOf(SoyList list, SoyValue value, NumberData startIndex) {
        List<? extends SoyValue> javaList = list.asResolvedJavaList();
        int clampedStartIndex = BasicFunctionsRuntime.clampListIndex(javaList, startIndex);
        if (clampedStartIndex >= list.length()) {
            return -1;
        }
        int indexInSubList = javaList.subList(clampedStartIndex, list.length()).indexOf(value);
        return indexInSubList == -1 ? -1 : indexInSubList + clampedStartIndex;
    }

    public static String join(SoyList list, String separator) {
        return list.asResolvedJavaList().stream().map(SoyValue::coerceToString).collect(Collectors.joining(separator));
    }

    public static String concatAttributeValues(SoyValue l, SoyValue r, String delimiter) {
        if (l == null && r == null) {
            return "";
        }
        if (l == null) {
            return r.coerceToString();
        }
        if (r == null) {
            return l.coerceToString();
        }
        String lValue = l.stringValue();
        String rValue = r.stringValue();
        if (lValue.isEmpty()) {
            return rValue;
        }
        if (rValue.isEmpty()) {
            return lValue;
        }
        return lValue + delimiter + rValue;
    }

    public static SanitizedContent concatCssValues(SoyValue l, SoyValue r) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(BasicFunctionsRuntime.concatAttributeValues(l, r, ";"), SanitizedContent.ContentKind.CSS);
    }

    public static List<? extends SoyValueProvider> listSlice(SoyList list, NumberData from, NumberData optionalTo) {
        int length = list.length();
        List<? extends SoyValueProvider> javaList = list.asJavaList();
        int intFrom = BasicFunctionsRuntime.clampListIndex(javaList, from);
        if (optionalTo == null) {
            return ImmutableList.copyOf(javaList.subList(intFrom, length));
        }
        int to = BasicFunctionsRuntime.clampListIndex(javaList, optionalTo);
        if (to < intFrom) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(javaList.subList(intFrom, to));
    }

    public static List<? extends SoyValueProvider> listReverse(SoyList list) {
        ArrayList<? extends SoyValueProvider> javaList = new ArrayList<SoyValueProvider>(list.asJavaList());
        Collections.reverse(javaList);
        return javaList;
    }

    public static ImmutableList<? extends SoyValueProvider> listUniq(SoyList list) {
        return (ImmutableList)list.asJavaList().stream().distinct().collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<SoyValueProvider> numberListSort(List<? extends SoyValueProvider> list) {
        return ImmutableList.sortedCopyOf(Comparator.comparingDouble(arg -> arg.resolve().numberValue()), list);
    }

    public static ImmutableList<SoyValueProvider> stringListSort(List<? extends SoyValueProvider> list) {
        return ImmutableList.sortedCopyOf(Comparator.comparing(arg -> arg.resolve().stringValue()), list);
    }

    public static long floor(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return ((IntegerData)arg).longValue();
        }
        return (long)Math.floor(arg.floatValue());
    }

    public static List<SoyValue> keys(SoyValue sv) {
        SoyLegacyObjectMap map = (SoyLegacyObjectMap)sv;
        ArrayList<SoyValue> list = new ArrayList<SoyValue>(map.getItemCnt());
        Iterables.addAll(list, map.getItemKeys());
        return list;
    }

    public static ImmutableList<SoyValue> mapKeys(SoyMap map) {
        return ImmutableList.copyOf(map.keys());
    }

    public static ImmutableList<SoyValueProvider> mapValues(SoyMap map) {
        return ImmutableList.copyOf(map.values());
    }

    public static ImmutableList<SoyValueProvider> mapEntries(SoyMap map) {
        return (ImmutableList)map.entrySet().stream().map(e -> new SoyRecordImpl((ImmutableMap<String, SoyValueProvider>)ImmutableMap.of((Object)"key", (Object)((SoyValueProvider)e.getKey()), (Object)"value", (Object)((SoyValueProvider)e.getValue())))).collect(ImmutableList.toImmutableList());
    }

    public static int mapSize(SoyMap map) {
        return map.size();
    }

    public static SoyDict mapToLegacyObjectMap(SoyMap map) {
        HashMap<String, SoyValueProvider> keysCoercedToStrings = new HashMap<String, SoyValueProvider>();
        for (Map.Entry<? extends SoyValue, ? extends SoyValueProvider> entry : map.asJavaMap().entrySet()) {
            keysCoercedToStrings.put(entry.getKey().coerceToString(), entry.getValue());
        }
        return DictImpl.forProviderMap(keysCoercedToStrings, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    public static NumberData max(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.max(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.max(arg0.numberValue(), arg1.numberValue()));
    }

    public static NumberData min(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.min(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.min(arg0.numberValue(), arg1.numberValue()));
    }

    public static FloatData parseFloat(String str) {
        Double d = Doubles.tryParse((String)str);
        return d == null || d.isNaN() ? null : FloatData.forValue(d);
    }

    public static IntegerData parseInt(String str, int radix) {
        if (radix < 2 || radix > 36) {
            return null;
        }
        Long l = Longs.tryParse((String)str, (int)radix);
        return l == null ? null : IntegerData.forValue(l);
    }

    public static long randomInt(double number) {
        return (long)Math.floor(Math.random() * number);
    }

    public static NumberData round(SoyValue value, int numDigitsAfterPoint) {
        if (numDigitsAfterPoint == 0) {
            return IntegerData.forValue(BasicFunctionsRuntime.round(value));
        }
        if (numDigitsAfterPoint > 0) {
            double valueDouble = value.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPoint);
            return FloatData.forValue((double)Math.round(valueDouble * shift) / shift);
        }
        double valueDouble = value.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPoint);
        return IntegerData.forValue((int)((double)Math.round(valueDouble / shift) * shift));
    }

    public static long round(SoyValue value) {
        if (value instanceof IntegerData) {
            return value.longValue();
        }
        return Math.round(value.numberValue());
    }

    public static ImmutableList<IntegerData> range(int start, int end, int step) {
        if (step == 0) {
            throw new IllegalArgumentException(String.format("step must be non-zero: %d", step));
        }
        int length = end - start;
        if ((length ^ step) < 0) {
            return ImmutableList.of();
        }
        int size = length / step + (length % step == 0 ? 0 : 1);
        ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)size);
        if (step > 0) {
            for (int i = start; i < end; i += step) {
                list.add((Object)IntegerData.forValue(i));
            }
        } else {
            for (int i = start; i > end; i += step) {
                list.add((Object)IntegerData.forValue(i));
            }
        }
        return list.build();
    }

    public static boolean strContains(SoyValue left, String right) {
        return left.stringValue().contains(right);
    }

    public static int strIndexOf(SoyValue str, SoyValue searchStr, NumberData start) {
        String strValue = str.stringValue();
        int clampedStart = BasicFunctionsRuntime.clampStrIndex(strValue, start);
        return strValue.indexOf(searchStr.stringValue(), clampedStart);
    }

    public static int strLen(SoyValue str) {
        return str.stringValue().length();
    }

    public static String strSub(SoyValue str, NumberData start) {
        String string = str.stringValue();
        return string.substring(BasicFunctionsRuntime.clampStrIndex(string, start));
    }

    public static String strSub(SoyValue str, NumberData start, NumberData end) {
        if (start.numberValue() > end.numberValue()) {
            return BasicFunctionsRuntime.strSub(str, end, start);
        }
        String string = str.stringValue();
        return string.substring(BasicFunctionsRuntime.clampStrIndex(string, start), BasicFunctionsRuntime.clampStrIndex(string, end));
    }

    public static boolean strStartsWith(String str, String arg, NumberData start) {
        int clampedStart = BasicFunctionsRuntime.clampStrIndex(str, start);
        if (clampedStart + arg.length() > str.length()) {
            return false;
        }
        return str.substring(clampedStart).startsWith(arg);
    }

    public static boolean strEndsWith(String str, String arg, NumberData length) {
        if (length == null) {
            return str.endsWith(arg);
        }
        int clampedLength = BasicFunctionsRuntime.clampStrIndex(str, length);
        if (clampedLength - arg.length() < 0) {
            return false;
        }
        return str.substring(0, clampedLength).endsWith(arg);
    }

    public static ImmutableList<StringData> strSplit(String str, String sep, NumberData limit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int truncLimit = -1;
        if (limit != null) {
            truncLimit = (int)limit.numberValue();
        }
        if (truncLimit == 0) {
            return builder.build();
        }
        int count = 0;
        for (String string : (sep.isEmpty() ? Splitter.fixedLength((int)1) : Splitter.on((String)sep)).split((CharSequence)str)) {
            if (count == truncLimit) {
                return builder.build();
            }
            builder.add((Object)StringData.forValue(string));
            ++count;
        }
        return builder.build();
    }

    public static String strReplaceAll(String str, String match, String token) {
        return str.replace(match, token);
    }

    public static String strTrim(String str) {
        return str.trim();
    }

    public static int length(List<?> list) {
        return list.size();
    }

    public static SoyMap legacyObjectMapToMap(SoyValue value) {
        return SoyMaps.legacyObjectMapToMap((SoyLegacyObjectMap)value);
    }

    public static boolean isDefault(Message proto) {
        return proto.equals((Object)proto.getDefaultInstanceForType());
    }

    public static boolean protoEquals(Message proto1, Message proto2) {
        return proto1.equals((Object)proto2);
    }

    private static int clampListIndex(List<?> list, NumberData index) {
        int truncIndex = (int)index.numberValue();
        int size = list.size();
        int clampLowerBound = Math.max(0, truncIndex >= 0 ? truncIndex : size + truncIndex);
        return Math.min(size, clampLowerBound);
    }

    private static int clampStrIndex(String str, NumberData position) {
        int clampLowerBound = Math.max(0, (int)position.numberValue());
        return Math.min(str.length(), clampLowerBound);
    }
}

