/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.SoyFileSetNode;

abstract class Rule<T extends Node> {
    private final Class<T> nodeClass = new TypeToken<T>(this.getClass()){}.getRawType();
    protected final SoyErrorKind error;

    Rule(SoyErrorKind error) {
        if (this.nodeClass == SoyFileSetNode.class) {
            throw new IllegalStateException("Rule<SoyFileSetNode> does not work with whitelists. Use Rule<SoyFileNode> instead.");
        }
        this.error = (SoyErrorKind)Preconditions.checkNotNull((Object)error);
    }

    final void checkConformance(Node node, ErrorReporter errorReporter) {
        if (this.nodeClass.isAssignableFrom(node.getClass())) {
            this.doCheckConformance((Node)this.nodeClass.cast(node), errorReporter);
        }
    }

    @ForOverride
    protected abstract void doCheckConformance(T var1, ErrorReporter var2);
}

