/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.AbstractSoyList;
import java.util.List;

public final class LazyProtoToSoyValueList<E>
extends AbstractSoyList {
    private final ImmutableList<E> rawValues;
    private final ProtoFieldInterpreter valueInterpreter;
    private final SoyValue[] wrappedValues;

    public static <E> LazyProtoToSoyValueList<E> forList(List<E> list, ProtoFieldInterpreter valueInterpreter) {
        return new LazyProtoToSoyValueList<E>(list, valueInterpreter);
    }

    private LazyProtoToSoyValueList(List<E> list, ProtoFieldInterpreter valueInterpreter) {
        this.rawValues = ImmutableList.copyOf(list);
        this.valueInterpreter = valueInterpreter;
        this.wrappedValues = new SoyValue[this.rawValues.size()];
    }

    @Override
    public int length() {
        return this.rawValues.size();
    }

    public ImmutableList<SoyValue> asJavaList() {
        return this.asResolvedJavaList();
    }

    public ImmutableList<SoyValue> asResolvedJavaList() {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < this.length(); ++i) {
            list.add((Object)this.get(i));
        }
        return list.build();
    }

    @Override
    public SoyValue get(int index) {
        SoyValue wrapped = this.wrappedValues[index];
        if (wrapped != null) {
            return wrapped;
        }
        this.wrappedValues[index] = wrapped = this.valueInterpreter.soyFromProto(this.rawValues.get(index));
        return wrapped;
    }

    @Override
    public SoyValueProvider getProvider(int index) {
        return this.get(index);
    }
}

