/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;

public final class SoyRecordImpl
extends SoyAbstractValue
implements SoyRecord {
    private final ImmutableMap<String, SoyValueProvider> map;

    public SoyRecordImpl(ImmutableMap<String, SoyValueProvider> map) {
        this.map = (ImmutableMap)Preconditions.checkNotNull(map);
    }

    public static SoyRecordImpl forProviderMap(Map<String, SoyValueProvider> map) {
        return new SoyRecordImpl((ImmutableMap<String, SoyValueProvider>)ImmutableMap.copyOf(map));
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        return this.map;
    }

    @Override
    public void forEach(BiConsumer<String, ? super SoyValueProvider> action) {
        this.map.forEach(action);
    }

    @Override
    public int recordSize() {
        return this.map.size();
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (Map.Entry entry : this.map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            appendable.append((CharSequence)entry.getKey()).append(": ");
            ((SoyValueProvider)entry.getValue()).resolve().render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean hasField(String name) {
        return this.map.containsKey((Object)name);
    }

    @Override
    public SoyValueProvider getFieldProvider(String name) {
        return (SoyValueProvider)this.map.get((Object)name);
    }

    @Override
    public SoyValue getField(String name) {
        SoyValueProvider svp = (SoyValueProvider)this.map.get((Object)name);
        if (svp == null) {
            return null;
        }
        return svp.resolve();
    }
}

