/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;

public final class NullSafeAccessNode
extends AbstractParentExprNode {
    private static final String BASE_PLACEHOLDER_VALUE = "DO_NOT_USE__NULL_SAFE_ACCESS";

    private NullSafeAccessNode(ExprNode base, ExprNode.AccessChainComponentNode access) {
        super(access.getSourceLocation());
        this.addChild(base);
        this.addChild(access);
    }

    private NullSafeAccessNode(NullSafeAccessNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.NULL_SAFE_ACCESS_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceString = new StringBuilder(this.getBase().toSourceString());
        ExprNode dataAccess = this.getDataAccess();
        while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
            NullSafeAccessNode.accumulateDataAccess(sourceString, (ExprNode.AccessChainComponentNode)node.getBase());
            dataAccess = node.getDataAccess();
        }
        NullSafeAccessNode.accumulateDataAccess(sourceString, (ExprNode.AccessChainComponentNode)dataAccess);
        return sourceString.toString();
    }

    private static void accumulateDataAccess(StringBuilder accumulator, ExprNode.AccessChainComponentNode node) {
        StringBuilder dataAccessChain = new StringBuilder();
        ExprNode child = node;
        while (child instanceof ExprNode.AccessChainComponentNode) {
            if (child instanceof DataAccessNode) {
                DataAccessNode dataAccessNode = (DataAccessNode)child;
                dataAccessChain.insert(0, dataAccessNode.getSourceStringSuffix());
                child = dataAccessNode.getBaseExprChild();
                continue;
            }
            OperatorNodes.AssertNonNullOpNode assertNonNullOpNode = (OperatorNodes.AssertNonNullOpNode)child;
            dataAccessChain.insert(0, assertNonNullOpNode.getOperator().getTokenString());
            child = assertNonNullOpNode.getChild(0);
        }
        accumulator.append('?').append((CharSequence)dataAccessChain);
    }

    @Override
    public ExprNode copy(CopyState copyState) {
        return new NullSafeAccessNode(this, copyState);
    }

    public ExprNode getBase() {
        return this.getChild(0);
    }

    public ExprNode getDataAccess() {
        return this.getChild(1);
    }

    public static boolean isPlaceholder(ExprNode node) {
        return node.getKind() == ExprNode.Kind.STRING_NODE && ((StringNode)node).getValue().equals(BASE_PLACEHOLDER_VALUE) || node.getKind() == ExprNode.Kind.GROUP_NODE && ((GroupNode)node).isNullSafeAccessPlaceHolder();
    }

    public static void createAndInsert(DataAccessNode node, ExprNode.AccessChainComponentNode accessChainRoot) {
        NullSafeAccessNode nullSafe;
        DataAccessNode child;
        Preconditions.checkArgument((boolean)node.isNullSafe());
        ExprNode base = node.getBaseExprChild();
        StringNode basePlaceholder = new StringNode(BASE_PLACEHOLDER_VALUE, QuoteStyle.DOUBLE, base.getSourceLocation());
        switch (node.getKind()) {
            case FIELD_ACCESS_NODE: {
                child = new FieldAccessNode(basePlaceholder, ((FieldAccessNode)node).getFieldName(), node.getAccessSourceLocation(), false);
                break;
            }
            case ITEM_ACCESS_NODE: {
                child = new ItemAccessNode(basePlaceholder, ((ItemAccessNode)node).getKeyExprChild(), node.getAccessSourceLocation(), false);
                break;
            }
            case METHOD_CALL_NODE: {
                MethodCallNode childMethodCall = MethodCallNode.newWithPositionalArgs(basePlaceholder, node.getChildren().subList(1, node.numChildren()), ((MethodCallNode)node).getMethodName(), node.getAccessSourceLocation(), false);
                if (((MethodCallNode)node).isMethodResolved()) {
                    childMethodCall.setSoyMethod(((MethodCallNode)node).getSoyMethod());
                }
                child = childMethodCall;
                break;
            }
            default: {
                throw new AssertionError((Object)node.getKind());
            }
        }
        ExprNode.ParentExprNode accessChainParent = accessChainRoot.getParent();
        int rootIndex = accessChainParent.getChildIndex(accessChainRoot);
        if (node == accessChainRoot) {
            nullSafe = new NullSafeAccessNode(base, child);
            accessChainParent.removeChild(rootIndex);
        } else {
            node.getParent().replaceChild(node, child);
            nullSafe = new NullSafeAccessNode(base, accessChainRoot);
        }
        accessChainParent.addChild(rootIndex, nullSafe);
    }
}

