/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

public final class VeLiteralNode
extends AbstractExprNode {
    private final Identifier veIdentifier;
    private final Identifier name;
    @Nullable
    private ValidatedLoggingConfig.ValidatedLoggableElement loggableElement;
    private SoyType type;

    public VeLiteralNode(Identifier veIdentifier, Identifier name, SourceLocation srcLoc) {
        super(srcLoc);
        this.veIdentifier = veIdentifier;
        this.name = name;
    }

    private VeLiteralNode(VeLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.veIdentifier = orig.veIdentifier;
        this.name = orig.name;
        this.loggableElement = orig.loggableElement;
        this.type = orig.type;
    }

    public Identifier getVeIdentifier() {
        return this.veIdentifier;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setLoggableElement(ValidatedLoggingConfig.ValidatedLoggableElement loggableElement) {
        this.loggableElement = loggableElement;
    }

    @Nullable
    public Long getId() {
        return this.loggableElement == null ? null : Long.valueOf(this.loggableElement.getId());
    }

    public ValidatedLoggingConfig.ValidatedLoggableElement getLoggableElement() {
        return (ValidatedLoggingConfig.ValidatedLoggableElement)Preconditions.checkNotNull((Object)this.loggableElement);
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    @Override
    public SoyType getType() {
        return this.type;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.VE_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        return "ve(" + this.name.identifier() + ")";
    }

    @Override
    public VeLiteralNode copy(CopyState copyState) {
        return new VeLiteralNode(this, copyState);
    }
}

