/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NumberData;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import javax.annotation.Nullable;

public final class I18NDirectivesRuntime {
    private I18NDirectivesRuntime() {
    }

    public static String formatNum(ULocale uLocale, @Nullable SoyValue number, String formatType, String numbersKeyword, @Nullable NumberData minFractionDigits, @Nullable NumberData maxFractionDigits) {
        if (number == null) {
            return "";
        }
        if (number instanceof NumberData) {
            return I18NDirectivesRuntime.formatInternal(uLocale, ((NumberData)number).toFloat(), formatType, numbersKeyword, minFractionDigits != null ? Integer.valueOf((int)minFractionDigits.numberValue()) : null, maxFractionDigits != null ? Integer.valueOf((int)maxFractionDigits.numberValue()) : null);
        }
        return "NaN";
    }

    public static String format(Object number, ULocale uLocale) {
        return I18NDirectivesRuntime.format(number, "decimal", null, null, null, uLocale);
    }

    public static String format(Object number, String formatType, ULocale uLocale) {
        return I18NDirectivesRuntime.format(number, formatType, null, null, null, uLocale);
    }

    public static String format(Object number, String formatType, String numbersKeyword, ULocale uLocale) {
        return I18NDirectivesRuntime.format(number, formatType, numbersKeyword, null, null, uLocale);
    }

    public static String format(Object number, String formatType, String numbersKeyword, Integer minFractionDigits, ULocale uLocale) {
        return I18NDirectivesRuntime.format(number, formatType, numbersKeyword, minFractionDigits, null, uLocale);
    }

    public static String format(Object number, String formatType, String numbersKeyword, Integer minFractionDigits, Integer maxFractionDigits, ULocale uLocale) {
        if (number == null) {
            return "";
        }
        if (number instanceof Number) {
            Double val = number instanceof Double ? (Double)number : (number instanceof Long ? Double.valueOf(((Long)number).doubleValue()) : (number instanceof Integer ? Double.valueOf(((Integer)number).doubleValue()) : Double.valueOf(Double.parseDouble(number.toString()))));
            return I18NDirectivesRuntime.formatInternal(uLocale, val, formatType, numbersKeyword, minFractionDigits, maxFractionDigits);
        }
        return "NaN";
    }

    private static String formatInternal(ULocale uLocale, double number, String formatType, String numbersKeyword, @Nullable Integer minFractionDigits, @Nullable Integer maxFractionDigits) {
        NumberFormat numberFormat;
        uLocale = uLocale.setKeywordValue("numbers", numbersKeyword);
        switch (formatType) {
            case "decimal": {
                numberFormat = NumberFormat.getInstance((ULocale)uLocale);
                break;
            }
            case "percent": {
                numberFormat = NumberFormat.getPercentInstance((ULocale)uLocale);
                break;
            }
            case "currency": {
                numberFormat = NumberFormat.getCurrencyInstance((ULocale)uLocale);
                break;
            }
            case "scientific": {
                numberFormat = NumberFormat.getScientificInstance((ULocale)uLocale);
                break;
            }
            case "compact_short": {
                numberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.SHORT);
                break;
            }
            case "compact_long": {
                numberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.LONG);
                break;
            }
            default: {
                throw new IllegalArgumentException("First argument to formatNum must be constant, and one of: 'decimal', 'currency', 'percent', 'scientific', 'compact_short', or 'compact_long'.");
            }
        }
        if (minFractionDigits != null || maxFractionDigits != null) {
            if (maxFractionDigits == null) {
                maxFractionDigits = minFractionDigits;
            }
            if (minFractionDigits != null) {
                numberFormat.setMinimumFractionDigits(minFractionDigits.intValue());
            }
            numberFormat.setMaximumFractionDigits(maxFractionDigits.intValue());
        } else if (numberFormat instanceof CompactDecimalFormat) {
            ((CompactDecimalFormat)numberFormat).setMaximumSignificantDigits(3);
        }
        return numberFormat.format(number);
    }

    public static ImmutableList<SoyValueProvider> localeSort(ULocale uLocale, SoyList list, @Nullable SoyRecord options) {
        RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance((ULocale)uLocale);
        if (options != null) {
            if (options.hasField("numeric")) {
                collator.setNumericCollation(options.getField("numeric").booleanValue());
            }
            if (options.hasField("caseFirst")) {
                String caseFirst = options.getField("caseFirst").stringValue();
                if ("upper".equals(caseFirst)) {
                    collator.setUpperCaseFirst(true);
                } else if ("lower".equals(caseFirst)) {
                    collator.setLowerCaseFirst(true);
                }
            }
            if (options.hasField("sensitivity")) {
                String sensitivity;
                switch (sensitivity = options.getField("sensitivity").stringValue()) {
                    case "base": {
                        collator.setStrength(0);
                        break;
                    }
                    case "accent": {
                        collator.setStrength(1);
                        break;
                    }
                    case "case": {
                        collator.setStrength(2);
                        break;
                    }
                    case "variant": {
                        collator.setStrength(15);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad value for sensitivity: " + sensitivity);
                    }
                }
            } else {
                collator.setStrength(15);
            }
        }
        return ImmutableList.sortedCopyOf(Comparator.comparing(arg -> arg.resolve().stringValue(), collator), list.asJavaList());
    }
}

