/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Supplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.HtmlContextVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.RemoveUnnecessaryEscapingDirectives;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.incrementaldomsrc.TransformSkipNodeVisitor;
import com.google.template.soy.incrementaldomsrc.UnescapingVisitor;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collections;
import java.util.List;

public class IncrementalDomSrcMain {
    private final SoyScopedData.Enterable apiCallScope;
    private final SoyTypeRegistry typeRegistry;

    public IncrementalDomSrcMain(SoyScopedData.Enterable apiCallScope, SoyTypeRegistry typeRegistry) {
        this.apiCallScope = apiCallScope;
        this.typeRegistry = typeRegistry;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, FileSetMetadata registry, SoyIncrementalDomSrcOptions options, ErrorReporter errorReporter) {
        SoyJsSrcOptions incrementalJSSrcOptions = options.toJsSrcOptions();
        BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(incrementalJSSrcOptions.getBidiGlobalDir(), incrementalJSSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
        try (SoyScopedData.InScope inScope = this.apiCallScope.enter(null, bidiGlobalDir);){
            new HtmlContextVisitor().exec(soyTree);
            if (errorReporter.hasErrors()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            UnescapingVisitor.unescapeRawTextInHtml(soyTree);
            TransformSkipNodeVisitor.reparentSkipNodes(soyTree);
            new RemoveUnnecessaryEscapingDirectives(bidiGlobalDir).run(soyTree);
            new CombineConsecutiveRawTextNodesPass().run(soyTree);
            List<String> list = IncrementalDomSrcMain.createVisitor(incrementalJSSrcOptions, this.typeRegistry, inScope.getBidiGlobalDir(), errorReporter).gen(soyTree, registry, errorReporter);
            return list;
        }
    }

    static GenIncrementalDomCodeVisitor createVisitor(SoyJsSrcOptions options, SoyTypeRegistry typeRegistry, BidiGlobalDir dir, ErrorReporter errorReporter) {
        GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genJsExprsVisitorFactory;
        final IncrementalDomDelTemplateNamer delTemplateNamer = new IncrementalDomDelTemplateNamer();
        final IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor = new IsComputableAsIncrementalDomExprsVisitor();
        JavaScriptValueFactoryImpl javaScriptValueFactory = new JavaScriptValueFactoryImpl(dir, errorReporter);
        CanInitOutputVarVisitor canInitOutputVarVisitor = new CanInitOutputVarVisitor(isComputableAsJsExprsVisitor);
        class GenCallCodeUtilsSupplier
        implements Supplier<IncrementalDomGenCallCodeUtils> {
            GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory factory;

            GenCallCodeUtilsSupplier() {
            }

            public IncrementalDomGenCallCodeUtils get() {
                return new IncrementalDomGenCallCodeUtils(delTemplateNamer, isComputableAsJsExprsVisitor, this.factory);
            }
        }
        GenCallCodeUtilsSupplier supplier = new GenCallCodeUtilsSupplier();
        supplier.factory = genJsExprsVisitorFactory = new GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory(javaScriptValueFactory, supplier, isComputableAsJsExprsVisitor);
        return new GenIncrementalDomCodeVisitor(options, javaScriptValueFactory, delTemplateNamer, supplier.get(), isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, typeRegistry);
    }
}

