/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.invocationbuilders.javatypes.CodeGenUtils;
import com.google.template.soy.invocationbuilders.javatypes.FutureJavaType;
import com.google.template.soy.invocationbuilders.javatypes.JavaType;
import com.google.template.soy.invocationbuilders.javatypes.RecordJavaType;
import com.google.template.soy.invocationbuilders.passes.SoyFileNodeTransformer;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.internal.gencode.JavaGenerationUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GenInvocationBuildersVisitor
extends AbstractSoyNodeVisitor<ImmutableList<GeneratedFile>> {
    private static final String TEMPLATE_NAME_FIELD = "__NAME__";
    private static final String PARAMS_FIELD = "__PARAMS__";
    private static final String PROTOS_FIELD = "__PROTOS__";
    private static final String CSS_PROVIDES_FIELD = "__PROVIDED_CSS__";
    private static final String CSS_MAP_FIELD = "__PROVIDED_CSS_MAP__";
    private static final String DEFAULT_INSTANCE_FIELD = "__DEFAULT_INSTANCE__";
    private static final SoyErrorKind TYPE_COLLISION = SoyErrorKind.of("Parameter ''{0}'' in {1} has different types in different templates. No parameter setter generated.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INDIRECT_PROTO = SoyErrorKind.of("Indirect parameter ''{0}'' in {1} is of type proto or proto enum. No parameter setter generated.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TEMPLATE_NAME_COLLISION = SoyErrorKind.of("When generating Soy Java Template Builders, the template: {0} generated the same Java UpperCamelCase name as another template in this file, or collided with a reserved identifier: " + SoyFileNodeTransformer.RESERVED_IDENTIFIERS + ". This template was skipped during Soy java_builders generation. To use this API, all Soy template names in a given file should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped). The generated Java class name was: {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_NAME_COLLISION = SoyErrorKind.of("When generating Soy Java Template Builders, the param named {0} in template {1} generated the same UpperCamelCase name as another parameter, or collided with a reserved identifier: " + SoyFileNodeTransformer.RESERVED_IDENTIFIERS + ". Param: {0} is being skipped (no setters will be generated for this param). The generated setter name was: {2}. To use this API, all parameter names for a given template should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FILE_NAME_COLLISION = SoyErrorKind.of("While generating Soy Java invocation builders, multiple files in this soy fileset mapped to the same file name: {0}. To use this api, soy file names should be unique when converted to UpperCamelCase (with non-alpha-numeric characters stripped).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FUTURE_NAME_COLLISION = SoyErrorKind.of("Achievement unlocked. You have a template with parameters named {0} and {0}Future, preventing a future setter from being created for the first parameter.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final SoyFileNodeTransformer transformer;
    private IndentedLinesBuilder ilb;
    private ImmutableList.Builder<GeneratedFile> generatedFiles;

    public GenInvocationBuildersVisitor(ErrorReporter errorReporter, String javaPackage, FileSetMetadata registry) {
        this.errorReporter = errorReporter;
        this.transformer = new SoyFileNodeTransformer(javaPackage, registry);
    }

    @Override
    public ImmutableList<GeneratedFile> exec(SoyNode node) {
        this.generatedFiles = new ImmutableList.Builder();
        this.ilb = null;
        this.visit(node);
        ImmutableList builtFileList = this.generatedFiles.build();
        this.logWarningIfFilenamesNotUnique((ImmutableList<GeneratedFile>)builtFileList);
        return builtFileList;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFile) {
        SoyFileNodeTransformer.FileInfo fileInfo = this.transformer.transform(soyFile);
        this.ilb = new IndentedLinesBuilder(2);
        this.appendFileHeaderAndImports(fileInfo);
        String javaClassNameForSoyFile = fileInfo.className();
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wrapper class containing {@link com.google.template.soy.data.SoyTemplate} builders for each template in: " + fileInfo.soyFileName() + ".", false, true);
        this.ilb.appendLine("@javax.annotation.Generated(\"com.google.template.soy.SoyParseInfoGenerator\")");
        this.ilb.appendLine("public final class " + javaClassNameForSoyFile + " {");
        this.ilb.increaseIndent();
        this.appendProtoDescriptors(fileInfo, soyFile.getSoyTypeRegistry());
        HashMap<String, String> filePathToNamespace = new HashMap<String, String>();
        fileInfo.fileNode().getRequiredCssPaths().forEach(cssPath -> {
            if (cssPath.getNamespace() != null && !filePathToNamespace.containsKey(cssPath.resolvedPath().get())) {
                filePathToNamespace.put(String.format("\"%s\"", cssPath.resolvedPath().get()), String.format("\"%s\"", cssPath.getNamespace()));
            }
        });
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "A map of filepath to symbol used for CSS resolution on server edit-refresh.", false, true);
        this.ilb.appendLineStart("private static final com.google.common.collect.ImmutableMap<java.lang.String, java.lang.String> __PROVIDED_CSS_MAP__ = ");
        JavaGenerationUtils.appendImmutableMap(this.ilb, "<java.lang.String, java.lang.String>", filePathToNamespace);
        this.ilb.appendLineEnd(";");
        ImmutableList namespaces = (ImmutableList)Streams.concat((Stream[])new Stream[]{fileInfo.fileNode().getRequiredCssNamespaces().stream(), fileInfo.fileNode().getRequiredCssPaths().stream().map(p -> p.resolvedPath().get()), fileInfo.templates().stream().flatMap(templateInfo -> templateInfo.template().getRequiredCssNamespaces().stream())}).map(ns -> String.format("\"%s\"", ns)).collect(ImmutableList.toImmutableList());
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "A list of provided symbols used for css validation on edit refresh.", false, true);
        this.ilb.appendLineStart("private static final com.google.common.collect.ImmutableList<java.lang.String> __PROVIDED_CSS__ = ");
        JavaGenerationUtils.appendImmutableList(this.ilb, "<java.lang.String>", (Collection<String>)namespaces);
        this.ilb.appendLineEnd(";");
        this.generateParamsClassesForEachTemplate(fileInfo);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        String fileName = javaClassNameForSoyFile + ".java";
        this.generatedFiles.add((Object)GeneratedFile.create(fileName, this.ilb.toString()));
        this.ilb = null;
    }

    private void generateParamsClassesForEachTemplate(SoyFileNodeTransformer.FileInfo soyFile) {
        soyFile.templates().forEach(t -> {
            switch (t.status()) {
                case HANDLED: {
                    this.visitTemplateInfo((SoyFileNodeTransformer.TemplateInfo)t);
                    break;
                }
                case NAME_COLLISION: {
                    this.errorReporter.warn(t.sourceLocation(), TEMPLATE_NAME_COLLISION, t.templateName(), t.className());
                }
            }
        });
    }

    private void visitTemplateInfo(SoyFileNodeTransformer.TemplateInfo template) {
        String paramsClass = template.className();
        String templateDescription = template.soyDocDesc();
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "Template params for " + template.templateNameForUserMsgs() + (templateDescription != null ? ": " + templateDescription : "."), false, true);
        this.ilb.appendLine("public static final class " + paramsClass + " extends com.google.template.soy.data.BaseSoyTemplateImpl {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final java.lang.String __NAME__ = \"" + template.templateName() + "\";");
        this.ilb.appendLine(new Object[0]);
        this.appendFutureWrapperMethod(paramsClass);
        this.ilb.appendLine("private " + paramsClass + "(com.google.common.collect.ImmutableMap<java.lang.String, com.google.template.soy.data.SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("public final java.lang.String getTemplateName() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __NAME__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.appendParamsBuilderClass(template, paramsClass);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendProtoDescriptors(SoyFileNodeTransformer.FileInfo fileInfo, SoyTypeRegistry typeRegistry) {
        List<String> protoTypes = fileInfo.getProtoTypes(typeRegistry).stream().sorted().collect(Collectors.toList());
        if (protoTypes.isEmpty()) {
            return;
        }
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "The list of protos used by all templates (public and private) in this Soy file, which are used by 1) the edit-refresh development compiler and 2) the java compiler to enforce strict proto deps.", false, true);
        this.ilb.appendLineStart("private static final com.google.common.collect.ImmutableList<com.google.protobuf.Descriptors.FileDescriptor> __PROTOS__ = ");
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(this.ilb, "com.google.common.collect.ImmutableList.of", protoTypes);
        this.ilb.appendLineEnd(";");
    }

    private void appendFutureWrapperMethod(String paramsClass) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wraps a ListenableFuture<" + paramsClass + "> as a SoyTemplate.AsyncWrapper<" + paramsClass + ">", false, true);
        this.ilb.appendLine("public static com.google.template.soy.data.SoyTemplate.AsyncWrapper<" + paramsClass + "> wrapFuture(com.google.common.util.concurrent.ListenableFuture<" + paramsClass + "> paramsFuture) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new com.google.template.soy.data.SoyTemplate.AsyncWrapper<>(__NAME__, paramsFuture);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendParamsBuilderClass(SoyFileNodeTransformer.TemplateInfo template, String templateParamsClassname) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new Builder instance.", false, true);
        this.ilb.appendLine("public static Builder builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new Builder();");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        List<SoyFileNodeTransformer.ParamInfo> combinedParams = template.params().stream().filter(info -> {
            switch (info.status()) {
                case HANDLED: 
                case UNHANDLED_TYPE: {
                    return true;
                }
                case NAME_COLLISION: {
                    this.errorReporter.warn(info.sourceLocation(), PARAM_NAME_COLLISION, info.name(), template.templateName(), info.setterName());
                    return true;
                }
                case JAVA_INCOMPATIBLE: {
                    break;
                }
                case INDIRECT_INCOMPATIBLE_TYPES: {
                    this.errorReporter.warn(info.sourceLocation(), TYPE_COLLISION, info.name(), template.templateName());
                    break;
                }
                case INDIRECT_PROTO: {
                    this.errorReporter.warn(info.sourceLocation(), INDIRECT_PROTO, info.name(), template.templateName());
                }
            }
            return false;
        }).collect(Collectors.toList());
        List<SoyFileNodeTransformer.ParamInfo> nonInjectedParams = combinedParams.stream().filter(p -> !p.injected()).collect(Collectors.toList());
        if (nonInjectedParams.stream().noneMatch(SoyFileNodeTransformer.ParamInfo::requiredAndNotIndirect)) {
            this.ilb.appendLine("private static final " + templateParamsClassname + " " + DEFAULT_INSTANCE_FIELD + " = new " + templateParamsClassname + "(com.google.common.collect.ImmutableMap.of());");
            this.ilb.appendLine(new Object[0]);
            JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new instance of " + templateParamsClassname + " with no parameters set. This method was generated because all template parameters are optional.", false, true);
            this.ilb.appendLine("public static " + templateParamsClassname + " getDefaultInstance() {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("return __DEFAULT_INSTANCE__;");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
            this.ilb.appendLine(new Object[0]);
        }
        GenInvocationBuildersVisitor.appendParamConstants(this.ilb, combinedParams);
        boolean anyAccumulatorParameters = nonInjectedParams.stream().flatMap(param -> param.javaTypes().stream()).anyMatch(javaType -> javaType instanceof RecordJavaType && ((RecordJavaType)javaType).isList());
        this.ilb.appendLine("public static final class Builder extends com.google.template.soy.data.BaseSoyTemplateImpl." + (anyAccumulatorParameters ? "AbstractBuilderWithAccumulatorParameters" : "AbstractBuilder") + "<Builder, " + templateParamsClassname + "> {");
        this.ilb.appendLine(new Object[0]);
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(", nonInjectedParams.size(), ");");
        GenInvocationBuildersVisitor.appendRecordListInitializations(this.ilb, nonInjectedParams);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("protected com.google.common.collect.ImmutableSet<com.google.template.soy.data.SoyTemplateParam<?>> allParams() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __PARAMS__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("protected " + templateParamsClassname + " buildInternal(com.google.common.collect.ImmutableMap<java.lang.String, com.google.template.soy.data.SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new " + templateParamsClassname + "(data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        nonInjectedParams.stream().filter(p -> p.status() == SoyFileNodeTransformer.ParamStatus.HANDLED).forEach(this::writeSettersForParam);
        this.ilb.appendLine(new Object[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
    }

    private static void appendParamConstants(IndentedLinesBuilder ilb, List<SoyFileNodeTransformer.ParamInfo> params) {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<String> nonInjected = new ArrayList<String>();
        for (SoyFileNodeTransformer.ParamInfo param : params) {
            JavaType javaType;
            while (usedNames.contains(param.constantFieldName())) {
                param.updateConstantFieldName();
            }
            String fieldName = param.constantFieldName();
            usedNames.add(fieldName);
            if (!param.injected()) {
                nonInjected.add(fieldName);
            }
            String genericType = "?";
            List<JavaType> types = param.javaTypes();
            if (types.size() == 1 && (javaType = types.get(0)).isTypeLiteralSupported()) {
                genericType = javaType.asTypeLiteralString();
            }
            String visibility = !"?".equals(genericType) ? "public" : "private";
            CodeGenUtils.Member factory = CodeGenUtils.STANDARD_P;
            if (param.injected()) {
                factory = CodeGenUtils.INJECTED_P;
            } else if (param.indirect()) {
                factory = CodeGenUtils.INDIRECT_P;
            }
            String paramDescription = param.param().getDescription();
            paramDescription = paramDescription == null ? "" : paramDescription + " ";
            String typeToken = "?".equals(genericType) ? "com.google.common.reflect.TypeToken.of(java.lang.Object.class)" : (genericType.matches("(\\.|\\w)+") ? "com.google.common.reflect.TypeToken.of(" + genericType + ".class)" : "new com.google.common.reflect.TypeToken<" + genericType + ">() {}");
            ilb.appendLine(String.format("/** {@%s %s} %s*/", param.injected() ? "inject" : "param", param.name(), paramDescription));
            ilb.appendLine(String.format("%s static final com.google.template.soy.data.SoyTemplateParam<%s>", visibility, genericType));
            ilb.increaseIndent(2);
            ilb.appendLine(fieldName, " =");
            ilb.increaseIndent(2);
            ilb.appendLine(factory, "(");
            ilb.increaseIndent(2);
            ilb.appendLine("\"", param.name(), "\",");
            ilb.appendLine("/* required= */ ", param.required(), ",");
            ilb.appendLine(typeToken, ");");
            ilb.decreaseIndent(6);
            ilb.appendLine(new Object[0]);
        }
        ilb.appendLineStart("private static final com.google.common.collect.ImmutableSet<com.google.template.soy.data.SoyTemplateParam<?>> __PARAMS__ = ");
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "com.google.common.collect.ImmutableSet.of", nonInjected);
        ilb.appendLineEnd(";");
        ilb.appendLine(new Object[0]);
    }

    private static void appendRecordListInitializations(IndentedLinesBuilder ilb, List<SoyFileNodeTransformer.ParamInfo> params) {
        for (SoyFileNodeTransformer.ParamInfo param : params) {
            List<JavaType> types;
            if (!param.required() || (types = param.javaTypes()).size() != 1 || !(types.get(0) instanceof RecordJavaType) || !((RecordJavaType)types.get(0)).isList()) continue;
            ilb.appendLine(String.format("%s(%s);", CodeGenUtils.INIT_LIST_PARAM, param.constantFieldName()));
        }
    }

    private void appendFileHeaderAndImports(SoyFileNodeTransformer.FileInfo soyFile) {
        this.ilb.appendLine("// This file was automatically generated by the Soy compiler.");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine("// source: " + soyFile.soyFilePath().path());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("package " + soyFile.packageName() + ";");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
    }

    private void writeSettersForParam(SoyFileNodeTransformer.ParamInfo param) {
        param.javaTypes().forEach(javaType -> GenInvocationBuildersVisitor.writeSetter(this.ilb, param, javaType));
        switch (param.futureStatus()) {
            case HANDLED: {
                for (JavaType futureType : param.futureTypes()) {
                    GenInvocationBuildersVisitor.writeFutureSetter(this.ilb, param, new FutureJavaType(futureType));
                }
                break;
            }
            case NAME_COLLISION: {
                this.errorReporter.warn(param.sourceLocation(), FUTURE_NAME_COLLISION, param.name());
                break;
            }
        }
    }

    private static void writeSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, JavaType javaType) {
        String paramDescription = param.param().getDescription();
        ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(ilb, "Sets " + param.name() + (Strings.isNullOrEmpty((String)paramDescription) ? "." : ": " + paramDescription), false, true);
        if (javaType instanceof RecordJavaType) {
            GenInvocationBuildersVisitor.writeRecordSetter(ilb, param, (RecordJavaType)javaType);
        } else {
            String javaTypeString = javaType.toJavaTypeString();
            boolean nullable = javaType.isNullable();
            ilb.appendLine("@com.google.errorprone.annotations.CanIgnoreReturnValue");
            ilb.appendLine("public Builder " + param.setterName() + "(" + (nullable ? "@javax.annotation.Nullable " : "") + javaTypeString + " value) {");
            ilb.increaseIndent();
            String newVariableName = javaType.asInlineCast("value");
            ilb.appendLine("return " + CodeGenUtils.SET_PARAM_INTERNAL + "(", param.constantFieldName(), ", ", newVariableName, ");");
            ilb.decreaseIndent();
            ilb.appendLine("}");
        }
    }

    private static void writeRecordSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, RecordJavaType type) {
        ilb.appendLine("@com.google.errorprone.annotations.CanIgnoreReturnValue");
        ilb.appendLineStart("public Builder ", type.isList() ? param.adderName() : param.setterName(), "(");
        ImmutableList paramNames = type.getJavaTypeMap().keySet().asList();
        ArrayList<String> javaParamNames = new ArrayList<String>();
        boolean first = true;
        for (Map.Entry entry : type.getJavaTypeMap().entrySet()) {
            JavaType paramType;
            String paramName = GenInvocationBuildersVisitor.makeParamName((String)entry.getKey());
            javaParamNames.add(paramName);
            if (!first) {
                ilb.append(", ");
            }
            if ((paramType = (JavaType)entry.getValue()).isNullable()) {
                ilb.append("@javax.annotation.Nullable ");
            }
            ilb.append(paramType.toJavaTypeString()).append(" ").append(paramName);
            first = false;
        }
        ilb.appendLineEnd(") {");
        ilb.increaseIndent();
        CodeGenUtils.Member delegate = type.isList() ? CodeGenUtils.ADD_TO_LIST_PARAM : CodeGenUtils.SET_PARAM_INTERNAL;
        ilb.appendLineStart("return ", delegate, "(", param.constantFieldName(), ", " + CodeGenUtils.AS_RECORD + "(");
        int numParams = paramNames.size();
        for (int i = 0; i < numParams; ++i) {
            if (i != 0) {
                ilb.append(", ");
            }
            ilb.append("\"").append((CharSequence)paramNames.get(i)).append("\", ").append(((JavaType)type.getJavaTypeMap().get(paramNames.get(i))).asInlineCast((String)javaParamNames.get(i)));
        }
        ilb.appendLineEnd("));");
        ilb.decreaseIndent();
        ilb.appendLine("}");
    }

    private static void writeFutureSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, FutureJavaType javaType) {
        ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(ilb, "Future compatible version of {@link #" + param.setterName() + "(" + GenInvocationBuildersVisitor.stripGenerics(javaType.getType().toJavaTypeString()) + ")}.", false, true);
        ilb.appendLine("@com.google.errorprone.annotations.CanIgnoreReturnValue");
        ilb.appendLine("public Builder " + param.futureSetterName() + "(" + javaType.toJavaTypeString() + " future) {");
        ilb.increaseIndent();
        ilb.appendLine("return " + CodeGenUtils.SET_PARAM_INTERNAL + "(" + param.constantFieldName() + ", " + javaType.asInlineCast("future") + ");");
        ilb.decreaseIndent();
        ilb.appendLine("}");
    }

    private static String stripGenerics(String type) {
        String newType = type;
        while (!(newType = (type = newType).replaceAll("<[^>]*>", "")).equals(type)) {
        }
        return newType;
    }

    private void logWarningIfFilenamesNotUnique(ImmutableList<GeneratedFile> files) {
        ImmutableList duplicateFilenames = (ImmutableList)files.stream().collect(Collectors.groupingBy(GeneratedFile::fileName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        for (String fileName : duplicateFilenames) {
            this.errorReporter.warn(SourceLocation.UNKNOWN, FILE_NAME_COLLISION, fileName);
        }
    }

    private static String makeParamName(String s) {
        return JavaGenerationUtils.isReservedKeyword(s = JavaGenerationUtils.makeLowerCamelCase(s)) ? s + "_" : s;
    }
}

