/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class ConstantsCompiler {
    static final TemplateAnalysis ALL_RESOLVED = new TemplateAnalysis(){

        @Override
        public boolean isResolved(VarRefNode ref) {
            return true;
        }

        @Override
        public boolean isResolved(DataAccessNode ref) {
            throw new UnsupportedOperationException();
        }
    };
    private final ConstNode constant;
    private final SoyClassWriter writer;
    private final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    private final PartialFileSetMetadata fileSetMetadata;

    ConstantsCompiler(ConstNode constant, SoyClassWriter writer, JavaSourceFunctionCompiler javaSourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        this.constant = constant;
        this.writer = writer;
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
        this.fileSetMetadata = fileSetMetadata;
    }

    static SoyRuntimeType getConstantRuntimeType(SoyType type) {
        return SoyRuntimeType.getUnboxedType(type).orElseGet(() -> SoyRuntimeType.getBoxedType(type));
    }

    static Method getConstantMethod(String symbol, SoyType type) {
        return new Method(symbol, ConstantsCompiler.getConstantRuntimeType(type).runtimeType(), new Type[]{BytecodeUtils.RENDER_CONTEXT_TYPE});
    }

    public void compile() {
        String javaClassName = Names.javaClassNameFromSoyNamespace(this.constant.getNearestAncestor(SoyFileNode.class).getNamespace());
        Method method = ConstantsCompiler.getConstantMethod(this.constant.getVar().name(), this.constant.getVar().type());
        Type methodType = method.getReturnType();
        final Label start = new Label();
        final Label end = new Label();
        final TemplateVariableManager variableSet = new TemplateVariableManager(TypeInfo.createClass(javaClassName).type(), method, (ImmutableList<String>)ImmutableList.of((Object)"$renderContext"), start, end, true);
        Expression renderContext = variableSet.getVariable("$renderContext");
        RenderContextExpression renderContextExpr = new RenderContextExpression(renderContext);
        ConstantVariables variables = new ConstantVariables(variableSet, renderContextExpr);
        ExpressionCompiler.BasicExpressionCompiler expressionCompiler = ExpressionCompiler.createBasicCompiler(this.constant, ALL_RESOLVED, variables, variableSet, this.javaSourceFunctionCompiler, this.fileSetMetadata);
        SoyExpression buildConstValue = expressionCompiler.compile(this.constant.getExpr());
        Preconditions.checkArgument((boolean)BytecodeUtils.isDefinitelyAssignableFrom(buildConstValue.soyRuntimeType().runtimeType(), methodType));
        String constKey = javaClassName + "#" + this.constant.getVar().name();
        boolean constIsPrimitive = BytecodeUtils.isPrimitive(methodType);
        final TemplateVariableManager.Variable tmpVar = variableSet.enterScope().create("tmp", renderContextExpr.getConst(constKey), TemplateVariableManager.SaveStrategy.STORE);
        final Statement storeLocal = tmpVar.local().store(constIsPrimitive ? BytecodeUtils.boxJavaPrimitive(methodType, buildConstValue) : buildConstValue);
        final Statement storeConst = renderContextExpr.storeConst(constKey, tmpVar.accessor());
        final Expression returnValue = constIsPrimitive ? BytecodeUtils.unboxJavaPrimitive(methodType, tmpVar.accessor()) : tmpVar.accessor().checkedCast(method.getReturnType());
        new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                tmpVar.initializer().gen(adapter);
                tmpVar.accessor().gen(adapter);
                adapter.ifNonNull(end);
                storeLocal.gen(adapter);
                storeConst.gen(adapter);
                adapter.mark(end);
                returnValue.gen(adapter);
                adapter.returnValue();
                variableSet.generateTableEntries(adapter);
            }
        }.writeMethod(this.methodAccess(), method, this.writer);
    }

    private int methodAccess() {
        return (this.constant.isExported() ? 1 : 0) | 8;
    }

    static final class ConstantVariables
    implements TemplateParameterLookup {
        private final TemplateVariableManager variableSet;
        private final RenderContextExpression renderContext;

        ConstantVariables(TemplateVariableManager variableSet, RenderContextExpression renderContext) {
            this.renderContext = renderContext;
            this.variableSet = variableSet;
        }

        UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("This method isn't supported in constants compilation context");
        }

        @Override
        public Expression getParam(TemplateParam param) {
            throw this.unsupported();
        }

        @Override
        public Expression getParamsRecord() {
            throw this.unsupported();
        }

        @Override
        public Expression getIjRecord() {
            throw this.unsupported();
        }

        @Override
        public Expression getLocal(AbstractLocalVarDefn<?> local) {
            return this.variableSet.getVariable(local.name());
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            throw this.unsupported();
        }

        @Override
        public RenderContextExpression getRenderContext() {
            return this.renderContext;
        }

        @Override
        public JbcSrcPluginContext getPluginContext() {
            throw this.unsupported();
        }
    }
}

