/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import javax.annotation.Nullable;

final class JbcSrcJavaValue
implements JavaValue {
    private final Expression expr;
    @Nullable
    private final MethodSignature methodSignature;

    static JbcSrcJavaValue of(Expression expr) {
        return new JbcSrcJavaValue(expr, null);
    }

    static JbcSrcJavaValue of(Expression expr, MethodSignature methodSignature) {
        Preconditions.checkNotNull((Object)methodSignature);
        return new JbcSrcJavaValue(expr, methodSignature);
    }

    private JbcSrcJavaValue(Expression expr, MethodSignature methodSignature) {
        this.expr = (Expression)Preconditions.checkNotNull((Object)expr);
        this.methodSignature = methodSignature;
    }

    Expression expr() {
        return this.expr;
    }

    @Nullable
    MethodSignature methodInfo() {
        return this.methodSignature;
    }

    @Override
    public JbcSrcJavaValue isNonNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNonNull(this.expr));
    }

    @Override
    public JbcSrcJavaValue isNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNull(this.expr));
    }

    @Override
    public JbcSrcJavaValue asSoyBoolean() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyFloat() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyInt() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyString() {
        return this;
    }

    @Override
    public JbcSrcJavaValue coerceToSoyBoolean() {
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToBoolean(), this.methodSignature);
    }

    @Override
    public JbcSrcJavaValue coerceToSoyString() {
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToString(), this.methodSignature);
    }

    public String toString() {
        String methodStr = this.methodSignature == null ? "" : ", methodSignature= " + this.methodSignature;
        return "JbcSrcJavaValue[expr=" + this.expr + methodStr + "]";
    }
}

