/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_SaveRestoreState;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_VarKey;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.SaveStateMetaFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class TemplateVariableManager
implements LocalVariableManager {
    private final SimpleLocalVariableManager delegate;
    private final Map<VarKey, AbstractVariable> variablesByKey = new LinkedHashMap<VarKey, AbstractVariable>();
    private LocalVariable stackFrameVariable;
    private static final Handle BOOTSTRAP_SAVE_HANDLE = MethodRef.create(SaveStateMetaFactory.class, "bootstrapSaveState", MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE).asHandle();
    private static final Handle BOOTSTRAP_RESTORE_HANDLE = MethodRef.create(SaveStateMetaFactory.class, "bootstrapRestoreState", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, Integer.TYPE).asHandle();

    TemplateVariableManager(Type owner, Method method, ImmutableList<String> parameterNames, Label methodBegin, Label methodEnd, boolean isStatic) {
        this.delegate = new SimpleLocalVariableManager(owner, method, parameterNames, methodBegin, methodEnd, isStatic);
        this.delegate.allActiveVariables().entrySet().forEach(entry -> this.variablesByKey.put(VarKey.create((String)entry.getKey()), new TrivialVariable((Expression)entry.getValue())));
    }

    @Override
    public Scope enterScope() {
        final LocalVariableManager.Scope delegateScope = this.delegate.enterScope();
        return new Scope(){
            final List<VarKey> activeVariables = new ArrayList<VarKey>();

            @Override
            void createTrivial(String name, Expression expression) {
                this.putVariable(VarKey.create(name), new TrivialVariable(expression));
            }

            @Override
            Variable createSynthetic(SyntheticVarName varName, Expression initExpr, SaveStrategy strategy) {
                return this.doCreate("$" + varName.name(), initExpr, VarKey.create(varName), strategy);
            }

            @Override
            Variable create(String name, Expression initExpr, SaveStrategy strategy) {
                return this.doCreate(name, initExpr, VarKey.create(name), strategy);
            }

            @Override
            public LocalVariable createTemporary(String proposedName, Type type) {
                return delegateScope.createTemporary(proposedName, type);
            }

            @Override
            public LocalVariable createNamedLocal(String name, Type type) {
                LocalVariable var = delegateScope.createNamedLocal(name, type);
                this.putVariable(VarKey.create(name), new TrivialVariable(var));
                return var;
            }

            @Override
            public Statement exitScope() {
                for (VarKey key : this.activeVariables) {
                    AbstractVariable var = (AbstractVariable)TemplateVariableManager.this.variablesByKey.remove(key);
                    if (var != null) continue;
                    throw new IllegalStateException("no variable active for key: " + key);
                }
                return delegateScope.exitScope();
            }

            private Variable doCreate(String proposedName, Expression initExpr, VarKey key, SaveStrategy strategy) {
                Variable var = new Variable(initExpr, delegateScope.createTemporary(proposedName, initExpr.resultType()), strategy);
                this.putVariable(key, var);
                return var;
            }

            private void putVariable(VarKey key, AbstractVariable var) {
                AbstractVariable old = TemplateVariableManager.this.variablesByKey.put(key, var);
                if (old != null) {
                    throw new IllegalStateException("multiple variables active for key: " + key);
                }
                this.activeVariables.add(key);
            }
        };
    }

    @Override
    public void generateTableEntries(CodeBuilder ga) {
        this.delegate.generateTableEntries(ga);
    }

    @Override
    public Expression getVariable(String name) {
        return this.getVariable(VarKey.create(name));
    }

    Expression getVariable(SyntheticVarName name) {
        return this.getVariable(VarKey.create(name));
    }

    private Expression getVariable(VarKey varKey) {
        AbstractVariable var = this.variablesByKey.get(varKey);
        if (var != null) {
            return var.accessor();
        }
        throw new IllegalArgumentException("No variable: '" + varKey + "' is bound. " + this.variablesByKey.keySet() + " are in scope");
    }

    LocalVariable getStackFrameVar() {
        if (this.stackFrameVariable == null) {
            this.stackFrameVariable = this.delegate.unsafeBorrowSlot("$stackFrame", BytecodeUtils.STACK_FRAME_TYPE);
        }
        return this.stackFrameVariable;
    }

    void assertSaveRestoreStateIsEmpty() {
        Preconditions.checkState((boolean)this.variablesByKey.values().stream().noneMatch(v -> v instanceof Variable));
    }

    SaveRestoreState saveRestoreState(final RenderContextExpression renderContextExpression, final int stateNumber) {
        List restoresInOrder = (List)this.variablesByKey.values().stream().filter(v -> !(v instanceof TrivialVariable)).map(v -> (Variable)v).collect(ImmutableList.toImmutableList());
        final List storesToPerform = (List)restoresInOrder.stream().filter(v -> ((Variable)v).strategy == SaveStrategy.STORE).sorted(Comparator.comparing(v -> v.accessor().resultType().getSort())).collect(ImmutableList.toImmutableList());
        ArrayList<Type> methodTypeParams = new ArrayList<Type>();
        methodTypeParams.add(BytecodeUtils.RENDER_CONTEXT_TYPE);
        for (Variable variable : storesToPerform) {
            methodTypeParams.add(variable.accessor().resultType());
        }
        final Type methodType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])methodTypeParams.toArray(new Type[0]));
        Statement saveState = new Statement(){

            @Override
            protected void doGen(CodeBuilder cb) {
                renderContextExpression.gen(cb);
                for (Variable var : storesToPerform) {
                    var.accessor().gen(cb);
                }
                cb.visitInvokeDynamicInsn("save", methodType.getDescriptor(), BOOTSTRAP_SAVE_HANDLE, new Object[]{stateNumber});
            }
        };
        final ImmutableMap storeToSlotIndex = (ImmutableMap)IntStream.range(0, storesToPerform.size()).boxed().collect(ImmutableMap.toImmutableMap(storesToPerform::get, index -> index));
        final ImmutableList variablesToRestoreFromStorage = (ImmutableList)restoresInOrder.stream().filter(v -> ((Variable)v).strategy == SaveStrategy.STORE).collect(ImmutableList.toImmutableList());
        Optional<Statement> restoreFromFrame = variablesToRestoreFromStorage.isEmpty() ? Optional.empty() : Optional.of(new Statement(){

            @Override
            protected void doGen(CodeBuilder cb) {
                TemplateVariableManager.this.getStackFrameVar().gen(cb);
                for (int i = 0; i < variablesToRestoreFromStorage.size(); ++i) {
                    if (i < variablesToRestoreFromStorage.size() - 1) {
                        cb.dup();
                    }
                    Variable variableToRestore = (Variable)variablesToRestoreFromStorage.get(i);
                    Type varType = variableToRestore.accessor().resultType();
                    cb.visitInvokeDynamicInsn("restoreLocal", Type.getMethodType((Type)variableToRestore.accessor().resultType(), (Type[])new Type[]{BytecodeUtils.STACK_FRAME_TYPE}).getDescriptor(), BOOTSTRAP_RESTORE_HANDLE, new Object[]{methodType, storeToSlotIndex.get((Object)variableToRestore)});
                    cb.visitVarInsn(varType.getOpcode(54), variableToRestore.local.index());
                }
            }
        });
        List restoreDerivedVariables = (List)restoresInOrder.stream().filter(var -> ((Variable)var).strategy == SaveStrategy.DERIVED).map(v -> ((Variable)v).local.store(((Variable)v).initExpression)).collect(ImmutableList.toImmutableList());
        return new AutoValue_TemplateVariableManager_SaveRestoreState(saveState, !restoreFromFrame.isPresent() && restoreDerivedVariables.isEmpty() ? Optional.empty() : Optional.of(Statement.concat(restoreFromFrame.orElse(Statement.NULL_STATEMENT), Statement.concat(restoreDerivedVariables))));
    }

    @AutoValue
    static abstract class SaveRestoreState {
        SaveRestoreState() {
        }

        abstract Statement save();

        abstract Optional<Statement> restore();
    }

    static final class Variable
    extends AbstractVariable {
        private final Expression initExpression;
        private final LocalVariable local;
        private final SaveStrategy strategy;
        private final Statement initializer;

        private Variable(Expression initExpression, LocalVariable local, SaveStrategy strategy) {
            this.initExpression = initExpression;
            if (initExpression.isNonNullable()) {
                local = local.asNonNullable();
            }
            this.local = local;
            this.initializer = local.store(initExpression, local.start());
            this.strategy = strategy;
        }

        final Statement initializer() {
            return this.initializer;
        }

        @Override
        final Expression accessor() {
            return this.local();
        }

        final LocalVariable local() {
            return this.local;
        }
    }

    private static final class TrivialVariable
    extends AbstractVariable {
        final Expression accessor;

        TrivialVariable(Expression accessor) {
            this.accessor = accessor;
        }

        @Override
        Expression accessor() {
            return this.accessor;
        }
    }

    private static abstract class AbstractVariable {
        private AbstractVariable() {
        }

        abstract Expression accessor();
    }

    @AutoValue
    static abstract class VarKey {
        VarKey() {
        }

        static VarKey create(String proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.USER_DEFINED, proposedName);
        }

        static VarKey create(SyntheticVarName proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.SYNTHETIC, proposedName);
        }

        abstract Kind kind();

        abstract Object name();

        static enum Kind {
            USER_DEFINED,
            SYNTHETIC;

        }
    }

    static abstract class Scope
    implements LocalVariableManager.Scope {
        private Scope() {
        }

        abstract void createTrivial(String var1, Expression var2);

        abstract Variable createSynthetic(SyntheticVarName var1, Expression var2, SaveStrategy var3);

        abstract Variable create(String var1, Expression var2, SaveStrategy var3);
    }

    static enum SaveStrategy {
        DERIVED,
        STORE;

    }
}

