/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyRecords;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyValueUnconverter;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.LazyProtoToSoyValueList;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyLegacyObjectMapImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.DetachableContentProvider;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.SaveStateMetaFactory;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class JbcSrcRuntime {
    private static final Logger logger = Logger.getLogger(JbcSrcRuntime.class.getName());
    public static final SoyValueProvider NULL_PROVIDER = new NullProvider("NULL_PROVIDER");
    private static final SoyValueProvider MISSING_PARAMETER = new NullProvider("MISSING_PARAMETER");
    private static final LoggingAdvisingAppendable LOGGER = new AbstractLoggingAdvisingAppendable(){

        @Override
        public final boolean softLimitReached() {
            return false;
        }

        @Override
        protected final void doAppend(char c) throws IOException {
            System.out.append(c);
        }

        @Override
        protected final void doAppend(CharSequence csq, int start, int end) throws IOException {
            System.out.append(csq, start, end);
        }

        @Override
        protected final void doAppend(CharSequence csq) throws IOException {
            System.out.append(csq);
        }

        @Override
        protected final void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected final void doExitLoggableElement() {
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            String val = funCall.placeholderValue();
            for (Function directive : escapers) {
                val = (String)directive.apply((Object)val);
            }
            System.out.append(val);
        }

        @Override
        public void flushBuffers(int depth) {
            throw new AssertionError((Object)"should not be called");
        }
    };

    public static AssertionError unexpectedStateError(StackFrame frame) {
        return new AssertionError((Object)("Unexpected state requested: " + frame.stateNumber));
    }

    public static NoSuchMethodException noExternJavaImpl() {
        return new NoSuchMethodException("No Java implementation for extern.");
    }

    public static void debugger(String fileName, int lineNumber) {
        logger.log(Level.WARNING, String.format("Hit {debugger} statement at %s:%d. Put a breakpoint here to halt Soy rendering.", fileName, lineNumber), new Exception());
    }

    public static boolean stringEqualsAsNumber(String expr, double number) {
        if (expr == null) {
            return false;
        }
        try {
            return Double.parseDouble(expr) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static SoyValueProvider convertObjectToSoyValueProvider(Object o) {
        return SoyValueConverter.INSTANCE.convert(o);
    }

    public static SoyValueProvider convertFutureToSoyValueProvider(Future<?> future) {
        return SoyValueConverter.INSTANCE.convert(future);
    }

    public static SoyValue resolveSoyValueProvider(SoyValueProvider provider) {
        SoyValue value = provider.resolve();
        return JbcSrcRuntime.handleTofuNull(value);
    }

    public static SoyValueProvider soyValueProviderOrNull(SoyValueProvider provider) {
        if (JbcSrcRuntime.resolveSoyValueProvider(provider) == null) {
            return null;
        }
        return provider;
    }

    private static SoyValue handleTofuNull(SoyValue value) {
        if (value instanceof NullData | value instanceof UndefinedData) {
            return null;
        }
        return value;
    }

    public static SoyValue getField(SoyRecord record, String field) {
        Preconditions.checkNotNull((Object)record, (String)"Attempted to access field '%s' of null", (Object)field);
        return JbcSrcRuntime.handleTofuNull(record.getField(field));
    }

    public static boolean hasField(SoyRecord record, String field) {
        Preconditions.checkNotNull((Object)record, (String)"Attempted to access field '%s' of null", (Object)field);
        return record.hasField(field);
    }

    public static ParamStore setField(ParamStore store, String field, SoyValueProvider provider) {
        return store.setField(field, provider == null ? NullData.INSTANCE : provider);
    }

    public static SoyValueProvider getFieldProvider(SoyRecord record, String field, @Nullable SoyValue defaultValue) {
        Preconditions.checkNotNull((Object)record, (String)"Attempted to access field '%s' of null", (Object)field);
        return JbcSrcRuntime.paramOrDefault(record.getFieldProvider(field), defaultValue);
    }

    public static SoyValueProvider getFieldProvider(SoyRecord record, String field) {
        return JbcSrcRuntime.getFieldProvider(record, field, null);
    }

    public static SoyValueProvider param(SoyValueProvider provider) {
        return JbcSrcRuntime.paramOrDefault(provider, null);
    }

    public static SoyValueProvider paramOrDefault(SoyValueProvider provider, @Nullable SoyValue defaultValue) {
        if (provider == null) {
            if (defaultValue == null) {
                return MISSING_PARAMETER;
            }
            return defaultValue;
        }
        if (provider instanceof NullData) {
            return NULL_PROVIDER;
        }
        return provider;
    }

    public static boolean isParamSet(SoyValueProvider provider) {
        return provider != MISSING_PARAMETER;
    }

    public static SafeUrl unboxSafeUrl(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return ((SanitizedContent)soyValue).toSafeUrl();
    }

    public static SafeUrlProto unboxSafeUrlProto(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return SafeUrls.toProto((SafeUrl)((SanitizedContent)soyValue).toSafeUrl());
    }

    public static SafeHtml unboxSafeHtml(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return ((SanitizedContent)soyValue).toSafeHtml();
    }

    public static SafeHtmlProto unboxSafeHtmlProto(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return SafeHtmls.toProto((SafeHtml)((SanitizedContent)soyValue).toSafeHtml());
    }

    public static TrustedResourceUrl unboxTrustedResourceUrl(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return ((SanitizedContent)soyValue).toTrustedResourceUrl();
    }

    public static TrustedResourceUrlProto unboxTrustedResourceUrlProto(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return TrustedResourceUrls.toProto((TrustedResourceUrl)((SanitizedContent)soyValue).toTrustedResourceUrl());
    }

    public static SoyValue callLegacySoyFunction(LegacyFunctionAdapter fnAdapter, List<SoyValue> args) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return JbcSrcRuntime.handleTofuNull(fnAdapter.computeForJava(args));
    }

    public static SoyValue applyPrintDirective(SoyJavaPrintDirective directive, SoyValue value, List<SoyValue> args) {
        value = value == null ? NullData.INSTANCE : value;
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return directive.applyForJava(value, args);
    }

    public static int longToInt(long value) {
        Preconditions.checkState((value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Casting long to integer results in overflow: %s", (long)value);
        return (int)value;
    }

    public static ImmutableList<String> listUnboxStrings(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::coerceToString).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Long> listUnboxInts(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::longValue).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Double> listUnboxFloats(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::floatValue).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Double> listUnboxNumbers(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::numberValue).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Boolean> listUnboxBools(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::coerceToBoolean).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Message> listUnboxProtos(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(v -> ((SoyProtoValue)v).getProto()).collect(ImmutableList.toImmutableList());
    }

    public static <T extends ProtocolMessageEnum> ImmutableList<T> listUnboxEnums(List<SoyValue> values, Class<T> type) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(v -> (ProtocolMessageEnum)JbcSrcRuntime.getEnumValue(type, (int)v.longValue())).collect(ImmutableList.toImmutableList());
    }

    public static Integer toBoxedInteger(SoyValue value) {
        if (value == null) {
            return null;
        }
        return value.integerValue();
    }

    public static Long toBoxedLong(SoyValue value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public static Double toBoxedDouble(SoyValue value) {
        if (value == null) {
            return null;
        }
        return value.floatValue();
    }

    public static Float toBoxedFloat(SoyValue value) {
        if (value == null) {
            return null;
        }
        return Float.valueOf((float)value.floatValue());
    }

    public static Boolean toBoxedBoolean(SoyValue value) {
        if (value == null) {
            return null;
        }
        return value.coerceToBoolean();
    }

    public static <T> T toEnum(SoyValue value, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        return JbcSrcRuntime.getEnumValue(clazz, value.integerValue());
    }

    static <T> T getEnumValue(Class<T> clazz, int enumValue) {
        try {
            Method forNumber = clazz.getMethod("forNumber", Integer.TYPE);
            return clazz.cast(forNumber.invoke(null, enumValue));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImmutableMap<?, ?> unboxMap(SoyMap map, Class<?> keyType, Class<?> valueType) {
        if (map == null) {
            return null;
        }
        return (ImmutableMap)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> JbcSrcRuntime.unboxMapItem((SoyValue)e.getKey(), keyType), e -> JbcSrcRuntime.unboxMapItem(((SoyValueProvider)e.getValue()).resolve(), valueType)));
    }

    public static Object unboxMapItem(SoyValue value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == String.class) {
            return value.coerceToString();
        }
        if (type == Boolean.class) {
            return value.coerceToBoolean();
        }
        if (type == Double.class) {
            return value.floatValue();
        }
        if (Message.class.isAssignableFrom(type)) {
            return ((SoyProtoValue)value).getProto();
        }
        if (ProtocolMessageEnum.class.isAssignableFrom(type)) {
            return JbcSrcRuntime.getEnumValue(type, value.integerValue());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static ImmutableMap<?, ?> unboxRecord(SoyRecord map) {
        if (map == null) {
            return null;
        }
        return (ImmutableMap)map.recordAsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> SoyValueUnconverter.unconvert((SoyValueProvider)e.getValue())));
    }

    public static List<SoyValueProvider> listBoxValues(List<?> javaValues) {
        if (javaValues == null) {
            return null;
        }
        return javaValues.stream().map(SoyValueConverter.INSTANCE::convert).collect(Collectors.toList());
    }

    public static CompiledTemplate applyEscapers(CompiledTemplate delegate, ImmutableList<SoyJavaPrintDirective> directives) {
        Preconditions.checkState((!directives.isEmpty() ? 1 : 0) != 0);
        return new EscapedCompiledTemplate(delegate, (List<SoyJavaPrintDirective>)directives);
    }

    public static SoyValue getSoyListItem(List<SoyValueProvider> list, long index) {
        return JbcSrcRuntime.resolveSoyValueProvider(JbcSrcRuntime.getSoyListItemProvider(list, index));
    }

    public static SoyValueProvider getSoyListItemProvider(List<SoyValueProvider> list, long index) {
        if (list == null) {
            throw new NullPointerException("Attempted to access list item '" + index + "' of null");
        }
        int size = list.size();
        if (index < (long)size & index >= 0L) {
            SoyValueProvider soyValueProvider = list.get((int)index);
            return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
        }
        return NULL_PROVIDER;
    }

    public static RenderResult getListStatus(List<? extends SoyValueProvider> soyValueProviders) {
        int size = soyValueProviders.size();
        for (int i = 0; i < size; ++i) {
            RenderResult result = soyValueProviders.get(i).status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static RenderResult getMapStatus(Map<String, ? extends SoyValueProvider> soyValueProviders) {
        for (SoyValueProvider soyValueProvider : soyValueProviders.values()) {
            RenderResult result = soyValueProvider.status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static SoyValue getSoyMapItem(SoyMap soyMap, SoyValue key) {
        Preconditions.checkNotNull((Object)soyMap, (String)"Attempted to access map item '%s' of null", (Object)key);
        return soyMap.get(key);
    }

    public static SoyValueProvider getSoyMapItemProvider(SoyMap soyMap, SoyValue key) {
        SoyValueProvider soyValueProvider;
        Preconditions.checkNotNull((Object)soyMap, (String)"Attempted to access map item '%s' of null", (Object)key);
        if (key == null) {
            key = NullData.INSTANCE;
        }
        return (soyValueProvider = soyMap.getProvider(key)) == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static SoyValue getSoyLegacyObjectMapItem(SoyLegacyObjectMap legacyObjectMap, SoyValue key) {
        Preconditions.checkNotNull((Object)legacyObjectMap, (String)"Attempted to access map item '%s' of null", (Object)key);
        return legacyObjectMap.getItem(key);
    }

    public static SoyValueProvider getSoyLegacyObjectMapItemProvider(SoyLegacyObjectMap legacyObjectMap, SoyValue key) {
        if (legacyObjectMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        SoyValueProvider soyValueProvider = legacyObjectMap.getItemProvider(key);
        return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static String handleBasicTranslation(List<SoyMsgPart> parts) {
        return ((SoyMsgRawTextPart)parts.get(0)).getRawText();
    }

    public static String handleBasicTranslationAndEscapeHtml(List<SoyMsgPart> parts) {
        return MsgRenderer.escapeHtml(JbcSrcRuntime.handleBasicTranslation(parts));
    }

    public static boolean compareNullableString(@Nullable String string, @Nullable SoyValue other) {
        if (string == null && other == null) {
            return true;
        }
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return Objects.equals(string, other.toString());
        }
        if (other instanceof NumberData) {
            if (string == null) {
                return false;
            }
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    public static LoggingAdvisingAppendable logger() {
        return LOGGER;
    }

    public static int rangeLoopLength(int start, int end, int step) {
        int length = end - start;
        if ((length ^ step) < 0) {
            return 0;
        }
        return length / step + (length % step == 0 ? 0 : 1);
    }

    public static boolean coerceToBoolean(double v) {
        return v != 0.0 & !Double.isNaN(v);
    }

    public static boolean coerceToBoolean(@Nullable SoyValue v) {
        return v != null && v.coerceToBoolean();
    }

    public static boolean coerceToBoolean(@Nullable String v) {
        return v != null && !v.isEmpty();
    }

    public static String coerceToString(@Nullable SoyValue v) {
        return v == null ? "null" : v.coerceToString();
    }

    public static LogStatement createLogStatement(boolean logOnly, SoyVisualElementData veData) {
        return LogStatement.create(veData.ve().id(), veData.data(), logOnly);
    }

    public static SanitizedContent flushLogsAndRender(SoyValueProvider valueProvider, SoyLogger logger) throws IOException {
        StringBuilder output = new StringBuilder();
        OutputAppendable appendable = OutputAppendable.create(output, logger);
        valueProvider.renderAndResolve(appendable, false);
        Preconditions.checkState((appendable.getSanitizedContentKind() == SanitizedContent.ContentKind.HTML ? 1 : 0) != 0);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(output.toString(), SanitizedContent.ContentKind.HTML, appendable.getSanitizedContentDirectionality());
    }

    public static <T extends SoyValueProvider> List<T> checkResolved(List<T> providerList) {
        for (int i = 0; i < providerList.size(); ++i) {
            SoyValueProvider provider = (SoyValueProvider)providerList.get(i);
            if (provider instanceof SoyValue) continue;
            throw new IllegalStateException("item " + i + " was expected to be a SoyValue, instead it is: " + provider.getClass());
        }
        return providerList;
    }

    public static <K, V extends SoyValueProvider> Map<K, V> checkResolved(Map<K, V> providerMap) {
        for (Map.Entry<K, V> entry : providerMap.entrySet()) {
            SoyValueProvider provider = (SoyValueProvider)entry.getValue();
            if (provider instanceof SoyValue) continue;
            throw new IllegalStateException("item " + entry.getKey() + " was expected to be a SoyValue, instead it is: " + provider.getClass());
        }
        return providerMap;
    }

    public static SoyMap boxJavaMapAsSoyMap(Map<?, ?> javaMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)javaMap.size());
        for (Map.Entry<?, ?> entry : javaMap.entrySet()) {
            map.put(SoyValueConverter.INSTANCE.convert(entry.getKey()).resolve(), SoyValueConverter.INSTANCE.convert(entry.getValue()));
        }
        return SoyMapImpl.forProviderMap(map);
    }

    public static SoyRecord boxJavaMapAsSoyRecord(Map<String, ?> javaMap) {
        return new SoyRecordImpl(JbcSrcRuntime.javaMapAsProviderMap(javaMap));
    }

    public static SoyLegacyObjectMap boxJavaMapAsSoyLegacyObjectMap(Map<String, ?> javaMap) {
        return new SoyLegacyObjectMapImpl(JbcSrcRuntime.javaMapAsProviderMap(javaMap));
    }

    private static ImmutableMap<String, SoyValueProvider> javaMapAsProviderMap(Map<String, ?> javaMap) {
        return (ImmutableMap)javaMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> SoyValueConverter.INSTANCE.convert(e.getValue())));
    }

    public static <MessageT extends GeneratedMessage.ExtendableMessage<MessageT>, T> LazyProtoToSoyValueList<T> getExtensionList(MessageT message, ExtensionLite<MessageT, List<T>> extension, ProtoFieldInterpreter protoFieldInterpreter) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < message.getExtensionCount(extension); ++i) {
            list.add(message.getExtension(extension, i));
        }
        return LazyProtoToSoyValueList.forList(list.build(), protoFieldInterpreter);
    }

    public static CompiledTemplate.TemplateValue bindTemplateParams(CompiledTemplate.TemplateValue template, SoyRecord boundParams) {
        return CompiledTemplate.TemplateValue.create(template.getTemplateName(), new PartiallyBoundTemplate(boundParams, template.getTemplate()));
    }

    static void awaitProvider(SoyValueProvider provider) {
        while (true) {
            RenderResult result = provider.status();
            switch (result.type()) {
                case LIMITED: {
                    throw new AssertionError((Object)"SoyValueProvider.status() returned a RenderResult.limited() which is out of spec");
                }
                case DETACH: {
                    Future<?> future = result.future();
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "blocking to resolve a SoyValueProvider: " + future, new Exception());
                    }
                    try {
                        future.get();
                        break;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted while waiting on: " + future + " to complete", ie);
                    }
                    catch (CancellationException | ExecutionException exception) {
                        break;
                    }
                }
                case DONE: {
                    return;
                }
            }
        }
    }

    private JbcSrcRuntime() {
    }

    @Immutable
    private static final class PartiallyBoundTemplate
    implements CompiledTemplate {
        private final SoyRecord boundParams;
        private final CompiledTemplate delegate;

        PartiallyBoundTemplate(SoyRecord boundParams, CompiledTemplate delegate) {
            if (delegate instanceof PartiallyBoundTemplate) {
                PartiallyBoundTemplate partiallyBoundTemplate = (PartiallyBoundTemplate)delegate;
                boundParams = SoyRecords.merge(partiallyBoundTemplate.boundParams, boundParams);
                delegate = partiallyBoundTemplate.delegate;
            }
            this.delegate = delegate;
            this.boundParams = boundParams;
        }

        @Override
        public RenderResult render(SoyRecord params, SoyRecord ij, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            return this.delegate.render(SoyRecords.merge(this.boundParams, params), ij, appendable, context);
        }
    }

    @Immutable
    private static final class EscapedCompiledTemplate
    implements CompiledTemplate {
        private final CompiledTemplate delegate;
        private final ImmutableList<SoyJavaPrintDirective> directives;

        EscapedCompiledTemplate(CompiledTemplate delegate, List<SoyJavaPrintDirective> directives) {
            this.delegate = (CompiledTemplate)Preconditions.checkNotNull((Object)delegate);
            this.directives = ImmutableList.copyOf(directives);
        }

        @Override
        public RenderResult render(SoyRecord params, SoyRecord ij, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            LoggingAdvisingAppendable.BufferingAppendable buffer;
            StackFrame frame = context.popFrame();
            switch (frame.stateNumber) {
                case 0: {
                    buffer = LoggingAdvisingAppendable.buffering();
                    break;
                }
                case 1: {
                    try {
                        buffer = SaveRestoreState.restoreAppendableHandle.invokeExact(frame);
                        break;
                    }
                    catch (Throwable t) {
                        throw new AssertionError((Object)t);
                    }
                }
                default: {
                    throw JbcSrcRuntime.unexpectedStateError(frame);
                }
            }
            RenderResult result = this.delegate.render(params, ij, buffer, context);
            if (result.isDone()) {
                SoyValue resultData = buffer.getAsSoyValue();
                for (SoyJavaPrintDirective directive : this.directives) {
                    resultData = directive.applyForJava(resultData, (List<SoyValue>)ImmutableList.of());
                }
                appendable.append(resultData.coerceToString());
            } else {
                try {
                    SaveRestoreState.saveStateMethodHandle.invokeExact(context, buffer);
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)t);
                }
            }
            return result;
        }

        static class SaveRestoreState {
            static final MethodHandle saveStateMethodHandle;
            static final MethodHandle restoreAppendableHandle;

            SaveRestoreState() {
            }

            static {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType saveMethodType = MethodType.methodType(Void.TYPE, RenderContext.class, LoggingAdvisingAppendable.BufferingAppendable.class);
                saveStateMethodHandle = SaveStateMetaFactory.bootstrapSaveState(lookup, "saveState", saveMethodType, 1).getTarget();
                restoreAppendableHandle = SaveStateMetaFactory.bootstrapRestoreState(lookup, "restoreLocal", MethodType.methodType(LoggingAdvisingAppendable.BufferingAppendable.class, StackFrame.class), saveMethodType, 0).getTarget();
            }
        }
    }

    public static final class PlrSelMsgRenderer
    extends MsgRenderer {
        private boolean resolvedCases;
        private double remainder = -1.0;

        public PlrSelMsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders, boolean htmlEscape) {
            super(msgId, msgParts, locale, numPlaceholders, htmlEscape);
        }

        @Override
        public RenderResult doRender(LoggingAdvisingAppendable out) throws IOException {
            if (!this.resolvedCases) {
                ImmutableList<SoyMsgPart> parts = this.msgParts;
                RenderResult caseSelectionResult = RenderResult.done();
                while (!parts.isEmpty()) {
                    SoyMsgPluralPart pluralPart;
                    SoyValueProvider pluralPlaceholder;
                    SoyMsgPart first = (SoyMsgPart)parts.get(0);
                    if (first instanceof SoyMsgSelectPart) {
                        SoyMsgSelectPart selectPart = (SoyMsgSelectPart)first;
                        SoyValueProvider selectPlaceholder = (SoyValueProvider)this.placeholders.get(selectPart.getSelectVarName());
                        caseSelectionResult = selectPlaceholder.status();
                        if (!caseSelectionResult.isDone()) break;
                        parts = selectPart.lookupCase(JbcSrcRuntime.coerceToString(selectPlaceholder.resolve()));
                        continue;
                    }
                    if (!(first instanceof SoyMsgPluralPart) || !(caseSelectionResult = (pluralPlaceholder = (SoyValueProvider)this.placeholders.get((pluralPart = (SoyMsgPluralPart)first).getPluralVarName())).status()).isDone()) break;
                    double pluralValue = pluralPlaceholder.resolve().numberValue();
                    parts = pluralPart.lookupCase(pluralValue, this.locale);
                    this.remainder = pluralValue - (double)pluralPart.getOffset();
                }
                this.msgParts = parts;
                if (!caseSelectionResult.isDone()) {
                    return caseSelectionResult;
                }
                this.resolvedCases = true;
            }
            return super.doRender(out);
        }

        @Override
        double getPluralRemainder() {
            return this.remainder;
        }
    }

    public static class MsgRenderer
    extends DetachableContentProvider {
        ImmutableList<SoyMsgPart> msgParts;
        final ULocale locale;
        private int partIndex;
        private SoyValueProvider pendingRender;
        final Map<String, SoyValueProvider> placeholders;
        @Nullable
        Set<String> startPlaceholders;
        @Nullable
        Multiset<String> startPlaceholderRenderCount;
        @Nullable
        SetMultimap<String, String> endPlaceholderToStartPlaceholder;
        private final long msgId;
        private final boolean htmlEscape;

        public MsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders, boolean htmlEscape) {
            this.msgId = msgId;
            this.msgParts = msgParts;
            this.locale = locale;
            this.placeholders = Maps.newLinkedHashMapWithExpectedSize((int)numPlaceholders);
            this.htmlEscape = htmlEscape;
        }

        public MsgRenderer setPlaceholder(String placeholderName, SoyValueProvider placeholderValue) {
            SoyValueProvider prev = this.placeholders.put(placeholderName, placeholderValue);
            if (prev != null) {
                throw new IllegalArgumentException("found multiple placeholders: " + prev + " and " + placeholderValue + " for key " + placeholderName);
            }
            return this;
        }

        static String escapeHtml(String s) {
            return s.replace("<", "&lt;");
        }

        public MsgRenderer setPlaceholderAndOrdering(String placeholderName, SoyValueProvider placeholderValue, String endPlaceholder) {
            if (this.endPlaceholderToStartPlaceholder == null) {
                this.startPlaceholders = new HashSet<String>();
                this.endPlaceholderToStartPlaceholder = HashMultimap.create();
                this.startPlaceholderRenderCount = HashMultiset.create();
            }
            if (this.endPlaceholderToStartPlaceholder.containsKey((Object)placeholderName)) {
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order contraints should not be transitive.", placeholderName, this.endPlaceholderToStartPlaceholder.get((Object)placeholderName).iterator().next(), endPlaceholder));
            }
            if (this.startPlaceholders.contains(endPlaceholder)) {
                String beforePlaceholder = null;
                for (Map.Entry entry : this.endPlaceholderToStartPlaceholder.entries()) {
                    if (!endPlaceholder.equals(entry.getValue())) continue;
                    beforePlaceholder = (String)entry.getKey();
                    break;
                }
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order contraints should not be transitive.", endPlaceholder, placeholderName, beforePlaceholder));
            }
            this.setPlaceholder(placeholderName, placeholderValue);
            this.endPlaceholderToStartPlaceholder.put((Object)endPlaceholder, (Object)placeholderName);
            this.startPlaceholders.add(placeholderName);
            return this;
        }

        @Override
        public RenderResult doRender(LoggingAdvisingAppendable out) throws IOException {
            if (this.pendingRender != null) {
                RenderResult result = this.pendingRender.renderAndResolve(out, false);
                if (!result.isDone()) {
                    return result;
                }
                this.pendingRender = null;
            }
            for (int i = this.partIndex; i < this.msgParts.size(); ++i) {
                SoyMsgPart msgPart = (SoyMsgPart)this.msgParts.get(i);
                if (msgPart instanceof SoyMsgRawTextPart) {
                    String s = ((SoyMsgRawTextPart)msgPart).getRawText();
                    if (this.htmlEscape) {
                        s = MsgRenderer.escapeHtml(s);
                    }
                    out.append(s);
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    SoyValueProvider placeholderValue;
                    String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                    if (this.endPlaceholderToStartPlaceholder != null) {
                        if (this.startPlaceholders.contains(placeholderName)) {
                            this.startPlaceholderRenderCount.add((Object)placeholderName);
                        } else {
                            Set startPlaceholders = this.endPlaceholderToStartPlaceholder.get((Object)placeholderName);
                            if (!startPlaceholders.isEmpty()) {
                                boolean matched = false;
                                for (String startPlaceholder : startPlaceholders) {
                                    if (!this.startPlaceholderRenderCount.remove((Object)startPlaceholder)) continue;
                                    matched = true;
                                    break;
                                }
                                if (!matched) {
                                    throw new IllegalStateException(String.format("Expected placeholder '%s' to come after one of %s, in message %d", placeholderName, startPlaceholders, this.msgId));
                                }
                            }
                        }
                    }
                    if ((placeholderValue = this.placeholders.get(placeholderName)) == null) {
                        throw new IllegalStateException("No value provided for placeholder: '" + placeholderName + "', expected one of " + this.placeholders.keySet());
                    }
                    try {
                        RenderResult result = placeholderValue.renderAndResolve(out, false);
                        if (result.isDone()) continue;
                        this.partIndex = i + 1;
                        this.pendingRender = placeholderValue;
                        return result;
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException(placeholderName, e);
                    }
                }
                if (msgPart instanceof SoyMsgPluralRemainderPart) {
                    out.append(String.valueOf(this.getPluralRemainder()));
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + msgPart));
            }
            if (this.startPlaceholderRenderCount != null && !this.startPlaceholderRenderCount.isEmpty()) {
                throw new IllegalStateException(String.format("The following placeholders never had their matching placeholders rendered in message %d: %s", this.msgId, this.startPlaceholderRenderCount.elementSet()));
            }
            return RenderResult.done();
        }

        double getPluralRemainder() {
            throw new UnsupportedOperationException("this is not a plural message so remainder don't make sense");
        }
    }

    private static final class NullProvider
    implements SoyValueProvider {
        private final String nameForDebugging;

        NullProvider(String nameForDebugging) {
            this.nameForDebugging = nameForDebugging;
        }

        @Override
        public RenderResult status() {
            return RenderResult.done();
        }

        @Override
        public SoyValue resolve() {
            return null;
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
            appendable.append("null");
            return RenderResult.done();
        }

        public String toString() {
            return this.nameForDebugging;
        }
    }
}

