/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.io.IOException;

@Immutable
public interface CompiledTemplate {
    public RenderResult render(SoyRecord var1, SoyRecord var2, LoggingAdvisingAppendable var3, RenderContext var4) throws IOException;

    public static final class TemplateValue
    extends SoyAbstractValue {
        private final String templateName;
        private final CompiledTemplate delegate;

        public static TemplateValue create(String templateName, CompiledTemplate template) {
            return new TemplateValue(templateName, template);
        }

        private TemplateValue(String templateName, CompiledTemplate delegate) {
            this.templateName = templateName;
            this.delegate = delegate;
        }

        public CompiledTemplate getTemplate() {
            return this.delegate;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final boolean coerceToBoolean() {
            return true;
        }

        @Override
        public final String coerceToString() {
            return String.format("** FOR DEBUGGING ONLY: %s **", this.templateName);
        }

        @Override
        public final void render(LoggingAdvisingAppendable appendable) {
            throw new IllegalStateException("Printing template types is not allowed.");
        }

        @Override
        public final boolean equals(Object other) {
            return this == other;
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final String toString() {
            return this.coerceToString();
        }
    }
}

