/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Ternary;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import javax.annotation.Nullable;

public final class ConditionalExpressionBuilder {
    private final ImmutableList.Builder<IfThenPair<Expression>> conditions = ImmutableList.builder();
    private Expression trailingElse;

    ConditionalExpressionBuilder(Expression predicate, Expression consequent) {
        this.conditions.add(new IfThenPair<Expression>(predicate, consequent));
    }

    public ConditionalExpressionBuilder addElseIf(Expression predicate, Expression consequent) {
        this.conditions.add(new IfThenPair<Expression>(predicate, consequent));
        return this;
    }

    public ConditionalExpressionBuilder setElse(Expression trailingElse) {
        Preconditions.checkState((this.trailingElse == null ? 1 : 0) != 0);
        this.trailingElse = trailingElse;
        return this;
    }

    @Nullable
    private Expression tryCreateTernary(ImmutableList<IfThenPair<Expression>> pairs) {
        if (pairs.size() != 1 || this.trailingElse == null) {
            return null;
        }
        IfThenPair ifThen = (IfThenPair)Iterables.getOnlyElement(pairs);
        Expression predicate = ifThen.predicate;
        Expression consequent = (Expression)ifThen.consequent;
        if (predicate.initialStatements().containsAll(consequent.initialStatements()) && predicate.initialStatements().containsAll(this.trailingElse.initialStatements())) {
            return Ternary.create(predicate, consequent, this.trailingElse);
        }
        return null;
    }

    @CheckReturnValue
    public Expression build(CodeChunk.Generator codeGenerator) {
        ImmutableList pairs = this.conditions.build();
        Expression ternary = this.tryCreateTernary((ImmutableList<IfThenPair<Expression>>)pairs);
        if (ternary != null) {
            return ternary;
        }
        VariableDeclaration decl = codeGenerator.declarationBuilder().setMutable().build();
        Expression var = decl.ref();
        ConditionalBuilder builder = null;
        for (IfThenPair oldCondition : pairs) {
            Expression newConsequent = var.assign((Expression)oldCondition.consequent);
            if (builder == null) {
                builder = Statement.ifStatement(oldCondition.predicate, newConsequent.asStatement());
                continue;
            }
            builder.addElseIf(oldCondition.predicate, newConsequent.asStatement());
        }
        if (this.trailingElse != null) {
            builder.setElse(var.assign(this.trailingElse).asStatement());
        }
        return var.withInitialStatements((Iterable<? extends Statement>)ImmutableList.of((Object)decl, (Object)builder.build()));
    }
}

