/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_LeafStatement;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.function.Consumer;

@Immutable
@AutoValue
abstract class LeafStatement
extends Statement {
    LeafStatement() {
    }

    abstract String value();

    abstract ImmutableSet<GoogRequire> requires();

    static LeafStatement create(String value, Iterable<GoogRequire> requires) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        if (!(value.isEmpty() || value.endsWith("}") || value.endsWith(";"))) {
            value = value + ';';
        }
        return new AutoValue_LeafStatement(value, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        if (this.value().length() == 0) {
            return;
        }
        for (String line : Splitter.on((char)'\n').split((CharSequence)this.value())) {
            ctx.append(line).endLine();
        }
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
        for (GoogRequire require : this.requires()) {
            collector.accept(require);
        }
    }
}

