/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.jssrc.dsl.AutoValue_TemplateLiteral;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.function.Consumer;

@Immutable
@AutoValue
public abstract class TemplateLiteral
extends Expression {
    abstract ImmutableList<String> stringParts();

    abstract ImmutableList<Expression> interpolatedParts();

    public static TemplateLiteral create(ImmutableList<String> stringParts, ImmutableList<Expression> interpolatedParts) {
        int expectedNumInterps;
        int numStrings = stringParts.size();
        int numInterps = interpolatedParts.size();
        Preconditions.checkArgument((numInterps == (expectedNumInterps = stringParts.size() - 1) ? 1 : 0) != 0, (Object)String.format("Template literal has %d string parts, so %d interpolated parts were expected, but there are %d interpolated parts.", numStrings, expectedNumInterps, numInterps));
        ImmutableList initialStatements = (ImmutableList)interpolatedParts.stream().flatMap(part -> part.initialStatements().stream()).collect(ImmutableList.toImmutableList());
        return new AutoValue_TemplateLiteral((ImmutableList<Statement>)initialStatements, stringParts, interpolatedParts);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (Expression part : this.interpolatedParts()) {
            ctx.appendInitialStatements(part);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('`');
        for (int i = 0; i < this.stringParts().size(); ++i) {
            ctx.append(TemplateLiteral.escapeStringPart((String)this.stringParts().get(i)));
            if (i >= this.stringParts().size() - 1) continue;
            ctx.append("${");
            ((Expression)this.interpolatedParts().get(i)).doFormatOutputExpr(ctx);
            ctx.append("}");
        }
        ctx.append('`');
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    private static String escapeStringPart(String literal) {
        String escaped = BaseUtils.escapeToSoyString(literal, true, QuoteStyle.BACKTICK);
        return escaped.replace("</script", "<\\/script");
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
        for (Expression part : this.interpolatedParts()) {
            part.collectRequires(collector);
        }
    }
}

