/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_DerivedNameAndContext;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_InferencesAndContext;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.RawTextContextUpdater;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.TemplateType;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

final class InferenceEngine {
    private final Inferences inferences;
    private final ErrorReporter errorReporter;

    public static Context inferTemplateEndContext(SoyNode soyNode, Context startContext, Inferences inferences, ErrorReporter errorReporter) {
        InferenceEngine inferenceEngine = new InferenceEngine(inferences, errorReporter);
        return inferenceEngine.infer(soyNode, startContext);
    }

    private static void checkBlockEndContext(SoyNode.RenderUnitNode node, Context endContext) {
        if (!endContext.isValidEndContextForContentKind(node.getContentKind())) {
            String msg = String.format("A block of kind=\"%s\" cannot end in context %s. Likely cause is %s.", node.getContentKind().asAttributeValue(), endContext, endContext.getLikelyEndContextMismatchCause(node.getContentKind()));
            throw SoyAutoescapeException.createWithNode(msg, node);
        }
    }

    static void inferStrictRenderUnitNode(SoyNode.RenderUnitNode node, Inferences inferences, ErrorReporter errorReporter) {
        InferenceEngine inferenceEngine = new InferenceEngine(inferences, errorReporter);
        Context endContext = inferenceEngine.inferChildren(node, Context.getStartContextForContentKind(node.getContentKind()));
        InferenceEngine.checkBlockEndContext(node, endContext);
    }

    private InferenceEngine(Inferences inferences, ErrorReporter errorReporter) {
        this.inferences = inferences;
        this.errorReporter = errorReporter;
    }

    private Context infer(SoyNode node, Context context) {
        return new ContextPropagatingVisitor(context).exec(node);
    }

    private Context inferChildren(SoyNode node, Context context) {
        ContextPropagatingVisitor contextPropagatingVisitor = new ContextPropagatingVisitor(context);
        return contextPropagatingVisitor.execChildren(node);
    }

    @AutoValue
    static abstract class InferencesAndContext {
        InferencesAndContext() {
        }

        static InferencesAndContext create(Inferences inferences, Context context) {
            return new AutoValue_InferenceEngine_InferencesAndContext(inferences, context);
        }

        abstract Inferences inferences();

        abstract Context context();
    }

    @AutoValue
    static abstract class DerivedNameAndContext {
        DerivedNameAndContext() {
        }

        static DerivedNameAndContext create(String derivedName, Context context) {
            return new AutoValue_InferenceEngine_DerivedNameAndContext(derivedName, context);
        }

        abstract String derivedName();

        abstract Context context();
    }

    private final class ContextPropagatingVisitor
    extends AbstractSoyNodeVisitor<Context> {
        private Context context;
        private RawTextNode uriStart = null;

        public ContextPropagatingVisitor(Context context) {
            this.context = context;
        }

        @Override
        public Context exec(SoyNode node) {
            this.visit(node);
            return this.context;
        }

        public Context execChildren(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return this.context;
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            Preconditions.checkState((boolean)this.context.isValidStartContextForContentKind(templateNode.getContentKind()), (Object)"Templates may only be visited in the context for their declared content kind.");
            this.context = Context.getStartContextForContentKind(templateNode.getContentKind());
            this.visitChildren(templateNode);
            InferenceEngine.checkBlockEndContext(templateNode, this.context);
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
            this.context = RawTextContextUpdater.processRawText(rawTextNode, this.context);
            if (this.context.uriPart() == Context.UriPart.TRUSTED_RESOURCE_URI_END) {
                this.uriStart = rawTextNode;
            }
            rawTextNode.setHtmlContext(this.context.state());
        }

        @Override
        protected void visitMsgNode(MsgNode node) {
            node.setEscapingMode(this.context.state().getEscapingMode());
            super.visitMsgNode(node);
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.checkUriEnd();
            node.setHtmlContext(this.context.state());
            Optional<Context.MsgEscapingStrategy> maybeStrategy = this.context.getMsgEscapingStrategy(node);
            if (!maybeStrategy.isPresent()) {
                throw SoyAutoescapeException.createWithNode("Messages are not supported in this context, because it would mean asking translators to write source code; if this is desired, try factoring the message into a {let} block: " + this.context, node);
            }
            if (this.context.delimType() == Context.AttributeEndDelimiter.SPACE_OR_TAG_END) {
                throw SoyAutoescapeException.createWithNode("Messages are not supported in this context because a space in the translation would end the attribute value. Wrap the attribute value into quotes.", node);
            }
            Context.MsgEscapingStrategy strategy = maybeStrategy.get();
            InferenceEngine.this.inferences.setEscapingDirectives(node, this.context, (List<EscapingMode>)strategy.escapingModesForFullMessage);
            Context msgEndContext = new InferenceEngine(InferenceEngine.this.inferences, InferenceEngine.this.errorReporter).inferChildren(node, strategy.childContext);
            if (!msgEndContext.equals(strategy.childContext)) {
                throw SoyAutoescapeException.createWithNode("Message text should not alter the escaping context. " + this.context + " != " + strategy.childContext, node);
            }
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            this.checkUriEnd();
            this.checkHtmlHtmlAttributePosition(callNode);
            callNode.setHtmlContext(this.context.state());
            this.context = this.inferCallSite(callNode, this.context, InferenceEngine.this.inferences);
            this.visitChildren(callNode);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            this.inferInStrictMode(node);
        }

        @Override
        protected void visitIfNode(IfNode ifNode) {
            ifNode.setHtmlContext(this.context.state());
            this.propagateAcrossDisjunction(ifNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode switchNode) {
            this.propagateAcrossDisjunction(switchNode);
        }

        @Override
        protected void visitForNode(ForNode forNode) {
            Context ifemptyContext;
            Optional<Context> combined;
            ForIfemptyNode ieNode;
            List foreachChildren = forNode.getChildren();
            ForNonemptyNode neNode = (ForNonemptyNode)foreachChildren.get(0);
            if (foreachChildren.size() == 2) {
                ieNode = (ForIfemptyNode)foreachChildren.get(1);
            } else if (foreachChildren.size() == 1) {
                ieNode = null;
            } else {
                throw new AssertionError();
            }
            Context afterBody = this.context;
            if (neNode != null) {
                afterBody = InferenceEngine.this.infer(neNode, this.context);
                Context elseContext = InferenceEngine.this.infer(neNode, afterBody);
                combined = Context.union(elseContext, afterBody);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode("{" + forNode.getCommandName() + "} body does not end in the same context after repeated entries.", forNode);
                }
                afterBody = combined.get();
            }
            if (!(combined = Context.union(ifemptyContext = ieNode != null ? InferenceEngine.this.infer(ieNode, this.context) : this.context, afterBody)).isPresent()) {
                throw SoyAutoescapeException.createWithNode("{" + forNode.getCommandName() + "} body " + (ieNode == null ? "changes context." : "does not end in the same context as {ifempty}."), ieNode == null ? forNode : ieNode);
            }
            this.context = combined.get();
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            printNode.setHtmlContext(this.context.state());
            this.checkUriEnd();
            this.checkHtmlHtmlAttributePosition(printNode);
            ImmutableList<EscapingMode> escapingModes = InferenceEngine.this.inferences.getEscapingMode(printNode);
            Context prev = this.context;
            if (escapingModes.isEmpty()) {
                ImmutableList<EscapingMode> escapingModesToSet = null;
                escapingModesToSet = this.context.getEscapingModes(printNode, printNode.getChildren());
                escapingModes = escapingModesToSet;
                InferenceEngine.this.inferences.setEscapingDirectives(printNode, prev, (List<EscapingMode>)escapingModesToSet);
            } else if (!this.context.isCompatibleWith((EscapingMode)((Object)escapingModes.get(0)))) {
                String msg = String.format("Escaping modes %s not compatible with %s.", escapingModes, this.context);
                throw SoyAutoescapeException.createWithNode(msg, printNode);
            }
            this.context = this.context.getContextAfterDynamicValue();
        }

        private void checkUriEnd() {
            if (this.context.uriPart() == Context.UriPart.TRUSTED_RESOURCE_URI_END) {
                throw SoyAutoescapeException.createWithNode("TrustedResourceUris containing dynamic content must have a fixed scheme (https) and host using one of the following formats:\n  * https://foo/\n  * //foo/\n  * /foo\nor move the calculation of this URL outside of the template and use an ordaining API.", this.uriStart);
            }
        }

        private void checkHtmlHtmlAttributePosition(SoyNode node) {
            if (this.context.htmlHtmlAttributePosition() == Context.HtmlHtmlAttributePosition.NOT_START) {
                throw SoyAutoescapeException.createWithNode("HTML attribute values containing HTML can use dynamic expressions only at the start of the value.", node);
            }
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            if (!node.getTagName().isWildCard()) {
                this.visitHtmlTagNode(node);
            }
        }

        @Override
        protected void visitHtmlCommentNode(HtmlCommentNode node) {
            this.context = this.context.transitionToState(HtmlContext.HTML_COMMENT);
            this.visitChildren(node);
            this.context = this.context.transitionToState(HtmlContext.HTML_PCDATA);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            Context oldContext = this.context;
            boolean isSelfClosing = tag instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tag).isSelfClosing();
            this.context = this.context.transitionToState(tag.getKind() == SoyNode.Kind.HTML_OPEN_TAG_NODE && !isSelfClosing ? HtmlContext.HTML_BEFORE_OPEN_TAG_NAME : HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME);
            if (tag.getTagName().isStatic() || tag.getTagName().isTemplateCall()) {
                this.context = this.context.transitionToTagName(tag);
                if (tag.getTagName().isStatic()) {
                    ((RawTextNode)tag.getChild(0)).setHtmlContext(HtmlContext.HTML_TAG_NAME);
                } else {
                    tag.getTagName().getDynamicTagName().setHtmlContext(HtmlContext.HTML_TAG_NAME);
                }
            } else {
                this.visit((SoyNode)tag.getChild(0));
            }
            Preconditions.checkArgument((this.context.elType() != Context.ElementType.NONE ? 1 : 0) != 0);
            this.context = this.context.transitionToTagAttributes();
            for (int i = 1; i < tag.numChildren(); ++i) {
                this.visit((SoyNode)tag.getChild(i));
            }
            this.context = isSelfClosing ? oldContext : this.context.transitionToAfterTag();
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            Node first = node.getChild(0);
            if (first.getKind() == SoyNode.Kind.RAW_TEXT_NODE) {
                this.context = this.context.transitionToAttrName(((RawTextNode)first).getRawText());
                ((RawTextNode)first).setHtmlContext(HtmlContext.HTML_ATTRIBUTE_NAME);
            } else {
                this.visit((SoyNode)first);
            }
            if (node.hasValue()) {
                this.visit((SoyNode)node.getChild(1));
            }
            this.context = this.context.transitionToTagAttributes();
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            Context.AttributeEndDelimiter delim;
            switch (node.getQuotes()) {
                case DOUBLE: {
                    delim = Context.AttributeEndDelimiter.DOUBLE_QUOTE;
                    break;
                }
                case NONE: {
                    delim = Context.AttributeEndDelimiter.SPACE_OR_TAG_END;
                    break;
                }
                case SINGLE: {
                    delim = Context.AttributeEndDelimiter.SINGLE_QUOTE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.context = this.context.transitionToAttrValue(delim);
            this.visitChildren(node);
            this.context = this.context.transitionToTagAttributes();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private SanitizedContentKind getCommonContentKindIfStrict(List<TemplateType> templates) {
            if (templates.isEmpty()) {
                return null;
            }
            TemplateContentKind contentKind = templates.get(0).getContentKind();
            for (TemplateType template : templates) {
                Preconditions.checkArgument((boolean)template.getContentKind().equals(contentKind));
            }
            return contentKind.getSanitizedContentKind();
        }

        private Context inferCallSite(CallNode callNode, Context startContext, Inferences inferences) {
            ImmutableList<TemplateType> targets = inferences.lookupTemplates(callNode);
            SanitizedContentKind calleeStrictContentKind = this.getCommonContentKindIfStrict((List<TemplateType>)targets);
            if (calleeStrictContentKind != null && startContext.isValidStartContextForContentKind(calleeStrictContentKind)) {
                return startContext.getContextAfterDynamicValue();
            }
            inferences.setEscapingDirectives(callNode, startContext, (List<EscapingMode>)startContext.getEscapingModes(callNode, (List<PrintDirectiveNode>)ImmutableList.of()));
            return startContext.getContextAfterDynamicValue();
        }

        private void propagateAcrossDisjunction(SoyNode.ParentSoyNode<?> node) {
            Iterator childIt = node.getChildren().iterator();
            SoyNode firstBranch = (SoyNode)childIt.next();
            Context out = InferenceEngine.this.infer(firstBranch, this.context);
            boolean sawElseOrDefault = false;
            while (childIt.hasNext()) {
                SoyNode branch = (SoyNode)childIt.next();
                Context brOut = InferenceEngine.this.infer(branch, this.context);
                Optional<Context> combined = Context.union(out, brOut);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode((node instanceof IfNode ? "{if} command branch ends in a different context than preceding branches:" : "{switch} command case ends in a different context than preceding cases:") + " " + branch.toSourceString(), branch);
                }
                out = combined.get();
                if (!(branch instanceof IfElseNode) && !(branch instanceof SwitchDefaultNode)) continue;
                sawElseOrDefault = true;
            }
            if (!sawElseOrDefault) {
                Optional<Context> combined = Context.union(this.context, out);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode(node instanceof IfNode ? "{if} command without {else} changes context." : "{switch} command without {default} changes context.", node);
                }
                out = combined.get();
            }
            this.context = out;
        }

        private void inferInStrictMode(SoyNode.RenderUnitNode node) {
            InferenceEngine.inferStrictRenderUnitNode(node, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter);
        }
    }
}

