/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RuntimeTypeCoercion;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@RunAfter(value={FinalizeTemplateRegistryPass.class})
public final class CheckTemplateCallsPass
implements CompilerFileSetPass {
    static final SoyErrorKind ARGUMENT_TYPE_MISMATCH = SoyErrorKind.of("Type mismatch on param {0}: expected: {1}, actual: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind EXPECTED_NAMED_PARAMETERS = SoyErrorKind.of("Expected named parameters.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_DEFAULT_DELTEMPLATE = SoyErrorKind.of("No default deltemplate found for {0}. Please add a default deltemplate, even if it is empty. NOTE: This check can be bypassed with 'allowemptydefault=\"true\"', but that feature is deprecated and will be removed soon.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_IMPORT_DEFAULT_DELTEMPLATE = SoyErrorKind.of("Delcall without without import to file containing default deltemplate ''{0}''. Add: import * as unused{1} from ''{2}'';\nNOTE: This check can be bypassed with 'allowemptydefault=\"true\"', but that feature is deprecated and will be removed soon.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALLOW_EMPTY_DEFAULT_ERROR = SoyErrorKind.of("Allowemptydefault=\"true\" is deprecated. Please remove it and add a default deltemplate and ensure the file that provides it is imported. NOTE: Some files are temporarily passlisted while the LSC to remove all usages are in progress.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALLOW_EMPTY_DEFAULT_WARNING = SoyErrorKind.deprecation("Allowemptydefault=\"true\" is deprecated. Please remove it and add a default deltemplate and ensure the file that provides it is imported. NOTE: This file is temporarily passlisted while the LSC to remove all usages are in progress.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_USEVARIANTTYPE = SoyErrorKind.of("Cannot specify \"variant\" unless the callee specifies \"usevarianttype\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VARIANT_TYPE = SoyErrorKind.of("Expected variant of type {0}, found type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_HTML = SoyErrorKind.of("Found call to non stricthtml template. Strict HTML template can only call other strict HTML templates from an HTML context.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CAN_ONLY_CALL_TEMPLATE_TYPES = SoyErrorKind.of("'{'call'}' is only valid on template types, but found type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_CALL_MIXED_CONTENT_TYPE = SoyErrorKind.of("Cannot call expressions of different content types; found {0} and {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_DATA_EXPR = SoyErrorKind.of("''data='' should be a record type, found ''{0}''.", SoyErrorKind.StyleAllowance.NO_CAPS);
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> templateRegistryFull;
    private static final ImmutableSet<String> DEFAULT_DELTEMPLATE_PASSLIST = ImmutableSet.of((Object)"boq.ads.townsquare.marketplaceui.components.carousel.templates.item", (Object)"boq.ads.townsquare.marketplaceui.components.grid.templates.item", (Object)"boq.ads.townsquare.marketplaceui.components.grid.templates.itemKey", (Object)"boq.dashersecurityadminconsoleui.reauth.common.templates.learnMoreLink_", (Object)"boq.dynamitewebui.member.templates.isOneOnOneDm", (Object)"boq.dynamitewebui.member.templates.readSingleUserFromDmHumanMembersList", (Object[])new String[]{"boq.googlefinanceui.views.bundles.portfolio.templates.portfolioLayoutRedesign", "boq.privacy.one.privacypage.product.components.privacypagepresentation.tabs.dependentlibraries.ps_dependencies_insights_info.templates.columns", "boq.protoshop.viewer.templates.topLevelMessage", "boq.saveui.listitem.templates.cardHeader", "boq.shopping.property.ui.components.carousel.templates.item", "boq.shopping.property.ui.components.componentregistry.classes.templates.type", "boq.shopping.property.ui.components.componentregistry.ghost.templates.type", "boq.shopping.property.ui.components.componentregistry.templates.type", "boq.shopping.property.ui.components.grid.templates.item", "boq.shopping.property.ui.components.grid.templates.itemKey", "boq.shopping.property.ui.components.grid.templates.renderPopoutTooltipArrow", "boq.taskswebshared.ssl.ui.app_view.templates.bundleView", "boq.townsquare.frontend.ui.components.carousel.templates.item", "boq.townsquare.frontend.ui.components.grid.templates.item", "boq.townsquare.frontend.ui.components.grid.templates.itemKey", "boq.townsquare.frontend.ui.components.grid.templates.renderPopoutTooltipArrow", "boq.travel.frontend.core.map.web.layers.hotels.summarycards.content_enable_links_to_embedded_placesheet.templates.relativePath", "boq.travelfrontendhotelssearchweb.component.bookingmodule.hotels.show_organic_prices.templates.bookingModuleHeader", "boq.travelfrontendhotelssearchweb.home.header.enable_expand_when_reach_bottom.templates.enableExpandWhenScrollToBottom", "boq.travelfrontendhotelssearchweb.home.header.enable_expand_when_scroll_up.templates.enableExpandWhenScrollUp", "boq.visualfrontendui.explorepanel.templates.closeButton", "boq.visualfrontendviewer.imagecard.templates.ampViewerTray", "boq.visualfrontendviewer.imagecard.templates.navigationButtons", "boq.visualfrontendui.explorepanel.templates.header", "Corp.Projectmgmt.Primavera.App.Workflow.Template.Core", "drive.search.filetypeicons.delSvg.templates", "gcal.mat.detaildialog.event.soy.detaildialog.rsvpButton", "gcal.mat.detaildialog.event.soy.detaildialog.rsvpButtonClasses", "gitiles.footerFormatBadge", "gitiles.logEntry", "materialdesign.wiz.icon.svgs.delSvg.templates", "renderComponentWithUiReference", "wiztest.pkg.deltemplates.passthroughTemplate", "boq.educms.fields.dispatcher.templates.enumfield", "boq.educms.fields.dispatcher.templates.groupfield", "boq.educms.fields.dispatcher.templates.nodefield", "boq.educms.fields.dispatcher.templates.repeatedenumfield", "boq.educms.fields.dispatcher.templates.repeatedgroupfield", "boq.educms.fields.dispatcher.templates.repeatednodefield", "boq.educms.fields.dispatcher.templates.repeatedstringfield", "boq.educms.fields.dispatcher.templates.stringfield", "boq.educms.renderer.templates.component", "boq.educms.renderer.templates.componentlist", "boq.educmseditor.fields.templates.editor", "boq.educmseditor.fields.templates.preview", "boq.ads.townsquare.marketplaceui.components.componentregistry.templates.ghost", "boq.ads.townsquare.marketplaceui.components.componentregistry.templates.type"});
    private static final ImmutableSet<String> ALLOWEMPTYDEFAULT_PASSLIST = ImmutableSet.of((Object)"delegateForUnitTest", (Object)"boq.accountsettingsnotifications.securityevent.templates.eventDetails", (Object)"boq.accountssigninui.discovery.identifier.internal.templates.contentText", (Object)"boq.accountssigninui.discovery.identifier.internal.templates.emailLabel", (Object)"boq.accountssigninui.discovery.identifier.internal.templates.enterpriseEnrollmentLabel", (Object)"boq.accountssigninui.discovery.identifier.internal.templates.extraJsaction", (Object[])new String[]{"boq.accountssigninui.discovery.identifier.internal.templates.guestModeLabel", "boq.accountssigninui.discovery.identifier.internal.templates.headerText", "boq.accountssigninui.discovery.identifier.internal.templates.keyboardOptionsLabel", "boq.accountssigninui.discovery.identifier.internal.templates.prefilledIdentifier", "boq.accountssigninui.discovery.identifier.internal.templates.secondaryActionLabel", "boq.accountssigninui.discovery.identifier.internal.templates.supplementaryActionUri", "boq.accounts.wireframe.api.nameinput.templates.isDense", "boq.adshomeservicesconsumerui.components.searchboxentrymodule.templates.searchboxEntryModule", "boq.adsintegrityopsuisupport.chrome.navigation.appbar.templates.user_photo", "boq.ads.townsquare.marketplaceui.components.componentregistry.classes.templates.type", "boq.androidgantryui.common.local.templates.localBanner", "boq.audiopub.show.templates.podcastsLink", "boq.audiopub.show.templates.subscribers", "boq.cloudbillingipxui.editdeal.templates.flexCudConfigurationHeader", "boq.cloudbillingipxui.editdeal.templates.flexCudConfigurationStep", "boq.cloudbillingipxui.editdeal.templates.useFlexCudConfigurationOffset", "boq.dasheradminconsolefrontendshell.chrome.navtree.persistcollpasedmode.templates.persistCollapsedModeEnabled", "boq.dasheradminconsolefrontendshell.landing.leftnav.globalparamsmod.templates.globalParamsForCollapsed", "boq.dasheradminconsoleui.appshealth.grid.templates.uptimeGrid", "boq.dinerfrontendui.scraper.templates.reviewsResultGroupScraperAttributes", "boq.dinerfrontendui.scraper.templates.webResultScraperAttributes", "boq.dotssplash.storypanel.templates.isGm3AlphaEnabled", "boq.drivesharedialog.dialogs.aclfixer.templates.dontShareText", "boq.drivesharedialog.dialogs.aclfixer.templates.helpLink", "boq.drivesharedialog.dialogs.aclfixer.templates.linkVisibilityText", "boq.drivesharedialog.dialogs.aclfixer.templates.popoverText", "boq.geomerchantprestoadslandingsharedv2.common.url.templates.buildUrlImpl", "boq.geo.ugc.maps.roads.about.start.templates.findOutMore", "boq.geo.ugc.maps.roads.about.start.templates.mapping", "boq.geo.ugc.maps.roads.challenges.templates.showInDevelopmentMissions", "boq.gmfe.embeddedui.editprofile.products.templates.pointyBanner", "boq.gmfe.posts.posts.templates.postCreationCardFooter", "boq.gmfe.verify.common.steps.common.templates.SetupContentItemClass", "boq.googlefinanceui.views.bundles.bundle.ads.templates.imageAd", "boq.googlefinanceui.views.bundles.portfolio.templates.plaidErrorBanner", "boq.googlefinanceui.views.bundles.watchlist.templates.renderFollowButton", "boq.googlefinanceui.views.bundles.watchlist.templates.renderUnfollowButton", "boq.hiringapplicationmanagementui.application.applicationdetails.templates.jobCode", "boq.hiringapplicationmanagementui.application.applicationdetails.templates.screenerJobDetails", "boq.hiringapplicationmanagementui.application.applicationdetails.templates.tenure", "boq.hiringcportalfrontendui.applymain.templates.skillsSections", "boq.infocardui.sharedtemplates.igaupsell.templates.upsell", "boq.lensweb.card.common.failureinfo.templates.autoFailureImageSource", "boq.lensweb.card.exploregrid.templates.eagerLoadCellImage", "boq.localplacesheetmodules.photogallery.templates.verificationBanner", "boq.meetingscommon.call.companion.companionscreen.templates.dasherUserLink", "boq.meetingscommon.call.companion.companionscreen.templates.eduUserLink", "boq.meetingscommon.pip.call.controls.mutebutton.templates.a11yAttributes", "boq.meetingscommon.pip.call.controls.mutebutton.templates.deviceMute", "boq.meetingscommon.pip.call.controls.mutebutton.templates.homeCameraAvailable", "boq.meetingscommon.ui.settings.templates.displayButton", "boq.meetingscommon.ui.settings.templates.displayPanel", "boq.momateamsgraphexplorerui.home.sidepanel.enableAaap.templates.navItem", "boq.onereviewertoolui.detailedview.common.templates.starToggle", "boq.onereviewertoolui.detailedview.launchoverview.templates.crossPwgButtons", "boq.onereviewertoolui.revieweritemstable.row.templates.starCell", "boq.onereviewertoolui.revieweritemstable.templates.StarHeader", "boq.plusappmenu.modadmincustomstream.templates.customStreamMenuContainer", "boq.plusappmenu.modbookmarkposts.templates.bookmarksMenu", "boq.plusappmenu.modgooglematerialfont.templates.joinIconClass", "boq.plusappmenu.modstreamliner.templates.managementToolsMenu", "boq.plusappmenu.modstreamliner.templates.managementToolsMenuLink", "boq.plusapp.view.templates.scollableClasses", "boq.podcastsui.root.templates.showUnsupportedBrowserToast", "boq.podcastsui.settings.aadc.templates.aadcToggle", "boq.podcastsui.settings.personalization.templates.personalizationToggle", "boq.profilepicturepicker.ui.body.templates.darkMode", "boq.rtcsupportmqtcommon.ogb.templates.helpLink", "boq.rtcsupportmqtcommon.ogb.templates.shortn", "boq.saveshared.internalweb.common.templates.darkThemeParam", "boq.scriptzui.deobfuscator.profile.templates.render", "boq.search.boq.chrome.searchboxweb.desktop.clientadapter.templates.outsideFormOverlays", "boq.searchconsole.navigation.templates.httpsDrilldownImpl", "boq.searchconsole.navigation.templates.httpsSummaryImpl", "boq.searchconsole.navigation.templates.robots", "boq.searchconsole.navigation.templates.sc4kEntityLookupHistoryImpl", "boq.searchconsole.navigation.templates.sc4kEntityLookupItemDrilldownImpl", "boq.searchconsole.navigation.templates.sc4kEntityLookupSummaryImpl", "boq.searchconsole.navigation.templates.useTheForceLinkImpl", "boq.searchconsole.navigation.templates.videoIndexingDrilldownImpl", "boq.searchconsole.navigation.templates.videoIndexingSummaryImpl", "boq.searchconsole.verification.templates.dnsCname", "boq.shopping.property.ui.components.componentregistry.classes.templates.type", "boq.squaresmembers.activity.modgooglematerialcommunity.templates.titleControlColor", "boq.squaresmembers.memberslist.modgooglematerialstream.templates.footerClass", "boq.streamactionbar.actionbuttons.modbookmarkposts.templates.bookmarkButton", "boq.surveysui.confirmationview.templates.feedback", "boq.surveysui.mysurveys.templates.responseCountCellMod", "boq.surveysui.surveycreator.templates.addImageButton", "boq.taskswebshared.ssl.ui.starred_view.templates.additionalActions", "boq.taskswebshared.ssl.ui.starred_view.templates.bundleModel", "boq.taskswebshared.ssl.ui.starred_view.templates.drop_zone", "boq.taskswebshared.ssl.ui.starred_view.templates.enablePrinting", "boq.taskswebshared.ssl.ui.task_list_switcher.templates.createNewListIcon", "boq.taskswebshared.ssl.ui.task_list_switcher.templates.ItemWithIconClass", "boq.travel.frontend.ui.body.templates.forPullingInBaseGss", "boq.unifieddevicesui.home.templates.chromeFishFoodLink", "boq.unifieddevicesui.home.templates.chromeTrustedTesterLink", "boq.visualfrontendviewer.imagecard.templates.sizing", "boq.voyagerfrontendui.customsurveys.templates.enablebulkimport", "boq.voyagerfrontendui.custom.templates.chooseLanguage", "boq.voyagerfrontendui.surveycreator.templates.imageranking", "boq.voyagerfrontendui.surveycreator.templates.imageslider", "boq.voyagerfrontendui.targetaudiencecreatorenableeducationlevelfilter.templates.educationLevelFilter", "boq.voyagerfrontendui.targetaudiencecreator.targetingfilters.audienceCategory.templates.affinityAudienceCategoryList", "del2.implByInactiveDelPkg", "delegateBoo", "drive.upload.soy.cellomaillink.contents", "drive.upload.soy.debugscottylink.contents", "drive.upload.soy.debugscottylink.scottyDashURIDelegate", "gcal.mat.bubble.create.soy.createbubble.reminderMigrationActions", "gcal.mat.bubble.edit.reminder.soy.bubble.infobanner", "gcal.mat.ui.attendeelist.soy.attendeelist.attendeeLocationIcon", "gcal.mat.ui.attendeelist.soy.attendeelist.workingLocation", "gcal.mat.ui.attendeelist.soy.attendeelist.workingLocationEverywhereActions", "gcal.mat.ui.attendeelist.soy.attendeelist.workingLocationEverywhereActionsAction", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.columnHeaders", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.jsaction", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.multipleWorkingHoursDetails", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.userLocation", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.workingHoursToggleLabelDescription", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.workingLocation", "gcal.mat.views.generalsettings.workinghourscard.soy.workinghourscard.workingLocationToggle", "ic.soy.url.isIdentityColorSchemeDark", "lifescience.csp.frontend.common.debugurls.templates.account", "lifescience.csp.frontend.common.debugurls.templates.adminaccounts", "lso.extraMeta", "lso.pageBody", "lso.pageHead", "lso.pageTitle", "nova.images.templates.bordeaux.flip35gWireframe", "nova.images.templates.ellen.landingLazyPricingIllo", "nova.images.templates.partner_retail_setup.bestBuyLogo", "roads.suspended.templates.alert", "soyfmt.deltemp"});

    CheckTemplateCallsPass(ErrorReporter errorReporter, Supplier<FileSetMetadata> templateRegistryFull) {
        this.errorReporter = errorReporter;
        this.templateRegistryFull = templateRegistryFull;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        CheckCallsHelper helper = new CheckCallsHelper(this.templateRegistryFull.get());
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallBasicNode.class)) {
                    helper.checkCall(template, (CallBasicNode)callNode);
                }
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    helper.checkCall(file, template, (CallDelegateNode)callNode, file.getFilePath().path());
                }
                for (PrintNode printNode : SoyTreeUtils.getAllNodesOfType(template, PrintNode.class)) {
                    if (!(printNode.getExpr().getRoot() instanceof FunctionNode) || !((FunctionNode)printNode.getExpr().getRoot()).allowedToInvokeAsFunction() && !(printNode.getExpr().getRoot().getType() instanceof SanitizedType.ElementType)) continue;
                    helper.checkFnCall(template, printNode, (FunctionNode)printNode.getExpr().getRoot());
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private static final class TemplateParamTypes {
        final Multimap<String, SoyType> params = HashMultimap.create();
        final Set<String> indirectParamNames = new HashSet<String>();

        private TemplateParamTypes() {
        }

        boolean isIndirect(String paramName) {
            return this.indirectParamNames.contains(paramName);
        }
    }

    private final class CheckCallsHelper {
        private final FileSetMetadata fileSetMetadata;
        private final Map<TemplateType, TemplateParamTypes> paramTypesMap = new HashMap<TemplateType, TemplateParamTypes>();

        CheckCallsHelper(FileSetMetadata registry) {
            this.fileSetMetadata = registry;
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node) {
            SoyType calleeType = node.getCalleeExpr().getType();
            if (calleeType.getKind() == SoyType.Kind.TEMPLATE) {
                this.checkCall(callerTemplate, node, (TemplateType)calleeType);
            } else if (calleeType.getKind() == SoyType.Kind.UNION) {
                TemplateContentKind templateContentKind = null;
                for (SoyType member : ((UnionType)calleeType).getMembers()) {
                    if (member.getKind() == SoyType.Kind.TEMPLATE) {
                        TemplateType templateType = (TemplateType)member;
                        if (templateContentKind == null) {
                            templateContentKind = templateType.getContentKind();
                        } else if (!templateType.getContentKind().equals(templateContentKind)) {
                            CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CANNOT_CALL_MIXED_CONTENT_TYPE, templateContentKind, templateType.getContentKind());
                        }
                        this.checkCall(callerTemplate, node, templateType);
                        continue;
                    }
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
                    GlobalNode.replaceExprWithError(node.getCalleeExpr().getChild(0));
                }
            } else if (calleeType.getKind() != SoyType.Kind.UNKNOWN) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
                GlobalNode.replaceExprWithError(node.getCalleeExpr().getChild(0));
            }
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node, TemplateType calleeType) {
            this.checkCallParamNames(node, calleeType);
            this.checkPassesUnusedParams(node, calleeType);
            this.checkStrictHtml(callerTemplate, node, calleeType);
            this.checkCallParamTypes(callerTemplate, node, calleeType);
            this.checkVariant(node, calleeType);
        }

        void checkCall(SoyFileNode file, TemplateNode callerTemplate, CallDelegateNode node, String callerFilename) {
            ImmutableList potentialCallees = this.fileSetMetadata.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName());
            for (TemplateMetadata delTemplate2 : potentialCallees) {
                TemplateType delTemplateType = delTemplate2.getTemplateType();
                this.checkCallParamTypes(callerTemplate, node, delTemplateType);
                this.checkCallParamNames(node, delTemplateType);
            }
            if (this.shouldEnforceDefaultDeltemplate(node.getDelCalleeName()) && !node.allowEmptyDefault()) {
                ImmutableList defaultImpl = (ImmutableList)potentialCallees.stream().filter(delTemplate -> delTemplate.getDelPackageName() == null && Strings.isNullOrEmpty((String)delTemplate.getDelTemplateVariant())).collect(ImmutableList.toImmutableList());
                if (defaultImpl.isEmpty()) {
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_DEFAULT_DELTEMPLATE, node.getDelCalleeName());
                } else {
                    SourceFilePath defaultLocation = ((TemplateMetadata)defaultImpl.get(0)).getSourceLocation().getFilePath();
                    if (!defaultLocation.equals(file.getSourceLocation().getFilePath()) && SoyTreeUtils.getAllNodesOfType(file, ImportNode.class).stream().noneMatch(imp -> imp.getSourceFilePath().equals(defaultLocation))) {
                        CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_IMPORT_DEFAULT_DELTEMPLATE, node.getDelCalleeName(), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, defaultLocation.fileName().replaceAll(".soy$", "")), defaultLocation.path());
                    }
                }
            }
            if (node.allowEmptyDefault()) {
                if (this.isPasslistedForAllowEmptyDefault(node.getDelCalleeName(), callerFilename)) {
                    CheckTemplateCallsPass.this.errorReporter.warn(node.getSourceLocation(), ALLOW_EMPTY_DEFAULT_WARNING, new Object[0]);
                } else {
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), ALLOW_EMPTY_DEFAULT_ERROR, new Object[0]);
                }
            }
            if (!potentialCallees.isEmpty()) {
                this.checkStrictHtml(callerTemplate, node, ((TemplateMetadata)potentialCallees.get(0)).getTemplateType());
            }
        }

        boolean isPasslistedForAllowEmptyDefault(String delCalleeName, String callerFilename) {
            return ALLOWEMPTYDEFAULT_PASSLIST.contains((Object)delCalleeName) || delCalleeName.startsWith("boq.dpanelchromeui.") || callerFilename.contains("/java_src/soy/integrationtest");
        }

        boolean shouldEnforceDefaultDeltemplate(String delCalleeName) {
            return !DEFAULT_DELTEMPLATE_PASSLIST.contains((Object)delCalleeName);
        }

        void checkFnCall(TemplateNode callerTemplate, PrintNode printNode, FunctionNode fnNode) {
            TemplateType type = fnNode.getNameExpr().getType() instanceof TemplateImportType ? ((TemplateImportType)fnNode.getNameExpr().getType()).getBasicTemplateType() : (TemplateType)fnNode.getNameExpr().getType();
            if (fnNode.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
                CheckTemplateCallsPass.this.errorReporter.report(fnNode.getSourceLocation(), EXPECTED_NAMED_PARAMETERS, new Object[0]);
                return;
            }
            this.checkCallParamNames(fnNode, type);
            this.checkPassesUnusedParams(fnNode, type);
            this.checkStrictHtml(callerTemplate, printNode, type);
            this.checkCallParamTypes(fnNode, type);
        }

        private void checkCallParamTypes(TemplateNode callerTemplate, CallNode call, TemplateType callee) {
            Collection declaredParamTypes;
            String paramName;
            TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
            HashSet<String> explicitParams = new HashSet<String>();
            for (Object callerParam : call.getChildren()) {
                SoyType argType;
                paramName = ((CallParamNode)callerParam).getKey().identifier();
                declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_VALUE_NODE) {
                    CallParamValueNode node = (CallParamValueNode)callerParam;
                    argType = RuntimeTypeCoercion.maybeCoerceType(node.getExpr().getRoot(), declaredParamTypes);
                } else if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_CONTENT_NODE) {
                    Object contentKind = ((CallParamContentNode)callerParam).getContentKind();
                    argType = contentKind == null ? StringType.getInstance() : SanitizedType.getTypeForContentKind(contentKind);
                } else {
                    throw new AssertionError();
                }
                for (SoyType formalType : declaredParamTypes) {
                    this.checkArgumentAgainstParamType(((AbstractSoyNode)callerParam).getSourceLocation(), paramName, argType, formalType, calleeParamTypes);
                }
                explicitParams.add(paramName);
            }
            if (call.isPassingData()) {
                if (call.isPassingAllData()) {
                    for (Object callerParam : callerTemplate.getParams()) {
                        paramName = ((AbstractVarDefn)callerParam).name();
                        if (explicitParams.contains(paramName)) continue;
                        declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                        for (SoyType formalType : declaredParamTypes) {
                            this.checkArgumentAgainstParamType(call.getSourceLocation(), paramName, ((AbstractVarDefn)callerParam).type(), formalType, calleeParamTypes);
                        }
                    }
                } else {
                    ExprRootNode dataExpr = call.getDataExpr();
                    if (!SoyTypes.isKindOrUnionOfKind(dataExpr.getType(), SoyType.Kind.RECORD) && dataExpr.getType().getKind() != SoyType.Kind.UNKNOWN && dataExpr.getType().getKind() != SoyType.Kind.ANY) {
                        CheckTemplateCallsPass.this.errorReporter.report(dataExpr.getSourceLocation(), INVALID_DATA_EXPR, dataExpr.getType());
                    }
                }
            }
        }

        private void checkCallParamTypes(FunctionNode call, TemplateType callee) {
            TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
            for (int i = 0; i < call.getParamNames().size(); ++i) {
                Identifier callerParam = call.getParamName(i);
                String paramName = callerParam.identifier();
                Collection declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                SoyType argType = RuntimeTypeCoercion.maybeCoerceType(call.getParams().get(i), declaredParamTypes);
                for (SoyType formalType : declaredParamTypes) {
                    this.checkArgumentAgainstParamType(callerParam.location(), paramName, argType, formalType, calleeParamTypes);
                }
            }
        }

        private void checkArgumentAgainstParamType(SourceLocation location, String paramName, SoyType argType, SoyType formalType, TemplateParamTypes calleeParams) {
            if (!formalType.isAssignableFromLoose(argType)) {
                if (calleeParams.isIndirect(paramName) && formalType.isAssignableFromLoose(SoyTypes.tryRemoveNull(argType))) {
                    return;
                }
                CheckTemplateCallsPass.this.errorReporter.report(location, ARGUMENT_TYPE_MISMATCH, paramName, formalType, argType);
            }
        }

        private TemplateParamTypes getTemplateParamTypes(TemplateType callee) {
            return this.paramTypesMap.computeIfAbsent(callee, this::computeTemplateParamTypes);
        }

        private TemplateParamTypes computeTemplateParamTypes(TemplateType callee) {
            TemplateParamTypes paramTypes = new TemplateParamTypes();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramTypes.params.put((Object)param.getName(), (Object)param.getType());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(callee);
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramTypes.params.containsKey((Object)indirectParamName)) continue;
                paramTypes.params.putAll((Object)indirectParamName, (Iterable)ipi.indirectParamTypes.get((Object)indirectParamName));
                paramTypes.indirectParamNames.add(indirectParamName);
            }
            return paramTypes;
        }

        private void checkStrictHtml(TemplateNode callerTemplate, CallNode caller, TemplateType callee) {
            if (callerTemplate.isStrictHtml() && caller.getIsPcData() && callee.getContentKind().getSanitizedContentKind().isHtml() && !callee.isStrictHtml()) {
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), STRICT_HTML, new Object[0]);
            }
        }

        private void checkStrictHtml(TemplateNode callerTemplate, PrintNode caller, TemplateType callee) {
            if (callerTemplate.isStrictHtml() && callee.getContentKind().getSanitizedContentKind().isHtml() && !callee.isStrictHtml()) {
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), STRICT_HTML, new Object[0]);
            }
        }

        private void checkCallParamNames(CallNode caller, TemplateType callee) {
            HashSet callerParamKeys = Sets.newHashSet();
            for (CallParamNode callerParam : caller.getChildren()) {
                boolean isUnique = callerParamKeys.add(callerParam.getKey().identifier());
                if (isUnique) continue;
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), DUPLICATE_PARAM, callerParam.getKey().identifier());
            }
            if (!caller.isPassingData()) {
                ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
                for (TemplateType.Parameter calleeParam : callee.getParameters()) {
                    if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.getName())) continue;
                    missingParamKeys.add(calleeParam.getName());
                }
                if (!missingParamKeys.isEmpty()) {
                    String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + missingParamKeys;
                    CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
                }
            }
        }

        private void checkCallParamNames(FunctionNode caller, TemplateType callee) {
            HashSet callerParamKeys = Sets.newHashSet();
            for (int i = 0; i < caller.getParams().size(); ++i) {
                boolean isUnique = callerParamKeys.add(((Identifier)caller.getParamNames().get(i)).identifier());
                if (isUnique) continue;
                CheckTemplateCallsPass.this.errorReporter.report(((Identifier)caller.getParamNames().get(i)).location(), DUPLICATE_PARAM, ((Identifier)caller.getParamNames().get(i)).identifier());
            }
            ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
            for (TemplateType.Parameter calleeParam : callee.getParameters()) {
                if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.getName())) continue;
                missingParamKeys.add(calleeParam.getName());
            }
            if (!missingParamKeys.isEmpty()) {
                String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + missingParamKeys;
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
            }
        }

        private void checkPassesUnusedParams(CallNode caller, TemplateType callee) {
            if (caller.numChildren() == 0) {
                return;
            }
            HashSet paramNames = Sets.newHashSet();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramNames.add(param.getName());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = null;
            for (CallParamNode callerParam : caller.getChildren()) {
                String paramName = callerParam.getKey().identifier();
                if (paramNames.contains(paramName)) continue;
                if (ipi == null) {
                    ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(callee);
                    if (ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) {
                        return;
                    }
                }
                if (ipi.indirectParams.containsKey((Object)paramName)) continue;
                ImmutableSet allParams = ImmutableSet.builder().addAll((Iterable)paramNames).addAll((Iterable)ipi.indirectParams.keySet()).build();
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), PASSES_UNUSED_PARAM, paramName, callee.getIdentifierForDebugging(), SoyErrors.getDidYouMeanMessage((Iterable<String>)allParams, paramName));
            }
        }

        private void checkPassesUnusedParams(FunctionNode caller, TemplateType callee) {
            if (caller.numChildren() == 0) {
                return;
            }
            HashSet paramNames = Sets.newHashSet();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramNames.add(param.getName());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = null;
            for (Identifier callerParam : caller.getParamNames()) {
                String paramName = callerParam.identifier();
                if (paramNames.contains(paramName)) continue;
                if (ipi == null) {
                    ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(callee);
                    if (ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) {
                        return;
                    }
                }
                if (ipi.indirectParams.containsKey((Object)paramName)) continue;
                ImmutableSet allParams = ImmutableSet.builder().addAll((Iterable)paramNames).addAll((Iterable)ipi.indirectParams.keySet()).build();
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.location(), PASSES_UNUSED_PARAM, paramName, callee.getIdentifierForDebugging(), SoyErrors.getDidYouMeanMessage((Iterable<String>)allParams, paramName));
            }
        }

        private void checkVariant(CallBasicNode node, TemplateType calleeType) {
            if (node.getVariantExpr() == null) {
                return;
            }
            if (calleeType.getUseVariantType().equals(NullType.getInstance())) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_USEVARIANTTYPE, new Object[0]);
            } else if (!calleeType.getUseVariantType().isAssignableFromStrict(node.getVariantExpr().getType())) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getVariantExpr().getSourceLocation(), BAD_VARIANT_TYPE, calleeType.getUseVariantType(), node.getVariantExpr().getType());
            }
        }
    }
}

