/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.AddDebugAttributesPass;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.BanDuplicateNamespacesPass;
import com.google.template.soy.passes.BasicHtmlValidationPass;
import com.google.template.soy.passes.CalculateMsgSubstitutionInfoPass;
import com.google.template.soy.passes.CallAnnotationPass;
import com.google.template.soy.passes.CheckAllFunctionsResolvedPass;
import com.google.template.soy.passes.CheckBadContextualUsagePass;
import com.google.template.soy.passes.CheckDeclaredTypesPass;
import com.google.template.soy.passes.CheckDelegatesPass;
import com.google.template.soy.passes.CheckEscapingSanityFilePass;
import com.google.template.soy.passes.CheckGeneratedSourcesPass;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CheckIndirectDepsPass;
import com.google.template.soy.passes.CheckModifiableTemplatesPass;
import com.google.template.soy.passes.CheckNonEmptyMsgNodesPass;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.CheckTemplateVisibilityPass;
import com.google.template.soy.passes.CheckValidVarrefsPass;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.CompilerPass;
import com.google.template.soy.passes.ContentSecurityPolicyNonceInjectionPass;
import com.google.template.soy.passes.DesugarGroupNodesPass;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.passes.DesugarStateNodesPass;
import com.google.template.soy.passes.ElementAttributePass;
import com.google.template.soy.passes.ElementCheckCrossTemplatePass;
import com.google.template.soy.passes.EnforceExperimentalFeaturesPass;
import com.google.template.soy.passes.FileDependencyOrderPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.IncrementalDomKeysPass;
import com.google.template.soy.passes.InsertMsgPlaceholderNodesPass;
import com.google.template.soy.passes.KeyCommandPass;
import com.google.template.soy.passes.ModernFeatureInvariantsEnforcementPass;
import com.google.template.soy.passes.MsgWithIdFunctionPass;
import com.google.template.soy.passes.NullSafeAccessPass;
import com.google.template.soy.passes.OptimizationPass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.ProtoImportProcessor;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveExpressionTypesCrossTemplatePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.ResolveTemplateFunctionsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.ResolveUseVariantTypePass;
import com.google.template.soy.passes.RestoreCompilerChecksPass;
import com.google.template.soy.passes.RestoreGlobalsPass;
import com.google.template.soy.passes.RewriteDirectivesCallableAsFunctionsPass;
import com.google.template.soy.passes.RewriteGenderMsgsPass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RewriteRemaindersPass;
import com.google.template.soy.passes.ShortFormCallPass;
import com.google.template.soy.passes.SimplifyAssertNonNullPass;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.passes.SoyElementCompositionPass;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.passes.TemplateCallMetadataPass;
import com.google.template.soy.passes.TemplateImportProcessor;
import com.google.template.soy.passes.UnknownJsGlobalPass;
import com.google.template.soy.passes.ValidateAliasesPass;
import com.google.template.soy.passes.ValidateExternsPass;
import com.google.template.soy.passes.ValidateVariantExpressionsPass;
import com.google.template.soy.passes.VeLogRewritePass;
import com.google.template.soy.passes.VeLogValidationPass;
import com.google.template.soy.passes.VeRewritePass;
import com.google.template.soy.passes.XidPass;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class PassManager {
    @VisibleForTesting
    final ImmutableList<CompilerFilePass> parsePasses;
    @VisibleForTesting
    final ImmutableList<CompilerFileSetPass> passes;
    private final AccumulatedState accumulatedState;

    private PassManager(ImmutableList<CompilerFilePass> parsePasses, ImmutableList<CompilerFileSetPass> passes, AccumulatedState accumulatedState) {
        this.parsePasses = parsePasses;
        this.passes = passes;
        this.accumulatedState = accumulatedState;
        this.checkOrdering();
    }

    public void runParsePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.parsePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    public CompilerFileSetPass.Result runPasses(SoyFileSetNode soyTree, FileSetMetadata partialFileSetMetadataWithJustDeps) {
        this.accumulatedState.fileSetMetadataFromDeps = partialFileSetMetadataWithJustDeps;
        ImmutableList sourceFiles = ImmutableList.copyOf(soyTree.getChildren());
        IdGenerator idGenerator = soyTree.getNodeIdGenerator();
        for (CompilerFileSetPass pass : this.passes) {
            ImmutableList sourceFilesThisPass = sourceFiles;
            if (pass instanceof CompilerFileSetPass.TopologicallyOrdered) {
                sourceFilesThisPass = this.accumulatedState.topologicallyOrderedFiles;
            }
            if (pass.run((ImmutableList<SoyFileNode>)sourceFilesThisPass, idGenerator) != CompilerFileSetPass.Result.STOP) continue;
            return CompilerFileSetPass.Result.STOP;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    @Nullable
    public FileSetMetadata getFinalTemplateRegistry() {
        return this.accumulatedState.fileSetMetadataFull;
    }

    private void checkOrdering() {
        LinkedHashSet<Class<? extends CompilerPass>> executed = new LinkedHashSet<Class<? extends CompilerPass>>();
        for (CompilerPass pass : Iterables.concat(this.parsePasses, this.passes)) {
            PassManager.prepareToRun(executed, pass);
        }
    }

    private static void prepareToRun(Set<Class<? extends CompilerPass>> executed, CompilerPass pass) {
        ImmutableList<Class<? extends CompilerPass>> shouldHaveAlreadyRun = pass.runAfter();
        if (!executed.containsAll((Collection<?>)shouldHaveAlreadyRun)) {
            throw new IllegalStateException("Attempted to executed pass " + pass.name() + " but its dependencies (" + shouldHaveAlreadyRun.stream().filter(dep -> !executed.contains(dep)).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ") haven't run yet.\n Passes executed so far: " + executed.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        ImmutableList<Class<? extends CompilerPass>> shouldNotHaveAlreadyRun = pass.runBefore();
        Sets.SetView ranButShouldntHave = Sets.intersection(new HashSet<Class<? extends CompilerPass>>((Collection<Class<? extends CompilerPass>>)shouldNotHaveAlreadyRun), executed);
        if (!ranButShouldntHave.isEmpty()) {
            throw new IllegalStateException("Attempted to execute pass " + pass.name() + " but it should always run before (" + ranButShouldntHave.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + ").\n Passes executed so far: " + executed.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        executed.add(pass.getClass());
    }

    private static ImmutableList<CompilerFilePass> createParsePasses(ErrorReporter reporter) {
        return ImmutableList.of((Object)new DesugarGroupNodesPass(), (Object)new BasicHtmlValidationPass(reporter), (Object)new InsertMsgPlaceholderNodesPass(reporter));
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private PluginResolver pluginResolver;
        private ImmutableList<? extends SoyPrintDirective> soyPrintDirectives;
        private ErrorReporter errorReporter;
        private SoyGeneralOptions options;
        private Optional<CssRegistry> cssRegistry = Optional.empty();
        private boolean allowUnknownGlobals;
        private boolean allowUnknownJsGlobals;
        private boolean disableAllTypeChecking;
        private MethodChecker javaPluginValidator;
        private boolean desugarHtmlNodes = true;
        private boolean desugarIdomFeatures = true;
        private boolean optimize = true;
        private ImmutableSet<SourceFilePath> generatedPathsToCheck = ImmutableSet.of();
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;
        private boolean insertEscapingDirectives = true;
        private boolean addHtmlAttributesForDebugging = true;
        private AstRewrites astRewrites = AstRewrites.ALL;
        private final Map<Class<? extends CompilerPass>, PassContinuationRule> passContinuationRegistry = Maps.newHashMap();
        private boolean building;
        private final AccumulatedState accumulatedState = new AccumulatedState();

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setSoyPrintDirectives(ImmutableList<? extends SoyPrintDirective> printDirectives) {
            this.soyPrintDirectives = (ImmutableList)Preconditions.checkNotNull(printDirectives);
            return this;
        }

        public Builder setJavaPluginValidator(MethodChecker javaPluginValidator) {
            this.javaPluginValidator = javaPluginValidator;
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)registry);
            return this;
        }

        public Builder setCssRegistry(Optional<CssRegistry> registry) {
            this.cssRegistry = registry;
            return this;
        }

        public Builder setPluginResolver(PluginResolver pluginResolver) {
            this.pluginResolver = pluginResolver;
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions options) {
            this.options = options;
            return this;
        }

        public Builder disableAllTypeChecking() {
            this.disableAllTypeChecking = true;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder astRewrites(AstRewrites astRewrites) {
            this.astRewrites = astRewrites;
            return this;
        }

        public Builder allowUnknownJsGlobals() {
            this.allowUnknownJsGlobals = true;
            return this;
        }

        public Builder desugarHtmlNodes(boolean desugarHtmlNodes) {
            this.desugarHtmlNodes = desugarHtmlNodes;
            return this;
        }

        public Builder desugarIdomFeatures(boolean desugarIdomFeatures) {
            this.desugarIdomFeatures = desugarIdomFeatures;
            return this;
        }

        public Builder optimize(boolean optimize) {
            this.optimize = optimize;
            return this;
        }

        public Builder setGeneratedPathsToCheck(ImmutableSet<SourceFilePath> generatedPaths) {
            this.generatedPathsToCheck = generatedPaths;
            return this;
        }

        public Builder addHtmlAttributesForDebugging(boolean addHtmlAttributesForDebugging) {
            this.addHtmlAttributesForDebugging = addHtmlAttributesForDebugging;
            return this;
        }

        public Builder setConformanceConfig(ValidatedConformanceConfig conformanceConfig) {
            this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
            return this;
        }

        public Builder setLoggingConfig(ValidatedLoggingConfig loggingConfig) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
            return this;
        }

        public Builder insertEscapingDirectives(boolean insertEscapingDirectives) {
            this.insertEscapingDirectives = insertEscapingDirectives;
            return this;
        }

        public Builder addPassContinuationRule(Class<? extends CompilerPass> pass, PassContinuationRule rule) {
            Preconditions.checkNotNull((Object)((Object)rule));
            this.passContinuationRegistry.put(pass, rule);
            return this;
        }

        public PassManager build() {
            this.building = true;
            PassBuilder passes = new PassBuilder().add(new CheckGeneratedSourcesPass(this.errorReporter, this.generatedPathsToCheck));
            if (this.astRewrites == AstRewrites.ALL) {
                passes.add(new ContentSecurityPolicyNonceInjectionPass(this.errorReporter)).add(new CheckEscapingSanityFilePass(this.errorReporter));
            }
            ImportsPass.ImportProcessor[] importProcessorArray = new ImportsPass.ImportProcessor[2];
            importProcessorArray[0] = new ProtoImportProcessor(this.registry, this.errorReporter, this.disableAllTypeChecking);
            importProcessorArray[1] = new TemplateImportProcessor(this.errorReporter, this.accumulatedState::registryFromDeps);
            passes.add(new ImportsPass(this.errorReporter, this.disableAllTypeChecking, importProcessorArray)).add(new ResolveUseVariantTypePass(this.errorReporter)).add(new FileDependencyOrderPass(this.errorReporter, v -> this.accumulatedState.topologicallyOrderedFiles = v)).add(new ModernFeatureInvariantsEnforcementPass(this.errorReporter)).add(new RestoreGlobalsPass()).add(new RestoreCompilerChecksPass(this.errorReporter)).add(new ResolveTemplateParamTypesPass(this.errorReporter, this.disableAllTypeChecking));
            passes.add(new ResolvePluginsPass(this.pluginResolver));
            if (!this.disableAllTypeChecking) {
                passes.add(new ValidateExternsPass(this.errorReporter, this.javaPluginValidator));
            }
            if (this.astRewrites == AstRewrites.ALL) {
                passes.add(new RewriteDirectivesCallableAsFunctionsPass(this.errorReporter)).add(new RewriteRemaindersPass(this.errorReporter)).add(new RewriteGenderMsgsPass(this.errorReporter)).add(new CalculateMsgSubstitutionInfoPass(this.errorReporter));
            }
            passes.add(new CheckNonEmptyMsgNodesPass(this.errorReporter));
            passes.add(new VeRewritePass()).add(new RewriteGlobalsPass()).add(new XidPass(this.errorReporter)).add(new UnknownJsGlobalPass(this.allowUnknownJsGlobals, this.errorReporter)).add(new ResolveNamesPass(this.errorReporter)).add(new ResolveDottedImportsPass(this.errorReporter, this.registry));
            if (this.astRewrites != AstRewrites.NONE) {
                passes.add(new ResolveTemplateFunctionsPass());
            }
            passes.add(new ResolveTemplateNamesPass(this.errorReporter));
            if (!this.disableAllTypeChecking) {
                passes.add(new ValidateVariantExpressionsPass(this.errorReporter));
            }
            if (this.astRewrites == AstRewrites.ALL) {
                passes.add(new MsgWithIdFunctionPass(this.errorReporter));
            }
            passes.add(new StrictHtmlValidationPass(this.errorReporter)).add(new SoyElementPass(this.errorReporter, this.accumulatedState::registryFromDeps));
            if (this.addHtmlAttributesForDebugging) {
                passes.add(new AddDebugAttributesPass());
            }
            if (this.astRewrites == AstRewrites.ALL) {
                passes.add(new ElementAttributePass(this.errorReporter, this.accumulatedState::registryFromDeps, this.desugarIdomFeatures));
            }
            if (!this.disableAllTypeChecking) {
                passes.add(new CheckDeclaredTypesPass(this.errorReporter)).add(new NullSafeAccessPass()).add(new ResolveExpressionTypesPass(this.errorReporter, this.loggingConfig, this.pluginResolver, this.accumulatedState::registryFromDeps)).add(new SimplifyAssertNonNullPass()).add(new TemplateCallMetadataPass(this.errorReporter)).add(new VeLogRewritePass()).add(new CheckModifiableTemplatesPass(this.errorReporter));
            }
            passes.add(new CheckAllFunctionsResolvedPass(this.pluginResolver));
            passes.add(new ResolvePackageRelativeCssNamesPass(this.errorReporter));
            if (!this.allowUnknownGlobals) {
                passes.add(new CheckGlobalsPass(this.errorReporter));
            }
            passes.add(new ValidateAliasesPass(this.errorReporter, this.loggingConfig)).add(new KeyCommandPass(this.errorReporter, this.disableAllTypeChecking)).add(new IncrementalDomKeysPass(this.errorReporter));
            if (!this.disableAllTypeChecking) {
                passes.add(new VeLogValidationPass(this.errorReporter, this.registry));
            }
            passes.add(new FinalizeTemplateRegistryPass(this.errorReporter, this.accumulatedState::registryFromDeps, reg -> this.accumulatedState.fileSetMetadataFull = reg));
            passes.add(new SoyConformancePass(this.conformanceConfig, this.errorReporter));
            if (!this.disableAllTypeChecking) {
                passes.add(new ResolveExpressionTypesCrossTemplatePass(this.errorReporter, this.astRewrites == AstRewrites.ALL));
            }
            passes.add(new CheckTemplateHeaderVarsPass(this.errorReporter, this.accumulatedState::registryFull));
            if (!this.disableAllTypeChecking) {
                passes.add(new EnforceExperimentalFeaturesPass(this.options.getExperimentalFeatures(), this.errorReporter)).add(new CheckTemplateCallsPass(this.errorReporter, this.accumulatedState::registryFull)).add(new ShortFormCallPass(this.astRewrites, this.errorReporter)).add(new ElementCheckCrossTemplatePass(this.errorReporter)).add(new CheckValidVarrefsPass(this.errorReporter)).add(new CheckTemplateVisibilityPass(this.errorReporter, this.accumulatedState::registryFull)).add(new CheckDelegatesPass(this.errorReporter, this.accumulatedState::registryFull)).add(new CheckIndirectDepsPass(this.errorReporter, this.accumulatedState::registryFull));
                if (this.desugarIdomFeatures && this.astRewrites == AstRewrites.ALL) {
                    passes.add(new DesugarStateNodesPass());
                }
                passes.add(new CombineConsecutiveRawTextNodesPass()).add(new AutoescaperPass(this.errorReporter, this.soyPrintDirectives, this.insertEscapingDirectives, this.accumulatedState::registryFull)).add(new SoyElementCompositionPass(this.astRewrites, this.errorReporter, this.soyPrintDirectives, this.accumulatedState::registryFull, this.desugarIdomFeatures));
            } else {
                passes.add(new CombineConsecutiveRawTextNodesPass()).add(new AutoescaperPass(this.errorReporter, this.soyPrintDirectives, this.insertEscapingDirectives, this.accumulatedState::registryFull));
            }
            passes.add(new CallAnnotationPass());
            if (!this.disableAllTypeChecking && this.insertEscapingDirectives) {
                passes.add(new CheckBadContextualUsagePass(this.errorReporter, this.accumulatedState::registryFull));
            }
            if (this.desugarHtmlNodes) {
                passes.add(new DesugarHtmlNodesPass());
            }
            if (this.optimize) {
                passes.add(new OptimizationPass(this.errorReporter));
            }
            passes.add(new CombineConsecutiveRawTextNodesPass()).add(new BanDuplicateNamespacesPass(this.errorReporter, this.accumulatedState::registryFull));
            this.building = false;
            if (!this.passContinuationRegistry.isEmpty()) {
                throw new IllegalStateException("The following continuation rules don't match any pass: " + this.passContinuationRegistry);
            }
            return new PassManager(PassManager.createParsePasses(this.errorReporter), passes.build(), this.accumulatedState);
        }

        private class PassBuilder {
            ImmutableList.Builder<CompilerFileSetPass> builder = ImmutableList.builder();

            private PassBuilder() {
            }

            PassBuilder add(CompilerFileSetPass pass) {
                Class<?> passClass = pass.getClass();
                PassContinuationRule rule = (PassContinuationRule)((Object)Builder.this.passContinuationRegistry.remove(passClass));
                if (!Builder.this.building) {
                    return this;
                }
                if (rule == null) {
                    this.builder.add((Object)pass);
                    return this;
                }
                switch (rule) {
                    case STOP_AFTER_PASS: {
                        this.builder.add((Object)pass);
                    }
                    case STOP_BEFORE_PASS: {
                        Builder.this.building = false;
                        return this;
                    }
                }
                throw new AssertionError((Object)("unhandled rule: " + (Object)((Object)rule)));
            }

            ImmutableList<CompilerFileSetPass> build() {
                return this.builder.build();
            }
        }
    }

    public static enum AstRewrites {
        NONE,
        KYTHE,
        TRICORDER,
        ALL;

    }

    private static class AccumulatedState {
        private FileSetMetadata fileSetMetadataFromDeps;
        private FileSetMetadata fileSetMetadataFull;
        private ImmutableList<SoyFileNode> topologicallyOrderedFiles;

        private AccumulatedState() {
        }

        FileSetMetadata registryFromDeps() {
            return this.fileSetMetadataFromDeps;
        }

        FileSetMetadata registryFull() {
            return this.fileSetMetadataFull;
        }
    }

    public static enum PassContinuationRule {
        STOP_BEFORE_PASS,
        STOP_AFTER_PASS;

    }
}

