/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;

public final class ResolveNamesPass
implements CompilerFilePass {
    private static final SoyErrorKind GLOBAL_MATCHES_VARIABLE = SoyErrorKind.of("Found global reference aliasing a local variable ''{0}'', did you mean ''${0}''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNKNOWN_VARIABLE = SoyErrorKind.of("Unknown variable.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    public ResolveNamesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        final ResolveNamesExprVisitor exprVisitor = new ResolveNamesExprVisitor();
        new LocalVariablesNodeVisitor(new LocalVariablesNodeVisitor.NodeVisitor(){

            @Override
            protected LocalVariablesNodeVisitor.ExprVisitor getExprVisitor() {
                return exprVisitor;
            }

            @Override
            protected ErrorReporter getErrorReporter() {
                return ResolveNamesPass.this.errorReporter;
            }
        }).exec(file);
    }

    private final class ResolveNamesExprVisitor
    extends LocalVariablesNodeVisitor.ExprVisitor {
        private ResolveNamesExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            String globalName = node.getName();
            LocalVariablesNodeVisitor.LocalVariables localVariables = this.getLocalVariables();
            VarDefn varDefn = localVariables.lookup("$" + globalName);
            if (varDefn != null) {
                ResolveNamesPass.this.errorReporter.report(node.getSourceLocation(), GLOBAL_MATCHES_VARIABLE, globalName);
                GlobalNode.replaceExprWithError(node);
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.getDefnDecl() != null) {
                return;
            }
            LocalVariablesNodeVisitor.LocalVariables localVariables = this.getLocalVariables();
            VarDefn varDefn = localVariables.lookup(varRef.getName());
            if (varDefn == null) {
                ResolveNamesPass.this.errorReporter.report(varRef.getSourceLocation(), UNKNOWN_VARIABLE, SoyErrors.getDidYouMeanMessage(localVariables.allVariablesInScope(), varRef.getOriginalName()));
                GlobalNode.replaceExprWithError(varRef);
            } else {
                varRef.setDefn(varDefn);
            }
        }
    }
}

