/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.ast.TypeNodeConverter;

public final class ResolveTemplateParamTypesPass
implements CompilerFilePass {
    private final ErrorReporter errorReporter;
    private final boolean disableAllTypeChecking;
    private static final SoyErrorKind ATTRIBUTE_PARAM_ONLY_IN_ELEMENT_TEMPLATE = SoyErrorKind.of("Only templates of kind=\"html<?>\" can have @attribute.", new SoyErrorKind.StyleAllowance[0]);

    public ResolveTemplateParamTypesPass(ErrorReporter errorReporter, boolean disableAllTypeChecking) {
        this.errorReporter = errorReporter;
        this.disableAllTypeChecking = disableAllTypeChecking;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        TypeNodeConverter converter = TypeNodeConverter.builder(this.errorReporter).setTypeRegistry(file.getSoyTypeRegistry()).setDisableAllTypeChecking(this.disableAllTypeChecking).build();
        for (ExternNode extern : file.getExterns()) {
            extern.setType((FunctionType)converter.getOrCreateType(extern.typeNode()));
        }
        for (TemplateNode template : file.getTemplates()) {
            for (TemplateParam param : template.getAllParams()) {
                if (param instanceof AttrParam && !(template.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind)) {
                    this.errorReporter.report(param.getSourceLocation(), ATTRIBUTE_PARAM_ONLY_IN_ELEMENT_TEMPLATE, new Object[0]);
                }
                if (param.getTypeNode() != null) {
                    param.setType(converter.getOrCreateType(param.getTypeNode()));
                    continue;
                }
                if (!this.disableAllTypeChecking) continue;
                param.setType(UnknownType.getInstance());
            }
            if (!(template instanceof TemplateElementNode)) continue;
            for (TemplateStateVar state : ((TemplateElementNode)template).getStateVars()) {
                if (state.getTypeNode() == null) continue;
                state.setType(converter.getOrCreateType(state.getTypeNode()));
            }
        }
    }
}

