/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.VeDataType;

final class VeLogRewritePass
implements CompilerFilePass {
    VeLogRewritePass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (VeLogNode node : SoyTreeUtils.getAllNodesOfType(file, VeLogNode.class)) {
            this.maybeRewriteVeLogNode(node);
        }
    }

    private void maybeRewriteVeLogNode(VeLogNode node) {
        ExprNode veExpr = node.getVeDataExpression().getRoot();
        if (SoyTypes.isKindOrUnionOfKind(veExpr.getType(), SoyType.Kind.VE)) {
            FunctionNode veData = FunctionNode.newPositional(Identifier.create(BuiltinFunction.VE_DATA.getName(), veExpr.getSourceLocation()), BuiltinFunction.VE_DATA, veExpr.getSourceLocation());
            veData.setType(VeDataType.getInstance());
            veData.addChild(veExpr);
            veData.addChild(new NullNode(veExpr.getSourceLocation()));
            node.getVeDataExpression().addChild(veData);
        }
    }
}

