/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.InternalPyExprUtils;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.LinkedHashMap;
import java.util.List;

final class GenPyCallExprVisitor
extends AbstractReturningSoyNodeVisitor<PyExpr> {
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final PythonValueFactoryImpl pluginValueFactory;
    private final GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    private LocalVariableStack localVarStack;
    private ErrorReporter errorReporter;

    GenPyCallExprVisitor(IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, PythonValueFactoryImpl pluginValueFactory, GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory) {
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.pluginValueFactory = pluginValueFactory;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
    }

    PyExpr exec(CallNode callNode, LocalVariableStack localVarStack, ErrorReporter errorReporter) {
        this.localVarStack = localVarStack;
        this.errorReporter = errorReporter;
        PyExpr callExpr = (PyExpr)this.visit(callNode);
        this.localVarStack = null;
        this.errorReporter = null;
        return callExpr;
    }

    @Override
    protected PyExpr visitCallBasicNode(CallBasicNode node) {
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarStack, this.pluginValueFactory, node, this.errorReporter);
        PyExpr calleeExpr = node.isStaticCall() ? translator.getCalleeExpr((TemplateLiteralNode)node.getCalleeExpr().getRoot()) : (PyExpr)translator.exec(node.getCalleeExpr());
        String calleeExprText = calleeExpr.getText();
        if (calleeExpr.getPrecedence() < Integer.MAX_VALUE) {
            calleeExprText = "(" + calleeExprText + ")";
        }
        calleeExprText = calleeExprText + "(" + this.genObjToPass(node) + ", ijData)";
        return this.escapeCall(calleeExprText, node.getEscapingDirectives());
    }

    @Override
    protected PyExpr visitCallDelegateNode(CallDelegateNode node) {
        PyExpr variantPyExpr;
        ExprRootNode variantSoyExpr = node.getDelCalleeVariantExpr();
        if (variantSoyExpr == null) {
            variantPyExpr = new PyStringExpr("''");
        } else {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarStack, this.pluginValueFactory, node, this.errorReporter);
            variantPyExpr = (PyExpr)translator.exec(variantSoyExpr);
        }
        String calleeExprText = new PyFunctionExprBuilder("runtime.get_delegate_fn").addArg(node.getDelCalleeName()).addArg(variantPyExpr).addArg(node.allowEmptyDefault()).build();
        String callExprText = calleeExprText + "(" + this.genObjToPass(node) + ", ijData)";
        return this.escapeCall(callExprText, node.getEscapingDirectives());
    }

    public String genObjToPass(CallNode callNode) {
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarStack, this.pluginValueFactory, callNode, this.errorReporter);
        String dataToPass = callNode.isPassingAllData() ? "data" : (callNode.isPassingData() ? ((PyExpr)translator.exec(callNode.getDataExpr())).getText() : "{}");
        LinkedHashMap<PyExpr, PyExpr> additionalParams = new LinkedHashMap<PyExpr, PyExpr>();
        for (CallParamNode child : callNode.getChildren()) {
            PyExpr valuePyExpr;
            PyStringExpr key = new PyStringExpr("'" + child.getKey().identifier() + "'");
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                additionalParams.put(key, (PyExpr)translator.exec(cpvn.getExpr()));
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsPyExprVisitor.exec(cpcn)).booleanValue()) {
                valuePyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitorFactory.create(this.localVarStack, this.errorReporter).exec(cpcn));
            } else {
                String paramExpr = "param" + cpcn.getId();
                valuePyExpr = new PyListExpr(paramExpr, Integer.MAX_VALUE);
            }
            valuePyExpr = InternalPyExprUtils.wrapAsSanitizedContent(cpcn.getContentKind(), valuePyExpr.toPyString());
            additionalParams.put(key, valuePyExpr);
        }
        LinkedHashMap<PyExpr, PyExpr> defaultParams = new LinkedHashMap<PyExpr, PyExpr>();
        for (TemplateParam param : callNode.getNearestAncestor(TemplateNode.class).getParams()) {
            if (!param.hasDefault()) continue;
            defaultParams.put(new PyStringExpr("'" + param.name() + "'"), (PyExpr)translator.exec(param.defaultValue()));
        }
        PyExpr additionalParamsExpr = PyExprUtils.convertMapToPyExpr(additionalParams);
        if (callNode.isPassingData()) {
            if (callNode.numChildren() > 0) {
                dataToPass = "dict(" + dataToPass + ")";
                dataToPass = "runtime.merge_into_dict(" + dataToPass + ", " + additionalParamsExpr.getText() + ")";
            }
            if (!defaultParams.isEmpty()) {
                PyExpr defaultParamsExpr = PyExprUtils.convertMapToPyExpr(defaultParams);
                dataToPass = "runtime.merge_into_dict(" + defaultParamsExpr.getText() + ", " + dataToPass + ")";
            }
            return dataToPass;
        }
        return additionalParamsExpr.getText();
    }

    private PyExpr escapeCall(String callExpr, ImmutableList<SoyPrintDirective> directives) {
        PyExpr escapedExpr = new PyExpr(callExpr, Integer.MAX_VALUE);
        if (directives.isEmpty()) {
            return escapedExpr;
        }
        for (SoyPrintDirective directive : directives) {
            Preconditions.checkState((boolean)(directive instanceof SoyPySrcPrintDirective), (String)"Autoescaping produced a bogus directive: %s", (Object)directive.getName());
            escapedExpr = ((SoyPySrcPrintDirective)directive).applyForPySrc(escapedExpr, (List<PyExpr>)ImmutableList.of());
        }
        return escapedExpr;
    }

    static String getLocalTemplateName(TemplateNode node) {
        String templateName = node.getLocalTemplateSymbol();
        if (node.getVisibility() == Visibility.PRIVATE) {
            return "__" + templateName;
        }
        return templateName;
    }

    static String getLocalConstName(ConstNode node) {
        String functionName = node.getVar().name();
        if (!node.isExported()) {
            return "__" + functionName;
        }
        return functionName;
    }
}

