/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.AutoValue_GenPyCodeVisitor_NamespaceAndName;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.InternalPyExprUtils;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LegacyObjectMapFinder;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PyCodeBuilder;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.TypeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

final class GenPyCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private final SoyPySrcOptions pySrcOptions;
    private final ImmutableMap<String, String> namespaceManifest;
    private final FileSetMetadata fileSetMetadata;
    @VisibleForTesting
    protected PyCodeBuilder pyCodeBuilder;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    @VisibleForTesting
    final GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    @VisibleForTesting
    protected GenPyExprsVisitor genPyExprsVisitor;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    private final PythonValueFactoryImpl pluginValueFactory;
    @VisibleForTesting
    protected LocalVariableStack localVarExprs;
    private static final SoyErrorKind DELEGATE_TEMPLATES_UNSUPPORTED = SoyErrorKind.of("Deltemplates are not supported in python.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MODIFIABLE_TEMPLATES_UNSUPPORTED = SoyErrorKind.of("Modifiable templates are not supported in python.", new SoyErrorKind.StyleAllowance[0]);

    GenPyCodeVisitor(SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest, FileSetMetadata fileSetMetadata, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory, GenPyCallExprVisitor genPyCallExprVisitor, PythonValueFactoryImpl pluginValueFactory) {
        this.pySrcOptions = pySrcOptions;
        this.fileSetMetadata = fileSetMetadata;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
        this.pluginValueFactory = pluginValueFactory;
        this.namespaceManifest = new ImmutableMap.Builder().putAll(pySrcOptions.getNamespaceManifest()).putAll(currentManifest).build();
    }

    public List<String> gen(SoyFileSetNode node, ErrorReporter errorReporter) {
        this.pyCodeBuilder = null;
        this.genPyExprsVisitor = null;
        this.localVarExprs = null;
        return new Impl(errorReporter).exec(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, ErrorReporter errorReporter) {
        new Impl(errorReporter).exec(node);
    }

    @AutoValue
    static abstract class NamespaceAndName {
        NamespaceAndName() {
        }

        static NamespaceAndName fromModule(String moduleName) {
            String namespace = moduleName;
            String name = moduleName;
            int lastDotIndex = moduleName.lastIndexOf(46);
            if (lastDotIndex != -1) {
                namespace = moduleName.substring(0, lastDotIndex);
                name = moduleName.substring(lastDotIndex + 1);
            }
            return new AutoValue_GenPyCodeVisitor_NamespaceAndName(namespace, name);
        }

        abstract String namespace();

        abstract String name();
    }

    private final class Impl
    extends AbstractSoyNodeVisitor<List<String>> {
        private List<String> pyFilesContents;
        final ErrorReporter errorReporter;

        Impl(ErrorReporter reporter) {
            this.errorReporter = reporter;
        }

        @Override
        public List<String> exec(SoyNode node) {
            this.pyFilesContents = new ArrayList<String>();
            this.visit(node);
            return this.pyFilesContents;
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            if (node.numChildren() == 0 && node instanceof SoyNode.ConditionalBlockNode) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("pass");
                return;
            }
            if (node.numChildren() > 0 && !((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec((SoyNode)node.getChild(0))).booleanValue()) {
                GenPyCodeVisitor.this.pyCodeBuilder.initOutputVarIfNecessary();
            }
            ArrayList<PyExpr> childPyExprs = new ArrayList<PyExpr>();
            for (SoyNode child : node.getChildren()) {
                if (((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) {
                    childPyExprs.addAll(GenPyCodeVisitor.this.genPyExprsVisitor.exec(child));
                    continue;
                }
                if (!childPyExprs.isEmpty()) {
                    GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(childPyExprs);
                    childPyExprs.clear();
                }
                this.visit(child);
            }
            if (!childPyExprs.isEmpty()) {
                GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(childPyExprs);
                childPyExprs.clear();
            }
        }

        @Override
        protected void visitSoyFileSetNode(SoyFileSetNode node) {
            for (SoyFileNode soyFile : node.getChildren()) {
                this.visit(soyFile);
            }
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            GenPyCodeVisitor.this.localVarExprs = new LocalVariableStack();
            GenPyCodeVisitor.this.pyCodeBuilder = new PyCodeBuilder();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("# coding=utf-8");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("\"\"\" This file was automatically generated by the Soy compiler.");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("Please don't edit this file by hand.");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("source: ", node.getFilePath().path());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("SOY_NAMESPACE: '" + node.getNamespace() + "'.");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            if (node.getNamespace() != null) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("Templates in namespace ", node.getNamespace(), ".");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("\"\"\"");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps();
            this.addCodeToRequireSoyNamespaces(node);
            this.addCodeToFixUnicodeStrings();
            if (SoyTreeUtils.hasNodesOfType(node, DebuggerNode.class)) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import pdb");
            }
            GenPyCodeVisitor.this.genPyExprsVisitor = GenPyCodeVisitor.this.genPyExprsVisitorFactory.create(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            node.getImports().forEach(this::visit);
            for (ConstNode constNode : node.getConstants()) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
                this.visit(constNode);
            }
            for (TemplateNode template : node.getTemplates()) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
                this.visit(template);
            }
            GenPyCodeVisitor.this.localVarExprs.popFrame();
            this.pyFilesContents.add(GenPyCodeVisitor.this.pyCodeBuilder.getCode());
            GenPyCodeVisitor.this.pyCodeBuilder = null;
        }

        @Override
        protected void visitImportNode(ImportNode node) {
            node.visitVars((var, parentType) -> {
                if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE && var.type().getKind() != SoyType.Kind.TEMPLATE_TYPE) {
                    String fullNamespace = GenPyCodeVisitor.this.fileSetMetadata.getNamespaceForPath(node.getSourceFilePath());
                    NamespaceAndName namespaceAndName = NamespaceAndName.fromModule(fullNamespace);
                    GenPyCodeVisitor.this.localVarExprs.addVariable(var.name(), new PyExpr(namespaceAndName.name() + "." + var.getSymbol() + "()", Integer.MAX_VALUE));
                }
            });
        }

        @Override
        protected void visitConstNode(ConstNode node) {
            String functionName = GenPyCallExprVisitor.getLocalConstName(node);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("def ", functionName, "():");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
            PyExpr value = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("return ", value.getText());
            GenPyCodeVisitor.this.localVarExprs.addVariable(node.getVar().name(), new PyExpr(functionName + "()", Integer.MAX_VALUE));
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            for (TemplateParam param : node.getParams()) {
                TypeNode type = param.getTypeNode();
                if (type == null) continue;
                type.accept(new LegacyObjectMapFinder(this.errorReporter));
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("def ", GenPyCallExprVisitor.getLocalTemplateName(node), "(data={}, ijData={}):");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            this.generateFunctionBody(node);
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
        }

        @Override
        protected void visitTemplateDelegateNode(TemplateDelegateNode node) {
            this.errorReporter.report(node.getSourceLocation(), DELEGATE_TEMPLATES_UNSUPPORTED, new Object[0]);
        }

        @Override
        protected void visitTemplateBasicNode(TemplateBasicNode node) {
            if (node.isModifiable() || node.getModifiesExpr() != null) {
                this.errorReporter.report(node.getSourceLocation(), MODIFIABLE_TEMPLATES_UNSUPPORTED, new Object[0]);
            }
            this.visitTemplateNode(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
        }

        @Override
        protected void visitIfNode(IfNode node) {
            if (((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
                GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
                return;
            }
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExpr());
                    if (icn.getCommandName().equals("if")) {
                        GenPyCodeVisitor.this.pyCodeBuilder.appendLine("if ", condPyExpr.getText(), ":");
                    } else {
                        GenPyCodeVisitor.this.pyCodeBuilder.appendLine("elif ", condPyExpr.getText(), ":");
                    }
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren(icn);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                if (child instanceof IfElseNode) {
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren((IfElseNode)child);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
            }
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
            String switchValueVarName = "switchValue";
            PyExpr switchValuePyExpr = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(switchValueVarName, " = ", switchValuePyExpr.getText());
            if (node.numChildren() == 1 && node.getChild(0) instanceof SwitchDefaultNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node.getChild(0));
                return;
            }
            boolean isFirstCase = true;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    for (ExprNode caseExpr : scn.getExprList()) {
                        PyExpr casePyExpr = (PyExpr)translator.exec(caseExpr);
                        PyExpr conditionFn = new PyFunctionExprBuilder("runtime.type_safe_eq").addArg(new PyExpr(switchValueVarName, Integer.MAX_VALUE)).addArg(casePyExpr).asPyExpr();
                        if (isFirstCase) {
                            GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart("if ").append(conditionFn.getText()).appendLineEnd(":");
                            isFirstCase = false;
                        } else {
                            GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart("elif ").append(conditionFn.getText()).appendLineEnd(":");
                        }
                        GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                        this.visitChildren(scn);
                        GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    }
                    continue;
                }
                if (child instanceof SwitchDefaultNode) {
                    SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren(sdn);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                throw new AssertionError((Object)("Unexpected switch child node type. Child: " + child));
            }
        }

        @Override
        protected void visitForNode(ForNode node) {
            boolean hasIfemptyNode;
            ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
            String baseVarName = nonEmptyNode.getVarName();
            String listVarName = String.format("%sList%d", baseVarName, node.getId());
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
            PyExpr dataRefPyExpr = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(listVarName, " = ", dataRefPyExpr.getText());
            boolean bl = hasIfemptyNode = node.numChildren() == 2;
            if (hasIfemptyNode) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("if ", listVarName, ":");
                GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            }
            this.visit(nonEmptyNode);
            if (hasIfemptyNode) {
                GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                this.visit((SoyNode)node.getChild(1));
                GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            }
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            String baseVarName = node.getVarName();
            String forNodeId = Integer.toString(node.getForNodeId());
            String listVarName = baseVarName + "List" + forNodeId;
            String indexVarName = baseVarName + "Index" + forNodeId;
            String dataVarName = baseVarName + "Data" + forNodeId;
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("for ", indexVarName, ", ", dataVarName, " in enumerate(", listVarName, "):");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.localVarExprs.addVariable(baseVarName, new PyExpr(dataVarName, Integer.MAX_VALUE));
            if (node.getIndexVar() != null) {
                GenPyCodeVisitor.this.localVarExprs.addVariable(node.getIndexVarName(), new PyExpr(indexVarName, Integer.MAX_VALUE));
            }
            this.visitChildren(node);
            GenPyCodeVisitor.this.localVarExprs.popFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
        }

        @Override
        protected void visitForIfemptyNode(ForIfemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            String generatedVarName = node.getUniqueVarName();
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
            PyExpr valuePyExpr = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(generatedVarName, " = ", valuePyExpr.getText());
            GenPyCodeVisitor.this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            String generatedVarName = node.getUniqueVarName();
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar(generatedVarName);
            this.visitChildren(node);
            PyStringExpr generatedContent = GenPyCodeVisitor.this.pyCodeBuilder.getOutputAsString();
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
            GenPyCodeVisitor.this.localVarExprs.popFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(generatedVarName, " = ", InternalPyExprUtils.wrapAsSanitizedContent(node.getContentKind(), generatedContent).getText());
            GenPyCodeVisitor.this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
        }

        @Override
        protected void visitCallDelegateNode(CallDelegateNode node) {
            this.errorReporter.report(node.getSourceLocation(), DELEGATE_TEMPLATES_UNSUPPORTED, new Object[0]);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            for (CallParamNode child : node.getChildren()) {
                if (!(child instanceof CallParamContentNode) || ((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) continue;
                this.visit(child);
            }
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(GenPyCodeVisitor.this.genPyCallExprVisitor.exec(node, GenPyCodeVisitor.this.localVarExprs, this.errorReporter).toPyString());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            Preconditions.checkArgument(((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node) == false ? 1 : 0) != 0, (Object)"Should only define 'param<n>' when not computable as Python expressions.");
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar("param" + node.getId());
            GenPyCodeVisitor.this.pyCodeBuilder.initOutputVarIfNecessary();
            this.visitChildren(node);
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
        }

        @Override
        protected void visitVeLogNode(VeLogNode node) {
            if (node.getLogonlyExpression() != null) {
                TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, GenPyCodeVisitor.this.pluginValueFactory, node, this.errorReporter);
                PyExpr isLogonly = (PyExpr)translator.exec(node.getLogonlyExpression());
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("if ", isLogonly.getText(), ":");
                GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("raise Exception('Cannot set logonly=\"true\" unless there is a logger configured, but pysrc doesn\\'t support loggers')");
                GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitDebuggerNode(DebuggerNode node) {
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("pdb.set_trace()");
        }

        @Override
        protected void visitKeyNode(KeyNode node) {
        }

        @Override
        protected void visitLogNode(LogNode node) {
            String outputVarName = "logger_" + node.getId();
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar(outputVarName);
            GenPyCodeVisitor.this.pyCodeBuilder.initOutputVarIfNecessary();
            this.visitChildren(node);
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("print " + outputVarName);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (!((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
                throw new UnsupportedOperationException();
            }
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
        }

        private void addCodeToRequireGeneralDeps() {
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from __future__ import unicode_literals");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from __future__ import division");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import collections");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import math");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import random");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import sys");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import bidi");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import directives");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import runtime");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import sanitize");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            if (!GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().isEmpty()) {
                int dotIndex = GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().lastIndexOf(46);
                String bidiModulePath = GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().substring(0, dotIndex);
                NamespaceAndName namespaceAndName = NamespaceAndName.fromModule(bidiModulePath);
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", namespaceAndName.namespace(), " import ", namespaceAndName.name(), " as ", "external_bidi");
            }
            if (!GenPyCodeVisitor.this.pySrcOptions.getTranslationClass().isEmpty()) {
                NamespaceAndName namespaceAndName = NamespaceAndName.fromModule(GenPyCodeVisitor.this.pySrcOptions.getTranslationClass());
                String translationName = namespaceAndName.name();
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", namespaceAndName.namespace(), " import ", translationName);
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("translator_impl", " = ", translationName, "()");
            }
        }

        private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
            SortedSet calleeModules = soyFile.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> GenPyCodeVisitor.this.fileSetMetadata.getNamespaceForPath(i.getSourceFilePath())).collect(Collectors.toCollection(TreeSet::new));
            for (String calleeModule : calleeModules) {
                NamespaceAndName namespaceAndName = NamespaceAndName.fromModule(calleeModule);
                if (GenPyCodeVisitor.this.namespaceManifest.containsKey((Object)calleeModule)) {
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import ", (String)GenPyCodeVisitor.this.namespaceManifest.get((Object)calleeModule), " as ", namespaceAndName.name());
                    continue;
                }
                GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart(namespaceAndName.name(), " = runtime.namespaced_import('", namespaceAndName.name(), "', namespace='", namespaceAndName.namespace(), "'");
                if (!GenPyCodeVisitor.this.pySrcOptions.getEnvironmentModulePath().isEmpty()) {
                    GenPyCodeVisitor.this.pyCodeBuilder.append(", environment_path='").append(GenPyCodeVisitor.this.pySrcOptions.getEnvironmentModulePath(), "'");
                }
                GenPyCodeVisitor.this.pyCodeBuilder.appendLineEnd(")");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("NAMESPACE_MANIFEST = {");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndentTwice();
            for (Map.Entry entry : GenPyCodeVisitor.this.namespaceManifest.entrySet()) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("'", (String)entry.getKey(), "': '", (String)entry.getValue(), "',");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndentTwice();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("}");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
        }

        private void addCodeToFixUnicodeStrings() {
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("try:");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("str = unicode");
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("except NameError:");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("pass");
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
        }

        private void generateFunctionBody(TemplateNode node) {
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar("output");
            this.visitChildren(node);
            PyExpr resultPyExpr = GenPyCodeVisitor.this.pyCodeBuilder.getOutputAsString();
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
            resultPyExpr = InternalPyExprUtils.wrapAsSanitizedContent(node.getContentKind(), resultPyExpr);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("return ", resultPyExpr.getText());
            GenPyCodeVisitor.this.localVarExprs.popFrame();
        }
    }
}

