/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.TemplateType;
import java.util.List;
import javax.annotation.Nullable;

public final class CallBasicNode
extends CallNode {
    private ExprRootNode calleeExpr;

    public CallBasicNode(int id, SourceLocation location, SourceLocation openTagLocation, ExprNode calleeExpr, List<CommandTagAttribute> attributes, boolean selfClosing, ErrorReporter errorReporter) {
        super(id, location, openTagLocation, "call", attributes, selfClosing, errorReporter);
        this.calleeExpr = new ExprRootNode(calleeExpr);
        block11: for (CommandTagAttribute attr : attributes) {
            String ident;
            switch (ident = attr.getName().identifier()) {
                case "data": 
                case "key": 
                case "phname": 
                case "phex": {
                    continue block11;
                }
                case "variant": {
                    attr.valueAsExpr(errorReporter);
                    continue block11;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, ident, "call", ImmutableList.of((Object)"data", (Object)"key", (Object)"phname", (Object)"phex", (Object)"variant"));
        }
    }

    private CallBasicNode(CallBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.calleeExpr = orig.calleeExpr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSourceCalleeName() {
        return this.calleeExpr.getRoot().toSourceString();
    }

    @Override
    public SourceLocation getSourceCalleeLocation() {
        return this.calleeExpr.getSourceLocation();
    }

    public String getCalleeName() {
        Preconditions.checkState((boolean)this.isStaticCall(), (String)"Expected static call, but found: %s", (Object)this.calleeExpr.getRoot());
        return ((TemplateLiteralNode)this.calleeExpr.getRoot()).getResolvedName();
    }

    public boolean isStaticCall() {
        return this.calleeExpr.getRoot().getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE;
    }

    public ExprRootNode getCalleeExpr() {
        return this.calleeExpr;
    }

    public TemplateType getStaticType() {
        Preconditions.checkArgument((boolean)this.isStaticCall());
        return (TemplateType)this.getCalleeExpr().getType();
    }

    public void setCalleeExpr(ExprRootNode calleeExpr) {
        this.calleeExpr = calleeExpr;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder allExprs = ImmutableList.builder();
        allExprs.add((Object)this.calleeExpr);
        allExprs.addAll(super.getExprList());
        return allExprs.build();
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.getSourceCalleeName());
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        this.getPlaceholder().userSuppliedName().ifPresent(phname -> commandText.append(" phname=\"").append((String)phname).append('\"'));
        this.getPlaceholder().example().ifPresent(phex -> commandText.append(" phex=\"").append((String)phex).append('\"'));
        return commandText.toString();
    }

    @Nullable
    public ExprRootNode getVariantExpr() {
        return this.getAttributes().stream().filter(a -> "variant".equals(a.getName().identifier()) && a.hasExprValue()).findFirst().map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    @Override
    public CallBasicNode copy(CopyState copyState) {
        return new CallBasicNode(this, copyState);
    }
}

