/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.AutoValue_MsgHtmlTagNode_SamenessKeyImpl;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.VeLogNode;
import java.util.Optional;
import javax.annotation.Nullable;

public final class MsgHtmlTagNode
extends AbstractBlockNode
implements SoyNode.MsgPlaceholderInitialNode {
    private static final SoyErrorKind DYNAMIC_TAG_NAME_IN_MSG_BLOCK = SoyErrorKind.of("HTML tags within within ''msg'' blocks must use constant tag names.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ATTRIBUTE = SoyErrorKind.of("''{0}'' attribute is not a constant.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableMap<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").buildOrThrow();
    private final String lcTagName;
    private final boolean isSelfEnding;
    @Nullable
    private final SoyNode.MsgPlaceholderInitialNode.SamenessKey samenessKey;
    private final MessagePlaceholder placeholder;
    private static final CharMatcher INVALID_PLACEHOLDER_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'_')).negate().precomputed();

    public static MsgHtmlTagNode fromNode(int id, HtmlTagNode tagNode, @Nullable VeLogNode velogParent, ErrorReporter errorReporter) {
        RawTextNode phExampleNode = MsgHtmlTagNode.getAttributeValue(tagNode, "phex", errorReporter);
        Optional<Object> phExample = Optional.ofNullable(phExampleNode == null ? null : MessagePlaceholder.validatePlaceholderExample(phExampleNode.getRawText(), phExampleNode.getSourceLocation(), errorReporter));
        RawTextNode userSuppliedPhNameNode = MsgHtmlTagNode.getAttributeValue(tagNode, "phname", errorReporter);
        String fullTagText = MsgHtmlTagNode.getFullTagText(tagNode);
        String lcTagName = MsgHtmlTagNode.getLcTagName(errorReporter, tagNode.getTagName());
        boolean isSelfEnding = false;
        if (tagNode instanceof HtmlCloseTagNode) {
            lcTagName = "/" + lcTagName;
        } else if (tagNode instanceof HtmlOpenTagNode) {
            isSelfEnding = ((HtmlOpenTagNode)tagNode).isSelfClosing();
        }
        VeLogNode.SamenessKey key = velogParent != null ? velogParent.getSamenessKey() : null;
        MessagePlaceholder placeholder = null;
        if (userSuppliedPhNameNode != null) {
            SourceLocation phNameLocation = userSuppliedPhNameNode.getSourceLocation();
            String phName = MessagePlaceholder.validatePlaceholderName(userSuppliedPhNameNode.getRawText(), phNameLocation, errorReporter);
            if (phName != null) {
                placeholder = MessagePlaceholder.createWithUserSuppliedName(BaseUtils.convertToUpperUnderscore(phName), phName, phNameLocation, phExample);
            }
        }
        if (placeholder == null) {
            placeholder = MessagePlaceholder.create(MsgHtmlTagNode.genBasePhName(lcTagName, isSelfEnding), phExample);
        }
        return new MsgHtmlTagNode(id, tagNode.getSourceLocation(), placeholder, lcTagName, isSelfEnding, fullTagText != null ? SamenessKeyImpl.create(placeholder.name(), fullTagText, key) : null, tagNode);
    }

    @Nullable
    private static String getFullTagText(HtmlTagNode openTagNode) {
        return SoyTreeUtils.allNodes(openTagNode).anyMatch(node -> !(node instanceof RawTextNode) && !(node instanceof HtmlAttributeNode) && !(node instanceof HtmlAttributeValueNode) && !(node instanceof HtmlOpenTagNode) && !(node instanceof HtmlCloseTagNode)) ? null : openTagNode.toSourceString();
    }

    @Nullable
    private static RawTextNode getAttributeValue(HtmlTagNode tagNode, String name, ErrorReporter errorReporter) {
        HtmlAttributeNode attribute = tagNode.getDirectAttributeNamed(name);
        if (attribute == null) {
            return null;
        }
        RawTextNode value = MsgHtmlTagNode.getAttributeValue(attribute, name, errorReporter);
        tagNode.removeChild(attribute);
        return value;
    }

    @Nullable
    private static RawTextNode getAttributeValue(HtmlAttributeNode htmlAttributeNode, String name, ErrorReporter errorReporter) {
        HtmlAttributeValueNode attributeValueNode;
        SoyNode.StandaloneNode valueNode = (SoyNode.StandaloneNode)htmlAttributeNode.getChild(1);
        if (valueNode instanceof HtmlAttributeValueNode && (attributeValueNode = (HtmlAttributeValueNode)valueNode).numChildren() == 1 && attributeValueNode.getChild(0) instanceof RawTextNode) {
            return (RawTextNode)attributeValueNode.getChild(0);
        }
        errorReporter.report(valueNode.getSourceLocation(), INVALID_ATTRIBUTE, name);
        return null;
    }

    private static String getLcTagName(ErrorReporter errorReporter, TagName tagName) {
        String lcTagName;
        if (!tagName.isStatic()) {
            errorReporter.report(tagName.getTagLocation(), DYNAMIC_TAG_NAME_IN_MSG_BLOCK, new Object[0]);
            lcTagName = "error";
        } else {
            lcTagName = tagName.getStaticTagNameAsLowerCase();
        }
        return lcTagName;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    private MsgHtmlTagNode(int id, SourceLocation sourceLocation, MessagePlaceholder placeholder, String lcTagName, boolean isSelfEnding, @Nullable SoyNode.MsgPlaceholderInitialNode.SamenessKey samenessKey, HtmlTagNode child) {
        super(id, sourceLocation);
        this.placeholder = placeholder;
        this.lcTagName = lcTagName;
        this.isSelfEnding = isSelfEnding;
        this.samenessKey = samenessKey;
        this.addChild(child);
    }

    private MsgHtmlTagNode(MsgHtmlTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.lcTagName = orig.lcTagName;
        this.isSelfEnding = orig.isSelfEnding;
        this.samenessKey = orig.samenessKey != null ? orig.samenessKey.copy(copyState) : null;
        this.placeholder = orig.placeholder;
        copyState.updateRefs(orig, this);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_HTML_TAG_NODE;
    }

    @Override
    public MessagePlaceholder getPlaceholder() {
        return this.placeholder;
    }

    private static String genBasePhName(String lcTagName, boolean isSelfEnding) {
        String baseLcTagName;
        boolean isEndTag;
        if (lcTagName.startsWith("/")) {
            isEndTag = true;
            baseLcTagName = lcTagName.substring(1);
        } else {
            isEndTag = false;
            baseLcTagName = lcTagName;
        }
        String basePlaceholderName = (String)LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.getOrDefault((Object)baseLcTagName, (Object)baseLcTagName);
        if (isEndTag) {
            basePlaceholderName = "end_" + basePlaceholderName;
        } else if (!isSelfEnding) {
            basePlaceholderName = "start_" + basePlaceholderName;
        }
        basePlaceholderName = INVALID_PLACEHOLDER_CHARS.replaceFrom((CharSequence)basePlaceholderName, '_');
        return Ascii.toUpperCase((String)basePlaceholderName);
    }

    @Override
    public SoyNode.MsgPlaceholderInitialNode.SamenessKey genSamenessKey() {
        return this.samenessKey == null ? new SoyNode.MsgPlaceholderInitialNode.IdentitySamenessKey(this) : this.samenessKey;
    }

    @Override
    public String toSourceString() {
        int indexBeforeClose;
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        if (this.isSelfEnding ? !sb.substring(indexBeforeClose = sb.length() - 2).equals("/>") : !sb.substring(indexBeforeClose = sb.length() - 1).equals(">")) {
            throw new AssertionError();
        }
        this.placeholder.example().ifPresent(phex -> sb.insert(indexBeforeClose, " phex=\"" + phex + "\""));
        this.placeholder.userSuppliedName().ifPresent(phname -> sb.insert(indexBeforeClose, " phname=\"" + phname + "\""));
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgHtmlTagNode copy(CopyState copyState) {
        return new MsgHtmlTagNode(this, copyState);
    }

    @AutoValue
    static abstract class SamenessKeyImpl
    implements SoyNode.MsgPlaceholderInitialNode.SamenessKey {
        SamenessKeyImpl() {
        }

        static SamenessKeyImpl create(String userSuppliedPlaceholderName, String fullTagText, VeLogNode.SamenessKey key) {
            if (userSuppliedPlaceholderName == null && fullTagText == null && key == null) {
                throw new IllegalArgumentException("at least one parameter should be nonnull");
            }
            return new AutoValue_MsgHtmlTagNode_SamenessKeyImpl(userSuppliedPlaceholderName, fullTagText, key);
        }

        @Override
        public SamenessKeyImpl copy(CopyState copyState) {
            return SamenessKeyImpl.create(this.userSuppliedPlaceholderName(), this.fullTagText(), this.logKey() == null ? null : this.logKey().copy(copyState));
        }

        @Nullable
        abstract String userSuppliedPlaceholderName();

        @Nullable
        abstract String fullTagText();

        @Nullable
        abstract VeLogNode.SamenessKey logKey();
    }
}

