/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;

public final class SwitchNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private final ExprRootNode expr;
    private final SourceLocation openTagLocation;

    public SwitchNode(int id, SourceLocation location, SourceLocation openTagLocation, ExprNode expr) {
        super(id, location, "switch");
        this.expr = new ExprRootNode(expr);
        this.openTagLocation = openTagLocation;
    }

    private SwitchNode(SwitchNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
        this.openTagLocation = orig.openTagLocation;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_NODE;
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return ImmutableList.of();
    }

    public boolean hasDefaultCase() {
        return this.numChildren() > 0 && this.getChild(this.numChildren() - 1) instanceof SwitchDefaultNode;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public String getCommandText() {
        return this.expr.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SwitchNode copy(CopyState copyState) {
        return new SwitchNode(this, copyState);
    }
}

