/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TemplateBasicNode
extends TemplateNode {
    public static final SoyErrorKind INVALID_USEVARIANTTYPE = SoyErrorKind.of("Invalid type name \"{0}\" for attribute \"usevarianttype\".", new SoyErrorKind.StyleAllowance[0]);
    private final boolean modifiable;
    private final String legacyDeltemplateNamespace;
    private final String useVariantTypeString;
    private SoyType useVariantType = null;

    TemplateBasicNode(TemplateBasicNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, Visibility visibility, boolean modifiable, String legacyDeltemplateNamespace, String useVariantTypeString, @Nullable ImmutableList<TemplateHeaderVarDefn> params) {
        super(nodeBuilder, "template", soyFileHeaderInfo, visibility, params);
        this.modifiable = modifiable;
        this.legacyDeltemplateNamespace = legacyDeltemplateNamespace;
        this.useVariantTypeString = useVariantTypeString;
    }

    private TemplateBasicNode(TemplateBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.modifiable = orig.modifiable;
        this.legacyDeltemplateNamespace = orig.legacyDeltemplateNamespace;
        this.useVariantTypeString = orig.useVariantTypeString;
        this.useVariantType = orig.useVariantType;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_BASIC_NODE;
    }

    @Override
    public TemplateBasicNode copy(CopyState copyState) {
        return new TemplateBasicNode(this, copyState);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    private Optional<CommandTagAttribute> getCommandTagAttribute(String name) {
        return this.getAttributes().stream().filter(a -> name.equals(a.getName().identifier()) && a.hasExprValue()).findFirst();
    }

    @Nullable
    public ExprRootNode getModifiesExpr() {
        return this.getCommandTagAttribute("modifies").map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    public String getLegacyDeltemplateNamespace() {
        return this.legacyDeltemplateNamespace;
    }

    @Nullable
    public ExprRootNode getVariantExpr() {
        return this.getCommandTagAttribute("variant").map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    public void resolveUseVariantType(SoyTypeRegistry registry, ErrorReporter errorReporter) {
        Preconditions.checkState((this.useVariantType == null ? 1 : 0) != 0);
        if (this.useVariantTypeString.isEmpty()) {
            this.useVariantType = NullType.getInstance();
            return;
        }
        SoyType resolvedType = registry.getType(this.useVariantTypeString);
        if (resolvedType == null) {
            errorReporter.report(this.getSourceLocation(), INVALID_USEVARIANTTYPE, this.useVariantTypeString);
            this.useVariantType = NullType.getInstance();
        } else {
            this.useVariantType = resolvedType;
        }
    }

    public SoyType getUseVariantType() {
        Preconditions.checkNotNull((Object)this.useVariantType, (Object)"if usevarianttype is set, resolveUseVariantType() needs to be called to resolve the type before getUseVariantType() is used");
        return this.useVariantType;
    }
}

