/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;

public class TemplateBasicNodeBuilder
extends TemplateNodeBuilder<TemplateBasicNodeBuilder> {
    public static final SoyErrorKind MODIFIABLE_AND_MODIFIES_BOTH_SET = SoyErrorKind.of("\"modifies\" and \"modifiable\" cannot both be set.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind LEGACYDELTEMPLATENAMESPACE_REQUIRES_MODIFIABLE = SoyErrorKind.of("\"legacydeltemplatenamespace\" requires \"modifiable\" to be set.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind USEVARIANTTYPE_REQUIRES_MODIFIABLE = SoyErrorKind.of("\"usevarianttype\" requires \"modifiable\" to be set.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind MODIFIABLE_REQUIRES_PUBLIC_VISIBILITY = SoyErrorKind.of("\"modifiable\" requires public visibility.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind MODIFIES_REQUIRES_PRIVATE_VISIBILITY = SoyErrorKind.of("\"modifies\" requires private visibility.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind VARIANT_REQUIRES_MODIFIES = SoyErrorKind.of("\"variant\" requires \"modifiable\" to be set.", new SoyErrorKind.StyleAllowance[0]);
    private boolean modifiable = false;
    private boolean hasModifies = false;
    private String legacyDeltemplateNamespace = "";
    private boolean hasVariant = false;
    private String useVariantTypeString = "";

    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateBasicNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.visibility = Visibility.PUBLIC;
        block16: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            if (COMMON_ATTRIBUTE_NAMES.contains((Object)name.identifier())) continue;
            switch (name.identifier()) {
                case "visibility": {
                    this.visibility = attribute.valueAsVisibility(this.errorReporter);
                    continue block16;
                }
                case "modifiable": {
                    this.modifiable = attribute.valueAsEnabled(this.errorReporter);
                    continue block16;
                }
                case "modifies": {
                    this.hasModifies = attribute.valueAsExpr(this.errorReporter) != null;
                    continue block16;
                }
                case "legacydeltemplatenamespace": {
                    this.legacyDeltemplateNamespace = attribute.getValue();
                    continue block16;
                }
                case "variant": {
                    this.hasVariant = attribute.valueAsExpr(this.errorReporter) != null;
                    continue block16;
                }
                case "usevarianttype": {
                    this.useVariantTypeString = attribute.getValue();
                    continue block16;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "template", ImmutableList.builder().add((Object)"visibility").add((Object)"modifiable").add((Object)"modifies").add((Object)"legacydeltemplatenamespace").add((Object)"variant").add((Object)"usevarianttype").addAll((Iterable)COMMON_ATTRIBUTE_NAMES).build());
        }
        this.setTemplateNames(templateName, this.soyFileHeaderInfo.getNamespace());
        return this;
    }

    @Override
    public TemplateBasicNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        if (this.modifiable && this.hasModifies) {
            this.errorReporter.report(this.openTagLocation, MODIFIABLE_AND_MODIFIES_BOTH_SET, new Object[0]);
        }
        if (!this.modifiable && !this.legacyDeltemplateNamespace.isEmpty()) {
            this.errorReporter.report(this.openTagLocation, LEGACYDELTEMPLATENAMESPACE_REQUIRES_MODIFIABLE, new Object[0]);
        }
        if (!this.modifiable && !this.useVariantTypeString.isEmpty()) {
            this.errorReporter.report(this.openTagLocation, USEVARIANTTYPE_REQUIRES_MODIFIABLE, new Object[0]);
        }
        if (this.modifiable && this.visibility != Visibility.PUBLIC) {
            this.errorReporter.report(this.openTagLocation, MODIFIABLE_REQUIRES_PUBLIC_VISIBILITY, new Object[0]);
        }
        if (this.hasModifies && this.visibility != Visibility.PRIVATE) {
            this.errorReporter.report(this.openTagLocation, MODIFIES_REQUIRES_PRIVATE_VISIBILITY, new Object[0]);
        }
        if (!this.hasModifies && this.hasVariant) {
            this.errorReporter.report(this.openTagLocation, VARIANT_REQUIRES_MODIFIES, new Object[0]);
        }
        return new TemplateBasicNode(this, this.soyFileHeaderInfo, this.visibility, this.modifiable, this.legacyDeltemplateNamespace, this.useVariantTypeString, (ImmutableList<TemplateHeaderVarDefn>)this.params);
    }

    @Override
    protected TemplateBasicNodeBuilder self() {
        return this;
    }
}

