/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ImportedVar
extends AbstractVarDefn {
    public static final String MODULE_IMPORT = "*";
    private final String symbol;
    private final Map<String, ImportedVar> nestedVarDefns;
    private final ImportedVar parent;
    private SourceFilePath filePath;

    public ImportedVar(String name, @Nullable String alias, SourceLocation nameLocation) {
        super(alias != null ? alias : name, nameLocation, null);
        Preconditions.checkArgument((alias == null || !alias.isEmpty() && !alias.equals(name) ? 1 : 0) != 0);
        this.nestedVarDefns = new LinkedHashMap<String, ImportedVar>();
        this.symbol = name;
        this.parent = null;
    }

    private ImportedVar(ImportedVar parent, String symbol) {
        super(parent.name() + "." + symbol, parent.nameLocation(), null);
        this.nestedVarDefns = new LinkedHashMap<String, ImportedVar>();
        this.symbol = symbol;
        this.parent = parent;
    }

    private ImportedVar(ImportedVar var, ImportedVar parent, CopyState copyState) {
        super(var);
        this.nestedVarDefns = new LinkedHashMap<String, ImportedVar>();
        for (Map.Entry<String, ImportedVar> entry : var.nestedVarDefns.entrySet()) {
            ImportedVar newNested = new ImportedVar(entry.getValue(), this, copyState);
            this.nestedVarDefns.put(entry.getKey(), newNested);
            copyState.updateRefs(entry.getValue(), newNested);
        }
        this.symbol = var.symbol;
        this.parent = parent;
        this.filePath = var.filePath;
    }

    public void onParentInit(SourceFilePath path) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
        this.filePath = path;
    }

    public ImportedVar copy(CopyState copyState) {
        return new ImportedVar(this, this.parent, copyState);
    }

    public ImportedVar getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public Set<String> getNestedTypes() {
        return Collections.unmodifiableSet(this.nestedVarDefns.keySet());
    }

    public ImportedVar nested(String symbolName) {
        return this.nestedVarDefns.computeIfAbsent(symbolName, n -> new ImportedVar(this, (String)n));
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.IMPORT_VAR;
    }

    public boolean isAliased() {
        return !this.name().equals(this.symbol);
    }

    @Override
    public boolean isInjected() {
        return false;
    }

    public boolean isModuleImport() {
        return MODULE_IMPORT.equals(this.symbol);
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    public SourceFilePath getSourceFilePath() {
        return this.parent != null ? this.parent.getSourceFilePath() : this.filePath;
    }
}

