/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.TypeNode;
import javax.annotation.Nullable;

public final class TemplateStateVar
extends AbstractVarDefn
implements TemplateHeaderVarDefn {
    private String desc;
    private final SourceLocation sourceLocation;
    @Nullable
    private final TypeNode typeNode;
    private final TypeNode originalTypeNode;
    @Nullable
    private final ExprRootNode initialValue;
    private final boolean isExplicitlyOptional;

    public TemplateStateVar(String name, @Nullable TypeNode typeNode, boolean optional, @Nullable ExprNode initialValue, @Nullable String desc, @Nullable SourceLocation nameLocation, SourceLocation sourceLocation) {
        super(name, nameLocation, null);
        this.originalTypeNode = typeNode;
        this.isExplicitlyOptional = optional;
        this.desc = desc;
        this.initialValue = initialValue == null ? new ExprRootNode(new NullNode(sourceLocation)) : new ExprRootNode(initialValue);
        this.sourceLocation = sourceLocation;
        if (optional && typeNode != null) {
            typeNode = TemplateParam.getNullableTypeNode(typeNode);
        }
        this.typeNode = typeNode;
    }

    private TemplateStateVar(TemplateStateVar old, CopyState copyState) {
        super(old);
        this.originalTypeNode = old.originalTypeNode == null ? null : old.originalTypeNode.copy();
        this.typeNode = old.typeNode == null ? null : old.typeNode.copy();
        this.isExplicitlyOptional = old.isExplicitlyOptional;
        this.desc = old.desc;
        this.initialValue = old.initialValue.copy(copyState);
        this.sourceLocation = old.sourceLocation;
        copyState.updateRefs(old.initialValue, this.initialValue);
    }

    @Override
    public String refName() {
        return "$" + this.name();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @Override
    public TypeNode getOriginalTypeNode() {
        return this.originalTypeNode;
    }

    @Override
    public ExprRootNode defaultValue() {
        return this.initialValue;
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.STATE;
    }

    @Override
    public boolean isInjected() {
        return false;
    }

    @Override
    public void setType(SoyType type) {
        if (this.type != null) {
            throw new IllegalStateException("type has already been set.");
        }
        this.type = type;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isExplicitlyOptional() {
        return this.isExplicitlyOptional;
    }

    @Override
    @Nullable
    public String desc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append(this.getClass().getSimpleName());
        description.append("{name = ").append(this.name());
        description.append(", desc = ").append(this.desc).append("}");
        return description.toString();
    }

    @Override
    public TemplateStateVar copy(CopyState copyState) {
        return new TemplateStateVar(this, copyState);
    }
}

