/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.soytree.FunctionTypeP;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AutoValue_FunctionType;
import com.google.template.soy.types.AutoValue_FunctionType_Parameter;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

@AutoValue
public abstract class FunctionType
extends SoyType {
    public static FunctionType of(Collection<Parameter> parameters, SoyType returnType) {
        return new AutoValue_FunctionType(returnType, (ImmutableList<Parameter>)ImmutableList.copyOf(parameters));
    }

    public abstract SoyType getReturnType();

    public abstract ImmutableList<Parameter> getParameters();

    public final ImmutableMap<String, SoyType> getParameterMap() {
        return (ImmutableMap)this.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, Parameter::getType));
    }

    @Override
    public final SoyType.Kind getKind() {
        return SoyType.Kind.FUNCTION;
    }

    @Override
    final boolean doIsAssignableFromNonUnionType(SoyType srcType, SoyType.UnknownAssignmentPolicy unknownPolicy) {
        if (srcType.getKind() != SoyType.Kind.FUNCTION) {
            return false;
        }
        FunctionType srcFunction = (FunctionType)srcType;
        Map thisParams = (Map)this.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, (Function)Functions.identity()));
        Map srcParams = (Map)srcFunction.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, (Function)Functions.identity()));
        for (Parameter thisParam : this.getParameters()) {
            if (srcParams.containsKey(thisParam.getName())) continue;
            return false;
        }
        for (Parameter srcParam : srcFunction.getParameters()) {
            Parameter thisParam = (Parameter)thisParams.get(srcParam.getName());
            if (srcParam.getType().isAssignableFromInternal(thisParam.getType(), unknownPolicy)) continue;
            return false;
        }
        return this.getReturnType().isAssignableFromStrict(srcFunction.getReturnType());
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Parameter parameter : this.getParameters()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String name = parameter.getName();
            sb.append(name);
            sb.append(": ");
            sb.append(parameter.getType());
        }
        sb.append(") => ");
        sb.append(this.getReturnType());
        return sb.toString();
    }

    @Override
    final void doToProto(SoyTypeP.Builder builder) {
        FunctionTypeP.Builder templateBuilder = builder.getFunctionBuilder().setReturnType(this.getReturnType().toProto());
        for (Parameter parameter : this.getParameters()) {
            templateBuilder.addParameters(FunctionTypeP.Parameter.newBuilder().setName(parameter.getName()).setType(parameter.getType().toProto()));
        }
    }

    @Override
    public final <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @AutoValue
    public static abstract class Parameter {
        public static Parameter of(String name, SoyType type) {
            return new AutoValue_FunctionType_Parameter(name, type);
        }

        public abstract String getName();

        public abstract SoyType getType();
    }
}

