/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.types.ast.AutoValue_RecordTypeNode;
import com.google.template.soy.types.ast.AutoValue_RecordTypeNode_Property;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

@AutoValue
public abstract class RecordTypeNode
extends TypeNode {
    public static RecordTypeNode create(SourceLocation sourceLocation, Iterable<Property> properties) {
        return new AutoValue_RecordTypeNode(sourceLocation, (ImmutableList<Property>)ImmutableList.copyOf(properties));
    }

    RecordTypeNode() {
    }

    public abstract ImmutableList<Property> properties();

    @Override
    public final String toString() {
        if (this.properties().size() < 3) {
            return "[" + Joiner.on((String)", ").join(this.properties()) + "]";
        }
        return "[\n  " + Joiner.on((String)",\n  ").join(this.properties()) + "\n]";
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RecordTypeNode copy() {
        ImmutableList.Builder newProperties = ImmutableList.builder();
        for (Property property : this.properties()) {
            newProperties.add((Object)property.copy());
        }
        RecordTypeNode copy = RecordTypeNode.create(this.sourceLocation(), (Iterable<Property>)newProperties.build());
        copy.copyResolvedTypeFrom(this);
        return copy;
    }

    @AutoValue
    public static abstract class Property {
        public static Property create(SourceLocation nameLocation, String name, boolean optional, TypeNode type) {
            return new AutoValue_RecordTypeNode_Property(nameLocation, name, optional, type);
        }

        Property() {
        }

        public abstract SourceLocation nameLocation();

        public abstract String name();

        public abstract boolean optional();

        public abstract TypeNode type();

        public final String toString() {
            return this.name() + (this.optional() ? "?" : "") + ": " + this.type();
        }

        Property copy() {
            return Property.create(this.nameLocation(), this.name(), this.optional(), this.type().copy());
        }
    }
}

