/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.DoNotCall;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.ProtoTypeRegistry;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistries;
import com.google.template.soy.types.TypeRegistry;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.ast.FunctionTypeNode;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public final class TypeNodeConverter
implements TypeNodeVisitor<SoyType>,
Function<TypeNode, SoyType> {
    private static final SoyErrorKind UNKNOWN_TYPE = SoyErrorKind.of("Unknown type ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_RECORD_FIELD = SoyErrorKind.of("Duplicate field ''{0}'' in record declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_TEMPLATE_ARGUMENT = SoyErrorKind.of("Duplicate argument ''{0}'' in template type declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_FUNCTION_PARAM = SoyErrorKind.of("Duplicate parameter ''{0}'' in function type declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_RETURN_TYPE = SoyErrorKind.of("Template types can only return html, attributes, string, js, css, uri, or trusted_resource_uri.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TYPE_PARAM = SoyErrorKind.of("Unexpected type parameter: ''{0}'' only has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind EXPECTED_TYPE_PARAM = SoyErrorKind.of("Expected a type parameter: ''{0}'' has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NOT_A_GENERIC_TYPE = SoyErrorKind.of("''{0}'' is not a generic type, expected ''list'' or ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_GENERIC_TYPE_PARAMETERS = SoyErrorKind.of("''{0}'' is a generic type, expected {1}.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind SAFE_PROTO_TYPE = SoyErrorKind.of("Please use Soy''s native ''{0}'' type instead of the ''{1}'' type.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind DASH_NOT_ALLOWED = SoyErrorKind.of("parse error at ''-'': expected identifier", SoyErrorKind.StyleAllowance.NO_CAPS, SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final ImmutableSet<SoyType.Kind> ALLOWED_TEMPLATE_RETURN_TYPES = Sets.immutableEnumSet((Enum)SoyType.Kind.ELEMENT, (Enum[])new SoyType.Kind[]{SoyType.Kind.HTML, SoyType.Kind.ATTRIBUTES, SoyType.Kind.STRING, SoyType.Kind.JS, SoyType.Kind.CSS, SoyType.Kind.URI, SoyType.Kind.TRUSTED_RESOURCE_URI});
    private static final ImmutableMap<String, BaseGenericTypeInfo> GENERIC_TYPES = ImmutableMap.of((Object)"list", (Object)new GenericTypeInfo(1){

        @Override
        SoyType create(List<SoyType> types, TypeInterner interner) {
            return interner.getOrCreateListType(types.get(0));
        }
    }, (Object)"legacy_object_map", (Object)new GenericTypeInfo(2){

        @Override
        SoyType create(List<SoyType> types, TypeInterner interner) {
            return interner.getOrCreateLegacyObjectMapType(types.get(0), types.get(1));
        }
    }, (Object)"map", (Object)new GenericTypeInfo(2){

        @Override
        SoyType create(List<SoyType> types, TypeInterner interner) {
            return interner.getOrCreateMapType(types.get(0), types.get(1));
        }
    }, (Object)"ve", (Object)new GenericTypeInfo(1){

        @Override
        SoyType create(List<SoyType> types, TypeInterner interner) {
            return interner.getOrCreateVeType(types.get(0).toString());
        }
    });
    private static final ImmutableMap<String, BaseGenericTypeInfo> GENERIC_TYPES_WITH_ELEMENT = new ImmutableMap.Builder().putAll(GENERIC_TYPES).put((Object)"html", (Object)new StringArgGenericTypeInfo(1){

        @Override
        SoyType create(List<String> types, TypeInterner interner) {
            String type;
            String tag = "";
            if (types.size() == 1 && !"?".equals(type = types.get(0))) {
                tag = type;
            }
            return interner.getOrCreateElementType(tag);
        }
    }).build();
    private final ErrorReporter errorReporter;
    private final TypeInterner interner;
    private final TypeRegistry typeRegistry;
    private final ProtoTypeRegistry protoRegistry;
    private final boolean disableAllTypeChecking;

    public static Builder builder(ErrorReporter errorReporter) {
        return new Builder().setErrorReporter(errorReporter);
    }

    private TypeNodeConverter(ErrorReporter errorReporter, TypeInterner interner, TypeRegistry typeRegistry, ProtoTypeRegistry protoRegistry, boolean disableAllTypeChecking) {
        this.errorReporter = errorReporter;
        this.interner = interner;
        this.typeRegistry = typeRegistry;
        this.protoRegistry = protoRegistry;
        this.disableAllTypeChecking = disableAllTypeChecking;
    }

    public SoyType getOrCreateType(TypeNode node) {
        return node.accept(this);
    }

    @Override
    public SoyType visit(NamedTypeNode node) {
        SanitizedType safeProtoType;
        SoyType type;
        String name = node.name().identifier();
        if (name.contains("-")) {
            this.errorReporter.report(node.sourceLocation(), DASH_NOT_ALLOWED, new Object[0]);
            node.setResolvedType(UnknownType.getInstance());
            return UnknownType.getInstance();
        }
        SoyType soyType = type = this.typeRegistry instanceof SoyTypeRegistry ? TypeRegistries.getTypeOrProtoFqn((SoyTypeRegistry)this.typeRegistry, this.errorReporter, node.name()) : this.typeRegistry.getType(name);
        if (type == null && this.protoRegistry != null) {
            type = this.protoRegistry.getProtoType(name);
        }
        if (type == null) {
            BaseGenericTypeInfo genericType = (BaseGenericTypeInfo)GENERIC_TYPES.get((Object)name);
            if (genericType != null) {
                this.errorReporter.report(node.sourceLocation(), MISSING_GENERIC_TYPE_PARAMETERS, name, genericType.formatNumTypeParams());
            } else if (!this.disableAllTypeChecking) {
                this.errorReporter.report(node.sourceLocation(), UNKNOWN_TYPE, name, SoyErrors.getDidYouMeanMessage(this.typeRegistry.getAllSortedTypeNames(), name));
            }
            type = UnknownType.getInstance();
        } else if (type.getKind() == SoyType.Kind.PROTO && (safeProtoType = (SanitizedType)SoyTypes.SAFE_PROTO_TO_SANITIZED_TYPE.get((Object)type.toString())) != null) {
            String safeProtoNativeType = safeProtoType.getContentKind().asAttributeValue();
            this.errorReporter.report(node.sourceLocation(), SAFE_PROTO_TYPE, safeProtoNativeType, name);
            type = UnknownType.getInstance();
        }
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(GenericTypeNode node) {
        return this.visit(node, GENERIC_TYPES);
    }

    private SoyType visit(GenericTypeNode node, ImmutableMap<String, BaseGenericTypeInfo> genericTypes) {
        SoyType type;
        ImmutableList<TypeNode> args = node.arguments();
        String name = node.name();
        BaseGenericTypeInfo genericType = (BaseGenericTypeInfo)genericTypes.get((Object)name);
        if (genericType == null) {
            this.errorReporter.report(node.sourceLocation(), NOT_A_GENERIC_TYPE, name);
            return UnknownType.getInstance();
        }
        if (args.size() < genericType.numParams) {
            this.errorReporter.report(node.sourceLocation().getEndLocation(), EXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
            return UnknownType.getInstance();
        }
        if (args.size() > genericType.numParams) {
            this.errorReporter.report(((TypeNode)args.get(genericType.numParams)).sourceLocation(), UNEXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
            return UnknownType.getInstance();
        }
        if (genericType instanceof GenericTypeInfo) {
            type = ((GenericTypeInfo)genericType).create(Lists.transform(args, (Function)this), this.interner);
        } else if (genericType instanceof StringArgGenericTypeInfo) {
            type = ((StringArgGenericTypeInfo)genericType).create(args.stream().map(TypeNode::toString).collect(Collectors.toList()), this.interner);
        } else {
            throw new AssertionError();
        }
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(UnionTypeNode node) {
        SoyType type = this.interner.getOrCreateUnionType((Collection)node.candidates().stream().map(this).collect(ImmutableList.toImmutableList()));
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(RecordTypeNode node) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (RecordTypeNode.Property property : node.properties()) {
            RecordType.Member oldType = map.put(property.name(), RecordType.memberOf(property.name(), property.optional(), property.type().accept(this)));
            if (oldType == null) continue;
            this.errorReporter.report(property.nameLocation(), DUPLICATE_RECORD_FIELD, property.name());
            map.put(property.name(), oldType);
        }
        RecordType type = this.interner.getOrCreateRecordType(map.values());
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(TemplateTypeNode node) {
        LinkedHashMap<String, TemplateType.Parameter> map = new LinkedHashMap<String, TemplateType.Parameter>();
        for (TemplateTypeNode.Parameter parameter : node.parameters()) {
            TemplateType.Parameter oldParameter = map.put(parameter.name(), TemplateType.Parameter.builder().setName(parameter.name()).setKind(parameter.kind()).setType(parameter.type().accept(this)).setRequired(true).setImplicit(false).build());
            if (oldParameter == null) continue;
            this.errorReporter.report(parameter.nameLocation(), DUPLICATE_TEMPLATE_ARGUMENT, parameter.name());
            map.put(parameter.name(), oldParameter);
        }
        SoyType returnType = this.handleReturnTypeOfTemplateType(node.returnType());
        if (!ALLOWED_TEMPLATE_RETURN_TYPES.contains((Object)returnType.getKind())) {
            this.errorReporter.report(node.returnType().sourceLocation(), INVALID_TEMPLATE_RETURN_TYPE, new Object[0]);
        }
        TemplateType type = this.interner.internTemplateType(TemplateType.declaredTypeOf(map.values(), returnType, NullType.getInstance()));
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(FunctionTypeNode node) {
        LinkedHashMap<String, FunctionType.Parameter> map = new LinkedHashMap<String, FunctionType.Parameter>();
        for (FunctionTypeNode.Parameter parameter : node.parameters()) {
            FunctionType.Parameter oldParameter = map.put(parameter.name(), FunctionType.Parameter.of(parameter.name(), parameter.type().accept(this)));
            if (oldParameter == null) continue;
            this.errorReporter.report(parameter.nameLocation(), DUPLICATE_FUNCTION_PARAM, parameter.name());
            map.put(parameter.name(), oldParameter);
        }
        FunctionType type = this.interner.intern(FunctionType.of(map.values(), node.returnType().accept(this)));
        node.setResolvedType(type);
        return type;
    }

    private SoyType handleReturnTypeOfTemplateType(TypeNode node) {
        if (node instanceof GenericTypeNode) {
            return this.visit((GenericTypeNode)node, GENERIC_TYPES_WITH_ELEMENT);
        }
        return node.accept(this);
    }

    @DoNotCall
    public SoyType apply(TypeNode node) {
        return node.accept(this);
    }

    public static class Builder {
        private ErrorReporter errorReporter;
        private TypeInterner interner;
        private TypeRegistry typeRegistry;
        private ProtoTypeRegistry protoRegistry;
        private boolean disableAllTypeChecking = false;
        private boolean systemExternal = false;

        private Builder() {
        }

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setDisableAllTypeChecking(boolean disableAllTypeChecking) {
            this.disableAllTypeChecking = disableAllTypeChecking;
            return this;
        }

        public Builder setSystemExternal(boolean systemExternal) {
            this.systemExternal = systemExternal;
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry typeRegistry) {
            this.interner = typeRegistry;
            this.typeRegistry = typeRegistry;
            this.protoRegistry = typeRegistry.getProtoRegistry();
            return this;
        }

        public TypeNodeConverter build() {
            Preconditions.checkState((this.interner != null ? 1 : 0) != 0);
            return new TypeNodeConverter(this.errorReporter, this.interner, this.systemExternal ? TypeRegistries.builtinTypeRegistry() : this.typeRegistry, this.systemExternal ? this.protoRegistry : null, this.disableAllTypeChecking);
        }
    }

    private static abstract class StringArgGenericTypeInfo
    extends BaseGenericTypeInfo {
        public StringArgGenericTypeInfo(int numParams) {
            super(numParams);
        }

        abstract SoyType create(List<String> var1, TypeInterner var2);
    }

    private static abstract class GenericTypeInfo
    extends BaseGenericTypeInfo {
        public GenericTypeInfo(int numParams) {
            super(numParams);
        }

        abstract SoyType create(List<SoyType> var1, TypeInterner var2);
    }

    private static abstract class BaseGenericTypeInfo {
        final int numParams;

        BaseGenericTypeInfo(int numParams) {
            this.numParams = numParams;
        }

        final String formatNumTypeParams() {
            return this.numParams + " type parameter" + (this.numParams > 1 ? "s" : "");
        }
    }
}

