/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PerInputOutputFiles;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import org.kohsuke.args4j.Option;

public final class SoyToIncrementalDomSrcCompiler
extends AbstractSoyCompiler {
    @Option(name="--dependOnCssHeader", usage="When this option is used, the generated JS files will have a requirecss annotation for the generated GSS header file.")
    private boolean dependOnCssHeader = false;
    @Option(name="--googMsgsAreExternal", usage="[Only applicable if --shouldGenerateGoogMsgDefs is true] If this option is true, then we generate \"var MSG_EXTERNAL_<soyGeneratedMsgId> = goog.getMsg(...);\". If this option is false, then we generate \"var MSG_UNNAMED_<uniquefier> = goog.getMsg(...);\".  [Explanation of true value] Set this option to true if your project is having Closure Templates do message extraction (e.g. with SoyMsgExtractor) and then having the Closure Compiler do translated message insertion.  [Explanation of false value] Set this option to false if your project is having the Closure Compiler do all of its localization, i.e. if you want the Closure Compiler to do both message extraction and translated message insertion. A significant drawback to this setup is that, if your templates are used from both JS and Java, you will end up with two separate and possibly different sets of translations for your messages.")
    private boolean googMsgsAreExternal = false;
    private final PerInputOutputFiles outputFiles = new PerInputOutputFiles("idom.soy.js", PerInputOutputFiles.JS_JOINER);

    public static void main(String[] args) {
        new SoyToIncrementalDomSrcCompiler().runMain(args);
    }

    SoyToIncrementalDomSrcCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyToIncrementalDomSrcCompiler() {
    }

    @Override
    protected void validateFlags() {
        this.outputFiles.validateFlags();
    }

    @Override
    Iterable<?> extraFlagsObjects() {
        return ImmutableList.of((Object)this.outputFiles);
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) {
        SoyFileSet sfs = sfsBuilder.build();
        SoyIncrementalDomSrcOptions options = SoyIncrementalDomSrcOptions.builder().setDependOnCssHeader(this.dependOnCssHeader).setGoogMsgsAreExternal(this.googMsgsAreExternal).build();
        this.outputFiles.writeFiles(this.srcs, sfs.compileToIncrementalDomSrcInternal(options), null);
    }
}

